/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.base64;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sqlrunner.base64.Base64;

public class StringCrypt {
    private static final String HASH_ALG = "SHA1";
    private static final String ENC_ALG = "TripleDES";

    public static byte[] encrypt(byte[] data, String passPhrase) throws IOException, GeneralSecurityException {
        Cipher cipher = StringCrypt.initCipher(true, passPhrase);
        byte[] encryptedText = cipher.doFinal(data);
        return encryptedText;
    }

    public static byte[] decrypt(byte[] cryptedData, String passPhrase) throws IOException, GeneralSecurityException {
        Cipher cipher = StringCrypt.initCipher(false, passPhrase);
        byte[] decryptedData = cipher.doFinal(cryptedData);
        return decryptedData;
    }

    protected static final Cipher initCipher(boolean encryptMode, String passPhrase) throws IOException, GeneralSecurityException {
        byte[] rawKey = StringCrypt.initSymmetricKey(passPhrase);
        SecretKeySpec key = new SecretKeySpec(new DESedeKeySpec(rawKey).getKey(), ENC_ALG);
        Cipher cipher = Cipher.getInstance(ENC_ALG);
        if (encryptMode) {
            cipher.init(1, key);
        } else {
            cipher.init(2, key);
        }
        return cipher;
    }

    protected static byte[] initSymmetricKey(String passPhrase) throws IOException, GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance(HASH_ALG);
        byte[] digest = md.digest(passPhrase.getBytes());
        byte[] rawKey = new byte[24];
        System.arraycopy(digest, 0, rawKey, 0, 8);
        System.arraycopy(digest, 8, rawKey, 8, 8);
        System.arraycopy(digest, 0, rawKey, 16, 8);
        return rawKey;
    }

    public static String cryptToBcase64(String clearData, String passPhrase) throws Exception {
        byte[] encryptedData = StringCrypt.encrypt(clearData.getBytes(), passPhrase);
        return Base64.encodeToBase64String(encryptedData);
    }

    public static String decryptFromBase64(String cryptedBase64, String passPhrase) throws Exception {
        byte[] receivedCryptedData = Base64.decodeFromBase64String(cryptedBase64);
        return new String(StringCrypt.decrypt(receivedCryptedData, passPhrase));
    }
}

