/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.Messages;
import sqlrunner.swinghelper.WindowHelper;

public final class TableSearchDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel panel = null;
    private JLabel jLabel1 = null;
    private JTextField textFieldSearchText = null;
    private JCheckBox checkBoxLatestColumn = null;
    private JCheckBox checkBoxViewerStart = null;
    private JButton buttonSearch = null;
    private JCheckBox checkBoxCaseSensitive = null;
    private JButton buttonCancel = null;
    private StatusBar status;
    private MainFrame mainFrame;
    private boolean searchNext = false;
    private JCheckBox checkBoxStartAt0 = null;
    private boolean windowIsActivated;

    public TableSearchDialog(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
            WindowHelper.checkAndCorrectWindowBounds(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.setTitle(Messages.getString("TableSearchDialog.seatchinallcolumns"));
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.buttonSearch);
        this.setResizable(false);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridy = 5;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 5;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridwidth = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(2, 20, 2, 2);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridwidth = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(2, 20, 2, 2);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridwidth = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(2, 20, 2, 2);
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(2, 20, 2, 2);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 3;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.insets = new Insets(5, 2, 2, 5);
            gridBagConstraints1.weightx = 1.0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 2, 5);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setForeground(Color.black);
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel1.setText(Messages.getString("TableSearchDialog.searchpattern"));
            this.textFieldSearchText = new JTextField();
            this.textFieldSearchText.setBackground(Main.info);
            this.textFieldSearchText.setToolTipText(Messages.getString("TableSearchDialog.tooltip"));
            this.checkBoxLatestColumn = new JCheckBox();
            this.checkBoxLatestColumn.setText(Messages.getString("TableSearchDialog.searchonlyincurrentcolumn"));
            this.checkBoxLatestColumn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TableSearchDialog.this.checkBoxLatestColumn_itemStateChanged(e);
                }
            });
            this.checkBoxViewerStart = new JCheckBox();
            this.checkBoxViewerStart.setText(Messages.getString("TableSearchDialog.opencelleditor"));
            this.buttonSearch = new JButton();
            this.buttonSearch.setText(Messages.getString("TableSearchDialog.search"));
            this.buttonSearch.setToolTipText(Messages.getString("TableSearchDialog.serachtooltip"));
            this.buttonSearch.addActionListener(this);
            this.buttonSearch.setActionCommand("search");
            this.checkBoxCaseSensitive = new JCheckBox();
            this.checkBoxCaseSensitive.setText(Messages.getString("TableSearchDialog.casesensitive"));
            this.buttonCancel = new JButton();
            this.buttonCancel.setText(Messages.getString("TableSearchDialog.Close"));
            this.buttonCancel.setToolTipText(Messages.getString("TableSearchDialog.closetooltip"));
            this.buttonCancel.addActionListener(this);
            this.buttonCancel.setActionCommand("cancel");
            this.checkBoxStartAt0 = new JCheckBox();
            this.checkBoxStartAt0.setText(Messages.getString("TableSearchDialog.searchfromfirstline"));
            this.checkBoxStartAt0.setSelected(true);
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.panel.add((Component)this.jLabel1, gridBagConstraints);
            this.panel.add((Component)this.textFieldSearchText, gridBagConstraints1);
            this.panel.add((Component)this.checkBoxLatestColumn, gridBagConstraints2);
            this.panel.add((Component)this.checkBoxViewerStart, gridBagConstraints3);
            this.panel.add((Component)this.checkBoxCaseSensitive, gridBagConstraints4);
            this.panel.add((Component)this.checkBoxStartAt0, gridBagConstraints5);
            this.panel.add((Component)this.buttonSearch, gridBagConstraints6);
            this.panel.add((Component)this.buttonCancel, gridBagConstraints7);
            this.status = new StatusBar();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.panel, "Center");
            this.jContentPane.add((Component)this.status, "South");
        }
        return this.jContentPane;
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 205: {
                this.textFieldSearchText.selectAll();
                this.textFieldSearchText.requestFocus();
                this.windowIsActivated = true;
                break;
            }
            case 206: {
                this.windowIsActivated = false;
                break;
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            if (e.getID() == 401 && this.windowIsActivated) {
                this.cancel();
            }
        } else if (e.getKeyCode() == 114) {
            if (e.getID() == 401) {
                this.buttonSearch_actionPerformed();
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancel) {
            this.cancel();
        } else if (e.getSource() == this.buttonSearch) {
            this.buttonSearch_actionPerformed();
        }
    }

    private void buttonSearch_actionPerformed() {
        this.status.infoAction.setText("BUSY");
        boolean founded = false;
        this.setEnabled(false);
        if (this.mainFrame.getDatabase() != null) {
            if (this.mainFrame.getDatabase().size() > 0) {
                String muster;
                if (this.checkBoxStartAt0.isSelected()) {
                    this.mainFrame.resultTable.setRowSelectionInterval(0, 0);
                    this.mainFrame.scrollTableToCell(0);
                    this.searchNext = false;
                }
                if ((muster = this.textFieldSearchText.getText().trim()).length() > 0) {
                    founded = this.searchNext ? this.mainFrame.getDatabase().findNextValue(muster, this.checkBoxCaseSensitive.isSelected(), this.checkBoxLatestColumn.isSelected()) : this.mainFrame.getDatabase().findValue(muster, this.checkBoxCaseSensitive.isSelected(), this.checkBoxLatestColumn.isSelected());
                    if (founded) {
                        int row = this.mainFrame.resultTable.getSelectedRow();
                        int col = this.mainFrame.resultTable.getSelectedColumn();
                        this.status.meldung.setText(Messages.getString("TableSearchDialog.fondinfield") + this.mainFrame.getDatabase().getColumnName(col) + Messages.getString("TableSearchDialog.foundinline") + String.valueOf(row + 1));
                        this.mainFrame.scrollTableToCell(row);
                        this.mainFrame.resultTable.requestFocus();
                        this.toFront();
                        if (this.checkBoxViewerStart.isSelected()) {
                            this.mainFrame.showEditor(row, col);
                        }
                        this.buttonSearch.setText(Messages.getString("TableSearchDialog.searchnext"));
                        this.checkBoxStartAt0.setSelected(false);
                        this.searchNext = true;
                    } else {
                        this.status.meldung.setText(Messages.getString("TableSearchDialog.status_notfound"));
                        this.checkBoxStartAt0.setSelected(true);
                        this.buttonSearch.setText(Messages.getString("TableSearchDialog.search"));
                        this.searchNext = false;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getString("TableSearchDialog.messagedefinesearchpattern"), Messages.getString("TableSearchDialog.search"), 1);
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("TableSearchDialog.message_nodata"), Messages.getString("TableSearchDialog.search"), 1);
            }
        } else {
            JOptionPane.showMessageDialog(this, Messages.getString("TableSearchDialog.message_nodata"), Messages.getString("TableSearchDialog.search"), 1);
        }
        this.setEnabled(true);
        this.status.infoAction.setText("READY");
        this.doLayout();
    }

    private void cancel() {
        this.searchNext = false;
        this.buttonSearch.setText(Messages.getString("TableSearchDialog.search"));
        this.setVisible(false);
    }

    public String getSearchString() {
        return this.textFieldSearchText.getText().trim();
    }

    public boolean searchInSelectedColumn() {
        return this.checkBoxLatestColumn.isSelected();
    }

    public boolean caseSensitive() {
        return this.checkBoxCaseSensitive.isSelected();
    }

    public boolean requestViewer() {
        return this.checkBoxViewerStart.isSelected();
    }

    private void checkBoxLatestColumn_itemStateChanged(ItemEvent e) {
        if (this.checkBoxLatestColumn.isSelected()) {
            String name = this.mainFrame.getDatabase().getSelectedColumnName();
            if (name != null) {
                this.setTitle(Messages.getString("TableSearchDialog.seartchincolumn") + name);
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("TableSearchDialog.selectcolumn"), Messages.getString("TableSearchDialog.Advise"), 1);
                this.checkBoxLatestColumn.setSelected(false);
            }
        } else {
            this.setTitle(Messages.getString("TableSearchDialog.titlesearchinallcolumns"));
        }
    }

    static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JLabel meldung = new FixedLabel();
        public JLabel infoAction = new FixedLabel();
        static final int INFO_ACTION_BREITE = 60;
        static final int HOEHE = 25;

        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.meldung.setBorder(BorderFactory.createLoweredBevelBorder());
            this.meldung.setForeground(Color.black);
            this.infoAction.setPreferredSize(new Dimension(60, 25));
            this.infoAction.setOpaque(true);
            this.infoAction.setText("IDLE");
            this.infoAction.setBorder(BorderFactory.createLoweredBevelBorder());
            this.infoAction.setForeground(Color.black);
            this.add(this.meldung);
            this.add(this.infoAction);
            this.meldung.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth() - 60;
            this.meldung.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.meldung);
            this.add(this.meldung, null, 0);
            this.doLayout();
        }

        class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.meldung.setToolTipText(StatusBar.this.meldung.getText());
            }
        }

        static class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            public FixedLabel(String text) {
                super(text);
            }

            public FixedLabel() {
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

