/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import sqlrunner.MainFrame;
import sqlrunner.SQLPSParamEditor;
import sqlrunner.swinghelper.WindowHelper;

public final class SQLPSParamConfigurer
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int returnCode = 1;
    private JScrollPane scrollPaneParams;
    private JPanel panelButtons;
    private JButton buttonCancel;
    private JButton buttonReset;
    private JButton buttonOk;
    private final List<SQLPSParamEditor> paramEditorList = new Vector<SQLPSParamEditor>();
    private transient SQLStatement psStat = null;
    private MainFrame mainFrame;
    private static final HashMap<String, ValueType> paramValueMap = new HashMap();
    private JPanel jContentPane = null;
    private JButton jButtonSort = null;
    private JPanel jPanelParameters = null;

    public SQLPSParamConfigurer(MainFrame mainFrame, SQLStatement ps) {
        super(mainFrame);
        this.getRootPane().putClientProperty("Window.style", "small");
        this.setModal(true);
        this.mainFrame = mainFrame;
        this.psStat = ps;
        this.initComponents();
        this.setSQLPreparedStatement(ps);
        this.pack();
    }

    private void correctPosition() {
        WindowHelper.locateWindowAtMiddle(this.mainFrame, this);
    }

    private void initComponents() {
        this.panelButtons = new JPanel();
        this.buttonOk = new JButton("OK");
        this.buttonOk.addActionListener(this);
        this.buttonReset = new JButton("Clear all values");
        this.buttonReset.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.panelButtons.add(this.buttonOk);
        this.panelButtons.add(this.buttonReset);
        this.panelButtons.add(this.buttonCancel);
        this.panelButtons.add((Component)this.getJButtonSort(), null);
        this.scrollPaneParams = new JScrollPane();
        this.scrollPaneParams.setViewportView(this.getJPanelParameters());
        this.setTitle("Statement " + this.psStat.getIndex());
        this.setContentPane(this.getJContentPane());
    }

    public void setSQLPreparedStatement(SQLStatement ps) {
        SQLPSParam param = null;
        SQLPSParamEditor paramEditor = null;
        this.paramEditorList.clear();
        ValueType vt = null;
        for (int i = 0; i < ps.getParams().size(); ++i) {
            param = ps.getParams().get(i);
            paramEditor = new SQLPSParamEditor(param);
            vt = param.getName() != null ? paramValueMap.get(param.getName()) : paramValueMap.get(String.valueOf(param.getIndex()));
            if (vt != null) {
                paramEditor.setRecommendedValue(vt.value);
                paramEditor.setRecommendedType(vt.type);
                paramEditor.setRecommendedOutputState(vt.output);
            }
            this.paramEditorList.add(paramEditor);
        }
        this.setupParamEditors(this.paramEditorList);
        this.doLayout();
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public SQLStatement getSQLPreparedStatement() {
        return this.psStat;
    }

    private void setupParameter() {
        SQLPSParamEditor paramEditor = null;
        SQLPSParam param = null;
        ValueType vt = null;
        for (int i = 0; i < this.paramEditorList.size(); ++i) {
            paramEditor = this.paramEditorList.get(i);
            param = paramEditor.getParameter();
            param.setBasicType(paramEditor.getBasicType());
            param.setOutParam(paramEditor.isOutParam());
            if (param.isOutParam()) {
                param.setValue(null);
            } else {
                param.setValue(paramEditor.getValueText());
            }
            vt = new ValueType();
            vt.type = param.getBasicType();
            vt.value = param.getValue();
            vt.output = param.isOutParam();
            if (param.getName() != null) {
                paramValueMap.put(param.getName(), vt);
                continue;
            }
            paramValueMap.put(String.valueOf(param.getIndex()), vt);
        }
    }

    private void sortParameterByName() {
        Collections.sort(this.paramEditorList, new ParamEditorComparator());
        this.setupParamEditors(this.paramEditorList);
    }

    private void setupParamEditors(List<SQLPSParamEditor> editorList) {
        int preferredHeight = 0;
        SQLPSParamEditor paramEditor = null;
        this.jPanelParameters.removeAll();
        int i = 0;
        while (i < editorList.size()) {
            paramEditor = editorList.get(i);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.jPanelParameters.add((Component)paramEditor, gridBagConstraints);
            preferredHeight = preferredHeight + paramEditor.getPreferredSize().height + 8;
        }
        if (preferredHeight > 600) {
            preferredHeight = 600;
        }
        this.scrollPaneParams.setPreferredSize(new Dimension(450, preferredHeight));
        this.scrollPaneParams.getVerticalScrollBar().setUnitIncrement(paramEditor.getPreferredSize().height);
        this.pack();
        this.correctPosition();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.buttonOk) {
            this.setupParameter();
            this.returnCode = 0;
            this.setVisible(false);
        } else if (ae.getSource() == this.buttonReset) {
            for (int i = 0; i < this.paramEditorList.size(); ++i) {
                this.paramEditorList.get(i).reset();
            }
        } else if (ae.getSource() == this.buttonCancel) {
            this.returnCode = 1;
            this.setVisible(false);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.returnCode = 1;
        }
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.scrollPaneParams, "Center");
            this.jContentPane.add((Component)this.panelButtons, "South");
        }
        return this.jContentPane;
    }

    private JButton getJButtonSort() {
        if (this.jButtonSort == null) {
            this.jButtonSort = new JButton();
            this.jButtonSort.setText("Sortieren");
            this.jButtonSort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLPSParamConfigurer.this.sortParameterByName();
                }
            });
        }
        return this.jButtonSort;
    }

    private JPanel getJPanelParameters() {
        if (this.jPanelParameters == null) {
            this.jPanelParameters = new JPanel();
            this.jPanelParameters.setLayout(new GridBagLayout());
        }
        return this.jPanelParameters;
    }

    static final class ValueType {
        public String value;
        public int type;
        public boolean output;

        ValueType() {
        }
    }

    private static final class ParamEditorComparator
    implements Comparator<SQLPSParamEditor>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ParamEditorComparator() {
        }

        @Override
        public int compare(SQLPSParamEditor e1, SQLPSParamEditor e2) {
            return e1.getParameterName().compareTo(e2.getParameterName());
        }
    }
}

