/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import sqlrunner.resources.ApplicationIcons;

public class FileOpenChooserPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title;
    private File previousFile;
    private JTextField fileTextField;
    private JButton jButtonChooseFile;
    private JFileChooser chooser = new JFileChooser();

    public FileOpenChooserPanel(String title) {
        this.title = title;
        this.initialize();
    }

    public void setAsOpenFileChooser() {
        this.chooser.setDialogType(0);
    }

    public void setAsSaveFileChooser() {
        this.chooser.setDialogType(1);
    }

    public void removeAllFileFilters() {
        this.chooser.resetChoosableFileFilters();
    }

    public void addFileFilter(FileFilter filter) {
        this.chooser.addChoosableFileFilter(filter);
    }

    public void setPreviousFile(File f) {
        this.previousFile = f;
    }

    public File getSelectedFile() {
        return new File(this.fileTextField.getText());
    }

    public void setTextFieldEditable(boolean editable) {
        this.getTextField().setEditable(editable);
    }

    public void clearSelectedFile() {
        this.getTextField().setText(null);
    }

    public void reset() {
        this.previousFile = null;
        this.getTextField().setText(null);
        this.chooser.resetChoosableFileFilters();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getTextField(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJButton(), gbc);
    }

    private JTextField getTextField() {
        if (this.fileTextField == null) {
            this.fileTextField = new JTextField();
        }
        return this.fileTextField;
    }

    private JButton getJButton() {
        if (this.jButtonChooseFile == null) {
            this.jButtonChooseFile = new JButton(ApplicationIcons.OPEN_GIF);
            this.jButtonChooseFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileOpenChooserPanel.this.openFileDialog();
                }
            });
        }
        return this.jButtonChooseFile;
    }

    public void openFileDialog() {
        File file;
        if (this.previousFile != null) {
            this.chooser.setSelectedFile(this.previousFile);
        }
        this.chooser.setMultiSelectionEnabled(false);
        this.chooser.setDialogTitle(this.title);
        int returnVal = this.chooser.getDialogType() == 0 ? this.chooser.showOpenDialog(this) : this.chooser.showSaveDialog(this);
        if (returnVal == 0 && (file = this.chooser.getSelectedFile()) != null) {
            this.getTextField().setText(file.getAbsolutePath());
        }
    }
}

