/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.DatabaseSessionPool;
import dbtools.SQLPSParam;
import dbtools.SQLParser;
import dbtools.SQLStatement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import sqlrunner.BinaryDataFile;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.ValueEditor;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.dbext.DatabaseExtensionFactory;
import sqlrunner.editor.WildcardSearch;
import sqlrunner.export.ExporterToSpreadsheetFile;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.text.GenericDateUtil;

public final class Database
implements TableModel {
    private static final Logger logger = Logger.getLogger(Database.class);
    private ResultSetMetaData rsmd;
    private DatabaseMetaData dbmd;
    private DatabaseSession session;
    private TableColumnModel tableColumnModel;
    private String[] columnNames;
    private String[] columnSourceClasses;
    private Class<?>[] columnClasses;
    private String[] columnTypeNames;
    private Boolean[] columnPkInfo;
    private Boolean[] columnRefFromInfo;
    private Integer[] columnPrecision;
    private Integer[] columnScale;
    private HashMap<String, StringBuilder> mapRefFromColumns;
    private String[][] columnRefToInfo;
    private int[] columnTypesValues;
    private Object[] newRow;
    private int newRowIndex = -1;
    private JTable table;
    private String lastTable;
    private ValueEditor currentCellEditor;
    private SimpleDateFormat sdf;
    public static final int CSV_FORMAT = 0;
    public static final int INSERT_FORMAT = 1;
    private int maxRowsToRead;
    private int maxRowsToWarning;
    private int lastSearchPosRow = 0;
    private int lastSearchPosCol = 0;
    private SQLDataModel dataModel;
    private boolean isAdditionalInfoReady = false;
    private MainFrame mainFrame;
    private int refreshTime = 2000;
    private int defaultPreferedColumnWidth = 80;
    static Properties columnsWidth = new Properties();
    private int preferredColumnWidthSum = 0;
    private final ColumnPropertyChangeListener cpcl = new ColumnPropertyChangeListener();
    private SQLStatement lastSelectStatement;
    private boolean verticalView = false;
    private boolean showsResultSet = true;
    private List<Object[]> resultSetResults = new ArrayList<Object[]>();
    private List<SQLPSParam> outputParameters = new ArrayList<SQLPSParam>();
    private DatabaseExtension databaseExtension;
    private Thread preloadDataModelThread;
    protected EventListenerList tabelModelListeners = new EventListenerList();
    protected EventListenerList listenerList = new EventListenerList();
    private final ResultTableHeaderRenderer titleRenderer = new ResultTableHeaderRenderer();
    private int columnWidthAdditive = 0;
    private boolean disablePropertyChangeListener = false;
    private boolean cancelStatementEnabled = true;
    private Statement currentLocalStatement = null;
    private boolean cancelled = false;
    private int answer = 0;

    public Database(JTable table, MainFrame mainFrame) {
        this.databaseExtension = DatabaseExtensionFactory.getGenericDatabaseExtension();
        this.table = table;
        this.table.setModel(this);
        this.mainFrame = mainFrame;
        this.tableColumnModel = table.getColumnModel();
        this.session = new DatabaseSession();
        this.maxRowsToWarning = Integer.parseInt(Main.getDefaultProperty("MAX_ROWS_TO_READ_IN", "10000"));
        this.createSDF();
        try {
            this.refreshTime = Integer.parseInt(Main.getDefaultProperty("DB_FETCH_REFRESH_CYCLE", "2000"));
        }
        catch (NumberFormatException nfe) {
            this.refreshTime = 2000;
        }
    }

    public Database() {
        this.session = new DatabaseSession();
        this.databaseExtension = DatabaseExtensionFactory.getGenericDatabaseExtension();
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    public String getCurrentUserName() {
        return this.getDatabaseSession().getUser();
    }

    public DatabaseExtension getDatabaseExtension() {
        return this.databaseExtension;
    }

    public void setVerticalView(boolean enable) {
        if (enable) {
            logger.debug((Object)"change to vertical view");
        } else {
            logger.debug((Object)"change to horizontal view");
        }
        this.verticalView = enable;
        this.fireTableStructureChanged();
        if (!enable) {
            this.prepareColumns();
        }
        this.mainFrame.resultTable.getTableHeader().setDefaultRenderer(this.titleRenderer);
    }

    public boolean isVerticalView() {
        return this.verticalView;
    }

    public void createSDF() {
        this.sdf = new SimpleDateFormat(MainFrame.getDateFormatMask());
    }

    public int getLogicalColumnCount() {
        if (this.columnNames != null) {
            return this.columnNames.length;
        }
        return 0;
    }

    public void setTable(JTable table_loc) {
        this.table = table_loc;
        this.table.setModel(this);
        this.tableColumnModel = table_loc.getColumnModel();
    }

    public void setDatabaseSession(DatabaseSession session_loc) {
        this.session = session_loc;
    }

    public DatabaseSession getDatabaseSession() {
        return this.session;
    }

    public String getTableName() {
        return this.lastTable;
    }

    public void refreshMetadata() {
        if (this.session.isConnected()) {
            this.dataModel.refresh();
        }
    }

    public SQLDataModel getSQLDataModel() {
        return this.dataModel;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        return this.dbmd;
    }

    public String getSQLDatamodelErrorMessage() {
        return this.dataModel.getLastErrorMessage();
    }

    public void setConnectionDescription(ConnectionDescription desc) {
        this.session.setConnectionDescription(desc);
    }

    public boolean loadDriver() {
        return this.session.loadDriver();
    }

    public boolean connect() {
        boolean ok = this.session.connect();
        this.dataModel = null;
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (ok) {
            try {
                logger.debug((Object)"setup meta data...");
                this.dbmd = this.session.getConnection().getMetaData();
                this.dataModel = new SQLDataModel(this.session.getConnectionDescription());
                this.databaseExtension = DatabaseExtensionFactory.getDatabaseExtension(this.session.getConnectionDescription());
                this.databaseExtension.setupConnection(this.session.getConnection());
                this.databaseExtension.setIdentifierQuoteString(this.dbmd.getIdentifierQuoteString());
                SQLCodeGenerator.getInstance().setEnclosureChar(this.databaseExtension.getIdentifierQuoteString());
                this.startPreloadingDataModel();
                this.registerAdditionalKeywords();
            }
            catch (SQLException sqle) {
                this.mainFrame.showWarningMessage("No metadata available: " + sqle.getMessage(), "connect");
            }
        } else {
            this.dbmd = null;
        }
        return ok;
    }

    private void startPreloadingDataModel() {
        this.preloadDataModelThread = new Thread(){

            @Override
            public void run() {
                Database.this.dataModel.reloadSchemasAndTables();
            }
        };
        this.preloadDataModelThread.start();
    }

    private void registerAdditionalKeywords() {
        if (this.mainFrame.getSyntaxScanner() != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String keywords = this.dbmd.getSQLKeywords();
                if (keywords != null && keywords.length() > 0) {
                    sb.append(keywords);
                    sb.append(',');
                }
                if ((keywords = this.dbmd.getStringFunctions()) != null && keywords.length() > 0) {
                    sb.append(keywords);
                    sb.append(',');
                }
                if ((keywords = this.dbmd.getSystemFunctions()) != null && keywords.length() > 0) {
                    sb.append(keywords);
                    sb.append(',');
                }
                if ((keywords = this.dbmd.getTimeDateFunctions()) != null && keywords.length() > 0) {
                    sb.append(keywords);
                    sb.append(',');
                }
                if ((keywords = this.dbmd.getNumericFunctions()) != null && keywords.length() > 0) {
                    sb.append(keywords);
                }
                this.mainFrame.getSyntaxScanner().addAdditionalKeywords(sb.toString());
                if (this.databaseExtension != null) {
                    this.mainFrame.getSyntaxScanner().addAdditionalKeywords(this.databaseExtension.getAdditionalSQLKeywords());
                    this.mainFrame.getSyntaxScanner().addAdditionalSQLDataTypes(this.databaseExtension.getAdditionalSQLDatatypes());
                    this.mainFrame.getSyntaxScanner().addAdditionalPLSQLKeywords(this.databaseExtension.getAdditionalProcedureKeywords());
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("registerAdditionalKeywords:" + sqle.getMessage()), (Throwable)sqle);
            }
        }
    }

    private void deregisterKeywords() {
        if (this.mainFrame.getSyntaxScanner() != null) {
            this.mainFrame.getSyntaxScanner().deregisterAdditionalKeywords();
        }
    }

    public boolean close() {
        if (this.preloadDataModelThread != null && this.preloadDataModelThread.isAlive()) {
            this.preloadDataModelThread.interrupt();
        }
        this.dataModel = null;
        this.dbmd = null;
        this.databaseExtension = DatabaseExtensionFactory.getGenericDatabaseExtension();
        this.deregisterKeywords();
        DatabaseSessionPool.close(this.session.getAliasName());
        boolean ok = this.session.close();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FieldDescription> selectFieldDescriptions(String table_loc) {
        if (this.dbmd != null) {
            String schema;
            ArrayList<FieldDescription> fields = new ArrayList<FieldDescription>();
            int pos = table_loc.indexOf(46);
            if (pos != -1) {
                schema = table_loc.substring(0, pos);
                table_loc = table_loc.substring(pos + 1, table_loc.length());
            } else {
                schema = this.session.getUser().toUpperCase();
            }
            ResultSet rsc = null;
            try {
                rsc = this.dbmd.getColumns(null, schema, table_loc, null);
                int i = 0;
                while (rsc.next()) {
                    fields.add(new FieldDescription(rsc.getString("COLUMN_NAME"), BasicDataType.getBasicTypeByTypes(rsc.getShort("DATA_TYPE")), "", rsc.getInt("ORDINAL_POSITION") - 1, 2, rsc.getInt("ORDINAL_POSITION") - 1, -1, rsc.getInt("COLUMN_SIZE"), false, true, "", false, true, null));
                }
                rsc.close();
                rsc = this.dbmd.getPrimaryKeys(null, schema, table_loc);
                block12: while (rsc.next()) {
                    String columnName = rsc.getString("COLUMN_NAME");
                    for (i = 0; i < fields.size(); ++i) {
                        FieldDescription fd = (FieldDescription)fields.get(i);
                        if (!fd.getName().equalsIgnoreCase(columnName)) continue;
                        fd.setIsPartOfPrimaryKey(true);
                        continue block12;
                    }
                }
                rsc.close();
            }
            catch (SQLException sqle) {
                logger.error((Object)("getFieldDescriptions:" + sqle.getMessage()));
            }
            finally {
                try {
                    if (rsc != null) {
                        rsc.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("failed to close result set " + e.getMessage()));
                }
            }
            if (fields.size() == 0) {
                return null;
            }
            return fields;
        }
        return null;
    }

    public List<FieldDescription> selectFieldDescriptions(SQLTable table) {
        ArrayList<FieldDescription> fields = new ArrayList<FieldDescription>();
        for (int i = 0; i < table.getFieldCount(); ++i) {
            SQLField field = table.getFieldAt(i);
            FieldDescription fd = new FieldDescription(field);
            fields.add(fd);
        }
        return fields;
    }

    public void setCurrentCellEditor(ValueEditor cv) {
        this.currentCellEditor = cv;
    }

    public String createInsertStatementText() {
        if (this.lastTable != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ");
            sb.append(this.lastTable);
            sb.append(" (");
            for (int i = 0; i < this.columnNames.length; ++i) {
                sb.append(this.columnNames[i]);
                if (i >= this.columnNames.length - 1) continue;
                sb.append(',');
            }
            sb.append(")\nvalues (");
            return sb.toString();
        }
        return null;
    }

    public String createSelectStatementText() {
        if (this.lastTable != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("select ");
            for (int i = 0; i < this.columnNames.length; ++i) {
                sb.append(this.columnNames[i]);
                if (i >= this.columnNames.length - 1) continue;
                sb.append(",\n       ");
            }
            sb.append("\nfrom ");
            sb.append(this.lastTable);
            return sb.toString();
        }
        return null;
    }

    private String createWherePartOfPreparedStatement(int row) {
        int x;
        int lastPkFieldIndex = -1;
        boolean error = false;
        for (x = 0; x < this.columnPkInfo.length; ++x) {
            if (!this.columnPkInfo[x].booleanValue()) continue;
            lastPkFieldIndex = x;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append(" where ");
        for (x = 0; x < this.columnPkInfo.length; ++x) {
            if (!this.columnPkInfo[x].booleanValue()) continue;
            whereClause.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnNames[x]));
            if (this.getValueAt(row, x) != null) {
                whereClause.append("=?");
            } else {
                whereClause.append(" is null");
            }
            if (x >= lastPkFieldIndex) continue;
            whereClause.append(" and ");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("where-condition = " + whereClause));
        }
        return whereClause.toString();
    }

    private boolean completeWherePartOfPreparedStatement(PreparedStatement ps, int row, int lastParamIndex, Object constraint) {
        boolean ok = true;
        int paramIndex = lastParamIndex + 1;
        for (int i = 0; i < this.columnPkInfo.length; ++i) {
            Object value;
            if (!this.columnPkInfo[i].booleanValue() || (value = this.getValueAtLogicalIndexes(row, i)) == null) continue;
            ok = this.setParameterValue(ps, paramIndex, i, value, constraint);
            ++paramIndex;
            if (!ok) break;
        }
        return ok;
    }

    public void deleteDataset(int[] rows) {
        DeleteDataSetThread thread = new DeleteDataSetThread(rows);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performDeleteDataset(int row) {
        boolean ok = true;
        if (this.getDatabaseSession().isConnected()) {
            String whereBed = this.createWherePartOfPreparedStatement(row);
            if (whereBed != null) {
                StringBuilder sql_loc = new StringBuilder("select count(");
                int countPk = 0;
                for (int x = 0; x < this.columnPkInfo.length; ++x) {
                    if (!this.columnPkInfo[x].booleanValue()) continue;
                    sql_loc.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnNames[x]));
                    sql_loc.append(") from ");
                    sql_loc.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.lastTable));
                    sql_loc.append(' ');
                    sql_loc.append(whereBed);
                    ++countPk;
                    break;
                }
                if (countPk == 0) {
                    this.mainFrame.showDBMessageWithoutContinueAction("no primary key definied!\ndefine primary keys with context menu in the table header", "delete dataset");
                    ok = false;
                } else {
                    int testCount = -1;
                    ResultSet rs_loc = null;
                    PreparedStatement psTest = null;
                    try {
                        psTest = this.getDatabaseSession().createPreparedStatement(sql_loc.toString());
                        this.completeWherePartOfPreparedStatement(psTest, row, 0, null);
                        rs_loc = psTest.executeQuery();
                        if (rs_loc != null && rs_loc.next()) {
                            testCount = rs_loc.getInt(1);
                        }
                    }
                    catch (SQLException sqle) {
                        this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "test of primary key");
                        ok = false;
                    }
                    finally {
                        try {
                            if (rs_loc != null) {
                                rs_loc.close();
                            }
                            if (psTest != null) {
                                psTest.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)("performDeleteDataset close cursors failed: " + e.toString()));
                        }
                    }
                    if (testCount == -1) {
                        this.mainFrame.showDBMessageWithoutContinueAction(this.getDatabaseSession().getLastErrorMessage(), "testcount for check primary key");
                        ok = false;
                    } else if (testCount == 0) {
                        this.mainFrame.showDBMessageWithoutContinueAction("test count got 0 datasets ! unable to perform delete", "delete dataset");
                        ok = false;
                    } else if (testCount > 1) {
                        this.mainFrame.showDBMessageWithoutContinueAction("test count got more than one dataset \n(" + String.valueOf(testCount) + ") !", "delete dataset");
                        ok = false;
                    }
                    if (testCount == 1) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("delete from ");
                        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.lastTable));
                        sb.append(whereBed);
                        int count = -1;
                        Statement ps = null;
                        try {
                            ps = this.session.createPreparedStatement(sb.toString());
                            this.completeWherePartOfPreparedStatement((PreparedStatement)ps, row, 0, null);
                            count = ps.executeUpdate();
                        }
                        catch (SQLException sqle) {
                            this.mainFrame.showDBMessage(sqle.getMessage(), "delete dataset");
                            ok = false;
                        }
                        finally {
                            try {
                                ps.close();
                            }
                            catch (Exception e) {
                                logger.error((Object)("Database.performDeleteDataset close statement failed: " + e.toString()));
                            }
                        }
                        if (count == 1) {
                            this.resultSetResults.remove(row);
                            this.fireTableRowsDeleted(row, row);
                        }
                    }
                }
            } else {
                ok = false;
            }
        } else {
            this.mainFrame.showDBMessageWithoutContinueAction("database connection disconnected!", "delete");
            ok = false;
        }
        if (ok && this.newRowIndex > 0) {
            --this.newRowIndex;
        }
        return ok;
    }

    public Thread deleteValue(int row, int col) {
        DeleteValueThread thread = new DeleteValueThread(row, col);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performDeleteValue(int row, int col) {
        int countPk;
        StringBuilder sql_loc;
        String whereBed;
        boolean ok;
        block37: {
            ok = true;
            if (this.getDatabaseSession().isConnected()) {
                whereBed = this.createWherePartOfPreparedStatement(row);
                if (whereBed != null) {
                    sql_loc = new StringBuilder("select count(");
                    countPk = 0;
                    break block37;
                } else {
                    this.currentCellEditor.toFront();
                    return false;
                }
            }
            this.mainFrame.showDBMessageWithoutContinueAction("database connection disconnected!", "delete field");
            return false;
        }
        for (int x = 0; x < this.columnPkInfo.length; ++x) {
            if (!this.columnPkInfo[x].booleanValue()) continue;
            sql_loc.append(this.columnNames[x]);
            sql_loc.append(") from ");
            sql_loc.append(this.lastTable);
            sql_loc.append(' ');
            sql_loc.append(whereBed);
            ++countPk;
            break;
        }
        if (countPk == 0) {
            this.mainFrame.showDBMessageWithoutContinueAction("no primary key definied!\ndefine primary key with context menu from table header", "delete field");
            return false;
        }
        int testCount = -1;
        ResultSet rs_loc = null;
        PreparedStatement psTest = null;
        try {
            psTest = this.getDatabaseSession().createPreparedStatement(sql_loc.toString());
            this.completeWherePartOfPreparedStatement(psTest, row, 0, null);
            rs_loc = psTest.executeQuery();
            if (rs_loc != null && rs_loc.next()) {
                testCount = rs_loc.getInt(1);
            }
        }
        catch (SQLException sqle) {
            this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "test of primary key");
            ok = false;
        }
        finally {
            try {
                if (rs_loc != null) {
                    rs_loc.close();
                }
                if (psTest != null) {
                    psTest.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Database.performDeleteValue close cursors failed: " + e.toString()), (Throwable)e);
            }
        }
        if (ok && testCount == -1) {
            this.mainFrame.showDBMessageWithoutContinueAction(this.getDatabaseSession().getLastErrorMessage(), "delete field");
            ok = false;
        } else if (testCount == 0) {
            this.mainFrame.showDBMessageWithoutContinueAction("test count got 0 datasets", "delete field");
            ok = false;
        } else if (testCount > 1) {
            this.mainFrame.showDBMessageWithoutContinueAction("test count got more than one datasets \n(" + String.valueOf(testCount) + ")", "delete field");
            ok = false;
        }
        if (testCount == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("update ");
            sb.append(this.lastTable);
            sb.append(" set ");
            sb.append(this.columnNames[col]);
            sb.append("=null ");
            sb.append(whereBed);
            Statement ps = null;
            try {
                ps = this.session.createPreparedStatement(sb.toString());
                this.completeWherePartOfPreparedStatement((PreparedStatement)ps, row, 0, null);
                int count = ps.executeUpdate();
                if (count != 1) {
                    ok = false;
                }
            }
            catch (SQLException sqle) {
                this.mainFrame.showDBMessage(sqle.getMessage(), "delete field");
                ok = false;
            }
            finally {
                try {
                    ps.close();
                }
                catch (Exception e) {
                    logger.error((Object)("deleteValue close prepared statement failed: " + e.toString()), (Throwable)e);
                }
            }
        }
        if (!ok) return ok;
        this.setValueAt(null, row, col);
        return ok;
    }

    public void updateValue(Object value, int row, int col, JFrame frame, Object constraint) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateValue(value=" + value + ", row=" + row + ", col=" + col + ", constraint=" + constraint + ")"));
        }
        UpdateValueExecuter uvt = new UpdateValueExecuter(value, row, col, frame, constraint);
        uvt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performUpdateValue(Object value, int row, int col, Object constraint) {
        boolean ok = true;
        if (this.getDatabaseSession().isConnected()) {
            String whereBed = this.createWherePartOfPreparedStatement(row);
            if (whereBed != null) {
                StringBuilder sqlBuffer = new StringBuilder("select count(");
                int countPk = 0;
                for (int x = 0; x < this.columnPkInfo.length; ++x) {
                    if (!this.columnPkInfo[x].booleanValue()) continue;
                    sqlBuffer.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnNames[x]));
                    sqlBuffer.append(") from ");
                    sqlBuffer.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.lastTable));
                    sqlBuffer.append(' ');
                    sqlBuffer.append(whereBed);
                    ++countPk;
                    break;
                }
                if (countPk == 0) {
                    this.mainFrame.showDBMessageWithoutContinueAction("no primary key definied\ndefine primary keys with context menu from table header", "update value");
                    return false;
                }
                int testCount = -1;
                ResultSet rs = null;
                PreparedStatement psTest = null;
                try {
                    psTest = this.getDatabaseSession().createPreparedStatement(sqlBuffer.toString());
                    this.completeWherePartOfPreparedStatement(psTest, row, 0, constraint);
                    rs = psTest.executeQuery();
                    if (rs != null && rs.next()) {
                        testCount = rs.getInt(1);
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("update test count failed: " + sqlBuffer.toString()), (Throwable)sqle);
                    this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "test of primary key");
                    ok = false;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (psTest != null) {
                            psTest.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("performUpdateValue close cursors failed: " + e.toString()));
                    }
                }
                if (ok && testCount == -1) {
                    this.mainFrame.showDBMessageWithoutContinueAction(this.getDatabaseSession().getLastErrorMessage(), "update value");
                    this.currentCellEditor.toFront();
                    ok = false;
                } else if (testCount == 0) {
                    this.mainFrame.showDBMessageWithoutContinueAction("test count got 0 datasets!", "update value");
                    this.currentCellEditor.toFront();
                    ok = false;
                } else if (testCount > 1) {
                    this.mainFrame.showDBMessageWithoutContinueAction("test count got more than one datasets\n(" + String.valueOf(testCount) + ")", "update value");
                    this.currentCellEditor.toFront();
                    ok = false;
                }
                if (testCount != 1) return ok;
                StringBuilder sb = new StringBuilder();
                sb.append("update ");
                sb.append(this.lastTable);
                sb.append(" set ");
                sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnNames[col]));
                sb.append("=? ");
                sb.append(whereBed);
                Statement ps = null;
                try {
                    ps = this.getDatabaseSession().createPreparedStatement(sb.toString());
                    ok = this.setParameterValue((PreparedStatement)ps, 1, col, value, constraint);
                    if (!ok) return ok;
                    this.completeWherePartOfPreparedStatement((PreparedStatement)ps, row, 1, constraint);
                    int count = ps.executeUpdate();
                    if (count == 1) {
                        if (this.columnTypeNames[col].contains("BINARY") || this.columnTypeNames[col].equals("BLOB")) {
                            if (value instanceof String) {
                                this.setValueAtLogicalIndexes(row, col, new BinaryDataFile((String)value), null);
                                return ok;
                            }
                            this.setValueAtLogicalIndexes(row, col, value, null);
                            return ok;
                        }
                        this.setValueAtLogicalIndexes(row, col, value, constraint);
                        return ok;
                    }
                    ok = false;
                    return ok;
                }
                catch (SQLException sqle) {
                    logger.error((Object)("update failed: " + sb.toString()), (Throwable)sqle);
                    this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "update value");
                    this.currentCellEditor.toFront();
                    ok = false;
                    return ok;
                }
                finally {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("performUpdateValue close prepared statement failed: " + e.toString()));
                    }
                }
            }
            this.currentCellEditor.toFront();
            return false;
        }
        this.mainFrame.showDBMessageWithoutContinueAction("database connection is disconnected", "update value");
        this.currentCellEditor.toFront();
        return false;
    }

    private boolean setParameterValue(PreparedStatement ps, int paramIndex, int columnIndex, Object value, Object constraint) {
        boolean ok;
        block53: {
            ok = true;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setParameterValue(paramIndex=" + paramIndex + ", columnIndex=" + columnIndex + ", constraint=" + constraint + ", value=" + value));
            }
            try {
                if (this.getColumnBasicType(columnIndex) == BasicDataType.CHARACTER.getId()) {
                    if (value != null && value.toString().length() > 0) {
                        ps.setString(paramIndex, value.toString());
                    } else {
                        ps.setNull(paramIndex, 12);
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.INTEGER.getId()) {
                    if (value != null && value.toString().length() > 0) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)" type=BASICTYPE_INTEGER");
                            }
                            ps.setInt(paramIndex, Integer.parseInt(value.toString().trim()));
                        }
                        catch (NumberFormatException nfe) {
                            ok = false;
                            this.mainFrame.showDBMessageWithoutContinueAction("interpretation of integer value failed\n" + nfe.getMessage(), "update");
                        }
                    } else {
                        ps.setNull(paramIndex, 2);
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.DOUBLE.getId()) {
                    if (value != null && value.toString().length() > 0) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)" type=BASICTYPE_DOUBLE");
                            }
                            ps.setDouble(paramIndex, Double.parseDouble(value.toString().trim()));
                        }
                        catch (NumberFormatException nfe) {
                            ok = false;
                            this.mainFrame.showDBMessageWithoutContinueAction("interpretation of double value failed\n" + nfe.getMessage(), "update");
                        }
                    } else {
                        ps.setNull(paramIndex, 2);
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.LONG.getId()) {
                    if (value != null && value.toString().length() > 0) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)" type=BASICTYPE_LONG");
                            }
                            ps.setLong(paramIndex, Long.parseLong(value.toString().trim()));
                        }
                        catch (NumberFormatException nfe) {
                            ok = false;
                            this.mainFrame.showDBMessageWithoutContinueAction("interpretation of long value failed\n" + nfe.getMessage(), "update");
                        }
                    } else {
                        ps.setNull(paramIndex, 2);
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.BOOLEAN.getId()) {
                    if (value != null && value.toString().length() > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)" type=BASICTYPE_BOOLEAN");
                        }
                        ps.setBoolean(paramIndex, Boolean.parseBoolean(value.toString().trim()));
                    } else {
                        ps.setNull(paramIndex, 16);
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.DATE.getId()) {
                    try {
                        if (value != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)" type=BASICTYPE_DATE");
                            }
                            if (value instanceof String && value.toString().length() > 0) {
                                if (constraint instanceof String) {
                                    SimpleDateFormat sdf2 = new SimpleDateFormat((String)constraint);
                                    Date date = null;
                                    try {
                                        date = sdf2.parse(value.toString().trim());
                                    }
                                    catch (ParseException pe) {
                                        date = GenericDateUtil.parseDate(value.toString().trim());
                                    }
                                    ps.setTimestamp(paramIndex, new Timestamp(date.getTime()));
                                    break block53;
                                }
                                Date date = GenericDateUtil.parseDate(value.toString().trim());
                                ps.setTimestamp(paramIndex, new Timestamp(date.getTime()));
                                break block53;
                            }
                            if (value instanceof Timestamp) {
                                ps.setTimestamp(paramIndex, (Timestamp)value);
                            }
                            break block53;
                        }
                        ps.setNull(paramIndex, 91);
                    }
                    catch (ParseException pe) {
                        this.mainFrame.showDBMessageWithoutContinueAction(pe.getMessage() + "\nCheck date format in preferences or in value editor.", "validate date value");
                        ok = false;
                    }
                    break block53;
                }
                if (this.getColumnBasicType(columnIndex) == BasicDataType.CLOB.getId()) {
                    if (value != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)" type=BASICTYPE_CLOB");
                        }
                        ps.setCharacterStream(paramIndex, (Reader)new StringReader(value.toString()), value.toString().length());
                    } else {
                        ps.setNull(paramIndex, 2005);
                    }
                } else if (this.getColumnBasicType(columnIndex) == BasicDataType.BINARY.getId()) {
                    if (value instanceof String) {
                        if (value != null && value.toString().length() > 0) {
                            try {
                                File f = new File(value.toString());
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)" type=BASICTYPE_BINARY");
                                }
                                ps.setBinaryStream(paramIndex, (InputStream)new FileInputStream(f), (int)f.length());
                            }
                            catch (FileNotFoundException fnfe) {
                                this.mainFrame.showDBMessageWithoutContinueAction(fnfe.getMessage(), "File upload");
                                ok = false;
                            }
                        } else {
                            ps.setNull(paramIndex, -4);
                        }
                    } else if (value instanceof byte[]) {
                        ps.setBytes(paramIndex, (byte[])value);
                    }
                }
            }
            catch (SQLException sqle) {
                this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "set value");
                this.currentCellEditor.toFront();
                ok = false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\n");
        }
        return ok;
    }

    private void setupParameterValues(CallableStatement callableStatement, SQLStatement sqlps) throws Exception {
        SQLPSParam parameter = null;
        String value = null;
        for (int i = 0; i < sqlps.getParams().size(); ++i) {
            parameter = sqlps.getParams().get(i);
            value = parameter.getValue();
            try {
                if (parameter.getBasicType() == BasicDataType.CHARACTER.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 12);
                        continue;
                    }
                    if (value != null && value.length() > 0) {
                        callableStatement.setString(parameter.getIndex(), value);
                        continue;
                    }
                    callableStatement.setNull(parameter.getIndex(), 12);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.DOUBLE.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 2);
                        continue;
                    }
                    if (value != null && value.trim().length() > 0) {
                        try {
                            callableStatement.setDouble(parameter.getIndex(), Double.parseDouble(value.trim()));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("Interpretation of double value failed\n" + nfe.getMessage(), nfe);
                        }
                    }
                    callableStatement.setNull(parameter.getIndex(), 2);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.LONG.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 2);
                        continue;
                    }
                    if (value != null && value.trim().length() > 0) {
                        try {
                            callableStatement.setLong(parameter.getIndex(), Long.parseLong(value.trim()));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("Interpretation of long value failed\n" + nfe.getMessage(), nfe);
                        }
                    }
                    callableStatement.setNull(parameter.getIndex(), 2);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.INTEGER.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 2);
                        continue;
                    }
                    if (value != null && value.trim().length() > 0) {
                        try {
                            callableStatement.setInt(parameter.getIndex(), Integer.parseInt(value.trim()));
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new Exception("Interpretation of integer value failed\n" + nfe.getMessage(), nfe);
                        }
                    }
                    callableStatement.setNull(parameter.getIndex(), 2);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.BOOLEAN.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 16);
                        continue;
                    }
                    if (value != null && value.length() > 0) {
                        callableStatement.setBoolean(parameter.getIndex(), Boolean.parseBoolean(value));
                        continue;
                    }
                    callableStatement.setNull(parameter.getIndex(), 16);
                    continue;
                }
                if (parameter.getBasicType() == BasicDataType.DATE.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 91);
                        continue;
                    }
                    try {
                        if (value != null) {
                            if (value.length() <= 0) continue;
                            Date date = GenericDateUtil.parseDate(value.trim());
                            callableStatement.setTimestamp(parameter.getIndex(), new Timestamp(date.getTime()));
                            continue;
                        }
                        callableStatement.setNull(parameter.getIndex(), 91);
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new Exception(pe.getMessage() + ": check date format in preferences", pe);
                    }
                }
                if (parameter.getBasicType() == BasicDataType.CLOB.getId()) {
                    if (parameter.isOutParam()) {
                        callableStatement.registerOutParameter(parameter.getIndex(), 2005);
                        continue;
                    }
                    if (value != null && value.length() > 0) {
                        callableStatement.setCharacterStream(parameter.getIndex(), (Reader)new StringReader(value), value.length());
                        continue;
                    }
                    callableStatement.setNull(parameter.getIndex(), 2005);
                    continue;
                }
                if (parameter.getBasicType() != BasicDataType.BINARY.getId()) continue;
                if (parameter.isOutParam()) {
                    callableStatement.registerOutParameter(parameter.getIndex(), -4);
                    continue;
                }
                if (value != null && value.length() > 0) {
                    try {
                        File f = new File(value);
                        callableStatement.setBinaryStream(parameter.getIndex(), (InputStream)new FileInputStream(f), (int)f.length());
                        continue;
                    }
                    catch (FileNotFoundException fnfe) {
                        throw new Exception("File upload for binary db upload failed: " + fnfe.getMessage(), fnfe);
                    }
                }
                callableStatement.setNull(parameter.getIndex(), -4);
                continue;
            }
            catch (SQLException sqle) {
                throw new Exception("set parameter failed:" + sqle.getMessage(), sqle);
            }
        }
    }

    public void writeLOBValueInFile(File file, int row, int col, JFrame frame) {
        WriteLobInFileThread thread = new WriteLobInFileThread(file, row, col, frame);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performWriteLOBValueInFile(File file, int row, int col) {
        boolean ok = false;
        if (this.getDatabaseSession().isConnected()) {
            String whereBed = this.createWherePartOfPreparedStatement(row);
            StringBuilder sql_loc = new StringBuilder("select count(");
            int countPk = 0;
            for (int x = 0; x < this.columnPkInfo.length; ++x) {
                if (!this.columnPkInfo[x].booleanValue()) continue;
                sql_loc.append(this.columnNames[x]);
                sql_loc.append(") from ");
                sql_loc.append(this.lastTable);
                sql_loc.append(' ');
                sql_loc.append(whereBed);
                ++countPk;
                break;
            }
            if (countPk == 0) {
                this.mainFrame.showDBMessageWithoutContinueAction("No primary key definied\ndefine primary keys with context menu of table header.", "select LOB");
                return false;
            }
            int testCount = -1;
            ResultSet rs_loc = null;
            PreparedStatement psTest = null;
            try {
                psTest = this.getDatabaseSession().createPreparedStatement(sql_loc.toString());
                this.completeWherePartOfPreparedStatement(psTest, row, 0, null);
                rs_loc = psTest.executeQuery();
                if (rs_loc != null && rs_loc.next()) {
                    testCount = rs_loc.getInt(1);
                }
            }
            catch (SQLException sqle) {
                this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "test primary key");
                ok = false;
            }
            finally {
                try {
                    if (rs_loc != null) {
                        rs_loc.close();
                    }
                    if (psTest != null) {
                        psTest.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("writeLOBValueInFile close cursors failed: " + e.toString()), (Throwable)e);
                }
            }
            if (testCount == -1) {
                this.mainFrame.showDBMessageWithoutContinueAction(this.getDatabaseSession().getLastErrorMessage(), "select LOB");
                this.currentCellEditor.toFront();
                ok = false;
            } else if (testCount == 0) {
                this.mainFrame.showDBMessageWithoutContinueAction("test count got 0 datasets", "select LOB");
                this.currentCellEditor.toFront();
                ok = false;
            } else if (testCount > 1) {
                this.mainFrame.showDBMessageWithoutContinueAction("test count got more than one datasets (" + String.valueOf(testCount) + ")", "select LOB");
                this.currentCellEditor.toFront();
                ok = false;
            }
            if (testCount != 1) return ok;
            StringBuilder sb = new StringBuilder();
            sb.append("select ");
            sb.append(this.columnNames[col]);
            sb.append(" from ");
            sb.append(this.lastTable);
            sb.append(whereBed);
            PreparedStatement ps = null;
            InputStream is = null;
            FileOutputStream os = null;
            try {
                ps = this.session.createPreparedStatement(sb.toString());
                this.completeWherePartOfPreparedStatement(ps, row, 0, null);
                rs_loc = ps.executeQuery();
                if (rs_loc == null) return ok;
                if (!rs_loc.next()) return ok;
                if (this.columnTypeNames[col].equals("BLOB") || this.columnTypeNames[col].equals("LONGVARBINARY")) {
                    Blob test = rs_loc.getBlob(1);
                    if (test instanceof Blob) {
                        Blob blob = test;
                        is = blob.getBinaryStream();
                    } else if (test != null) {
                        logger.error((Object)("Get anything else than an Blob object:" + test.getClass().getName()));
                    }
                }
                try {
                    if (is != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("write in File " + file.getAbsolutePath()));
                        }
                        os = new FileOutputStream(file);
                        byte[] buffer = new byte[1024];
                        int length = -1;
                        while ((length = is.read(buffer)) != -1) {
                            os.write(buffer, 0, length);
                        }
                        ok = true;
                        return ok;
                    }
                    logger.error((Object)"write lob in file failed: no inputstream received");
                    return ok;
                }
                catch (IOException ioe) {
                    this.mainFrame.showDBMessageWithoutContinueAction(ioe.getMessage(), "write cell data");
                    this.currentCellEditor.toFront();
                }
                return ok;
            }
            catch (SQLException sqle) {
                this.mainFrame.showDBMessageWithoutContinueAction(sqle.getMessage(), "read cell data");
                this.currentCellEditor.toFront();
                return ok;
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
                try {
                    rs_loc.close();
                    ps.close();
                }
                catch (Exception e) {}
            }
        }
        this.mainFrame.showDBMessageWithoutContinueAction("database connection disconnected", "read data from db");
        this.currentCellEditor.toFront();
        return ok;
    }

    public void insertNewRowInDB() {
        InsertNewRowInDBThread thread = new InsertNewRowInDBThread();
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performInsertNewRowInDB() {
        boolean ok = true;
        if (this.newRowIndex != -1) {
            Object[] row = this.resultSetResults.get(this.newRowIndex);
            int rowCount = 0;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (this.getColumnBasicType(i) == -100) continue;
                ++rowCount;
            }
            if (rowCount > 0) {
                int i;
                Object[] newRow_loc = new Object[rowCount];
                int[] columnIndexes = new int[rowCount];
                int x = 0;
                for (int i2 = 0; i2 < row.length; ++i2) {
                    if (this.getColumnBasicType(i2) == -100) continue;
                    newRow_loc[x] = row[i2];
                    columnIndexes[x] = i2;
                    ++x;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("insert into ");
                sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.lastTable));
                int valueCount = 0;
                boolean firstLoop = true;
                for (i = 0; i < newRow_loc.length; ++i) {
                    if (newRow_loc[i] == null) continue;
                    if (firstLoop) {
                        sb.append(" (");
                        firstLoop = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnNames[columnIndexes[i]]));
                    ++valueCount;
                }
                firstLoop = true;
                if (valueCount == 0) {
                    sb.append(" values (");
                    for (i = 0; i < newRow_loc.length; ++i) {
                        if (!firstLoop) {
                            sb.append(',');
                        } else {
                            firstLoop = false;
                        }
                        sb.append("null");
                    }
                    sb.append(')');
                } else {
                    sb.append(") values (");
                    for (i = 0; i < newRow_loc.length; ++i) {
                        if (newRow_loc[i] == null) continue;
                        if (!firstLoop) {
                            sb.append(',');
                        } else {
                            firstLoop = false;
                        }
                        sb.append('?');
                    }
                    sb.append(')');
                }
                Statement ps = null;
                try {
                    ps = this.getDatabaseSession().createPreparedStatement(sb.toString());
                    int paramIndex = 1;
                    for (int i3 = 0; i3 < newRow_loc.length; ++i3) {
                        if (newRow_loc[i3] == null) continue;
                        ok = this.setParameterValue((PreparedStatement)ps, paramIndex, columnIndexes[i3], newRow_loc[i3], null);
                        ++paramIndex;
                        if (!ok) break;
                    }
                    if (ok) {
                        ps.executeUpdate();
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("insert failed: " + sb.toString()), (Throwable)sqle);
                    this.mainFrame.showDBMessage(sqle.getMessage(), "insert row");
                    ok = false;
                }
                finally {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("insertNewRowInDB close statement failed: " + e.toString()));
                    }
                }
            }
            if (ok) {
                this.newRowIndex = -1;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public int getNewRowIndex() {
        return this.newRowIndex;
    }

    public boolean insertRowInTable() {
        if (this.getColumnCount() > 0) {
            this.newRow = new Object[this.getColumnCount()];
            this.resultSetResults.add(this.newRow);
            this.newRowIndex = this.resultSetResults.indexOf(this.newRow);
            this.fireTableRowsInserted(this.newRowIndex, this.newRowIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new line with index=" + this.newRowIndex + " appended"));
            }
            return true;
        }
        return false;
    }

    public boolean insertRowInTableAsCopy() {
        if (this.getColumnCount() > 0) {
            int currentRowIndex = this.table.getSelectedRow();
            if (currentRowIndex != -1) {
                Object[] temp = this.resultSetResults.get(currentRowIndex);
                this.newRow = new Object[this.getColumnCount()];
                for (int i = 0; i < this.newRow.length; ++i) {
                    this.newRow[i] = temp[i];
                }
                this.resultSetResults.add(this.newRow);
            } else {
                this.newRow = new Object[this.getColumnCount()];
                this.resultSetResults.add(this.newRow);
            }
            this.newRowIndex = this.resultSetResults.indexOf(this.newRow);
            this.fireTableRowsInserted(this.newRowIndex, this.newRowIndex);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new line with index=" + this.newRowIndex + " appended"));
            }
            return true;
        }
        return false;
    }

    public void removeNewRow() {
        if (this.newRowIndex != -1) {
            this.resultSetResults.remove(this.newRowIndex);
            this.fireTableRowsDeleted(this.newRowIndex, this.newRowIndex);
            this.newRowIndex = -1;
        }
    }

    public boolean exportTableInCSVFile(File file, String delim, String enclosure, int exportType, String dateFormatTemplate, boolean withHeader, boolean setComma4Point) {
        boolean ok = false;
        try {
            this.mainFrame.setStatusMessage("export table in file:" + file.getName());
            BufferedWriter bw = null;
            bw = Main.currentCharSet != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Main.currentCharSet)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            if (exportType == 0) {
                for (int r = 0; r < this.resultSetResults.size(); ++r) {
                    if (r == 0 && withHeader) {
                        bw.write(this.createDelimitedHeaderLine(delim, enclosure));
                        bw.newLine();
                    }
                    bw.write(this.createDelimitedLine(r, delim, enclosure, setComma4Point));
                    bw.newLine();
                }
            } else if (exportType == 1) {
                String insertStatementBegin = this.createInsertStatementText();
                for (int r = 0; r < this.resultSetResults.size(); ++r) {
                    bw.write(this.createInsertLine(r, insertStatementBegin, dateFormatTemplate));
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
            ok = true;
            this.mainFrame.setStatusMessage("ready");
        }
        catch (FileNotFoundException fnfe) {
            this.mainFrame.showDBMessageWithoutContinueAction(fnfe.getMessage(), "open export file");
        }
        catch (IOException ioe) {
            this.mainFrame.showDBMessageWithoutContinueAction(ioe.getMessage(), "write in export file");
        }
        return ok;
    }

    public void exportTableToSpreadSheetFile(File f, boolean withHeader) throws Exception {
        ExporterToSpreadsheetFile exporter = new ExporterToSpreadsheetFile();
        exporter.setOutputFile(f);
        exporter.setDateFormat(MainFrame.getDateFormatMask());
        for (int r = 0; r < this.resultSetResults.size(); ++r) {
            if (r == 0 && withHeader) {
                exporter.writeRow(this.columnNames);
            }
            Object[] oneRow = this.resultSetResults.get(r);
            exporter.writeRow(oneRow);
        }
        exporter.writeWorkbook();
        exporter.close();
    }

    public String exportTableToString(String delim, String enclosure, int exportType, String dateFormatTemplate, boolean withHeader, boolean setComma4Point) {
        StringBuilder sb = new StringBuilder();
        if (exportType == 0) {
            for (int r = 0; r < this.resultSetResults.size(); ++r) {
                if (r == 0 && withHeader) {
                    sb.append(this.createDelimitedHeaderLine(delim, enclosure));
                    sb.append('\n');
                }
                sb.append(this.createDelimitedLine(r, delim, enclosure, setComma4Point));
                sb.append('\n');
            }
        } else if (exportType == 1) {
            String insertStatementBegin = this.createInsertStatementText();
            for (int r = 0; r < this.resultSetResults.size(); ++r) {
                sb.append(this.createInsertLine(r, insertStatementBegin, dateFormatTemplate));
                sb.append('\n');
            }
        }
        this.mainFrame.setStatusMessage("ready");
        return sb.toString();
    }

    public String createImportScriptText(int limit, String dateFormatTemplate) {
        StringBuilder sb = new StringBuilder();
        String insertStatementBegin = this.createInsertStatementText();
        for (int r = 0; r < this.resultSetResults.size() && r != limit; ++r) {
            sb.append(this.createInsertLine(r, insertStatementBegin, dateFormatTemplate));
            sb.append(Main.LINE_FEED);
        }
        return sb.toString();
    }

    public boolean exportTableInMultipleFiles(File fileTemplate, String delim, String enclosure, int exportType, String dateFormatTemplate, long maxDatasetsPerFile, boolean withHeader, boolean setComma4Point) {
        boolean ok = false;
        int fileIndex = 0;
        int rowCountPerFile = 0;
        try {
            BufferedWriter bw = null;
            boolean firstLoop = true;
            if (exportType == 0) {
                for (int r = 0; r < this.resultSetResults.size(); ++r) {
                    File f;
                    if (firstLoop) {
                        firstLoop = false;
                        f = fileIndex > 0 ? this.createNextFile(fileTemplate, fileIndex) : fileTemplate;
                        this.mainFrame.setStatusMessage("export table in file: " + f.getName());
                        bw = new BufferedWriter(new FileWriter(f));
                        if (withHeader) {
                            bw.write(this.createDelimitedHeaderLine(delim, enclosure));
                            bw.newLine();
                        }
                    } else if ((long)rowCountPerFile == maxDatasetsPerFile) {
                        rowCountPerFile = 0;
                        f = this.createNextFile(fileTemplate, ++fileIndex);
                        this.mainFrame.setStatusMessage("export table in file: " + f.getName());
                        bw.flush();
                        bw.close();
                        bw = new BufferedWriter(new FileWriter(f));
                        if (withHeader) {
                            bw.write(this.createDelimitedHeaderLine(delim, enclosure));
                            bw.newLine();
                        }
                    }
                    bw.write(this.createDelimitedLine(r, delim, enclosure, setComma4Point));
                    bw.newLine();
                    ++rowCountPerFile;
                }
            } else if (exportType == 1) {
                String insertStatementBegin = this.createInsertStatementText();
                for (int r = 0; r < this.resultSetResults.size(); ++r) {
                    File f;
                    if (firstLoop) {
                        firstLoop = false;
                        f = fileIndex > 0 ? this.createNextFile(fileTemplate, fileIndex) : fileTemplate;
                        this.mainFrame.setStatusMessage("export table in file: " + f.getName());
                        bw = new BufferedWriter(new FileWriter(f));
                    } else if ((long)rowCountPerFile == maxDatasetsPerFile) {
                        rowCountPerFile = 0;
                        f = this.createNextFile(fileTemplate, ++fileIndex);
                        this.mainFrame.setStatusMessage("export table in file: " + f.getName());
                        bw.flush();
                        bw.close();
                        bw = new BufferedWriter(new FileWriter(f));
                    }
                    bw.write(this.createInsertLine(r, insertStatementBegin, dateFormatTemplate));
                    bw.newLine();
                    ++rowCountPerFile;
                }
            }
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            ok = true;
            this.mainFrame.setStatusMessage("Fertig");
        }
        catch (FileNotFoundException fnfe) {
            this.mainFrame.showDBMessageWithoutContinueAction(fnfe.getMessage(), "open export file");
        }
        catch (IOException ioe) {
            this.mainFrame.showDBMessageWithoutContinueAction(ioe.getMessage(), "write in export file");
        }
        return ok;
    }

    public File createNextFile(File f, int index) {
        String path = f.getParent();
        path = path == null ? "./" : path + "/";
        String fullname = f.getName();
        int p0 = fullname.lastIndexOf(".");
        String name = p0 != -1 ? fullname.substring(0, p0) + "_" + String.valueOf(index) + fullname.substring(p0, fullname.length()) : fullname + "_" + String.valueOf(index);
        return new File(path + name);
    }

    private String createDelimitedLine(int row, String delim, String enclosure, boolean setComma4Point) {
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (enclosure != null) {
                sb.append(enclosure);
            }
            if (this.getColumnBasicType(c) == BasicDataType.DATE.getId()) {
                if (this.getValueAt(row, c) != null) {
                    sb.append(this.sdf.format((Date)this.getValueAt(row, c)));
                }
            } else if (BasicDataType.isNumberType(this.getColumnBasicType(c))) {
                if (this.getValueAt(row, c) != null) {
                    if (setComma4Point) {
                        sb.append(this.getValueAt(row, c).toString().replace('.', ','));
                    } else {
                        sb.append(this.getValueAt(row, c).toString());
                    }
                }
            } else if (this.getValueAt(row, c) != null) {
                sb.append(this.getValueAt(row, c).toString().replace('\n', ' ').replace('\r', ' '));
            }
            if (enclosure != null) {
                sb.append(enclosure);
            }
            if (c >= this.getColumnCount() - 1) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    private String createDelimitedHeaderLine(String delim, String enclosure) {
        StringBuilder sb = new StringBuilder();
        boolean firstLoop = true;
        for (int c = 0; c < this.columnNames.length; ++c) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(delim);
            }
            if (enclosure != null) {
                sb.append(enclosure);
            }
            sb.append(this.columnNames[c]);
            if (enclosure == null) continue;
            sb.append(enclosure);
        }
        return sb.toString();
    }

    private String createInsertLine(int row, String insertStart, String dateFormatTemplate) {
        StringBuilder sb = new StringBuilder();
        sb.append(insertStart);
        for (int c = 0; c < this.getColumnCount(); ++c) {
            if (this.getColumnBasicType(c) == BasicDataType.DATE.getId()) {
                if (this.getValueAt(row, c) != null) {
                    String s = this.sdf.format((Date)this.getValueAt(row, c));
                    int p0 = dateFormatTemplate.indexOf("<");
                    if (p0 != -1) {
                        int p1 = dateFormatTemplate.indexOf(">", p0 + 1);
                        dateFormatTemplate = dateFormatTemplate.substring(0, p0) + s + dateFormatTemplate.substring(p1 + 1, dateFormatTemplate.length());
                    }
                    sb.append(dateFormatTemplate);
                } else {
                    sb.append("null");
                }
            } else if (BasicDataType.isStringType(this.getColumnBasicType(c))) {
                sb.append('\'');
                if (this.getValueAt(row, c) != null) {
                    sb.append(this.dublicateSingleQuotas(this.getValueAt(row, c).toString().replace('\n', ' ').replace('\r', ' ')));
                }
                sb.append('\'');
            } else if (this.getValueAt(row, c) != null) {
                sb.append(this.getValueAt(row, c).toString().replace('\n', ' ').replace('\r', ' '));
            } else {
                sb.append("null");
            }
            if (c < this.getColumnCount() - 1) {
                sb.append(',');
                continue;
            }
            sb.append(");");
        }
        return sb.toString();
    }

    private String dublicateSingleQuotas(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\'') {
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getSelectedColumnName() {
        int col = this.table.getSelectedColumn();
        if (col != -1) {
            return this.columnNames[col];
        }
        return null;
    }

    public boolean findValue(String value, boolean caseSensitive, boolean inSelectedColumn) {
        this.lastSearchPosRow = this.table.getSelectedRow() - 1;
        if (this.lastSearchPosRow == -2) {
            this.lastSearchPosRow = -1;
        }
        this.lastSearchPosCol = this.table.getSelectedColumn();
        if (this.lastSearchPosCol == -2) {
            this.lastSearchPosCol = -1;
        }
        return this.findNextValue(value, caseSensitive, inSelectedColumn);
    }

    public boolean findNextValue(String value, boolean caseSensitive, boolean inSelectedColumn) {
        boolean founded = false;
        WildcardSearch comparer = new WildcardSearch();
        if (inSelectedColumn) {
            int col = this.lastSearchPosCol;
            if (this.lastSearchPosRow < this.resultSetResults.size() - 1) {
                ++this.lastSearchPosRow;
            }
            for (int r = this.lastSearchPosRow; r < this.resultSetResults.size(); ++r) {
                Object cellObject = this.getValueAt(r, col);
                if (cellObject == null) continue;
                String cellValue = cellObject instanceof Timestamp ? this.sdf.format(cellObject) : cellObject.toString();
                if (caseSensitive) {
                    if (!comparer.patternSearch(value, cellValue)) continue;
                    this.lastSearchPosRow = r;
                    this.lastSearchPosCol = col;
                    this.table.setRowSelectionInterval(r, r);
                    founded = true;
                } else {
                    if (!comparer.patternSearch(value.toUpperCase(), cellValue.toUpperCase())) continue;
                    this.lastSearchPosRow = r;
                    this.lastSearchPosCol = col;
                    this.table.setRowSelectionInterval(r, r);
                    founded = true;
                }
                break;
            }
        } else {
            if (this.lastSearchPosCol < this.getColumnCount() - 1) {
                ++this.lastSearchPosCol;
            } else if (this.lastSearchPosRow < this.resultSetResults.size() - 1) {
                ++this.lastSearchPosRow;
            }
            if (this.lastSearchPosRow < 0) {
                this.lastSearchPosRow = 0;
            }
            int c = this.lastSearchPosCol;
            for (int r = this.lastSearchPosRow; r < this.resultSetResults.size(); ++r) {
                while (c < this.getColumnCount()) {
                    Object cellObject = this.getValueAt(r, c);
                    if (cellObject != null) {
                        String cellValue = cellObject instanceof Timestamp ? this.sdf.format(cellObject) : cellObject.toString();
                        if (caseSensitive) {
                            if (comparer.patternSearch(value, cellValue)) {
                                this.lastSearchPosRow = r;
                                this.lastSearchPosCol = c;
                                this.table.setRowSelectionInterval(r, r);
                                this.table.setColumnSelectionInterval(c, c);
                                founded = true;
                                break;
                            }
                        } else if (comparer.patternSearch(value.toUpperCase(), cellValue.toUpperCase())) {
                            this.lastSearchPosRow = r;
                            this.lastSearchPosCol = c;
                            this.table.setRowSelectionInterval(r, r);
                            this.table.setColumnSelectionInterval(c, c);
                            founded = true;
                            break;
                        }
                    }
                    ++c;
                }
                if (c >= this.getColumnCount()) {
                    c = 0;
                    continue;
                }
                break;
            }
        }
        return founded;
    }

    public void sortByNewSelect(int columnIndex) {
        SQLStatement sortStat = new SQLStatement();
        sortStat.setSQL(this.createSQLWithOrderBy(columnIndex));
        this.executeStatement(sortStat);
    }

    public String createSQLWithOrderBy(int col) {
        String columnName = this.getColumnName(col).toUpperCase();
        String sql_loc = this.lastSelectStatement.getSQL();
        String ORDER_BY = " order by ";
        int p0 = sql_loc.toLowerCase().lastIndexOf(" order by ");
        if (p0 != -1) {
            StringBuilder sb = new StringBuilder();
            sb.append(sql_loc.substring(0, p0 + " order by ".length()));
            sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(columnName));
            StringTokenizer st = new StringTokenizer(sql_loc.substring(p0 + " order by ".length(), sql_loc.length()), ",", false);
            boolean hasColumnRemoved = false;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (!hasColumnRemoved) {
                    if (!token.equals(columnName)) {
                        if (token.startsWith(columnName)) {
                            sb.append(',');
                            sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(token.substring(columnName.length(), token.length())));
                            hasColumnRemoved = true;
                            continue;
                        }
                        sb.append(',');
                        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(token));
                        continue;
                    }
                    hasColumnRemoved = true;
                    continue;
                }
                sb.append(',');
                sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(token));
            }
            return sb.toString();
        }
        return sql_loc + " order by " + SQLCodeGenerator.getInstance().getEncapsulatedName(columnName);
    }

    public boolean enabledForSorting(int columnIndex) {
        int basicType;
        boolean ok = this.getColumnNameByLogicalColIndex(columnIndex).indexOf(40) != -1 ? false : ((basicType = this.getColumnBasicType(columnIndex)) == BasicDataType.CHARACTER.getId() ? true : (basicType == BasicDataType.DATE.getId() ? true : BasicDataType.isNumberType(basicType)));
        return ok;
    }

    public void sortVector(int columnIndex) {
        this.bubbleSort(columnIndex);
    }

    private void bubbleSort(int columnIndex) {
        Object[] row1 = null;
        Object[] row2 = null;
        Object o1 = null;
        double n1 = 0.0;
        Date d1 = null;
        Date d2 = null;
        String s1 = null;
        String s2 = null;
        int maxIndex = this.resultSetResults.size() - 1;
        int cResult = 1;
        int basicType = this.getColumnBasicType(columnIndex);
        boolean hasChanged = true;
        if (BasicDataType.isNumberType(basicType)) {
            int i;
            double[] numbers = new double[this.resultSetResults.size()];
            for (i = 0; i < numbers.length; ++i) {
                row1 = this.resultSetResults.get(i);
                o1 = row1[columnIndex];
                if (o1 != null) {
                    if (o1 instanceof Number) {
                        numbers[i] = ((Number)o1).doubleValue();
                        continue;
                    }
                    if (!(o1 instanceof String)) continue;
                    numbers[i] = Double.parseDouble((String)o1);
                    continue;
                }
                numbers[i] = 0.0;
            }
            while (hasChanged) {
                hasChanged = false;
                for (i = 0; i < maxIndex; ++i) {
                    if (i == 0) {
                        row1 = this.resultSetResults.get(i);
                        row2 = this.resultSetResults.get(i + 1);
                    } else {
                        if (cResult <= 0) {
                            row1 = row2;
                        }
                        row2 = this.resultSetResults.get(i + 1);
                    }
                    int n = numbers[i] < numbers[i + 1] ? -1 : (cResult = numbers[i] > numbers[i + 1] ? 1 : 0);
                    if (cResult <= 0) continue;
                    this.resultSetResults.set(i, row2);
                    this.resultSetResults.set(i + 1, row1);
                    n1 = numbers[i];
                    numbers[i] = numbers[i + 1];
                    numbers[i + 1] = n1;
                    hasChanged = true;
                }
                --maxIndex;
            }
        } else if (BasicDataType.isStringType(basicType)) {
            while (hasChanged) {
                hasChanged = false;
                for (int i = 0; i < maxIndex; ++i) {
                    if (i == 0) {
                        row1 = this.resultSetResults.get(i);
                        row2 = this.resultSetResults.get(i + 1);
                        s1 = (String)row1[columnIndex];
                        s2 = (String)row2[columnIndex];
                    } else {
                        if (cResult <= 0) {
                            row1 = row2;
                            s1 = s2;
                        }
                        row2 = this.resultSetResults.get(i + 1);
                        s2 = (String)row2[columnIndex];
                    }
                    cResult = s1 == null ? -1 : (s2 == null ? 1 : s1.compareToIgnoreCase(s2));
                    if (cResult <= 0) continue;
                    this.resultSetResults.set(i, row2);
                    this.resultSetResults.set(i + 1, row1);
                    hasChanged = true;
                }
                --maxIndex;
            }
        } else if (basicType == BasicDataType.DATE.getId()) {
            while (hasChanged) {
                hasChanged = false;
                for (int i = 0; i < maxIndex; ++i) {
                    if (i == 0) {
                        row1 = this.resultSetResults.get(i);
                        row2 = this.resultSetResults.get(i + 1);
                        d1 = (Date)row1[columnIndex];
                        d2 = (Date)row2[columnIndex];
                    } else {
                        if (cResult <= 0) {
                            row1 = row2;
                            d1 = d2;
                        }
                        row2 = this.resultSetResults.get(i + 1);
                        d2 = (Date)row2[columnIndex];
                    }
                    cResult = d1 == null ? -1 : (d2 == null ? 1 : d1.compareTo(d2));
                    if (cResult <= 0) continue;
                    this.resultSetResults.set(i, row2);
                    this.resultSetResults.set(i + 1, row1);
                    hasChanged = true;
                }
                --maxIndex;
            }
        }
        this.fireTableRowsUpdated(0, this.resultSetResults.size() - 1);
    }

    @Override
    public int getRowCount() {
        if (this.showsResultSet) {
            if (this.verticalView) {
                if (this.resultSetResults.size() > 0) {
                    if (this.columnNames != null) {
                        return this.resultSetResults.size() * this.columnNames.length;
                    }
                    return 0;
                }
                if (this.columnNames != null) {
                    return this.columnNames.length;
                }
                return 0;
            }
            return this.resultSetResults.size();
        }
        if (this.outputParameters != null) {
            return this.outputParameters.size();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this.showsResultSet) {
            if (this.verticalView) {
                return 2;
            }
            if (this.columnNames == null) {
                return 0;
            }
            return this.columnNames.length;
        }
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (this.showsResultSet) {
            if (this.verticalView) {
                switch (columnIndex) {
                    case 0: {
                        return "column";
                    }
                    case 1: {
                        return "value";
                    }
                }
                logger.error((Object)("getColumnName: invalid column index=" + columnIndex));
                return null;
            }
            return this.columnNames[columnIndex];
        }
        switch (columnIndex) {
            case 0: {
                return "index";
            }
            case 1: {
                return "name";
            }
            case 2: {
                return "value";
            }
        }
        logger.error((Object)("getColumnName: invalid column index=" + columnIndex));
        return null;
    }

    public String getColumnNameByLogicalColIndex(int logicalColumnIndex) {
        if (this.columnNames != null && this.columnNames.length > logicalColumnIndex) {
            return this.columnNames[logicalColumnIndex];
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.showsResultSet) {
            if (this.verticalView) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Object.class;
            }
            return this.columnClasses[columnIndex];
        }
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex == -1 || columnIndex == -1) {
            return null;
        }
        if (this.showsResultSet) {
            if (this.verticalView) {
                if (columnIndex == 0) {
                    if (this.resultSetResults.size() == 0) {
                        return this.columnNames[rowIndex];
                    }
                    int verticalColumnIndex = rowIndex % this.columnNames.length;
                    return this.columnNames[verticalColumnIndex];
                }
                if (this.resultSetResults.size() == 0) {
                    return null;
                }
                int logicalColumnIndex = rowIndex % this.columnNames.length;
                int logicalRowIndex = rowIndex / this.columnNames.length;
                return this.getValueAtLogicalIndexes(logicalRowIndex, logicalColumnIndex);
            }
            return this.getValueAtLogicalIndexes(rowIndex, columnIndex);
        }
        SQLPSParam param = this.outputParameters.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return param.getIndex();
            }
            case 1: {
                return param.getName();
            }
            case 2: {
                return param.getValue();
            }
        }
        return null;
    }

    Object getValueAtLogicalIndexes(int logicalRowIndex, int logicalColIndex) {
        if (logicalRowIndex < this.resultSetResults.size()) {
            Object[] tableRow = this.resultSetResults.get(logicalRowIndex);
            if (logicalColIndex < tableRow.length) {
                return tableRow[logicalColIndex];
            }
            return null;
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.showsResultSet) {
            int internalColumnIndex = 0;
            int internalRowIndex = 0;
            if (this.verticalView) {
                internalColumnIndex = rowIndex % this.columnNames.length;
                internalRowIndex = rowIndex / this.columnNames.length;
            } else {
                internalColumnIndex = columnIndex;
                internalRowIndex = rowIndex;
            }
            this.setValueAtLogicalIndexes(internalRowIndex, internalColumnIndex, value, null);
        }
    }

    void setValueAtLogicalIndexes(int logicalRow, int logicalCol, Object value, Object constraint) {
        block7: {
            if (value == null) {
                this.resultSetResults.get((int)logicalRow)[logicalCol] = null;
            } else if (this.getColumnBasicType(logicalCol) == BasicDataType.DATE.getId()) {
                try {
                    if (constraint instanceof String) {
                        SimpleDateFormat sdf2 = new SimpleDateFormat((String)constraint);
                        this.resultSetResults.get((int)logicalRow)[logicalCol] = new Timestamp(sdf2.parse(value.toString()).getTime());
                        break block7;
                    }
                    Date date = GenericDateUtil.parseDate(value.toString());
                    this.resultSetResults.get((int)logicalRow)[logicalCol] = new Timestamp(date.getTime());
                }
                catch (ParseException pe) {
                    this.mainFrame.showDBMessageWithoutContinueAction(pe.getMessage() + "\nThe date format can be adjusted in preferences", "validate date value");
                }
            } else {
                this.resultSetResults.get((int)logicalRow)[logicalCol] = value;
            }
        }
        this.fireTableRowsUpdated(logicalRow, logicalCol);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public String getColumnTypename(int columnIndex) {
        if (this.verticalView) {
            switch (columnIndex) {
                case 0: {
                    return "";
                }
            }
            return "";
        }
        return this.columnTypeNames[columnIndex];
    }

    public int getColumnBasicType(int columnIndex) {
        if (!this.showsResultSet || this.columnTypeNames[columnIndex].equals("VARCHAR") || this.columnTypeNames[columnIndex].equals("CHAR")) {
            return BasicDataType.CHARACTER.getId();
        }
        return BasicDataType.getBasicTypeByTypes(this.columnTypesValues[columnIndex]);
    }

    public boolean isPrimaryKey(int columnIndex) {
        if (this.columnPkInfo != null && columnIndex < this.columnPkInfo.length) {
            return this.columnPkInfo[columnIndex];
        }
        return false;
    }

    public void setPrimaryKey(int columnIndex, boolean isPrimaryKey) {
        if (columnIndex < this.columnPkInfo.length) {
            this.columnPkInfo[columnIndex] = isPrimaryKey;
        }
    }

    public boolean isExportedKey(int columnIndex) {
        if (this.columnRefFromInfo != null && columnIndex < this.columnRefFromInfo.length) {
            return this.columnRefFromInfo[columnIndex];
        }
        return false;
    }

    public void setExportedKey(int columnIndex, boolean isExportedKey) {
        if (columnIndex < this.columnRefFromInfo.length) {
            this.columnRefFromInfo[columnIndex] = isExportedKey;
        }
    }

    public void setPrimaryKey(String columnName, boolean isPrimaryKey) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!this.columnNames[i].equals(columnName)) continue;
            this.setPrimaryKey(i, isPrimaryKey);
            break;
        }
    }

    public void togglePrimaryKey(int columnIndex) {
        if (this.isPrimaryKey(columnIndex)) {
            this.setPrimaryKey(columnIndex, false);
        } else {
            this.setPrimaryKey(columnIndex, true);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public void fireTableChanged(final TableModelEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                ((TableModelListener)listeners[i + 1]).tableChanged(e);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] listeners = Database.this.listenerList.getListenerList();
                    for (int i = listeners.length - 2; i >= 0; i -= 2) {
                        if (listeners[i] != TableModelListener.class) continue;
                        ((TableModelListener)listeners[i + 1]).tableChanged(e);
                    }
                }
            });
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        boolean hack = false;
        if (lastRow > 10 && lastRow == this.getRowCount()) {
            --firstRow;
            --lastRow;
            hack = true;
        }
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
        if (hack) {
            this.table.clearSelection();
        }
    }

    public synchronized void removeAllElements() {
        if (!this.verticalView) {
            this.removeAllColumns();
        }
        this.resultSetResults.clear();
    }

    private void removeAllColumns() {
        this.tableColumnModel = new DefaultTableColumnModel();
        this.table.setColumnModel(this.tableColumnModel);
    }

    private void addColumns(int count) {
        if (!this.verticalView) {
            this.setupColumnWidthAdditive(count);
            for (int i = 0; i < count; ++i) {
                TableColumn column = new TableColumn(i);
                column.setHeaderValue(this.getColumnName(i));
                int width = Integer.parseInt(columnsWidth.getProperty(this.getColumnName(i), String.valueOf(this.defaultPreferedColumnWidth)));
                if (width > 20) {
                    column.setPreferredWidth(width + this.columnWidthAdditive);
                }
                column.setHeaderRenderer(this.titleRenderer);
                column.addPropertyChangeListener(this.cpcl);
                this.tableColumnModel.addColumn(column);
            }
        }
    }

    private void setupColumnWidthAdditive(int count) {
        int width = 0;
        for (int i = 0; i < count; ++i) {
            width += Integer.parseInt(columnsWidth.getProperty(this.getColumnName(i), String.valueOf(this.defaultPreferedColumnWidth)));
        }
        this.columnWidthAdditive = this.preferredColumnWidthSum - width;
        if (this.columnWidthAdditive < 0) {
            this.columnWidthAdditive = 0;
        }
        this.columnWidthAdditive /= count;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setupColumnWidthAdditive count=" + count + " preferredColumnWidthSum=" + this.preferredColumnWidthSum + " set columnWidthAdditive=" + this.columnWidthAdditive));
        }
    }

    public void setColumnWidthForAllColumns(int newWidth) {
        if (newWidth > 20) {
            this.defaultPreferedColumnWidth = newWidth;
            this.disablePropertyChangeListener = true;
            for (int i = 0; i < this.tableColumnModel.getColumnCount(); ++i) {
                this.tableColumnModel.getColumn(i).setPreferredWidth(newWidth);
            }
            this.table.repaint();
            this.disablePropertyChangeListener = false;
        }
    }

    private void prepareColumns() {
        this.disablePropertyChangeListener = true;
        TableColumn column = null;
        int width = 80;
        for (int i = 0; i < this.tableColumnModel.getColumnCount(); ++i) {
            column = this.tableColumnModel.getColumn(i);
            width = Integer.parseInt(columnsWidth.getProperty(this.getColumnName(i), String.valueOf(this.defaultPreferedColumnWidth)));
            if (width > 20) {
                column.setPreferredWidth(width);
            }
            column.setHeaderRenderer(this.titleRenderer);
            column.removePropertyChangeListener(this.cpcl);
            column.addPropertyChangeListener(this.cpcl);
        }
        this.table.repaint();
        this.disablePropertyChangeListener = false;
    }

    public int getDefaultColumnWidth() {
        return this.defaultPreferedColumnWidth;
    }

    private void configColumnClassInfo() {
        try {
            int cols = this.rsmd.getColumnCount();
            this.columnClasses = new Class[cols];
            this.columnSourceClasses = new String[cols];
            this.columnPkInfo = new Boolean[cols];
            this.columnTypeNames = new String[cols];
            this.columnTypesValues = new int[cols];
            this.columnPrecision = new Integer[cols];
            this.columnScale = new Integer[cols];
            block26: for (int i = 0; i < cols; ++i) {
                this.columnPkInfo[i] = false;
                this.columnPrecision[i] = this.rsmd.getPrecision(i + 1);
                this.columnScale[i] = this.rsmd.getScale(i + 1);
                int type = this.rsmd.getColumnType(i + 1);
                this.columnTypeNames[i] = this.rsmd.getColumnTypeName(i + 1);
                this.columnSourceClasses[i] = this.rsmd.getColumnClassName(i + 1);
                this.columnTypesValues[i] = type;
                switch (type) {
                    case 91: {
                        this.columnClasses[i] = java.sql.Date.class;
                        continue block26;
                    }
                    case 93: {
                        this.columnClasses[i] = Timestamp.class;
                        continue block26;
                    }
                    case 92: {
                        this.columnClasses[i] = Time.class;
                        continue block26;
                    }
                    case 2: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 4: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 8: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 6: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 5: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 3: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 7: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case -5: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case -6: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 1: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 12: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 2005: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case 2004: {
                        this.columnClasses[i] = Object.class;
                        continue block26;
                    }
                    case -1: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case -2: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    case -7: 
                    case 16: {
                        this.columnClasses[i] = Boolean.class;
                        continue block26;
                    }
                    case -3: {
                        this.columnClasses[i] = Object.class;
                        continue block26;
                    }
                    case -4: {
                        this.columnClasses[i] = Object.class;
                        continue block26;
                    }
                    case -100: {
                        this.columnClasses[i] = String.class;
                        continue block26;
                    }
                    default: {
                        this.columnClasses[i] = Object.class;
                    }
                }
            }
        }
        catch (Exception sqle) {
            logger.error((Object)sqle.getMessage(), (Throwable)sqle);
        }
    }

    private void configColumnNameInfo() {
        try {
            if (this.rsmd != null) {
                int cols = this.rsmd.getColumnCount();
                this.columnNames = new String[cols];
                for (int i = 0; i < cols; ++i) {
                    this.columnNames[i] = this.rsmd.getColumnName(i + 1);
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)sqle.getMessage(), (Throwable)sqle);
        }
    }

    public int size() {
        return this.resultSetResults.size();
    }

    private void configColumnPkInfo() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"configColumnPkInfo");
        }
        String schemaName = null;
        String tableName = null;
        int pos = this.lastTable.indexOf(46);
        if (pos != -1) {
            schemaName = this.lastTable.substring(0, pos);
            tableName = this.lastTable.substring(pos + 1);
        } else {
            schemaName = this.databaseExtension.getLoginSchema(this.session.getConnectionDescription());
            tableName = this.lastTable;
        }
        if (this.dataModel != null) {
            SQLTable sqlTable;
            if (!this.dataModel.isSchemaLoaded()) {
                this.dataModel.loadSchemas();
            }
            if ((sqlTable = this.dataModel.getSQLTable(schemaName, tableName)) != null) {
                if (!sqlTable.isFieldsLoaded()) {
                    sqlTable.loadColumns();
                }
                for (int f = 0; f < sqlTable.getFieldCount(); ++f) {
                    SQLField sqlField = sqlTable.getFieldAt(f);
                    if (!sqlField.isPrimaryKey()) continue;
                    this.setPrimaryKey(sqlField.getName(), true);
                }
            } else {
                logger.warn((Object)("configColumnPkInfo failed: table=" + schemaName + "." + tableName + " not found in metadata"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configColumnRefFromInfo() {
        DatabaseSession localSession = DatabaseSessionPool.getDatabaseSession(this.session.getAliasName());
        if (localSession != null) {
            this.columnRefFromInfo = new Boolean[this.columnNames.length];
            this.mapRefFromColumns = new HashMap();
            try {
                DatabaseMetaData localDbmd = localSession.getConnection().getMetaData();
                if (localDbmd != null) {
                    String schemaName = null;
                    String tableName = null;
                    int pos = this.lastTable.indexOf(46);
                    if (pos != -1) {
                        schemaName = this.lastTable.substring(0, pos);
                        tableName = this.lastTable.substring(pos + 1);
                    } else {
                        schemaName = this.databaseExtension.getLoginSchema(this.session.getConnectionDescription());
                        tableName = this.lastTable;
                    }
                    if (localDbmd.getDatabaseProductName().toLowerCase().indexOf("oracle") != -1) {
                        schemaName = schemaName.toUpperCase();
                        tableName = tableName.toUpperCase();
                    } else if (localDbmd.getDatabaseProductName().toLowerCase().indexOf("informix") != -1) {
                        schemaName = schemaName.toLowerCase();
                        tableName = tableName.toLowerCase();
                    }
                    ResultSet rsc = localDbmd.getExportedKeys(null, schemaName, tableName);
                    if (rsc != null) {
                        block5: while (rsc.next()) {
                            StringBuilder sb;
                            StringBuilder object;
                            String column = rsc.getString("PKCOLUMN_NAME");
                            String fSchema = rsc.getString("FKTABLE_SCHEM");
                            String fTable = rsc.getString("FKTABLE_NAME");
                            String fColumn = rsc.getString("FKCOLUMN_NAME");
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(column + ": " + fTable + "." + fColumn));
                            }
                            if ((object = this.mapRefFromColumns.get(column)) == null) {
                                sb = new StringBuilder();
                                this.mapRefFromColumns.put(column, sb);
                            } else {
                                sb = object;
                            }
                            if (fSchema != null && fSchema.length() > 0) {
                                sb.append(fSchema);
                                sb.append('.');
                            }
                            sb.append(fTable);
                            sb.append('.');
                            sb.append(fColumn);
                            sb.append('|');
                            for (int i = 0; i < this.columnNames.length; ++i) {
                                if (!this.columnNames[i].equalsIgnoreCase(column)) continue;
                                this.columnRefFromInfo[i] = true;
                                continue block5;
                            }
                        }
                        rsc.close();
                    }
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("configColumnRefFromInfo: read foreign keys from metadata:" + sqle.getMessage()), (Throwable)sqle);
                localSession.error(sqle.getMessage(), sqle);
            }
            finally {
                DatabaseSessionPool.release(localSession);
            }
        }
    }

    public boolean isReferencedColumn(int columnIndex) {
        Boolean b = this.columnRefFromInfo[columnIndex];
        if (b != null) {
            return b;
        }
        return false;
    }

    public String[] getReferencingColumns(int columnIndex) {
        String column;
        StringBuilder sb;
        String[] list = null;
        if (columnIndex != -1 && (sb = this.mapRefFromColumns.get(column = this.getColumnName(columnIndex))) != null) {
            StringTokenizer st = new StringTokenizer(sb.toString(), "|", false);
            list = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                list[i] = st.nextToken();
                ++i;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configColumnRefToInfo() {
        DatabaseSession localSession = DatabaseSessionPool.getDatabaseSession(this.session.getConnectionDescription().getUniqueId());
        if (localSession != null) {
            this.columnRefToInfo = new String[this.columnNames.length][2];
            try {
                DatabaseMetaData localDbmd = localSession.getConnection().getMetaData();
                if (localDbmd != null) {
                    String schemaName = null;
                    String tableName = null;
                    int pos = this.lastTable.indexOf(46);
                    if (pos != -1) {
                        schemaName = this.lastTable.substring(0, pos);
                        tableName = this.lastTable.substring(pos + 1);
                    } else {
                        schemaName = this.databaseExtension.getLoginSchema(this.session.getConnectionDescription());
                        tableName = this.lastTable;
                    }
                    ResultSet rsc = localDbmd.getImportedKeys(null, schemaName.toUpperCase(), tableName.toUpperCase());
                    if (rsc != null) {
                        block5: while (rsc.next()) {
                            String column = rsc.getString("FKCOLUMN_NAME");
                            String fSchema = rsc.getString("PKTABLE_SCHEM");
                            String fTable = rsc.getString("PKTABLE_NAME");
                            String fColumn = rsc.getString("PKCOLUMN_NAME");
                            for (int i = 0; i < this.columnNames.length; ++i) {
                                if (!this.columnNames[i].equalsIgnoreCase(column)) continue;
                                this.columnRefToInfo[i][0] = fSchema != null && fSchema.length() > 0 ? fSchema + "." + fTable : fTable;
                                this.columnRefToInfo[i][1] = fColumn;
                                continue block5;
                            }
                        }
                        rsc.close();
                    }
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("configColumnRefToInfo: read foreign keys from metadata: " + sqle.getMessage()), (Throwable)sqle);
                localSession.error(sqle.getMessage(), sqle);
            }
            finally {
                DatabaseSessionPool.release(localSession);
            }
        }
    }

    public boolean isReferencingColumn(int columnIndex) {
        return this.columnRefToInfo[columnIndex][0] != null;
    }

    public String createSelectForReferencingTable(String tableColumn, int row, int col) {
        int pos = tableColumn.lastIndexOf(".");
        String table_loc = tableColumn.substring(0, pos);
        String column = tableColumn.substring(pos + 1, tableColumn.length());
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(table_loc));
        sb.append(" where ");
        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(column));
        if (BasicDataType.isNumberType(this.getColumnBasicType(col))) {
            sb.append('=');
            sb.append(this.getValueAt(row, col));
        } else {
            sb.append("='");
            sb.append(this.getValueAt(row, col));
            sb.append('\'');
        }
        return sb.toString();
    }

    public String getReferencedColumn(int columnIndex) {
        return this.columnRefToInfo[columnIndex][0] + "." + this.columnRefToInfo[columnIndex][1];
    }

    public String createSelectForReferencedTable(int row, int col) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ");
        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnRefToInfo[col][0]));
        sb.append(" where ");
        sb.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.columnRefToInfo[col][1]));
        if (BasicDataType.isNumberType(this.getColumnBasicType(col))) {
            sb.append('=');
            sb.append(this.getValueAt(row, col));
        } else {
            sb.append("='");
            sb.append(this.getValueAt(row, col));
            sb.append('\'');
        }
        return sb.toString();
    }

    public void cancel() {
        this.cancelled = true;
        this.answer = 1;
        if (this.cancelStatementEnabled) {
            if (this.currentLocalStatement != null) {
                try {
                    Statement toCancelStatement = this.currentLocalStatement;
                    this.currentLocalStatement = null;
                    toCancelStatement.cancel();
                }
                catch (Exception e) {
                    logger.warn((Object)("cancel currentLocalStatement failed: " + e.getMessage()), (Throwable)e);
                }
            }
            this.session.cancelStatement();
        }
    }

    public SQLStatement getLastSelectStatement() {
        return this.lastSelectStatement;
    }

    public void executeScript(SQLParser parser, boolean noMetaData) {
        SQLExecuter executer = new SQLExecuter();
        executer.parser = parser;
        executer.execute(noMetaData);
    }

    public void executeStatement(SQLStatement statement) {
        this.executeScript(new SQLParser(statement.getSQL()), false);
    }

    public void showOutputParameters(SQLStatement sqlStat) {
        if (sqlStat.hasOutputParams()) {
            this.outputParameters = sqlStat.getOutputParams();
            this.showsResultSet = false;
            this.fireTableStructureChanged();
            this.mainFrame.ensureResultTableIsVisible();
        }
    }

    public boolean isShowingResultSet() {
        return this.showsResultSet;
    }

    public int convertFromVerticalToLogicalRowIndex(int verticalRowIndex) {
        return verticalRowIndex / this.columnNames.length;
    }

    public int convertFromVerticalToLogicalColIndex(int verticalRowIndex) {
        return verticalRowIndex % this.columnNames.length;
    }

    public int convertFromLogicalToVerticalRowSelection(int verticalRowIndex) {
        return verticalRowIndex * this.columnNames.length;
    }

    public double calculateColumnValueSum(int[] rows, int column) {
        double result = 0.0;
        if (rows.length > 1) {
            for (int row : rows) {
                result += this.getFailSaveNumberValue(row, column);
            }
        }
        return result;
    }

    public String getDataValueRangeInfo(int[] rows, int column) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public String getDataValueRangeInfo(int row, int[] columns) {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public double calculateRowValueSum(int row, int[] columns) {
        double result = 0.0;
        if (columns.length > 1) {
            for (int column : columns) {
                result += this.getFailSaveNumberValue(row, column);
            }
        }
        return result;
    }

    public Date calculateRowValueTimeMax(int row, int[] columns) {
        Date maxDate = null;
        if (columns.length > 1) {
            for (int column : columns) {
                Date cd = this.getFailSaveDate(row, column);
                if (cd == null || maxDate != null && !cd.after(maxDate)) continue;
                maxDate = cd;
            }
        }
        return maxDate;
    }

    private Date getFailSaveDate(int row, int column) {
        Date date = null;
        Object value = this.resultSetResults.get(row)[column];
        if (value != null) {
            // empty if block
        }
        return date;
    }

    private double getFailSaveNumberValue(int row, int column) {
        double numberValue = 0.0;
        try {
            Object value = this.resultSetResults.get(row)[column];
            if (value != null) {
                numberValue = Double.parseDouble(value.toString());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return numberValue;
    }

    public SQLDataModel getDataModel() {
        return this.dataModel;
    }

    public int getPreferredColumnWidthSum() {
        return this.preferredColumnWidthSum;
    }

    public void setPreferredColumnWidthSum(int preferredColumnWidthSum) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setPreferredColumnWidthSum:" + preferredColumnWidthSum));
        }
        this.preferredColumnWidthSum = preferredColumnWidthSum;
    }

    public SQLTable getSQLTableFromCurrentQuery() throws SQLException {
        if (this.dataModel != null) {
            String schemaName = null;
            String tableName = null;
            int pos = this.lastTable.indexOf(46);
            if (pos != -1) {
                schemaName = this.lastTable.substring(0, pos);
                tableName = this.lastTable.substring(pos + 1);
            } else {
                schemaName = this.databaseExtension.getLoginSchema(this.session.getConnectionDescription());
                tableName = this.lastTable;
            }
            if (!this.dataModel.isSchemaLoaded()) {
                this.dataModel.loadSchemas();
            }
            SQLSchema schema = this.dataModel.getSchema(schemaName);
            SQLTable table = new SQLTable(this.dataModel, schema, tableName);
            table.setType("TABLE");
            table.setFieldsLoaded();
            for (int i = 0; i < this.columnNames.length; ++i) {
                SQLField field = new SQLField(this.dataModel, table, this.columnNames[i]);
                field.setBasicType(BasicDataType.getBasicTypeByTypes(this.columnTypesValues[i]));
                field.setPrimaryKey(this.columnPkInfo[i]);
                field.setType(this.columnTypesValues[i]);
                field.setTypeName(this.columnTypeNames[i]);
                if (this.rsmd != null) {
                    field.setLength(this.columnPrecision[i]);
                    if (BasicDataType.isNumberType(field.getBasicType())) {
                        field.setDecimalDigits(this.columnScale[i]);
                    }
                }
                table.addField(field);
            }
            return table;
        }
        return null;
    }

    static /* synthetic */ String[] access$2402(Database x0, String[] x1) {
        x0.columnTypeNames = x1;
        return x1;
    }

    private final class ResultTableHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private String text;
        private String toTable;
        private String toColumn;
        private boolean isReferenced;
        private boolean isPrimaryKey;
        private final transient Color bg = new Color(220, 220, 220);

        public ResultTableHeaderRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object cellValue, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(new Font("Dialog", 0, 10));
            this.setForeground(Color.black);
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setHorizontalAlignment(0);
            this.text = (String)cellValue;
            this.setText(this.text);
            if (Database.this.isAdditionalInfoReady && !Database.this.verticalView) {
                if (Database.this.isPrimaryKey(column)) {
                    this.setBackground(Color.yellow);
                    this.isPrimaryKey = true;
                } else {
                    this.setBackground(this.bg);
                    this.isPrimaryKey = false;
                }
                if (Database.this.columnRefFromInfo != null && Database.this.columnRefFromInfo.length > column) {
                    if (Database.this.columnRefFromInfo[column] != null) {
                        this.setText(">" + this.getText());
                        this.isReferenced = true;
                    } else {
                        this.isReferenced = false;
                    }
                } else {
                    this.isReferenced = false;
                }
                if (Database.this.columnRefToInfo != null && Database.this.columnRefToInfo.length > column) {
                    if (Database.this.columnRefToInfo[column][0] != null) {
                        this.setText("<" + this.getText());
                        this.toTable = Database.this.columnRefToInfo[column][0];
                        this.toColumn = Database.this.columnRefToInfo[column][1];
                    } else {
                        this.toTable = "--";
                        this.toColumn = "--";
                    }
                } else {
                    this.toTable = "--";
                    this.toColumn = "--";
                }
                if (Database.this.columnTypeNames != null) {
                    this.setToolTipText("<HTML><BODY><b>index</b>=" + String.valueOf(column + 1) + "<br>" + "<b>name</b>=" + this.text + "<br>" + "<b>type name=</b>" + Database.this.columnTypeNames[column] + " <b>id=</b>" + Database.this.columnTypesValues[column] + "<br>" + "<b>Basic type=</b>" + BasicDataType.getBasicTypeByTypeObjects(Database.this.columnTypesValues[column]) + "<br>" + "<b>Class=</b>" + Database.this.columnSourceClasses[column] + "<br>" + "<b>is primary key</b>=" + String.valueOf(this.isPrimaryKey) + "<br>" + "<b>is referenced</b>=" + String.valueOf(this.isReferenced) + "<br>" + "<b>reference to</b> " + this.toTable + "." + this.toColumn + "</BODY></HTML>");
                }
            } else {
                this.setBackground(this.bg);
            }
            return this;
        }
    }

    private class SQLExecuter {
        private SQLParser parser;
        private boolean refreshNow = false;
        private boolean isScript = false;
        private boolean prevHistoryFreezState = false;

        private SQLExecuter() {
        }

        private void execute(boolean noMetaData) {
            Database.this.answer = 0;
            Database.this.cancelled = false;
            if (this.parser != null) {
                this.isScript = this.parser.getStatementCount() > 1;
                this.prevHistoryFreezState = MainFrame.sqlHistory.isFreesed();
                if (this.parser.getStatementCount() > 1000) {
                    MainFrame.sqlHistory.setFreezed(true);
                }
                this.runScript(this.parser, noMetaData);
                if (this.isScript) {
                    Database.this.mainFrame.setDatabaseBusyFiltered(false, this.parser.getStatementCount() + " statements proceeded.");
                    MainFrame.sqlHistory.setFreezed(this.prevHistoryFreezState);
                }
            } else {
                throw new IllegalStateException("parser cannot be null");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runScript(final SQLParser parser, boolean noMetaData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runScript noMetaData=" + noMetaData));
            }
            try {
                long lastUpdatedAt = 0L;
                SQLStatement currStatement = null;
                if (parser.getStatementCount() == 0) {
                    logger.warn((Object)"Parser has no statements");
                }
                for (int i = 0; i < parser.getStatementCount() && !Database.this.cancelled; ++i) {
                    final SQLStatement sqlStat = currStatement = parser.getStatementAt(i);
                    if (!noMetaData && System.currentTimeMillis() - lastUpdatedAt > 1000L) {
                        lastUpdatedAt = System.currentTimeMillis();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!Database.this.mainFrame.isTextSelected() && parser.getStatementCount() > 1) {
                                    Database.this.mainFrame.setCaretPos(sqlStat.getStartPos());
                                }
                            }
                        });
                    }
                    this.runStatement(sqlStat, noMetaData);
                }
                if (!noMetaData) {
                    final SQLStatement lastStatement = currStatement;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!Database.this.mainFrame.isTextSelected() && parser.getStatementCount() > 1) {
                                Database.this.mainFrame.setCaretPos(lastStatement.getStartPos());
                            }
                        }
                    });
                }
            }
            finally {
                Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
            }
        }

        private void runStatement(final SQLStatement sqlStat, boolean noMetaData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runStatement sqlStat=" + sqlStat));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Database.this.mainFrame.setDatabaseBusyFiltered(true, "exec statement(" + String.valueOf(sqlStat.getIndex()) + ")...");
                }
            });
            Database.this.currentLocalStatement = null;
            Database.this.cancelStatementEnabled = true;
            sqlStat.setStartTime();
            sqlStat.setCurrentUrl(Database.this.session.getUrl());
            sqlStat.setCurrentUser(Database.this.session.getUser());
            if (!noMetaData && !MainFrame.sqlHistory.isFreesed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"sqlHistory add statement");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.sqlHistory.addSQLStatement(sqlStat, SQLExecuter.this.isScript);
                    }
                });
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"sqlHistory skipped");
            }
            if (sqlStat.getType() == 0) {
                this.runOtherStatement(sqlStat, noMetaData);
            } else if (sqlStat.getType() == 2) {
                this.runUpdateStatement(sqlStat);
            } else if (sqlStat.getType() == 3) {
                this.runStartStatement(sqlStat);
            } else {
                this.runQueryStatement(sqlStat, noMetaData);
            }
            Database.this.session.closeCurrentOpenStatement();
            if (!noMetaData && !MainFrame.sqlHistory.isFreesed()) {
                MainFrame.sqlHistory.refresh();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"runStatement ends.");
            }
        }

        private void runStartStatement(SQLStatement sqlStat) {
            File scriptFile;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runStartStatement " + sqlStat));
            }
            String currentDirectory = Database.this.mainFrame.getCurrentDirectory();
            String fileName = SQLParser.extractFileName(sqlStat.getSQL(), currentDirectory);
            if (!fileName.toLowerCase().endsWith(".sql")) {
                fileName = fileName + ".sql";
            }
            if ((scriptFile = new File(fileName)).exists()) {
                try {
                    SQLParser subParser = new SQLParser(scriptFile, Main.getFileEnoding());
                    this.runScript(subParser, false);
                    sqlStat.setSuccessful(true);
                    sqlStat.setMessage("file " + fileName + " successfully loaded.");
                }
                catch (IOException e) {
                    sqlStat.setSuccessful(false);
                    sqlStat.setMessage("Load file " + fileName + " failed:" + e.getMessage());
                }
            } else {
                sqlStat.setSuccessful(false);
                sqlStat.setMessage("file " + fileName + " does not exists!");
            }
            sqlStat.setExecStopTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void runOtherStatement(SQLStatement sqlStat, boolean noMetaData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runOtherStatement " + sqlStat));
            }
            if (sqlStat.isPrepared()) {
                try {
                    CallableStatement cs = Database.this.session.createCallableStatement(sqlStat.getSQL());
                    Database.this.currentLocalStatement = cs;
                    try {
                        Database.this.setupParameterValues(cs, sqlStat);
                        if (cs.execute()) {
                            this.processResultSet(sqlStat, cs.getResultSet(), noMetaData);
                            return;
                        } else {
                            this.processOutputParameters(cs, sqlStat);
                            Database.this.showOutputParameters(sqlStat);
                            sqlStat.setExecStopTime();
                            sqlStat.setSuccessful(true);
                            sqlStat.setMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") successful");
                            Database.this.mainFrame.setStatusMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") successful");
                        }
                        return;
                    }
                    finally {
                        cs.close();
                    }
                }
                catch (Exception sqle) {
                    Database.this.cancelStatementEnabled = false;
                    sqlStat.setExecStopTime();
                    sqlStat.setSuccessful(false);
                    sqlStat.setMessage(sqle.getMessage());
                    Database.this.mainFrame.setStatusMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") failed !");
                    if (Database.this.answer == 1) return;
                    Database.this.answer = Database.this.mainFrame.showDBMessage(sqle.getMessage(), "execution statement(" + String.valueOf(sqlStat.getIndex()) + ")");
                    if (Database.this.answer != 2) return;
                    Database.this.cancelled = true;
                    Database.this.session.rollback();
                }
                return;
            }
            if (Database.this.session.execute(sqlStat.getSQL())) {
                if (Database.this.session.lastStatementWasAQuery()) {
                    this.processResultSet(sqlStat, Database.this.session.getCurrentResultSet(), noMetaData);
                    return;
                } else {
                    sqlStat.setExecStopTime();
                    sqlStat.setSuccessful(true);
                    sqlStat.setMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") successful.");
                    if (this.isScript) return;
                    Database.this.mainFrame.setStatusMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") successful");
                }
                return;
            } else {
                Database.this.cancelStatementEnabled = false;
                sqlStat.setExecStopTime();
                sqlStat.setSuccessful(false);
                sqlStat.setMessage(Database.this.session.getLastErrorMessage());
                Database.this.mainFrame.setStatusMessage("statement(" + String.valueOf(sqlStat.getIndex()) + ") failed !");
                if (Database.this.answer == 1) return;
                Database.this.answer = Database.this.mainFrame.showDBMessage(Database.this.session.getLastErrorMessage(), "execution statement(" + String.valueOf(sqlStat.getIndex()) + ")");
                if (Database.this.answer != 2) return;
                Database.this.cancelled = true;
                Database.this.session.rollback();
            }
        }

        private void processOutputParameters(CallableStatement callableStatement, SQLStatement sqlStat) throws SQLException {
            if (sqlStat.hasOutputParams()) {
                SQLPSParam parameter = null;
                List<SQLPSParam> listOutputParams = sqlStat.getOutputParams();
                for (int i = 0; i < listOutputParams.size(); ++i) {
                    parameter = listOutputParams.get(i);
                    if (BasicDataType.isStringType(parameter.getBasicType())) {
                        parameter.setValue(callableStatement.getString(parameter.getIndex()));
                        continue;
                    }
                    if (BasicDataType.isNumberType(parameter.getBasicType())) {
                        parameter.setValue(callableStatement.getString(parameter.getIndex()));
                        continue;
                    }
                    if (parameter.getBasicType() == BasicDataType.DATE.getId()) {
                        parameter.setValue(callableStatement.getString(parameter.getIndex()));
                        continue;
                    }
                    if (parameter.getBasicType() != BasicDataType.BOOLEAN.getId()) continue;
                    parameter.setValue(String.valueOf(callableStatement.getBoolean(parameter.getIndex())));
                }
            }
        }

        private void runUpdateStatement(final SQLStatement sqlStat) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runUpdateStatement " + sqlStat));
            }
            int updateCount = -1;
            if (sqlStat.isPrepared()) {
                try {
                    CallableStatement ps = Database.this.session.createCallableStatement(sqlStat.getSQL());
                    Database.this.currentLocalStatement = ps;
                    Database.this.setupParameterValues(ps, sqlStat);
                    updateCount = ps.executeUpdate();
                    sqlStat.setExecStopTime();
                    ResultSet rs = ps.getResultSet();
                    if (rs != null) {
                        this.processResultSet(sqlStat, rs, true);
                    }
                    ps.close();
                }
                catch (Exception sqle) {
                    Database.this.session.error(sqle.getMessage(), sqle);
                }
            } else {
                updateCount = Database.this.session.executeUpdate(sqlStat.getSQL());
                Database.this.cancelStatementEnabled = false;
                sqlStat.setExecStopTime();
            }
            if (updateCount == -1) {
                sqlStat.setSuccessful(false);
                sqlStat.setMessage(Database.this.session.getLastErrorMessage());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Database.this.mainFrame.setStatusMessage("modification(" + String.valueOf(sqlStat.getIndex()) + ") failed !");
                    }
                });
                if (Database.this.answer != 1) {
                    Database.this.answer = Database.this.mainFrame.showDBMessage(Database.this.session.getLastErrorMessage(), "execution modification(" + String.valueOf(sqlStat.getIndex()) + ')');
                    if (Database.this.answer == 2) {
                        Database.this.cancelled = true;
                        Database.this.session.rollback();
                    }
                }
            } else {
                sqlStat.setSuccessful(true);
                sqlStat.setMessage("modification(" + String.valueOf(sqlStat.getIndex()) + ") proceeded for " + String.valueOf(updateCount) + " datasets");
                if (!this.isScript) {
                    int c = updateCount;
                    Database.this.mainFrame.setStatusMessage("modification(" + String.valueOf(sqlStat.getIndex()) + ") proceeded for " + String.valueOf(c) + " datasets");
                }
            }
        }

        private void runQueryStatement(SQLStatement sqlStat, boolean noMetaData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("runQueryStatement " + sqlStat));
            }
            Database.this.maxRowsToRead = 0;
            if (sqlStat.isPrepared()) {
                try {
                    CallableStatement ps = Database.this.session.createCallableStatement(sqlStat.getSQL());
                    Database.this.currentLocalStatement = ps;
                    Database.this.databaseExtension.setupStatement(ps);
                    Database.this.setupParameterValues(ps, sqlStat);
                    ResultSet rs = ps.executeQuery();
                    this.processResultSet(sqlStat, rs, noMetaData);
                    ps.close();
                }
                catch (Exception sqle) {
                    Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + ") failed !");
                    sqlStat.setMessage(sqle.getMessage());
                    sqlStat.setSuccessful(false);
                    if (Database.this.answer != 1) {
                        Database.this.answer = Database.this.mainFrame.showDBMessage(sqle.getMessage(), "execution prepared query(" + String.valueOf(sqlStat.getIndex()) + ")");
                        if (Database.this.answer == 2) {
                            Database.this.cancelled = true;
                            Database.this.session.rollback();
                        }
                    }
                }
            } else {
                ResultSet rs = Database.this.session.executeQuery(sqlStat.getSQL());
                sqlStat.setExecStopTime();
                if (Database.this.session.isSuccessful()) {
                    this.processResultSet(sqlStat, rs, noMetaData);
                } else {
                    Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + ") failed !");
                    sqlStat.setMessage(Database.this.session.getLastErrorMessage());
                    sqlStat.setSuccessful(false);
                    if (Database.this.answer != 1) {
                        Database.this.answer = Database.this.mainFrame.showDBMessage(Database.this.session.getLastErrorMessage(), "execution query(" + String.valueOf(sqlStat.getIndex()) + ")");
                        if (Database.this.answer == 2) {
                            Database.this.cancelled = true;
                            Database.this.session.rollback();
                        }
                    }
                }
            }
        }

        private void setRefreshNow(boolean ok) {
            this.refreshNow = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processResultSet(final SQLStatement sqlStat, ResultSet rs, boolean noMetaData) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processResultSet stat=" + sqlStat + " noMetaData=" + noMetaData));
            }
            Database.this.showsResultSet = true;
            Database.this.cancelStatementEnabled = false;
            Database.this.newRowIndex = -1;
            Database.this.lastTable = SQLParser.getTableForQuery(sqlStat);
            if (Database.this.lastTable != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((Database)Database.this).mainFrame.status.setTablename(Database.this.lastTable);
                        ((Database)Database.this).mainFrame.status.setToolTipText(Database.this.lastTable);
                    }
                });
            }
            int currentColumnIndex = 0;
            if (rs != null) {
                Database.this.mainFrame.ensureResultTableIsVisible();
                Database.this.isAdditionalInfoReady = false;
                Timer timer = new Timer(Database.this.refreshTime, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLExecuter.this.setRefreshNow(true);
                    }
                });
                timer.setRepeats(true);
                timer.start();
                Database.this.removeAllElements();
                Database.access$2402(Database.this, null);
                Database.this.mainFrame.setDatabaseBusyFiltered(true, "read data from query(" + String.valueOf(sqlStat.getIndex()) + ")...");
                int rowCount = 0;
                int i = -1;
                try {
                    int cRowCount;
                    Database.this.rsmd = rs.getMetaData();
                    Database.this.configColumnClassInfo();
                    Database.this.configColumnNameInfo();
                    int cols = Database.this.rsmd.getColumnCount();
                    Database.this.addColumns(cols);
                    if (cols > 0) {
                        int deltaRows = 0;
                        logger.debug((Object)"gather column types");
                        int[] types = new int[cols];
                        for (int c = 0; c < cols; ++c) {
                            types[c] = BasicDataType.getBasicTypeByTypes(Database.this.rsmd.getColumnType(c + 1));
                        }
                        block26: while (rs.next()) {
                            if (Database.this.cancelled) {
                                try {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"cancel current statement...");
                                    }
                                    rs.getStatement().close();
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("close statement failed: " + e.getMessage()), (Throwable)e);
                                }
                                Database.this.mainFrame.setStatusMessage("abort read results from statement(" + String.valueOf(sqlStat.getIndex()) + ")");
                                break;
                            }
                            Object[] resultRow = new Object[cols];
                            ++deltaRows;
                            ++rowCount;
                            currentColumnIndex = 0;
                            for (i = 0; i < cols; ++i) {
                                currentColumnIndex = i;
                                if (types[i] == BasicDataType.DATE.getId()) {
                                    try {
                                        resultRow[i] = rs.getTimestamp(i + 1);
                                    }
                                    catch (Exception fe) {
                                        resultRow[i] = rs.getString(i + 1);
                                    }
                                    continue;
                                }
                                if (BasicDataType.isNumberType(types[i])) {
                                    resultRow[i] = rs.getObject(i + 1);
                                    continue;
                                }
                                if (types[i] == BasicDataType.BOOLEAN.getId()) {
                                    if (rs.getObject(i + 1) != null) {
                                        resultRow[i] = rs.getBoolean(i + 1);
                                        continue;
                                    }
                                    resultRow[i] = null;
                                    continue;
                                }
                                if (types[i] == BasicDataType.CHARACTER.getId()) {
                                    resultRow[i] = rs.getString(i + 1);
                                    continue;
                                }
                                if (types[i] == BasicDataType.CLOB.getId()) {
                                    resultRow[i] = rs.getString(i + 1);
                                    continue;
                                }
                                if (types[i] == BasicDataType.BINARY.getId()) {
                                    Object v = rs.getObject(i + 1);
                                    if (v instanceof Blob) {
                                        Blob blob = (Blob)v;
                                        if (blob.length() > 0L) {
                                            resultRow[i] = new BinaryDataFile(blob);
                                            continue;
                                        }
                                        resultRow[i] = null;
                                        continue;
                                    }
                                    if (v instanceof byte[]) {
                                        resultRow[i] = (byte[])v;
                                        continue;
                                    }
                                    if (v != null) {
                                        try {
                                            resultRow[i] = rs.getObject(i + 1);
                                        }
                                        catch (Exception e) {}
                                        continue;
                                    }
                                    resultRow[i] = null;
                                    continue;
                                }
                                if (types[i] == -100) {
                                    resultRow[i] = rs.getString(i + 1);
                                    continue;
                                }
                                try {
                                    resultRow[i] = rs.getObject(i + 1);
                                    continue;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            Database.this.resultSetResults.add(resultRow);
                            if (this.refreshNow) {
                                Database.this.fireTableRowsInserted(rowCount - deltaRows, rowCount);
                                Thread.yield();
                                deltaRows = 0;
                                this.refreshNow = false;
                                int cRowCount2 = rowCount;
                                Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + "): until now " + String.valueOf(cRowCount2) + " datasets read.");
                            }
                            if (Database.this.maxRowsToRead != 0 && rowCount >= Database.this.maxRowsToRead) {
                                Database.this.cancelled = true;
                            }
                            if (rowCount != Database.this.maxRowsToWarning) continue;
                            while (true) {
                                String answer_loc;
                                if ((answer_loc = Database.this.mainFrame.showInputDialog(String.valueOf(rowCount) + " datasets read.\nlimit count datasets to read ? (0=no limitation)", "read data", String.valueOf(rowCount))) == null) {
                                    Database.this.cancelled = true;
                                    continue block26;
                                }
                                if (answer_loc.length() <= 0) break;
                                try {
                                    Database.this.maxRowsToRead = Integer.parseInt(answer_loc);
                                    continue block26;
                                }
                                catch (NumberFormatException nfe) {
                                    Database.this.maxRowsToRead = 1000;
                                    continue;
                                }
                                break;
                            }
                            Database.this.maxRowsToRead = 0;
                        }
                        if (deltaRows > 0 || Thread.currentThread().isInterrupted()) {
                            Database.this.fireTableRowsInserted(rowCount - deltaRows, rowCount);
                        }
                    }
                    sqlStat.setGetStopTime();
                    sqlStat.setSuccessful(true);
                    Database.this.lastSelectStatement = sqlStat;
                    if (!noMetaData) {
                        Database.this.configColumnPkInfo();
                        Database.this.configColumnRefToInfo();
                        Database.this.configColumnRefFromInfo();
                    }
                    Database.this.isAdditionalInfoReady = true;
                    Database.this.table.getTableHeader().repaint();
                    if (Database.this.cancelled) {
                        sqlStat.setMessage("query(" + String.valueOf(sqlStat.getIndex()) + "):" + String.valueOf(rowCount) + " datasets read. ABORT");
                        cRowCount = rowCount;
                        Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + "):" + String.valueOf(cRowCount) + " datasets read. ABORT");
                    }
                    sqlStat.setMessage("query(" + String.valueOf(sqlStat.getIndex()) + "):" + String.valueOf(rowCount) + " datasets read. READY");
                    cRowCount = rowCount;
                    Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + "):" + String.valueOf(cRowCount) + " datasets read. READY");
                }
                catch (SQLException sqle) {
                    logger.error((Object)("processResultSet failed:" + sqle.getMessage()), (Throwable)sqle);
                    sqlStat.setGetStopTime();
                    sqlStat.setSuccessful(false);
                    sqlStat.setMessage(sqle.getMessage());
                    final int ci = currentColumnIndex;
                    final int cRowCount = rowCount;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Database.this.mainFrame.showDBMessageWithoutContinueAction("column=" + String.valueOf(ci + 1) + " row=" + String.valueOf(cRowCount) + "\n" + sqle.getMessage(), "error in statement(" + String.valueOf(sqlStat.getIndex()) + ")");
                        }
                    });
                }
                catch (OutOfMemoryError error) {
                    this.setRefreshNow(false);
                    timer.stop();
                    Database.this.resultSetResults.clear();
                    System.gc();
                    String message = "query(" + String.valueOf(sqlStat.getIndex()) + "):" + " out of memory error: " + error.getMessage() + " . ABORT !";
                    Database.this.mainFrame.setStatusMessage(message);
                    sqlStat.setMessage(message);
                    logger.error((Object)"out of memory error", (Throwable)error);
                }
                finally {
                    timer.stop();
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"close result set");
                        }
                        rs.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)("processResultSet close cursor failed: " + e.toString()));
                    }
                }
            } else {
                Database.this.mainFrame.setStatusMessage("query(" + String.valueOf(sqlStat.getIndex()) + ") returns none result set !");
                sqlStat.setMessage(Database.this.session.getLastErrorMessage());
                sqlStat.setSuccessful(false);
                if (Database.this.answer != 1) {
                    Database.this.answer = Database.this.mainFrame.showDBMessage("No resultset received.\n" + Database.this.session.getLastErrorMessage(), "execution query(" + String.valueOf(sqlStat.getIndex()) + ")");
                    if (Database.this.answer == 2) {
                        Database.this.cancelled = true;
                    }
                }
            }
            this.setRefreshNow(false);
        }
    }

    private final class ColumnPropertyChangeListener
    implements PropertyChangeListener {
        private ColumnPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!Database.this.disablePropertyChangeListener) {
                TableColumn column = (TableColumn)evt.getSource();
                if (column.getWidth() != Database.this.defaultPreferedColumnWidth) {
                    columnsWidth.setProperty(Database.this.getColumnName(column.getModelIndex()), String.valueOf((column.getWidth() > 20 ? column.getWidth() : 20) - Database.this.columnWidthAdditive));
                }
            } else {
                TableColumn column = (TableColumn)evt.getSource();
                if (column.getWidth() != Database.this.defaultPreferedColumnWidth) {
                    columnsWidth.remove(Database.this.getColumnName(column.getModelIndex()));
                }
            }
        }
    }

    private final class InsertNewRowInDBThread
    extends Thread {
        private InsertNewRowInDBThread() {
        }

        @Override
        public void run() {
            if (!Database.this.mainFrame.isDatabaseBusy()) {
                Database.this.mainFrame.setDatabaseBusyFiltered(true, "perform insert");
                if (Database.this.performInsertNewRowInDB()) {
                    if (Database.this.getNewRowIndex() == -1) {
                        Database.this.mainFrame.setCreateNewRowEnabled(true);
                    }
                    ((Database)Database.this).mainFrame.resultTable.repaint();
                }
                Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
            }
        }
    }

    private final class WriteLobInFileThread
    extends Thread {
        private File f;
        private int row;
        private int col;
        private JFrame frame;

        WriteLobInFileThread(File f, int row, int col, JFrame frame) {
            this.f = f;
            this.row = row;
            this.col = col;
            this.frame = frame;
        }

        @Override
        public void run() {
            if (!Database.this.mainFrame.isDatabaseBusy()) {
                Database.this.mainFrame.setDatabaseBusyFiltered(true, "perform write LOB in file");
                Database.this.performWriteLOBValueInFile(this.f, this.row, this.col);
                this.frame.toFront();
                Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
            }
        }
    }

    private final class UpdateValueExecuter {
        private Object value;
        private int row;
        private int col;
        private JFrame frame;
        private Object constraint;

        UpdateValueExecuter(Object value, int row, int col, JFrame frame, Object constraint) {
            this.value = value;
            this.row = row;
            this.col = col;
            this.frame = frame;
            this.constraint = constraint;
        }

        public void execute() {
            if (!Database.this.mainFrame.isDatabaseBusy()) {
                if (Database.this.performUpdateValue(this.value, this.row, this.col, this.constraint)) {
                    this.frame.dispose();
                } else {
                    this.frame.toFront();
                }
                Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
            }
        }
    }

    private final class DeleteValueThread
    extends Thread {
        private int row;
        private int col;

        DeleteValueThread(int row, int col) {
            this.row = row;
            this.col = col;
        }

        @Override
        public void run() {
            if (!Database.this.mainFrame.isDatabaseBusy()) {
                Database.this.mainFrame.setDatabaseBusyFiltered(true, "delete value");
                Database.this.performDeleteValue(this.row, this.col);
                Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
            }
        }
    }

    private final class DeleteDataSetThread
    extends Thread {
        private int[] rows;

        DeleteDataSetThread(int[] rows) {
            this.rows = rows;
        }

        @Override
        public void run() {
            if (!Database.this.mainFrame.isDatabaseBusy()) {
                int row = this.rows[0];
                for (int i = 0; i < this.rows.length; ++i) {
                    Database.this.mainFrame.setDatabaseBusyFiltered(true, "delete dataset");
                    if (!Database.this.performDeleteDataset(row)) {
                        Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
                        break;
                    }
                    Database.this.mainFrame.setDatabaseBusyFiltered(false, null);
                }
            }
        }
    }
}

