/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.DatabaseSession;
import dbtools.DatabaseSessionPool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DatabaseSessionPoolInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private SessionTableModel sessionTableModel = new SessionTableModel();
    private Timer refreshTimer;
    private JPanel poolThreadInfoPanel;

    public DatabaseSessionPoolInfoPanel() {
        this.initialize();
    }

    public void startRefreshing() {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DatabaseSessionPoolInfoPanel.this.sessionTableModel != null) {
                        DatabaseSessionPoolInfoPanel.this.sessionTableModel.refresh();
                        DatabaseSessionPoolInfoPanel.this.repaint();
                    }
                }
            });
        }
        if (!this.refreshTimer.isRunning()) {
            this.refreshTimer.start();
        }
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getPoolThreadInfoPanel(), "South");
    }

    private JPanel getPoolThreadInfoPanel() {
        if (this.poolThreadInfoPanel == null) {
            this.poolThreadInfoPanel = new JPanel();
        }
        return this.poolThreadInfoPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTable());
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            this.jTable = new JTable();
            this.jTable.setSelectionMode(0);
            this.jTable.setEnabled(false);
            this.jTable.setAutoResizeMode(0);
            this.jTable.setModel(this.sessionTableModel);
            this.jTable.setDefaultRenderer(String.class, new SessionTableRenderer());
        }
        return this.jTable;
    }

    public void stopRefreshing() {
        if (this.refreshTimer != null && this.refreshTimer.isRunning()) {
            this.refreshTimer.stop();
        }
    }

    static final class SessionTableModel
    extends DefaultTableModel {
        private SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        private static final long serialVersionUID = 1L;

        SessionTableModel() {
        }

        @Override
        public int getRowCount() {
            if (DatabaseSessionPool.getPool() != null) {
                return DatabaseSessionPool.getPool().size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 13;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "class";
                }
                case 2: {
                    return "connected";
                }
                case 3: {
                    return "last used";
                }
                case 4: {
                    return "often used";
                }
                case 5: {
                    return "idle time";
                }
                case 6: {
                    return "ready";
                }
                case 7: {
                    return "last error message";
                }
                case 8: {
                    return "occured at";
                }
                case 9: {
                    return "URL";
                }
                case 10: {
                    return "schema";
                }
                case 11: {
                    return "last action";
                }
                case 12: {
                    return "alias";
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DatabaseSession session = DatabaseSessionPool.getPool().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return String.valueOf(session.getSessionID());
                }
                case 1: {
                    return session.getClass().getName();
                }
                case 2: {
                    return this.sdf.format(new Date(session.getConnectedTimestamp()));
                }
                case 3: {
                    if (session.getLastOccupiedTimestamp() > 0L) {
                        return this.sdf.format(new Date(session.getLastOccupiedTimestamp()));
                    }
                    return "";
                }
                case 4: {
                    return String.valueOf(session.getCountUsage());
                }
                case 5: {
                    return String.valueOf(session.getIdleTime());
                }
                case 6: {
                    return String.valueOf(session.isReady());
                }
                case 7: {
                    return session.getLastErrorMessage();
                }
                case 8: {
                    return this.sdf.format(new Date(session.getLastErrorTimestamp()));
                }
                case 9: {
                    return session.getUrl();
                }
                case 10: {
                    return session.getUser();
                }
                case 11: {
                    return session.getLastSQL();
                }
                case 12: {
                    return session.getAliasName();
                }
            }
            return null;
        }

        public void refresh() {
            this.fireTableDataChanged();
        }
    }

    static final class SessionTableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        SessionTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                DatabaseSession session = DatabaseSessionPool.getPool().get(row);
                if (session != null) {
                    comp.setForeground(Color.BLACK);
                    if (!session.isReady()) {
                        if (session.isSuccessful()) {
                            comp.setBackground(Color.YELLOW);
                        } else {
                            comp.setBackground(Color.RED);
                        }
                    } else {
                        comp.setForeground(Color.BLACK);
                        comp.setBackground(Color.WHITE);
                    }
                } else {
                    comp.setBackground(Color.LIGHT_GRAY);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return comp;
        }
    }
}

