/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.DatabaseType;
import dbtools.URLElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import sqlrunner.base64.StringCrypt;

public class ConnectionDescription
implements Comparable<ConnectionDescription>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String driverClassName;
    private String user;
    private String password;
    private String comment;
    private String propertiesString;
    private String initSQL;
    private static final boolean userInfoInUrl = false;
    public static final int ORACLE_THIN = 0;
    public static final int ORACLE_OCI_USE_LOCAL_TNSNAMES = 1;
    public static final int ORACLE_OCI_WITHOUT_LOCAL_TNSNAMES = 2;
    public static final int ODBC = 3;
    private static final List<DatabaseType> databaseTypes = new ArrayList<DatabaseType>();
    private static boolean showCommentAsDefault = false;
    private static boolean extendsUrlWithProperties = false;
    private static boolean runInitialSQLOnConnect = false;
    private DatabaseType dt;
    private boolean storePasswdEnabled = true;
    private List<URLElement> urlElements;
    private boolean autoCommit = true;
    private String jndiDataSourceName = null;
    private int defaultFetchSize = -1;
    private int maxCountSessions = 0;
    private boolean productive = false;

    public int getMaxCountSessions() {
        return this.maxCountSessions;
    }

    public void setMaxCountSessions(int maxCountSessions) {
        this.maxCountSessions = maxCountSessions;
    }

    public ConnectionDescription() {
        ConnectionDescription.createDefaults();
    }

    public void setProperties(Properties properties) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append((String)entry.getValue());
            sb.append(";");
        }
        this.setPropertiesString(sb.toString());
    }

    public ConnectionDescription(String paramStr) {
        ConnectionDescription.createDefaults();
        this.parseParamStr(paramStr);
        this.createURL();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url_loc) {
        this.url = url_loc;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName_loc) {
        this.driverClassName = driverClassName_loc;
    }

    public void setAutoCommit(boolean autoCommit_loc) {
        this.autoCommit = autoCommit_loc;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setDatabaseType(DatabaseType dt_loc) {
        if (this.dt != dt_loc) {
            this.dt = dt_loc;
            this.urlElements = dt_loc.cloneURLElementList();
            this.driverClassName = dt_loc.getDriverClassName();
        }
    }

    public void setDatabaseType(int id) {
        DatabaseType dt_loc = ConnectionDescription.getDatabaseType(id);
        if (dt_loc == null) {
            throw new RuntimeException("kein Datenbanktyp mit id=" + id + " vorhanden!");
        }
        if (this.dt != dt_loc) {
            this.dt = dt_loc;
            this.urlElements = dt_loc.cloneURLElementList();
            this.driverClassName = dt_loc.getDriverClassName();
        }
    }

    public DatabaseType getDatabaseType() {
        return this.dt;
    }

    public String getUser() {
        if (this.urlElements != null) {
            String userFormURLElements = null;
            for (int i = 0; i < this.urlElements.size(); ++i) {
                if (!this.urlElements.get(i).getName().equals("USER")) continue;
                userFormURLElements = this.urlElements.get(i).getValue();
                break;
            }
            if (userFormURLElements != null) {
                return userFormURLElements;
            }
            return this.user;
        }
        return this.user;
    }

    public String getPasswd() {
        if (this.urlElements != null && this.urlElements.size() > 0) {
            String passwdFromUrlElement = null;
            for (int i = 0; i < this.urlElements.size(); ++i) {
                if (!this.urlElements.get(i).getName().equals("PASSWORD")) continue;
                passwdFromUrlElement = this.urlElements.get(i).getValue();
                break;
            }
            if (passwdFromUrlElement != null) {
                return passwdFromUrlElement;
            }
            return this.password;
        }
        return this.password;
    }

    public void setUser(String user_loc) {
        if (this.urlElements != null && this.urlElements.size() > 0) {
            for (int i = 0; i < this.urlElements.size(); ++i) {
                URLElement element = this.urlElements.get(i);
                if (!element.getName().equals("USER")) continue;
                element.setValue(user_loc);
                break;
            }
        }
        this.user = user_loc;
    }

    public void setPasswd(String password_loc) {
        if (this.urlElements != null && this.urlElements.size() > 0) {
            for (int i = 0; i < this.urlElements.size(); ++i) {
                URLElement element = this.urlElements.get(i);
                if (!element.getName().equals("PASSWORD")) continue;
                element.setValue(password_loc);
                break;
            }
        }
        this.password = password_loc;
    }

    public void setComment(String comment_loc) {
        this.comment = comment_loc;
    }

    public void setPropertiesString(String text) {
        this.propertiesString = text;
    }

    public String getComment() {
        return this.comment;
    }

    public void setDefaultFetchSize(int size) {
        this.defaultFetchSize = size;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public String getPropertiesString() {
        return this.propertiesString;
    }

    public void setURLElements(ArrayList<URLElement> urlElements_loc) {
        this.urlElements = (ArrayList)urlElements_loc.clone();
    }

    public List<URLElement> getURLElements() {
        return this.urlElements;
    }

    private void storeURLElementValue(URLElement element) {
        if (element.getName().equals("PRODUCTIVE")) {
            this.productive = Boolean.parseBoolean(element.getValue());
        } else if (element.getName().equals("COMMENT")) {
            this.comment = element.getValue();
        } else if (element.getName().equals("INIT_SQL")) {
            this.initSQL = element.getValue();
        } else if (element.getName().equals("PROPERTIES")) {
            this.propertiesString = element.getValue();
        } else if (element.getName().equals("FETCHSIZE")) {
            String value = element.getValue();
            this.defaultFetchSize = value != null && value.length() > 0 ? Integer.parseInt(value) : -1;
        } else {
            for (int i = 0; i < this.urlElements.size(); ++i) {
                URLElement urlElement = this.urlElements.get(i);
                if (!urlElement.equals(element)) continue;
                urlElement.setValue(element.getValue());
                if (!element.isUserNameElement()) break;
                this.user = element.getValue();
                break;
            }
        }
    }

    private void parseParamStr(String param) {
        int p0 = param.indexOf(124);
        this.dt = ConnectionDescription.getDatabaseType(Integer.parseInt(param.substring(0, p0)));
        if (this.dt != null) {
            this.driverClassName = this.dt.getDriverClassName();
            this.urlElements = new ArrayList<URLElement>();
            for (int i = 0; i < this.dt.getURLElementeCount(); ++i) {
                this.urlElements.add(new URLElement(this.dt.getURLElementAt(i)));
            }
        } else {
            throw new IllegalStateException("parseParamStr can only work within SQLRunner. It needs DatabaseTypes!");
        }
        ++p0;
        boolean ready = false;
        while (!ready) {
            int p1 = param.indexOf(124, p0);
            if (p1 == -1) {
                ready = true;
                break;
            }
            this.storeURLElementValue(new URLElement(param.substring(p0, p1)));
            p0 = p1 + 1;
        }
        this.storeURLElementValue(new URLElement(param.substring(p0, param.length())));
    }

    public void createURL() {
        String urlTemp = this.dt.getUrlTemplate();
        for (int i = 0; i < this.urlElements.size(); ++i) {
            String name = this.urlElements.get(i).getName();
            String value = this.urlElements.get(i).getValue();
            int p0 = urlTemp.indexOf("%" + name);
            if (p0 == -1) continue;
            int p1 = urlTemp.indexOf("%", p0 + 1);
            urlTemp = urlTemp.substring(0, p0) + value + urlTemp.substring(p1 + 1, urlTemp.length());
        }
        this.url = urlTemp;
    }

    public void setStorePasswdEnabled(boolean enable) {
        this.storePasswdEnabled = enable;
    }

    public boolean getStorePasswdEnabled() {
        return this.storePasswdEnabled;
    }

    public String getParamStr() {
        if (this.dt == null || this.urlElements == null || this.urlElements.size() == 0) {
            throw new IllegalStateException("parseParamStr can only be used within SQLRunner because it need DatabaseTypes");
        }
        StringBuilder param = new StringBuilder();
        param.append(String.valueOf(this.dt.getId()));
        param.append('|');
        for (int i = 0; i < this.urlElements.size(); ++i) {
            URLElement element = this.urlElements.get(i);
            if (this.storePasswdEnabled) {
                param.append(element.getParamStr());
            } else if (element.getParamStr().indexOf("PASSWORD") != -1) {
                param.append("PASSWORD=");
            } else {
                param.append(element.getParamStr());
            }
            if (i >= this.urlElements.size() - 1) continue;
            param.append('|');
        }
        param.append('|');
        param.append("PRODUCTIVE");
        param.append("=");
        param.append(this.productive);
        if (this.initSQL != null && this.initSQL.length() > 0) {
            param.append('|');
            param.append("INIT_SQL");
            param.append("=");
            param.append(this.initSQL);
        }
        if (this.comment != null && this.comment.length() > 0) {
            param.append('|');
            param.append("COMMENT");
            param.append("=");
            param.append(this.comment);
        }
        if (this.propertiesString != null && this.propertiesString.length() > 0) {
            param.append('|');
            param.append("PROPERTIES");
            param.append("=");
            param.append(this.propertiesString);
        }
        if (this.defaultFetchSize > 0) {
            param.append('|');
            param.append("FETCHSIZE");
            param.append("=");
            param.append(this.defaultFetchSize);
        }
        return param.toString();
    }

    public String toString() {
        if (showCommentAsDefault) {
            String comment_loc = this.getComment();
            if (comment_loc != null && comment_loc.length() > 0) {
                return this.getComment();
            }
            return this.url + " AS USER " + this.getUser();
        }
        String propStr = this.getPropertiesString();
        if (propStr != null && propStr.length() > 0) {
            if (extendsUrlWithProperties) {
                return this.url + "?" + propStr + " AS USER " + this.getUser();
            }
            return this.url + " [" + propStr + "] AS USER " + this.getUser();
        }
        return this.url + " AS USER " + this.getUser();
    }

    public boolean hasInitdata() {
        boolean ok = false;
        if (this.url != null && this.driverClassName != null) {
            ok = true;
        }
        return ok;
    }

    public boolean hasUserdata() {
        return this.getUser() != null && this.getPasswd() != null;
    }

    public boolean equals(Object o) {
        if (o instanceof ConnectionDescription) {
            ConnectionDescription cd = (ConnectionDescription)o;
            if (!this.driverClassName.equals(cd.driverClassName)) {
                return false;
            }
            return this.getUniqueId().equals(cd.getUniqueId());
        }
        return false;
    }

    public int hashCode() {
        return (this.driverClassName + this.url + this.getUser()).hashCode();
    }

    public String getUniqueId() {
        return this.driverClassName + "_" + this.url + "_" + this.getUser();
    }

    public static List<DatabaseType> getDBTypes() {
        return databaseTypes;
    }

    public static List<DatabaseType> getDatabaseTypes() {
        ConnectionDescription.createDefaults();
        return databaseTypes;
    }

    public static synchronized void createDefaults() {
        if (databaseTypes.size() == 0) {
            databaseTypes.add(new DatabaseType(0, "Oracle THIN", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@%HOST%:%PORT=1521%:%SID%"));
            databaseTypes.add(new DatabaseType(1, "Oracle OCI (use local TNSNAMES)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@%SERVICENAME%"));
            databaseTypes.add(new DatabaseType(2, "Oracle OCI (self created TNSNAMES-entry)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@(description=(address=(host=%HOST%)(protocol=tcp)(port=%PORT=1521%))(connect_data=(sid=%SID%)))"));
            databaseTypes.add(new DatabaseType(3, "ODBC", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:%DATASOURCE%"));
        }
    }

    public static synchronized DatabaseType getDatabaseType(int id) {
        DatabaseType databaseType = null;
        boolean gefunden = false;
        for (int i = 0; i < databaseTypes.size(); ++i) {
            databaseType = databaseTypes.get(i);
            if (id != databaseType.getId()) continue;
            gefunden = true;
            break;
        }
        if (gefunden) {
            return databaseType;
        }
        return new DatabaseType(-1, "unbekannter Typ:" + String.valueOf(id), "UNBEKANNT", "UNBEKANNT");
    }

    public String getURLElementValue(String urlElementName) {
        for (URLElement elem : this.urlElements) {
            if (!urlElementName.equals(elem.getName())) continue;
            return elem.getValue();
        }
        return null;
    }

    public static final boolean isShowCommentAsDefault() {
        return showCommentAsDefault;
    }

    public static final void setShowCommentAsDefault(boolean showCommentAsDefault) {
        ConnectionDescription.showCommentAsDefault = showCommentAsDefault;
    }

    public static final boolean isUserInfoInUrl() {
        return false;
    }

    public static final boolean isExtendsUrlWithProperties() {
        return extendsUrlWithProperties;
    }

    public static final void setExtendsUrlWithProperties(boolean extendsUrlWithProperties) {
        ConnectionDescription.extendsUrlWithProperties = extendsUrlWithProperties;
    }

    public final String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public final void setJndiDataSourceName(String jndiDataSourceName) {
        this.jndiDataSourceName = jndiDataSourceName;
    }

    public String getDatabasePropertyString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DRIVER=");
        sb.append(this.driverClassName);
        sb.append('\n');
        sb.append("URL=");
        sb.append(this.url);
        sb.append('\n');
        sb.append("USER=");
        sb.append(this.getUser());
        sb.append('\n');
        sb.append("PASSWORD=");
        sb.append(this.getPasswd());
        sb.append('\n');
        return sb.toString();
    }

    public String getInitSQL() {
        if (this.urlElements != null && this.urlElements.size() > 0) {
            String sql = null;
            for (int i = 0; i < this.urlElements.size(); ++i) {
                if (!this.urlElements.get(i).getName().equals("INIT_SQL")) continue;
                sql = this.urlElements.get(i).getValue();
                break;
            }
            if (sql == null) {
                return this.initSQL;
            }
            return sql;
        }
        return this.initSQL;
    }

    public void setInitSQL(String sql) {
        if (this.urlElements != null && this.urlElements.size() > 0) {
            for (int i = 0; i < this.urlElements.size(); ++i) {
                if (!this.urlElements.get(i).getName().equals("INIT_SQL")) continue;
                this.urlElements.get(i).setValue(sql);
                break;
            }
        }
        this.initSQL = sql;
    }

    public static final boolean isRunInitialSQLOnConnect() {
        return runInitialSQLOnConnect;
    }

    public static final void setRunInitialSQLOnConnect(boolean runInitialSQLOnConnect) {
        ConnectionDescription.runInitialSQLOnConnect = runInitialSQLOnConnect;
    }

    @Override
    public int compareTo(ConnectionDescription cd) {
        int compareValue = this.url.compareTo(cd.getUrl());
        if (compareValue == 0) {
            compareValue = this.getUser().compareTo(cd.getUser());
        }
        if (compareValue == 0) {
            compareValue = this.driverClassName.compareTo(cd.getDriverClassName());
        }
        return compareValue;
    }

    public static ConnectionDescription create(String encryptedAccessData, String passPhrase) throws Exception {
        String paramStr = StringCrypt.decryptFromBase64(encryptedAccessData, passPhrase);
        return new ConnectionDescription(paramStr);
    }

    public String getEncryptedSetupData(String passPhrase) throws Exception {
        return StringCrypt.cryptToBcase64(this.getParamStr(), passPhrase);
    }

    public ConnectionDescription clone() {
        if (this.urlElements != null) {
            return new ConnectionDescription(this.getParamStr());
        }
        ConnectionDescription clone = new ConnectionDescription();
        clone.setUrl(this.getUrl());
        clone.setUser(this.getUser());
        clone.setPasswd(this.getPasswd());
        clone.setDriverClassName(this.getDriverClassName());
        clone.setAutoCommit(this.getAutoCommit());
        clone.setComment(this.getComment());
        clone.setDefaultFetchSize(this.getDefaultFetchSize());
        clone.setInitSQL(this.getInitSQL());
        clone.setPropertiesString(this.getPropertiesString());
        clone.setProductive(this.isProductive());
        return clone;
    }

    public boolean isProductive() {
        return this.productive;
    }

    public void setProductive(boolean productive) {
        this.productive = productive;
    }
}

