/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class XMLWriter {
    private BufferedWriter out;
    private static final char TAG_START = '<';
    private static final char TAG_END = '>';
    private static final String TAG_END_WITHOUT_CHILDREN = "/>";
    private static final String INDENT_STRING = "  ";
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private final TagStack stack = new TagStack();
    private static final int maxAttrCountPerLine = 2;
    private boolean formatOutput = true;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";
    private boolean lastElementWasTagEnd = false;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isFormatOutput() {
        return this.formatOutput;
    }

    public void setFormatOutput(boolean formatOutput) {
        this.formatOutput = formatOutput;
    }

    public XMLWriter(BufferedWriter out) {
        this.out = out;
    }

    public XMLWriter(OutputStream out, String encoding) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(out, encoding));
    }

    public XMLWriter(OutputStream out) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter(out, DEFAULT_ENCODING));
    }

    public void writeXMLBegin() throws IOException {
        this.out.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\" standalone=\"yes\"?>");
    }

    public void writeDocType(String docTypeTag) throws IOException {
        this.out.write(docTypeTag);
    }

    public String getCurrentTagName() {
        return this.stack.getCurrentTag();
    }

    public void writeTagBegin(String tagName, String[][] attributes) throws IOException {
        this.lastElementWasTagEnd = false;
        this.out.newLine();
        if (this.formatOutput) {
            for (int x = 0; x < this.stack.getCurrentLevel(); ++x) {
                this.out.write(INDENT_STRING);
            }
        }
        this.out.write(60);
        this.out.write(tagName);
        if (attributes != null) {
            this.out.write(32);
            for (int i = 0; i < attributes.length; ++i) {
                int x;
                this.out.write(attributes[i][0]);
                this.out.write("='");
                this.out.write(attributes[i][1]);
                this.out.write("' ");
                if (!this.formatOutput || i <= 0 || i >= attributes.length - 1 || i % 2 != 0) continue;
                this.out.newLine();
                for (x = 0; x < this.stack.getCurrentLevel(); ++x) {
                    this.out.write(INDENT_STRING);
                }
                for (x = 0; x < tagName.length() + 2; ++x) {
                    this.out.write(32);
                }
            }
        }
        this.out.write(62);
        this.stack.pushTag(tagName);
    }

    public void writeClosedTag(String tagName, String[][] attributes) throws IOException {
        this.lastElementWasTagEnd = true;
        this.out.newLine();
        if (this.formatOutput) {
            for (int x = 0; x < this.stack.getCurrentLevel(); ++x) {
                this.out.write(INDENT_STRING);
            }
        }
        this.out.write(60);
        this.out.write(tagName);
        if (attributes != null) {
            this.out.write(32);
            for (int i = 0; i < attributes.length; ++i) {
                this.out.write(attributes[i][0]);
                this.out.write("='");
                this.out.write(attributes[i][1]);
                this.out.write("' ");
                if (this.formatOutput && i > 0 && i < attributes.length - 1 && i % 2 == 0) {
                    int x;
                    this.out.newLine();
                    for (x = 0; x < this.stack.getCurrentLevel(); ++x) {
                        this.out.write(INDENT_STRING);
                    }
                    for (x = 0; x < tagName.length() + 2; ++x) {
                        this.out.write(32);
                    }
                }
                if (i != attributes.length - 1) continue;
                this.out.write(TAG_END_WITHOUT_CHILDREN);
            }
        }
    }

    public void writeTextContent(String content) throws IOException {
        if (content != null) {
            this.out.write(content);
        }
    }

    public void writeCDATAContent(String content) throws IOException {
        this.out.write(CDATA_START);
        this.out.newLine();
        this.out.write(content);
        this.out.newLine();
        if (this.formatOutput) {
            for (int i = 0; i < this.stack.getCurrentLevel(); ++i) {
                this.out.write(INDENT_STRING);
            }
        }
        this.out.write(CDATA_END);
    }

    public void writeComment(String commentText) throws IOException {
        int i;
        this.out.newLine();
        if (this.formatOutput) {
            for (i = 0; i < this.stack.getCurrentLevel(); ++i) {
                this.out.write(INDENT_STRING);
            }
        }
        this.out.write("<!--");
        this.out.newLine();
        this.out.write(commentText);
        this.out.newLine();
        if (this.formatOutput) {
            for (i = 0; i < this.stack.getCurrentLevel(); ++i) {
                this.out.write(INDENT_STRING);
            }
        }
        this.out.write("-->");
    }

    public void writeTagEnd() throws IOException {
        String tagName = this.stack.popTag();
        if (this.lastElementWasTagEnd) {
            this.out.newLine();
            if (this.formatOutput) {
                for (int i = 0; i < this.stack.getCurrentLevel(); ++i) {
                    this.out.write(INDENT_STRING);
                }
            }
        }
        this.out.write(60);
        this.out.write("/");
        this.out.write(tagName);
        this.out.write(62);
        this.lastElementWasTagEnd = true;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.stack.clear();
        this.out.close();
    }

    private static class TagStack {
        private List<String> stack = new ArrayList<String>();

        private TagStack() {
        }

        void pushTag(String tagName) {
            this.stack.add(tagName);
        }

        void clear() {
            this.stack.clear();
        }

        String popTag() {
            int pos = this.stack.size() - 1;
            String tagName = this.stack.get(pos);
            this.stack.remove(pos);
            return tagName;
        }

        String getCurrentTag() {
            int pos = this.stack.size() - 1;
            String tagName = this.stack.get(pos);
            return tagName;
        }

        int getCurrentLevel() {
            return this.stack.size();
        }
    }
}

