/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import sqlrunner.xml.ImportDescription;
import sqlrunner.xml.SAXStoppedException;
import sqlrunner.xml.TableImportHandler;

public class TableCountImportHandler
extends DefaultHandler {
    private static final Logger staticLogger = Logger.getLogger(TableImportHandler.class);
    private Logger logger = staticLogger;
    private ImportDescription impDesc;
    private int countCurrDatasets;

    TableCountImportHandler(ImportDescription impDesc) {
        this.impDesc = impDesc;
    }

    public void setLogger(Logger instanceLogger) {
        if (instanceLogger == null) {
            throw new IllegalArgumentException("instanceLogger cannot be null");
        }
        this.logger = instanceLogger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void resetToStaticLogger() {
        this.logger = staticLogger;
    }

    @Override
    public void startDocument() throws SAXException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXStoppedException("stopped");
        }
        this.countCurrDatasets = 0;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("startDocument() - import file " + this.impDesc.getXmlFile().getAbsolutePath()));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("endDocument() - ..." + this.countCurrDatasets));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (Thread.currentThread().isInterrupted()) {
            throw new SAXStoppedException("stopped");
        }
        if (qName.equals("row")) {
            ++this.countCurrDatasets;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.logger.error((Object)("xml error in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.error((Object)("xml fatalError in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn((Object)("xml warning in line=" + e.getLineNumber() + " column=" + e.getColumnNumber()));
    }

    public int getCountCurrDatasets() {
        return this.countCurrDatasets;
    }
}

