/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.regex;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.StringCharacterIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import org.apache.log4j.Logger;
import sqlrunner.regex.Messages;
import sqlrunner.text.StringReplacer;

public class RegexTestFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(RegexTestFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPaneTestText = null;
    private JTextField jTextFieldRegex = null;
    private JTextField jTextFieldJava = null;
    private JSplitPane jSplitPane = null;
    private JPanel jPanelTop = null;
    private JPanel jPanelButtom = null;
    private JTextArea jTextAreaTest = null;
    private JScrollPane jScrollPaneMessage = null;
    private JTextArea jTextAreaMessage = null;
    private DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.lightGray);
    private JCheckBox jCheckBoxShowOnlyByGroupFound = null;
    private JCheckBox jCheckBoxCaseSensitive = null;
    private boolean currentlyCopyingToRegex = false;
    private boolean currentlyCopyingToJava = false;

    public RegexTestFrame() {
        this.initialize();
        this.setVisible(true);
        this.jSplitPane.setDividerLocation(this.getHeight() / 3);
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                RegexTestFrame.this.showRegexMatches();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RegexTestFrame.this.showRegexMatches();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RegexTestFrame.this.showRegexMatches();
            }
        };
        this.jTextAreaTest.getDocument().addDocumentListener(docListener);
        this.jTextFieldRegex.getDocument().addDocumentListener(docListener);
        this.jTextFieldRegex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToJava();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToJava();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToJava();
            }
        });
        this.jTextFieldJava.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToRegex();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToRegex();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RegexTestFrame.this.copyToRegex();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToJava() {
        if (!this.currentlyCopyingToRegex) {
            this.currentlyCopyingToJava = true;
            try {
                String regex = this.jTextFieldRegex.getText();
                if (regex != null) {
                    regex = regex.trim();
                    String javaCode = RegexTestFrame.regexToJava(regex);
                    this.jTextFieldJava.setText(javaCode);
                    this.jTextFieldJava.setSelectionStart(0);
                    this.jTextFieldJava.setSelectionEnd(javaCode.length() - 1);
                }
            }
            finally {
                this.currentlyCopyingToJava = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyToRegex() {
        if (!this.currentlyCopyingToJava) {
            this.currentlyCopyingToRegex = true;
            try {
                String javaCode = this.jTextFieldJava.getText();
                if (javaCode != null) {
                    String regex = this.javaToRegex(javaCode);
                    this.jTextFieldRegex.setText(regex);
                }
            }
            finally {
                this.currentlyCopyingToRegex = false;
            }
        }
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("RegexTestFrame.0"));
        this.setSize(new Dimension(400, 400));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJSplitPane(), gbc);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPaneTestText() {
        if (this.jScrollPaneTestText == null) {
            this.jScrollPaneTestText = new JScrollPane();
            this.jScrollPaneTestText.setViewportView(this.getJTextAreaTest());
        }
        return this.jScrollPaneTestText;
    }

    private JTextField getJTextFieldRegex() {
        if (this.jTextFieldRegex == null) {
            this.jTextFieldRegex = new JTextField();
        }
        return this.jTextFieldRegex;
    }

    private JTextField getJTextFieldJava() {
        if (this.jTextFieldJava == null) {
            this.jTextFieldJava = new JTextField();
        }
        return this.jTextFieldJava;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setOrientation(0);
            this.jSplitPane.setTopComponent(this.getJPanelTop());
            this.jSplitPane.setBottomComponent(this.getJPanelButtom());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanelTop() {
        if (this.jPanelTop == null) {
            this.jPanelTop = new JPanel();
            this.jPanelTop.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("RegexTestFrame.2"));
            this.jPanelTop.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanelTop.add((Component)this.getJScrollPaneTestText(), gbc);
        }
        return this.jPanelTop;
    }

    private JPanel getJPanelButtom() {
        if (this.jPanelButtom == null) {
            this.jPanelButtom = new JPanel();
            this.jPanelButtom.setLayout(new GridBagLayout());
            int y = 0;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridy = y++;
            this.jPanelButtom.add((Component)this.getJCheckBoxCheckBoxCaseSensitive(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridy = y++;
            JLabel jLabel1 = new JLabel();
            jLabel1.setText(Messages.getString("RegexTestFrame.3"));
            this.jPanelButtom.add((Component)jLabel1, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridy = y++;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            this.jPanelButtom.add((Component)this.getJTextFieldRegex(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridy = y++;
            gbc.gridwidth = 2;
            jLabel1 = new JLabel();
            jLabel1.setText("Escaped String");
            this.jPanelButtom.add((Component)jLabel1, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridy = y++;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            this.jPanelButtom.add((Component)this.getJTextFieldJava(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridy = y++;
            this.jPanelButtom.add((Component)this.getJCheckBoxShowOnlyByGroupFound(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridy = y++;
            JLabel jLabel2 = new JLabel();
            jLabel2.setText(Messages.getString("RegexTestFrame.1"));
            this.jPanelButtom.add((Component)jLabel2, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridy = y;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridwidth = 2;
            gbc.gridx = 0;
            this.jPanelButtom.add((Component)this.getJScrollPaneMessage(), gbc);
        }
        return this.jPanelButtom;
    }

    private JTextArea getJTextAreaTest() {
        if (this.jTextAreaTest == null) {
            this.jTextAreaTest = new JTextArea();
            this.jTextAreaTest.setWrapStyleWord(true);
            this.jTextAreaTest.setLineWrap(true);
        }
        return this.jTextAreaTest;
    }

    private JScrollPane getJScrollPaneMessage() {
        if (this.jScrollPaneMessage == null) {
            this.jScrollPaneMessage = new JScrollPane();
            this.jScrollPaneMessage.setViewportView(this.getJTextAreaMessage());
        }
        return this.jScrollPaneMessage;
    }

    private JTextArea getJTextAreaMessage() {
        if (this.jTextAreaMessage == null) {
            this.jTextAreaMessage = new JTextArea();
            this.jTextAreaMessage.setSize(new Dimension(300, 30));
            this.jTextAreaMessage.setEditable(false);
        }
        return this.jTextAreaMessage;
    }

    private void showRegexMatches() {
        String regex = this.jTextFieldRegex.getText();
        if (regex != null) {
            Pattern pattern = null;
            StringBuffer message = new StringBuffer();
            try {
                pattern = this.jCheckBoxCaseSensitive.isSelected() ? Pattern.compile(this.jTextFieldRegex.getText()) : Pattern.compile(this.jTextFieldRegex.getText(), 2);
                this.jTextFieldRegex.setBackground(new Color(200, 255, 200));
                message.append(Messages.getString("RegexTestFrame.4"));
            }
            catch (PatternSyntaxException pse) {
                this.jTextFieldRegex.setBackground(new Color(255, 200, 200));
                message.append(pse.getMessage());
            }
            this.jTextAreaTest.getHighlighter().removeAllHighlights();
            this.jTextAreaTest.repaint();
            if (pattern != null) {
                Matcher matcher = pattern.matcher(this.jTextAreaTest.getText());
                int countSequences = 0;
                while (matcher.find()) {
                    message.append('\n');
                    message.append("sequence (");
                    message.append(++countSequences);
                    message.append(") <");
                    message.append(matcher.group());
                    message.append(">");
                    if (this.jCheckBoxShowOnlyByGroupFound.isSelected()) {
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            int end;
                            int start = matcher.start(i);
                            if (start >= (end = matcher.end(i))) continue;
                            message.append('\n');
                            message.append("  start:");
                            message.append(start);
                            message.append("  end:");
                            message.append(end);
                            message.append("  group:");
                            message.append(i);
                            message.append(" <");
                            message.append(matcher.group(i));
                            message.append(">");
                            try {
                                this.jTextAreaTest.getHighlighter().addHighlight(matcher.start(i), matcher.end(i), this.highlightPainter);
                                continue;
                            }
                            catch (BadLocationException ex) {
                                logger.error((Object)("showRegexMatches failed: " + ex.getMessage()), (Throwable)ex);
                            }
                        }
                        continue;
                    }
                    if (matcher.start() >= matcher.end()) continue;
                    try {
                        this.jTextAreaTest.getHighlighter().addHighlight(matcher.start(), matcher.end(), this.highlightPainter);
                    }
                    catch (BadLocationException ex) {
                        logger.error((Object)("showRegexMatches failed: " + ex.getMessage()), (Throwable)ex);
                    }
                }
            }
            this.jTextAreaMessage.setText(message.toString());
        }
    }

    private JCheckBox getJCheckBoxShowOnlyByGroupFound() {
        if (this.jCheckBoxShowOnlyByGroupFound == null) {
            this.jCheckBoxShowOnlyByGroupFound = new JCheckBox();
            this.jCheckBoxShowOnlyByGroupFound.setText(Messages.getString("RegexTestFrame.11"));
            this.jCheckBoxShowOnlyByGroupFound.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RegexTestFrame.this.showRegexMatches();
                }
            });
        }
        return this.jCheckBoxShowOnlyByGroupFound;
    }

    private JCheckBox getJCheckBoxCheckBoxCaseSensitive() {
        if (this.jCheckBoxCaseSensitive == null) {
            this.jCheckBoxCaseSensitive = new JCheckBox();
            this.jCheckBoxCaseSensitive.setSelected(true);
            this.jCheckBoxCaseSensitive.setText(Messages.getString("RegexTestFrame.caseSensitive"));
            this.jCheckBoxCaseSensitive.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    RegexTestFrame.this.showRegexMatches();
                }
            });
        }
        return this.jCheckBoxCaseSensitive;
    }

    private static String regexToJava(String aRegexFragment) {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(aRegexFragment);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\"') {
                result.append('\\');
                result.append(character);
            } else if (character == '\\') {
                result.append('\\');
                result.append(character);
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    private String javaToRegex(String javaEscapedText) {
        if (javaEscapedText.startsWith("\"")) {
            javaEscapedText = javaEscapedText.substring(0, 1);
        }
        if (javaEscapedText.endsWith("\"")) {
            int lenght = javaEscapedText.length();
            javaEscapedText = javaEscapedText.substring(lenght - 1, lenght);
        }
        StringReplacer sr = new StringReplacer(javaEscapedText);
        sr.replace("\\\"", "\"");
        sr.replace("\\\\", "\\");
        return sr.getResultText();
    }
}

