/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.log4jpanel;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;

public class Log4JModel
extends AbstractTableModel {
    private static final Logger logger = Logger.getLogger(Log4JModel.class);
    private static final long serialVersionUID = 1L;
    private Vector<Logger> loggerList = new Vector();

    public void init() {
        logger.debug((Object)"init");
        this.loggerList.removeAllElements();
        Logger rootLogger = Logger.getRootLogger();
        LoggerRepository rep = rootLogger.getLoggerRepository();
        Enumeration el = rep.getCurrentLoggers();
        while (el.hasMoreElements()) {
            this.loggerList.add((Logger)el.nextElement());
        }
        Collections.sort(this.loggerList, new Comparator<Logger>(){

            @Override
            public int compare(Logger o1, Logger o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.loggerList.add(0, rootLogger);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.loggerList.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public Class<String> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "LoggerName";
            }
            case 1: {
                return "Level";
            }
        }
        return "unknown";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Logger logger = this.loggerList.get(rowIndex);
        if (columnIndex == 0) {
            return logger.getName();
        }
        if (columnIndex == 1) {
            if (logger.getLevel() != null) {
                return logger.getLevel().toString();
            }
            return null;
        }
        return "unknown columnIndex=" + columnIndex;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Logger logger = this.loggerList.get(rowIndex);
        if (Level.ALL.toString().equals(value)) {
            logger.setLevel(Level.ALL);
        } else if (Level.ALL.toString().equals(value)) {
            logger.setLevel(Level.ALL);
        } else if (Level.TRACE.toString().equals(value)) {
            logger.setLevel(Level.TRACE);
        } else if (Level.DEBUG.toString().equals(value)) {
            logger.setLevel(Level.DEBUG);
        } else if (Level.ERROR.toString().equals(value)) {
            logger.setLevel(Level.ERROR);
        } else if (Level.FATAL.toString().equals(value)) {
            logger.setLevel(Level.FATAL);
        } else if (Level.INFO.toString().equals(value)) {
            logger.setLevel(Level.INFO);
        } else if (Level.OFF.toString().equals(value)) {
            logger.setLevel(Level.OFF);
        } else if (Level.WARN.toString().equals(value)) {
            logger.setLevel(Level.WARN);
        }
    }
}

