/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.history;

import dbtools.SQLStatement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import sqlrunner.Main;
import sqlrunner.history.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class DetailDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JSplitPane splitpane = new JSplitPane();
    private final JScrollPane jScrollPaneTop = new JScrollPane();
    private final JScrollPane jScrollPaneButtom = new JScrollPane();
    private final JTextArea textAreaSQL = new JTextArea();
    private final JTextArea textAreaSummary = new JTextArea();
    private JButton buttonClose;
    private SQLStatement statement = null;

    public DetailDialog(JFrame parent) {
        super((Frame)parent, false);
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            WindowHelper.checkAndCorrectWindowBounds(this);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.setTitle("Statement-Details");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.splitpane, "Center");
        this.getContentPane().add((Component)this.getJButtonClose(), "South");
        this.jScrollPaneTop.setViewportView(this.textAreaSummary);
        this.jScrollPaneTop.setPreferredSize(new Dimension(390, 140));
        this.jScrollPaneButtom.setViewportView(this.textAreaSQL);
        this.jScrollPaneButtom.setPreferredSize(new Dimension(390, 140));
        this.textAreaSQL.setFont(new Font("Monospaced", 0, 12));
        this.textAreaSummary.setBackground(Main.info);
        this.splitpane.setOrientation(0);
        this.splitpane.setContinuousLayout(true);
        this.splitpane.setTopComponent(this.jScrollPaneTop);
        this.splitpane.setBottomComponent(this.jScrollPaneButtom);
        this.splitpane.setDividerSize(5);
    }

    private JButton getJButtonClose() {
        if (this.buttonClose == null) {
            this.buttonClose = new JButton();
            this.buttonClose.setText(Messages.getString("HistoryView.7"));
            this.buttonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailDialog.this.dispose();
                }
            });
        }
        return this.buttonClose;
    }

    public void setStatement(SQLStatement stat) {
        this.statement = stat;
        this.refresh();
    }

    public void refresh() {
        if (this.statement != null) {
            this.textAreaSQL.setText(this.statement.getSQL());
            this.textAreaSummary.setText(this.statement.getSummary());
        } else {
            this.textAreaSQL.setText(null);
            this.textAreaSummary.setText(null);
        }
        this.jScrollPaneTop.invalidate();
        this.textAreaSQL.setCaretPosition(0);
        this.jScrollPaneButtom.invalidate();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }
}

