/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.generator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import sqlrunner.Main;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.generator.JavaCodeGenerator;

public final class JavaCreatorFrame
extends JFrame {
    private static final long serialVersionUID = -5042003376518345983L;
    private JPanel jContentPane = null;
    private JLabel labelDirectory = null;
    private JTextField textFieldJavaRootDir = null;
    private JButton buttonChooseDirectory = null;
    private JProgressBar progressBar = null;
    private JButton buttonStart = null;
    private JButton buttonStop = null;
    private transient JavaCreatorThread creatorThread;
    private JTextField jTextFieldPackage = null;
    private JLabel jLabel = null;
    private transient SQLSchema schema = null;

    public JavaCreatorFrame(SQLSchema metaModel) {
        this.schema = metaModel;
        this.initialize();
    }

    private void initialize() {
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Java Files Creator Model: " + this.schema.toString());
        this.setSize(453, 167);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints constraints = new GridBagConstraints();
            this.jLabel = new JLabel();
            this.labelDirectory = new JLabel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.labelDirectory.setText("Source Root Directory");
            this.labelDirectory.setHorizontalTextPosition(4);
            this.labelDirectory.setHorizontalAlignment(4);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.labelDirectory, constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getTextFieldJavaRootDir(), constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getButtonChooseDirectory(), constraints);
            this.jLabel.setText("package");
            this.jLabel.setHorizontalAlignment(4);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.jLabel, constraints);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 3;
            constraints.fill = 2;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getJTextFieldPackage(), constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 4;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getProgressBar(), constraints);
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getButtonStart(), constraints);
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.gridwidth = 2;
            constraints.anchor = 13;
            constraints.insets = new Insets(2, 2, 2, 2);
            this.jContentPane.add((Component)this.getButtonStop(), constraints);
        }
        return this.jContentPane;
    }

    private JTextField getTextFieldJavaRootDir() {
        if (this.textFieldJavaRootDir == null) {
            this.textFieldJavaRootDir = new JTextField();
            this.textFieldJavaRootDir.setBounds(136, 5, 268, 23);
            String directoryName = Main.getUserProperty("JAVA_SOURCE_ROOT");
            if (directoryName != null) {
                this.textFieldJavaRootDir.setText(directoryName);
            }
        }
        return this.textFieldJavaRootDir;
    }

    private JButton getButtonChooseDirectory() {
        if (this.buttonChooseDirectory == null) {
            this.buttonChooseDirectory = new JButton();
            this.buttonChooseDirectory.setBounds(411, 5, 27, 23);
            this.buttonChooseDirectory.setText("Choose...");
            this.buttonChooseDirectory.setMnemonic(68);
            this.buttonChooseDirectory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaCreatorFrame.this.openJavaRootChooserDialog();
                }
            });
        }
        return this.buttonChooseDirectory;
    }

    private void openJavaRootChooserDialog() {
        String directoryName = Main.getUserProperty("JAVA_SOURCE_ROOT");
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        if (directoryName != null) {
            chooser.setCurrentDirectory(new File(directoryName));
        }
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Choose Java Source root");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            String javaSourceRoot = chooser.getSelectedFile().getAbsolutePath();
            this.textFieldJavaRootDir.setText(javaSourceRoot);
        }
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setBounds(8, 75, 430, 19);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private JButton getButtonStart() {
        if (this.buttonStart == null) {
            this.buttonStart = new JButton();
            this.buttonStart.setBounds(8, 107, 268, 25);
            this.buttonStart.setText("Start Creating Java Files");
            this.buttonStart.setMnemonic(83);
            this.buttonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaCreatorFrame.this.startCreatingJavaFiles1();
                }
            });
        }
        return this.buttonStart;
    }

    private JButton getButtonStop() {
        if (this.buttonStop == null) {
            this.buttonStop = new JButton();
            this.buttonStop.setBounds(292, 107, 146, 25);
            this.buttonStop.setText("Cancel");
            this.buttonStop.setEnabled(false);
            this.buttonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JavaCreatorFrame.this.cancelCreatingJavaFiles();
                }
            });
        }
        return this.buttonStop;
    }

    private void startCreatingJavaFiles1() {
        if (this.jTextFieldPackage.getText() == null || this.jTextFieldPackage.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "package or java source root is null !");
        } else if (this.textFieldJavaRootDir.getText() == null || this.textFieldJavaRootDir.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "schema is empty !");
        } else {
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(this.schema.getTableCount());
            Main.setUserProperty("JAVA_PACKAGE", this.jTextFieldPackage.getText().trim());
            Main.setUserProperty("JAVA_SOURCE_ROOT", this.textFieldJavaRootDir.getText().trim());
            this.creatorThread = new JavaCreatorThread(this.textFieldJavaRootDir.getText().trim(), this.jTextFieldPackage.getText().trim());
            this.creatorThread.start();
        }
    }

    private void createFile(String sourceRootDir, String packageName, String tableName, String text) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        File f = JavaCodeGenerator.createSourceFile(sourceRootDir, packageName, tableName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f.getAbsoluteFile()), Main.getFileEnoding()));
        bw.write(text);
        bw.close();
    }

    private void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private void cancelCreatingJavaFiles() {
        if (this.creatorThread != null && this.creatorThread.isAlive()) {
            this.creatorThread.interrupt();
        }
    }

    private JTextField getJTextFieldPackage() {
        if (this.jTextFieldPackage == null) {
            this.jTextFieldPackage = new JTextField();
            String packageName = Main.getUserProperty("JAVA_PACKAGE");
            this.jTextFieldPackage.setText(packageName);
            this.jTextFieldPackage.setBounds(137, 37, 268, 23);
        }
        return this.jTextFieldPackage;
    }

    private final class JavaCreatorThread
    extends Thread {
        final String javaSourceRoot;
        final String packageName;

        JavaCreatorThread(String javaSourceRoot, String packageName) {
            this.javaSourceRoot = javaSourceRoot;
            this.packageName = packageName;
        }

        @Override
        public void run() {
            JavaCreatorFrame.this.buttonStart.setEnabled(false);
            JavaCreatorFrame.this.buttonStop.setEnabled(true);
            for (int i = 0; i < JavaCreatorFrame.this.schema.getTableCount(); ++i) {
                SQLTable table = JavaCreatorFrame.this.schema.getTableAt(i);
                if (this.isInterrupted()) continue;
                try {
                    JavaCreatorFrame.this.createFile(this.javaSourceRoot, this.packageName, table.getName(), JavaCodeGenerator.createJavaClassCode(table, this.packageName));
                    JavaCreatorFrame.this.progressBar.setValue(i + 1);
                    continue;
                }
                catch (Exception ex) {
                    JavaCreatorFrame.this.showErrorMessage("Failed to create file for table " + table.toString(), ex.getMessage());
                    break;
                }
            }
            JavaCreatorFrame.this.buttonStart.setEnabled(true);
            JavaCreatorFrame.this.buttonStop.setEnabled(false);
        }
    }
}

