/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.generator;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.text.StringReplacer;

public class JavaCodeGenerator {
    public static String formJavaClassName(String name) {
        name = name.toLowerCase();
        StringReplacer sr = new StringReplacer(name);
        sr.replace("\u00fc", "ue");
        sr.replace("\u00f6", "oe");
        sr.replace("\u00e4", "ae");
        sr.replace("\u00df", "sz");
        sr.replace(" ", "");
        name = sr.getResultText();
        name = JavaCodeGenerator.changeUnderScoresToCamelCase(name);
        char c = name.charAt(0);
        if (Character.isLowerCase(c)) {
            name = Character.toUpperCase(c) + name.substring(1);
        }
        return name;
    }

    public static final File createSourceFile(String sourceRootDir, String packageName, String tableName) {
        return new File(sourceRootDir + "/" + packageName.replace('.', '/') + "/" + JavaCodeGenerator.formJavaClassName(tableName) + ".java");
    }

    private static String formJavaPropertyName(String name) {
        name = name.toLowerCase();
        StringReplacer sr = new StringReplacer(name);
        sr.replace("\u00fc", "ue");
        sr.replace("\u00f6", "oe");
        sr.replace("\u00e4", "ae");
        sr.replace("\u00df", "sz");
        sr.replace(" ", "");
        name = sr.getResultText();
        if (name.equals("abstract")) {
            name = "abstractObject";
        } else if (name.equals("class")) {
            name = "objectClass";
        } else if (name.equals("protected")) {
            name = "protectedObject";
        }
        return JavaCodeGenerator.changeUnderScoresToCamelCase(name);
    }

    private static String changeUnderScoresToCamelCase(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        int c0 = 32;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '_') {
                if (c0 == 95) {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(c);
                }
            }
            c0 = c;
        }
        return sb.toString();
    }

    private static String capitalizeName(String name) {
        char c = name.charAt(0);
        if (Character.isLowerCase(c)) {
            name = Character.toUpperCase(c) + name.substring(1);
        }
        return name;
    }

    private static String formGetterMethodeName(SQLField field) {
        return "get" + JavaCodeGenerator.capitalizeName(JavaCodeGenerator.changeUnderScoresToCamelCase(field.getName().toLowerCase()));
    }

    private static String formSetterMethodeName(SQLField field) {
        return "set" + JavaCodeGenerator.capitalizeName(JavaCodeGenerator.changeUnderScoresToCamelCase(field.getName().toLowerCase()));
    }

    public static String createJavaClassCode(SQLTable table, String packageName) {
        StringBuffer sbClass = new StringBuffer();
        sbClass.append("/**\n");
        sbClass.append(" * build from database url=");
        sbClass.append(table.getModel().toString());
        sbClass.append('\n');
        sbClass.append(" * at: ");
        sbClass.append(new SimpleDateFormat().format(new Date()));
        sbClass.append('\n');
        sbClass.append(" */\n");
        sbClass.append("package ");
        sbClass.append(packageName);
        sbClass.append(";\n\n");
        sbClass.append("import java.sql.Connection;\n");
        sbClass.append("import java.sql.ResultSet;\n");
        sbClass.append("import java.sql.SQLException;\n\n");
        sbClass.append("public class ");
        sbClass.append(JavaCodeGenerator.formJavaClassName(table.getName()));
        sbClass.append(" {\n\n");
        for (int i = 0; i < table.getFieldCount(); ++i) {
            sbClass.append(JavaCodeGenerator.createMemberVariableCode(table.getFieldAt(i)));
        }
        sbClass.append("\n}");
        return sbClass.toString();
    }

    private static String createMemberVariableCode(SQLField field) {
        StringBuffer sb = new StringBuffer();
        if (BasicDataType.isStringType(field.getBasicType())) {
            sb.append("    private String ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = null;\n\n");
            sb.append("    public String ");
            sb.append(JavaCodeGenerator.formGetterMethodeName(field));
            sb.append("() {\n");
            sb.append("        return ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(";\n");
            sb.append("    }\n\n");
            sb.append("    public void ");
            sb.append(JavaCodeGenerator.formSetterMethodeName(field));
            sb.append("(String value) {\n");
            if (!field.isNullValueAllowed()) {
                sb.append("        if (value == null) {\n");
                sb.append("            throw new IllegalArgumentException(\"");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" cannot be null\");\n");
                sb.append("        }\n");
            }
            sb.append("        this.");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = value;\n");
            sb.append("    }\n\n");
        } else if (field.getBasicType() == BasicDataType.DATE.getId()) {
            sb.append("    private java.util.Date ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = null;\n\n");
            sb.append("    public java.util.Date ");
            sb.append(JavaCodeGenerator.formGetterMethodeName(field));
            sb.append("() {\n");
            sb.append("        return ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(";\n");
            sb.append("    }\n\n");
            sb.append("    public void ");
            sb.append(JavaCodeGenerator.formSetterMethodeName(field));
            sb.append("(java.util.Date value) {\n");
            if (!field.isNullValueAllowed()) {
                sb.append("        if (value == null) {\n");
                sb.append("            throw new IllegalArgumentException(\"");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" cannot be null\");\n");
                sb.append("        }\n");
            }
            sb.append("        this.");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = value;\n");
            sb.append("    }\n\n");
        } else if (BasicDataType.isNumberType(field.getBasicType())) {
            if (field.isNullValueAllowed()) {
                sb.append("    private Double ");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" = null;\n\n");
                sb.append("    public Double ");
            } else {
                sb.append("    private double ");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" = 0;\n\n");
                sb.append("    public double ");
            }
            sb.append(JavaCodeGenerator.formGetterMethodeName(field));
            sb.append("() {\n");
            sb.append("        return ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(";\n");
            sb.append("    }\n");
            sb.append('\n');
            if (field.isNullValueAllowed()) {
                sb.append("    public void ");
                sb.append(JavaCodeGenerator.formSetterMethodeName(field));
                sb.append("(Double value) {\n");
                sb.append("        if (value == null) {\n");
                sb.append("            throw new IllegalArgumentException(\"");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" cannot be null\");\n");
                sb.append("        }\n");
            } else {
                sb.append("    public void ");
                sb.append(JavaCodeGenerator.formSetterMethodeName(field));
                sb.append("(double value) {\n");
            }
            sb.append("        this.");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = value;\n");
            sb.append("    }\n\n");
        } else if (field.getBasicType() == BasicDataType.BOOLEAN.getId()) {
            if (field.isNullValueAllowed()) {
                sb.append("    private Boolean ");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" = null;\n\n");
                sb.append("    public Boolean ");
            } else {
                sb.append("    private boolean ");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" = false;\n\n");
                sb.append("    public boolean ");
            }
            sb.append(JavaCodeGenerator.formGetterMethodeName(field));
            sb.append("() {\n");
            sb.append("        return ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(";\n");
            sb.append("    }\n");
            sb.append('\n');
            if (field.isNullValueAllowed()) {
                sb.append("    public void ");
                sb.append(JavaCodeGenerator.formSetterMethodeName(field));
                sb.append("(Boolean value) {\n");
                sb.append("        if (value == null) {\n");
                sb.append("            throw new IllegalArgumentException(\"");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" cannot be null\");\n");
                sb.append("        }\n");
            } else {
                sb.append("    public void ");
                sb.append(JavaCodeGenerator.formSetterMethodeName(field));
                sb.append("(boolean value) {\n");
            }
            sb.append("        this.");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = value;\n");
            sb.append("    }\n\n");
        } else {
            sb.append("    private Object ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = null;\n\n");
            sb.append("    public Object ");
            sb.append(JavaCodeGenerator.formGetterMethodeName(field));
            sb.append("() {\n");
            sb.append("        return ");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(";\n");
            sb.append("    }\n");
            sb.append('\n');
            sb.append("    public void ");
            sb.append(JavaCodeGenerator.formSetterMethodeName(field));
            sb.append("(Object value) {\n");
            if (!field.isNullValueAllowed()) {
                sb.append("        if (value == null) {\n");
                sb.append("            throw new IllegalArgumentException(\"");
                sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
                sb.append(" cannot be null\");\n");
                sb.append("        }\n");
            }
            sb.append("        this.");
            sb.append(JavaCodeGenerator.formJavaPropertyName(field.getName()));
            sb.append(" = value;\n");
            sb.append("    }\n\n");
        }
        return sb.toString();
    }
}

