/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.apache.log4j.Logger;
import sqlrunner.Database;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.editor.TextViewer;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.CSVFieldTokenizer;
import sqlrunner.flatfileimport.CSVFileDatasetProvider;
import sqlrunner.flatfileimport.DatasetProvider;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.FileImporter;
import sqlrunner.flatfileimport.ImportAttributes;
import sqlrunner.flatfileimport.ParserException;
import sqlrunner.flatfileimport.gui.DelimiterConfigPanel;
import sqlrunner.flatfileimport.gui.DescriptionEditor;
import sqlrunner.flatfileimport.gui.DescriptionTableModel;
import sqlrunner.flatfileimport.gui.ImpDataFileFilter;
import sqlrunner.flatfileimport.gui.ImpPropFileFilter;
import sqlrunner.flatfileimport.gui.ImportConfiguratorTransferHandler;
import sqlrunner.flatfileimport.gui.ImportProgressPanel;
import sqlrunner.flatfileimport.gui.Messages;
import sqlrunner.flatfileimport.gui.TalendSchemaFileFilter;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.talend.SchemaUtil;

public final class ImportConfiguratorFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ImportConfiguratorFrame.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane jTabbedPane = null;
    private JButton jButtonStartImport = null;
    private JButton jButtonCancelImport = null;
    private JTextField jTextFieldSourceFileName = null;
    private JTextField jTextFieldSheetName = null;
    private JButton jButtonChooseSourceFile = null;
    private JCheckBox jCheckBoxIgnoreFirstLine = null;
    private JTextField jTextFieldSkipRows = null;
    private JComboBox jComboBoxCharSet = null;
    private JButton jButtonCountLines = null;
    private JTextField jTextFieldCountLines = null;
    private JCheckBox jCheckBoxEnablePreProcessing = null;
    private JComboBox jComboBoxAddPreSQLParameter = null;
    private JTextArea jTextAreaPostProcessingSQL = null;
    private JComboBox jComboBoxAddPostSQLParameter = null;
    private JCheckBox jCheckBoxEnablePostProcessing = null;
    private JTextArea jTextAreaPreProcessingSQL = null;
    private DelimiterConfigPanel delimiterConfigPanel = null;
    private JTextField jTextFieldTableName = null;
    private JTextField jTextFieldBatchSize = null;
    private JButton jButtonCreateNewFieldDescriptions = null;
    private JButton jButtonEditFieldDescription = null;
    private JButton jButtonAddFieldDescription = null;
    private JButton jButtonDeleteFieldDescription = null;
    private JButton jButtonDeleteAllFieldDescriptions = null;
    private JButton jButtonTakeOverHeaderAsFieldName = null;
    private JCheckBox jCheckBoxDeleteAllBefore = null;
    private JCheckBox jCheckBoxInsertEnabled = null;
    private JCheckBox jCheckBoxUpdateEnabled = null;
    private JButton jButtonTestForwards = null;
    private JButton jButtonTestBackwards = null;
    private JTextField jTextFieldCurrentRowNum = null;
    private JLabel jLabelCurrentCountColumns = null;
    private JButton jButtonMoveFieldDescUp = null;
    private JButton jButtonMoveFieldDescDown = null;
    private JTable jTableFieldDescriptions = null;
    private transient DescriptionTableModel descriptionTableModel = null;
    private ImportProgressPanel importProgressPanel = null;
    private final Vector<Long> filePointers = new Vector();
    private transient Database database = null;
    private final transient FileImporter importer = new FileImporter();
    private transient Thread counterThread = null;
    private JMenuBar importConfigMenuBar = null;
    private JMenu jMenuFile = null;
    private JMenuItem jMenuItemFileNew = null;
    private JMenuItem jMenuItemFileOpen = null;
    private JMenuItem jMenuItemFileSave = null;
    private JMenuItem jMenuItemFileSaveAs = null;
    private JMenuItem jMenuItemFileSaveAsTalendSchema = null;
    private JMenuItem jMenuItemClose = null;
    private String configFileName;
    private Properties lastConfiguration = new Properties();
    private JCheckBox jCheckBoxTestOnly = null;
    public static final String IMPORT_CONFIG_EXTENSION = ".importconfig";
    public static final String DATASOURCE_EXTENSION = ".csv";
    private File currentDataFile = null;
    private transient FieldTokenizer testFieldParser = null;
    private DatasetProvider testDatasetProvider = null;
    private JCheckBox jCheckBoxHandleAlwaysAsCSVFile;
    private JComboBox jComboBoxSortFieldDescriptions = null;
    private AbstractAction deleteAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImportConfiguratorFrame.this.jTableFieldDescriptions.getSelectedRow() != -1) {
                int deletedFDIndex = ImportConfiguratorFrame.this.jTableFieldDescriptions.getSelectedRow();
                ImportConfiguratorFrame.this.descriptionTableModel.removeFieldDescriptionAt(deletedFDIndex);
                ImportConfiguratorFrame.this.reorgFieldDescriptionIndex();
            }
        }
    };
    private AbstractAction moveForwardAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportConfiguratorFrame.this.showTestData(1);
        }
    };
    private AbstractAction moveBackwardAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportConfiguratorFrame.this.showTestData(-1);
        }
    };
    private AbstractAction readDatasetAtRowAction = new ReadDatasetAtRowAction();

    public ImportConfiguratorFrame() {
        this.initialize();
        this.lastConfiguration = this.buildProperties();
    }

    public ImportConfiguratorFrame(Database database) {
        this();
        this.database = database;
    }

    public ImportConfiguratorFrame(Database database, String tableName) {
        this(database);
        if (tableName != null && tableName.trim().length() > 0) {
            this.createImportDescriptionForTable(tableName);
            this.jCheckBoxInsertEnabled.setSelected(true);
            this.jTextFieldBatchSize.setEditable(true);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                if (!this.close()) break;
                super.processWindowEvent(winEvent);
                break;
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    private boolean close() {
        if (!this.jButtonStartImport.isEnabled()) {
            int answer = JOptionPane.showConfirmDialog(this, Messages.getString("ImportConfiguratorFrame.interruptQuestion"), Messages.getString("ImportConfiguratorFrame.close"), 0);
            if (answer == 0) {
                if (this.importer != null) {
                    this.importer.abort();
                }
                return true;
            }
            return false;
        }
        return this.checkSaveConfig();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.testDatasetProvider != null) {
            this.testDatasetProvider.closeDatasetProvider();
        }
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
        if (visible) {
            WindowHelper.checkAndCorrectWindowBounds(this);
        }
    }

    private void initialize() {
        this.setJMenuBar(this.getImportConfigMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("ImportConfiguratorFrame.title"));
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.createJPanelSourceFile(), "North");
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
            this.jContentPane.add((Component)this.createJPanelStartStopButtons(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab(Messages.getString("ImportConfiguratorFrame.mapping"), null, this.createJPanelMapping(), null);
            this.jTabbedPane.addTab(Messages.getString("ImportConfiguratorFrame.preprocesssql"), null, this.createJPanelPreProcessSQL(), null);
            this.jTabbedPane.addTab(Messages.getString("ImportConfiguratorFrame.postprocesssql"), null, this.createJPanelPostProcessSQL(), null);
            this.jTabbedPane.addTab(Messages.getString("ImportConfiguratorFrame.progress"), null, this.createJPanelProgress(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel createJPanelMapping() {
        JPanel jPanelMapping = new JPanel();
        jPanelMapping.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        jPanelMapping.add((Component)this.getDelimiterConfigPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(Messages.getString("ImportConfiguratorFrame.tablename"));
        jPanelMapping.add((Component)this.createJPanelTableConfig(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        jPanelMapping.add((Component)this.createJPanelFieldDescriptions(), gbc);
        return jPanelMapping;
    }

    private JCheckBox getJCheckBoxHandleFilesAlwaysAsCSV() {
        if (this.jCheckBoxHandleAlwaysAsCSVFile == null) {
            this.jCheckBoxHandleAlwaysAsCSVFile = new JCheckBox();
            this.jCheckBoxHandleAlwaysAsCSVFile.setText(Messages.getString("ImportConfiguratorFrame.alwaysCSV"));
            this.jCheckBoxHandleAlwaysAsCSVFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!(ImportConfiguratorFrame.this.testDatasetProvider instanceof CSVFileDatasetProvider)) {
                        ImportConfiguratorFrame.this.intitializeTestdataView();
                    }
                }
            });
        }
        return this.jCheckBoxHandleAlwaysAsCSVFile;
    }

    private JPanel createJPanelSourceFile() {
        JPanel jPanelSourceFile = new JPanel();
        jPanelSourceFile.setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 5, 2, 2);
        gbc.anchor = 13;
        JLabel label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.sourcefilename"));
        jPanelSourceFile.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        jPanelSourceFile.add((Component)this.getJTextFieldSourceFileName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = y++;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelSourceFile.add((Component)this.getJButtonChooseSourceFile(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 5, 2, 2);
        gbc.anchor = 13;
        label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.sheetName"));
        jPanelSourceFile.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = 2;
        gbc.anchor = 10;
        jPanelSourceFile.add((Component)this.getJTextFieldSheetName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = y++;
        gbc.insets = new Insets(2, 5, 2, 2);
        gbc.anchor = 17;
        label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.sheetNameHint"));
        jPanelSourceFile.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 0);
        gbc.gridwidth = 2;
        label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.skipRows"));
        jPanelSourceFile.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = 1;
        jPanelSourceFile.add((Component)this.getJTextFieldSkipRows(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = y++;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.gridwidth = 1;
        jPanelSourceFile.add((Component)this.getJCheckBoxIgnoreFirstLine(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 5, 2, 2);
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("ImportConfiguratorFrame.charset"));
        jPanelSourceFile.add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = y;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelSourceFile.add((Component)this.getJCheckBoxHandleFilesAlwaysAsCSV(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        jPanelSourceFile.add((Component)this.getJComboBoxCharSet(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        jPanelSourceFile.add((Component)this.getJButtonCountLines(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.fill = 2;
        this.jTextFieldCountLines = new JTextField();
        this.jTextFieldCountLines.setEditable(false);
        this.jTextFieldCountLines.setText("0");
        jPanelSourceFile.add((Component)this.jTextFieldCountLines, gbc);
        return jPanelSourceFile;
    }

    private JPanel createJPanelProgress() {
        JPanel jPanelProgress = new JPanel();
        jPanelProgress.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        jPanelProgress.add((Component)this.getImportProgressPanel(), gbc);
        return jPanelProgress;
    }

    private JPanel createJPanelStartStopButtons() {
        JPanel jPanelButtom = new JPanel();
        jPanelButtom.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelButtom.add((Component)this.getJButtonStartImport(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelButtom.add((Component)this.getJCheckBoxTestOnly(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelButtom.add((Component)this.getJButtonCancelImport(), gbc);
        return jPanelButtom;
    }

    private JCheckBox getJCheckBoxTestOnly() {
        if (this.jCheckBoxTestOnly == null) {
            this.jCheckBoxTestOnly = new JCheckBox();
            this.jCheckBoxTestOnly.setText(Messages.getString("ImportConfiguratorFrame.testOnly"));
        }
        return this.jCheckBoxTestOnly;
    }

    private JButton getJButtonStartImport() {
        if (this.jButtonStartImport == null) {
            this.jButtonStartImport = new JButton();
            this.jButtonStartImport.setText(Messages.getString("ImportConfiguratorFrame.startimport"));
            this.jButtonStartImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonStart_actionPerformed();
                }
            });
        }
        return this.jButtonStartImport;
    }

    private JButton getJButtonCancelImport() {
        if (this.jButtonCancelImport == null) {
            this.jButtonCancelImport = new JButton();
            this.jButtonCancelImport.setEnabled(false);
            this.jButtonCancelImport.setText(Messages.getString("ImportConfiguratorFrame.cancelimport"));
            this.jButtonCancelImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImportConfiguratorFrame.this.importer != null) {
                        ImportConfiguratorFrame.this.importer.interrupt();
                        ImportConfiguratorFrame.this.jButtonCancelImport.setEnabled(false);
                        ImportConfiguratorFrame.this.jButtonStartImport.setEnabled(true);
                    }
                }
            });
        }
        return this.jButtonCancelImport;
    }

    private void buttonUp_actionPerformed() {
        int row = this.jTableFieldDescriptions.getSelectedRow();
        if (row > 0) {
            FieldDescription movedDesc = this.descriptionTableModel.getFieldDescription(row);
            FieldDescription skippedDesc = this.descriptionTableModel.getFieldDescription(row - 1);
            int abspos = movedDesc.getAbsPos();
            int delimpos = movedDesc.getDelimPos();
            movedDesc.setAbsPos(skippedDesc.getAbsPos());
            skippedDesc.setAbsPos(abspos);
            movedDesc.setDelimPos(skippedDesc.getDelimPos());
            skippedDesc.setDelimPos(delimpos);
            this.descriptionTableModel.removeFieldDescriptionAt(row);
            this.descriptionTableModel.insertFieldDescriptionAt(movedDesc, row - 1);
            this.descriptionTableModel.setupFieldDescriptionIndex();
            this.jTableFieldDescriptions.setRowSelectionInterval(row - 1, row - 1);
            this.refreshTestData();
        }
    }

    private void buttonDown_actionPerformed() {
        int row = this.jTableFieldDescriptions.getSelectedRow();
        if (row < this.descriptionTableModel.getRowCount() - 1) {
            FieldDescription movedDesc = this.descriptionTableModel.getFieldDescription(row);
            FieldDescription skippedDesc = this.descriptionTableModel.getFieldDescription(row + 1);
            int index = movedDesc.getIndex();
            int abspos = movedDesc.getAbsPos();
            int delimpos = movedDesc.getDelimPos();
            movedDesc.setIndex(skippedDesc.getIndex());
            skippedDesc.setIndex(index);
            movedDesc.setAbsPos(skippedDesc.getAbsPos());
            skippedDesc.setAbsPos(abspos);
            movedDesc.setDelimPos(skippedDesc.getDelimPos());
            skippedDesc.setDelimPos(delimpos);
            this.descriptionTableModel.removeFieldDescriptionAt(row);
            this.descriptionTableModel.insertFieldDescriptionAt(movedDesc, row + 1);
            this.descriptionTableModel.setupFieldDescriptionIndex();
            this.jTableFieldDescriptions.setRowSelectionInterval(row + 1, row + 1);
            this.refreshTestData();
        }
    }

    private void createNewFieldDescriptions() {
        SQLTable table;
        if (this.database != null && this.database.getDatabaseSession().isConnected() && (table = this.database.getDataModel().getSQLTable(this.jTextFieldTableName.getText().trim())) != null) {
            List<FieldDescription> v = this.database.selectFieldDescriptions(table);
            if (v != null) {
                this.descriptionTableModel.setFieldDescriptions(v);
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("ImportConfiguratorFrame.tablenotexist"), Messages.getString("ImportConfiguratorFrame.loadTableStructure"), 0);
            }
        }
        this.createTestFieldDescriptions();
        this.refreshTestData();
    }

    private boolean existsFile(String fileName) {
        File f = new File(fileName);
        return f.exists();
    }

    private void buttonStart_actionPerformed() {
        String message = this.isDescriptionValid();
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, Messages.getString("ImportConfiguratorFrame.importMessageTitle"), 0);
        } else if (this.database == null || !this.database.isConnected()) {
            JOptionPane.showMessageDialog(this, Messages.getString("ImportConfiguratorFrame.noconnectioncreated"), Messages.getString("ImportConfiguratorFrame.importMessageTitle"), 0);
        } else if (!this.existsFile(this.jTextFieldSourceFileName.getText())) {
            JOptionPane.showMessageDialog(this, Messages.getString("ImportConfiguratorFrame.sourcefilenotexists"), Messages.getString("ImportConfiguratorFrame.importMessageTitle"), 0);
        } else {
            this.importProgressPanel.reset();
            this.importProgressPanel.setImporter(this.importer);
            Thread importThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LongRunningAction lra = new LongRunningAction(){

                        @Override
                        public String getName() {
                            return "Import file";
                        }

                        @Override
                        public void cancel() {
                        }

                        @Override
                        public boolean canBeCanceled() {
                            return false;
                        }
                    };
                    MainFrame.addLongRunningAction(lra);
                    ImportConfiguratorFrame.this.jButtonStartImport.setEnabled(false);
                    ImportConfiguratorFrame.this.jMenuItemFileNew.setEnabled(false);
                    ImportConfiguratorFrame.this.jMenuItemFileOpen.setEnabled(false);
                    ImportConfiguratorFrame.this.jButtonCancelImport.setEnabled(true);
                    try {
                        ImportConfiguratorFrame.this.importer.setupLocalLoggerWithFileAppender(ImportConfiguratorFrame.this.jTextFieldSourceFileName.getText().trim());
                        if (ImportConfiguratorFrame.this.importer.connect(ImportConfiguratorFrame.this.database.getDatabaseSession().getConnectionDescription())) {
                            if (ImportConfiguratorFrame.this.importer.initConfig(ImportConfiguratorFrame.this.buildProperties())) {
                                ImportConfiguratorFrame.this.importer.setTestOnly(ImportConfiguratorFrame.this.jCheckBoxTestOnly.isSelected());
                                ImportConfiguratorFrame.this.importer.importData(new File(ImportConfiguratorFrame.this.jTextFieldSourceFileName.getText().trim()));
                                ImportConfiguratorFrame.this.importer.disconnect();
                            } else {
                                JOptionPane.showMessageDialog(ImportConfiguratorFrame.this.importProgressPanel, ImportConfiguratorFrame.this.importer.getLastErrorMessage(), "config", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(ImportConfiguratorFrame.this.importProgressPanel, ImportConfiguratorFrame.this.importer.getLastErrorMessage(), "connect", 0);
                        }
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(ImportConfiguratorFrame.this.importProgressPanel, "logger cannot be initiated:" + ioe.getMessage(), "init importer", 0);
                    }
                    finally {
                        ImportConfiguratorFrame.this.jButtonStartImport.setEnabled(true);
                        ImportConfiguratorFrame.this.jButtonCancelImport.setEnabled(false);
                        ImportConfiguratorFrame.this.jMenuItemFileNew.setEnabled(true);
                        ImportConfiguratorFrame.this.jMenuItemFileOpen.setEnabled(true);
                        MainFrame.removeLongRunningAction(lra);
                    }
                }
            };
            importThread.start();
            this.importProgressPanel.startMonitoring();
            this.jTabbedPane.setSelectedIndex(this.jTabbedPane.getTabCount() - 1);
        }
    }

    private boolean isChanged() {
        Properties currentConfig = this.buildProperties();
        return !currentConfig.equals(this.lastConfiguration);
    }

    private boolean checkSaveConfig() {
        boolean ok = true;
        if (this.isChanged()) {
            int answer = JOptionPane.showConfirmDialog(this, Messages.getString("ImportConfiguratorFrame.changedMessage"), Messages.getString("ImportConfiguratorFrame.changedTitle"), 1);
            switch (answer) {
                case 0: {
                    ok = this.saveConfigFile(false);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ok = false;
                    break;
                }
                default: {
                    ok = false;
                }
            }
        }
        return ok;
    }

    private void chooseAndOpenConfigfile() {
        File f = this.chooseImportCfgFilename(false);
        if (f != null && this.checkSaveConfig()) {
            this.openConfigFile(f);
        }
    }

    public boolean openConfigFile(File file) {
        return this.openConfigFile(file.getAbsolutePath());
    }

    public boolean openConfigFile(String file) {
        boolean ok = false;
        ok = this.importer.setImportConfig(file);
        this.showImportConfigurationFromImporter();
        this.setConfigFileName(file);
        if (!ok) {
            JOptionPane.showMessageDialog(this, this.importer.getLastErrorMessage(), Messages.getString("ImportConfiguratorFrame.openImportConfiguration"), 0);
        }
        return ok;
    }

    private void showImportConfigurationFromImporter() {
        ImportAttributes attr = this.importer.getImportAttributes();
        this.jTextFieldTableName.setText(attr.getTableName());
        this.jTextFieldSheetName.setText(attr.getSheetName());
        this.delimiterConfigPanel.setDelimiterToken(attr.getDelimiterToken());
        this.delimiterConfigPanel.setEnclosure(attr.getEnclosure());
        this.jCheckBoxInsertEnabled.setSelected(attr.isInsertEnabled());
        if (attr.getBatchSize() > 1) {
            this.jTextFieldBatchSize.setText(String.valueOf(attr.getBatchSize()));
            this.jTextFieldBatchSize.setEditable(true);
        } else {
            this.jTextFieldBatchSize.setText(null);
        }
        this.jCheckBoxUpdateEnabled.setSelected(attr.isUpdateEnabled());
        this.jCheckBoxDeleteAllBefore.setSelected(attr.isDeleteBeforeImport());
        this.jCheckBoxIgnoreFirstLine.setSelected(attr.isSkipFirstRow());
        this.jCheckBoxHandleAlwaysAsCSVFile.setSelected(attr.isHandleFileAlwaysAsCSV());
        NumberFormat nf = NumberFormat.getInstance(new Locale("en_UK"));
        nf.setGroupingUsed(false);
        this.jTextFieldSkipRows.setText(nf.format(attr.getCountSkipRows()));
        this.jComboBoxCharSet.setSelectedItem(attr.getCharsetName());
        this.jTextAreaPreProcessingSQL.setText(attr.getPreProcessSQL());
        this.jCheckBoxEnablePreProcessing.setSelected(attr.isPreProcessEnabled());
        this.jTextAreaPostProcessingSQL.setText(attr.getPostProcessSQL());
        this.jCheckBoxEnablePostProcessing.setSelected(attr.isPostProcessEnabled());
        this.descriptionTableModel.setFieldDescriptions(this.importer.getFieldDescriptions());
        this.filePointers.removeAllElements();
        this.lastConfiguration = this.buildProperties();
        this.showTestData(0);
    }

    private void clearConfiguration() {
        this.jTextFieldTableName.setText(null);
        this.jCheckBoxInsertEnabled.setSelected(true);
        this.jTextFieldBatchSize.setText(null);
        this.jCheckBoxUpdateEnabled.setSelected(false);
        this.jCheckBoxDeleteAllBefore.setSelected(false);
        this.jCheckBoxIgnoreFirstLine.setSelected(false);
        this.jCheckBoxHandleAlwaysAsCSVFile.setSelected(false);
        this.jTextFieldSkipRows.setText("0");
        this.jComboBoxCharSet.setSelectedItem(Main.currentCharSet);
        this.jTextAreaPreProcessingSQL.setText(null);
        this.jCheckBoxEnablePreProcessing.setSelected(false);
        this.jTextAreaPostProcessingSQL.setText(null);
        this.jCheckBoxEnablePostProcessing.setSelected(false);
        this.descriptionTableModel.removeAllFieldDescriptions();
        this.filePointers.removeAllElements();
        this.configFileName = null;
        this.lastConfiguration = this.buildProperties();
        this.setTitle(Messages.getString("ImportConfiguratorFrame.newTitle"));
    }

    private void buttonOpenSourceFile_actionPerformed() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Messages.getString("ImportConfiguratorFrame.chooseSourceFile"));
        chooser.setDialogType(0);
        chooser.addChoosableFileFilter(new ImpDataFileFilter());
        File parentDir = null;
        if (this.configFileName != null) {
            File cfgFile = new File(this.configFileName.trim());
            parentDir = cfgFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else if (this.jTextFieldSourceFileName.getText().trim().length() > 0) {
            File dataFile = new File(this.jTextFieldSourceFileName.getText().trim());
            chooser.setSelectedFile(dataFile);
            parentDir = dataFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else {
            parentDir = new File(Main.getUserProperty("IMPORT_DATAFILE_DIR", System.getProperty("user.home")));
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        }
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            parentDir = f.getParentFile().getAbsoluteFile();
            Main.setUserProperty("IMPORT_DATAFILE_DIR", parentDir.getAbsolutePath());
            this.jTextFieldSourceFileName.setText(f.getAbsolutePath());
            this.jButtonCountLines.setEnabled(true);
            this.openDataFile(new File(this.jTextFieldSourceFileName.getText()));
        }
    }

    private void buttonClear_actionPerformed() {
        this.descriptionTableModel.removeAllFieldDescriptions();
    }

    public void createImportDescriptionForTable(String tablename) {
        this.jTextFieldTableName.setText(tablename);
        this.createNewFieldDescriptions();
    }

    public void takeOverHeaderAsFieldNames() {
        int rowCount = this.descriptionTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String testdata = (String)this.descriptionTableModel.getValueAt(i, 5);
            FieldDescription fd = this.descriptionTableModel.getFieldDescription(i);
            if (!fd.isDummy()) continue;
            fd.setName(testdata);
            fd.setEnabled(true);
            fd.setIndex(i);
        }
        this.descriptionTableModel.fireTableRowsUpdated(0, rowCount - 1);
    }

    private JPanel createJPanelPostProcessSQL() {
        JPanel jPanelPostProcessSQL = new JPanel();
        jPanelPostProcessSQL.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelPostProcessSQL.add((Component)this.getJCheckBoxEnablePostProcessing(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelPostProcessSQL.add((Component)this.getJComboBoxAddPostSQLParameter(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelPostProcessSQL.add((Component)this.createJScrollPanePostProcessingSQL(), gbc);
        return jPanelPostProcessSQL;
    }

    private JComboBox getJComboBoxAddPostSQLParameter() {
        if (this.jComboBoxAddPostSQLParameter == null) {
            this.jComboBoxAddPostSQLParameter = new JComboBox();
            this.setupAddParameterComboBox(this.jComboBoxAddPostSQLParameter);
            this.jComboBoxAddPostSQLParameter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object selection;
                    if (e.getStateChange() == 1 && (selection = e.getItem()) instanceof ParameterPlaceHolder) {
                        ParameterPlaceHolder ph = (ParameterPlaceHolder)selection;
                        ImportConfiguratorFrame.this.jTextAreaPostProcessingSQL.insert(ph.getCode(), ImportConfiguratorFrame.this.jTextAreaPostProcessingSQL.getCaretPosition());
                    }
                }
            });
        }
        return this.jComboBoxAddPostSQLParameter;
    }

    private void setupAddParameterComboBoxes() {
        this.setupAddParameterComboBox(this.getJComboBoxAddPreSQLParameter());
        this.setupAddParameterComboBox(this.getJComboBoxAddPostSQLParameter());
    }

    private void setupAddParameterComboBox(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.addItem(Messages.getString("ImportConfiguratorFrame.addparameter"));
        ArrayList<FieldDescription> list = this.descriptionTableModel.getDescriptions();
        for (FieldDescription fieldDescription : list) {
            if (fieldDescription.isDummy()) continue;
            ParameterPlaceHolder ph = new ParameterPlaceHolder();
            ph.setName("default value of Field " + fieldDescription.getName());
            if (fieldDescription.getBasicTypeId() == BasicDataType.CHARACTER.getId() || fieldDescription.getBasicTypeId() == BasicDataType.CLOB.getId()) {
                ph.setCode("'{field." + fieldDescription.getName() + ".defaultValue}'");
            } else {
                ph.setCode("{field." + fieldDescription.getName() + ".defaultValue}");
            }
            jComboBox.addItem(ph);
            jComboBox.setSelectedIndex(0);
        }
    }

    private JPanel createJPanelPreProcessSQL() {
        JPanel jPanelPreProcessSQL = new JPanel();
        jPanelPreProcessSQL.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelPreProcessSQL.add((Component)this.getJCheckBoxEnablePreProcessing(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelPreProcessSQL.add((Component)this.getJComboBoxAddPreSQLParameter(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 1;
        jPanelPreProcessSQL.add((Component)this.createJScrollPanePreProcessingSQL(), gbc);
        return jPanelPreProcessSQL;
    }

    private JComboBox getJComboBoxAddPreSQLParameter() {
        if (this.jComboBoxAddPreSQLParameter == null) {
            this.jComboBoxAddPreSQLParameter = new JComboBox();
            this.setupAddParameterComboBox(this.jComboBoxAddPreSQLParameter);
            this.jComboBoxAddPreSQLParameter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object selection;
                    if (e.getStateChange() == 1 && (selection = e.getItem()) instanceof ParameterPlaceHolder) {
                        ParameterPlaceHolder ph = (ParameterPlaceHolder)selection;
                        ImportConfiguratorFrame.this.jTextAreaPreProcessingSQL.insert(ph.getCode(), ImportConfiguratorFrame.this.jTextAreaPreProcessingSQL.getCaretPosition());
                    }
                }
            });
        }
        return this.jComboBoxAddPreSQLParameter;
    }

    private JTextField getJTextFieldSourceFileName() {
        if (this.jTextFieldSourceFileName == null) {
            this.jTextFieldSourceFileName = new JTextField();
            this.jTextFieldSourceFileName.setEditable(false);
        }
        return this.jTextFieldSourceFileName;
    }

    private JTextField getJTextFieldSheetName() {
        if (this.jTextFieldSheetName == null) {
            this.jTextFieldSheetName = new JTextField();
            this.jTextFieldSheetName.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        ImportConfiguratorFrame.this.setupTestDatasetProvider();
                        ImportConfiguratorFrame.this.showTestDataAtRow(0L);
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        return this.jTextFieldSheetName;
    }

    private JButton getJButtonChooseSourceFile() {
        if (this.jButtonChooseSourceFile == null) {
            this.jButtonChooseSourceFile = new JButton();
            this.jButtonChooseSourceFile.setText(Messages.getString("ImportConfiguratorFrame.choosesourcefile"));
            this.jButtonChooseSourceFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonOpenSourceFile_actionPerformed();
                }
            });
        }
        return this.jButtonChooseSourceFile;
    }

    private JCheckBox getJCheckBoxIgnoreFirstLine() {
        if (this.jCheckBoxIgnoreFirstLine == null) {
            this.jCheckBoxIgnoreFirstLine = new JCheckBox();
            this.jCheckBoxIgnoreFirstLine.setText(Messages.getString("ImportConfiguratorFrame.ignorefirstline"));
            this.jCheckBoxIgnoreFirstLine.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.refreshTestData();
                }
            });
        }
        return this.jCheckBoxIgnoreFirstLine;
    }

    private JTextField getJTextFieldSkipRows() {
        if (this.jTextFieldSkipRows == null) {
            this.jTextFieldSkipRows = new JTextField();
            this.jTextFieldSkipRows.setText("0");
            this.jTextFieldSkipRows.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        ImportConfiguratorFrame.this.refreshTestData();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        return this.jTextFieldSkipRows;
    }

    private JComboBox getJComboBoxCharSet() {
        if (this.jComboBoxCharSet == null) {
            this.jComboBoxCharSet = new JComboBox();
            this.jComboBoxCharSet.setEditable(true);
            String charSets = Main.getDefaultProperty("CHAR_SETS", "ISO-8859-1|ISO-8859-15|UTF-8|UTF-16|Cp1252|MacRoman");
            String currentCharSet = Main.getUserProperty("CURR_CHAR_SET");
            String systemCharSet = System.getProperty("file.encoding");
            StringTokenizer st = new StringTokenizer(charSets, "|");
            String charSet = null;
            while (st.hasMoreTokens()) {
                charSet = st.nextToken();
                this.jComboBoxCharSet.addItem(charSet);
                if (currentCharSet != null) {
                    if (!charSet.equals(currentCharSet)) continue;
                    this.jComboBoxCharSet.setSelectedItem(charSet);
                    continue;
                }
                if (systemCharSet == null || !charSet.equals(systemCharSet)) continue;
                this.jComboBoxCharSet.setSelectedItem(charSet);
            }
            this.jComboBoxCharSet.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ImportConfiguratorFrame.this.setupTestDatasetProvider();
                        ImportConfiguratorFrame.this.showTestDataAtRow(0L);
                    }
                }
            });
        }
        return this.jComboBoxCharSet;
    }

    public void handleFile(File file) {
        if (file != null) {
            if (file.getName().toLowerCase().endsWith(IMPORT_CONFIG_EXTENSION)) {
                if (this.checkSaveConfig()) {
                    this.openConfigFile(file);
                }
            } else if (this.importer.isDataFile(file)) {
                this.jTextFieldSourceFileName.setText(file.getAbsolutePath());
                this.openDataFile(file);
            }
        }
    }

    public void handleFile(String filePath) {
        if (filePath != null) {
            this.handleFile(new File(filePath));
        }
    }

    public void handleConfigProperties(String propertiesAsString) {
        if (this.checkSaveConfig()) {
            boolean ok = false;
            ok = this.importer.initConfig(propertiesAsString);
            this.showImportConfigurationFromImporter();
            this.setConfigFileName(null);
            if (!ok) {
                JOptionPane.showMessageDialog(this, this.importer.getLastErrorMessage(), Messages.getString("ImportConfiguratorFrame.openImportConfiguration"), 0);
            }
        }
    }

    public void openDataFile(File file) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("openDataFile(file=" + file + ")"));
        }
        this.currentDataFile = file;
        this.intitializeTestdataView();
    }

    private void intitializeTestdataView() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    }
                });
                try {
                    if (ImportConfiguratorFrame.this.setupTestDatasetProvider()) {
                        ImportConfiguratorFrame.this.setupTestFieldTokenizer();
                        ImportConfiguratorFrame.this.showTestDataAtRow(0L);
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }.start();
    }

    private JButton getJButtonCountLines() {
        if (this.jButtonCountLines == null) {
            this.jButtonCountLines = new JButton();
            this.jButtonCountLines.setEnabled(false);
            this.jButtonCountLines.setText(Messages.getString("ImportConfiguratorFrame.countlines"));
            this.jButtonCountLines.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.countLines();
                }
            });
        }
        return this.jButtonCountLines;
    }

    private void countLines() {
        if (this.jTextFieldSourceFileName.getText() != null) {
            this.counterThread = new Thread(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                            ImportConfiguratorFrame.this.jButtonCountLines.setEnabled(false);
                        }
                    });
                    long count = 0L;
                    try {
                        count = ImportConfiguratorFrame.this.importer.retrieveDatasetCount(new File(ImportConfiguratorFrame.this.jTextFieldSourceFileName.getText().trim()), ImportConfiguratorFrame.this.buildImportAttributes());
                    }
                    catch (Exception ex) {
                        logger.error((Object)("countLines failed: " + ex.getMessage()), (Throwable)ex);
                        JOptionPane.showMessageDialog(ImportConfiguratorFrame.this.jTextFieldSourceFileName, ex.getMessage(), "retrieve line count failed", 0);
                    }
                    final long fcount = count;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ImportConfiguratorFrame.this.jTextFieldCountLines.setText(String.valueOf(fcount));
                            ImportConfiguratorFrame.this.setCursor(Cursor.getDefaultCursor());
                            ImportConfiguratorFrame.this.jButtonCountLines.setEnabled(true);
                        }
                    });
                }
            };
            this.counterThread.start();
        }
    }

    private JCheckBox getJCheckBoxEnablePostProcessing() {
        if (this.jCheckBoxEnablePostProcessing == null) {
            this.jCheckBoxEnablePostProcessing = new JCheckBox();
            this.jCheckBoxEnablePostProcessing.setText(Messages.getString("ImportConfiguratorFrame.enablepostprocessing"));
        }
        return this.jCheckBoxEnablePostProcessing;
    }

    private JScrollPane createJScrollPanePostProcessingSQL() {
        JScrollPane jScrollPanePostProcessingSQL = new JScrollPane();
        jScrollPanePostProcessingSQL.setViewportView(this.getJTextAreaPostProcessingSQL());
        return jScrollPanePostProcessingSQL;
    }

    private JCheckBox getJCheckBoxEnablePreProcessing() {
        if (this.jCheckBoxEnablePreProcessing == null) {
            this.jCheckBoxEnablePreProcessing = new JCheckBox();
            this.jCheckBoxEnablePreProcessing.setText(Messages.getString("ImportConfiguratorFrame.enablepreprocessing"));
        }
        return this.jCheckBoxEnablePreProcessing;
    }

    private JScrollPane createJScrollPanePreProcessingSQL() {
        JScrollPane jScrollPanePreProcessingSQL = new JScrollPane();
        jScrollPanePreProcessingSQL.setViewportView(this.getJTextAreaPreProcessingSQL());
        return jScrollPanePreProcessingSQL;
    }

    private JTextArea getJTextAreaPostProcessingSQL() {
        if (this.jTextAreaPostProcessingSQL == null) {
            this.jTextAreaPostProcessingSQL = new JTextArea();
        }
        return this.jTextAreaPostProcessingSQL;
    }

    private JTextArea getJTextAreaPreProcessingSQL() {
        if (this.jTextAreaPreProcessingSQL == null) {
            this.jTextAreaPreProcessingSQL = new JTextArea();
        }
        return this.jTextAreaPreProcessingSQL;
    }

    private DelimiterConfigPanel getDelimiterConfigPanel() {
        if (this.delimiterConfigPanel == null) {
            this.delimiterConfigPanel = new DelimiterConfigPanel();
            this.delimiterConfigPanel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ImportConfiguratorFrame.this.createTestFieldDescriptions();
                    ImportConfiguratorFrame.this.refreshTestData();
                }
            });
        }
        return this.delimiterConfigPanel;
    }

    private JTextField getJTextFieldTableName() {
        if (this.jTextFieldTableName == null) {
            this.jTextFieldTableName = new JTextField();
        }
        return this.jTextFieldTableName;
    }

    private JTextField getJTextFieldBatchSize() {
        if (this.jTextFieldBatchSize == null) {
            this.jTextFieldBatchSize = new JTextField();
            this.jTextFieldBatchSize.setEditable(false);
            this.jTextFieldBatchSize.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ImportConfiguratorFrame.this.checkBatchSizeInput();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ImportConfiguratorFrame.this.checkBatchSizeInput();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ImportConfiguratorFrame.this.checkBatchSizeInput();
                }
            });
        }
        return this.jTextFieldBatchSize;
    }

    private void checkBatchSizeInput() {
        String s = this.jTextFieldBatchSize.getText();
        if (s != null && !(s = s.trim()).isEmpty()) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, "Invalid value for batch size: it must be an integer!");
                this.jTextFieldBatchSize.requestFocusInWindow();
            }
        }
    }

    private JPanel createJPanelFieldConfigButtons() {
        JPanel jPanelFieldConfigButtons = new JPanel();
        jPanelFieldConfigButtons.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonCreateNewFieldDescriptions(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonAddFieldDescription(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonEditFieldDescription(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonDeleteFieldDescription(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonDeleteAllFieldDescriptions(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)new JLabel(Messages.getString("ImportConfiguratorFrame.sortFdByLabel")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJComboBoxSortFieldDescriptions(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        jPanelFieldConfigButtons.add((Component)this.getJButtonTakeOverHeaderAsFieldName(), gbc);
        return jPanelFieldConfigButtons;
    }

    private JButton getJButtonCreateNewFieldDescriptions() {
        if (this.jButtonCreateNewFieldDescriptions == null) {
            this.jButtonCreateNewFieldDescriptions = new JButton();
            this.jButtonCreateNewFieldDescriptions.setText(Messages.getString("ImportConfiguratorFrame.createnewdesc"));
            this.jButtonCreateNewFieldDescriptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.createNewFieldDescriptions();
                }
            });
        }
        return this.jButtonCreateNewFieldDescriptions;
    }

    private JButton getJButtonEditFieldDescription() {
        if (this.jButtonEditFieldDescription == null) {
            this.jButtonEditFieldDescription = new JButton();
            this.jButtonEditFieldDescription.setText(Messages.getString("ImportConfiguratorFrame.editdesc"));
            this.jButtonEditFieldDescription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonEdit_actionPerformed();
                }
            });
        }
        return this.jButtonEditFieldDescription;
    }

    private JButton getJButtonAddFieldDescription() {
        if (this.jButtonAddFieldDescription == null) {
            this.jButtonAddFieldDescription = new JButton();
            this.jButtonAddFieldDescription.setText(Messages.getString("ImportConfiguratorFrame.adddesc"));
            this.jButtonAddFieldDescription.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonAdd_actionPerformed();
                }
            });
        }
        return this.jButtonAddFieldDescription;
    }

    private JButton getJButtonDeleteFieldDescription() {
        if (this.jButtonDeleteFieldDescription == null) {
            this.jButtonDeleteFieldDescription = new JButton();
            this.jButtonDeleteFieldDescription.setText(Messages.getString("ImportConfiguratorFrame.deletedesc"));
            this.jButtonDeleteFieldDescription.addActionListener(this.deleteAction);
        }
        return this.jButtonDeleteFieldDescription;
    }

    private JButton getJButtonDeleteAllFieldDescriptions() {
        if (this.jButtonDeleteAllFieldDescriptions == null) {
            this.jButtonDeleteAllFieldDescriptions = new JButton();
            this.jButtonDeleteAllFieldDescriptions.setText(Messages.getString("ImportConfiguratorFrame.deletealldesc"));
            this.jButtonDeleteAllFieldDescriptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonClear_actionPerformed();
                }
            });
        }
        return this.jButtonDeleteAllFieldDescriptions;
    }

    private JButton getJButtonTakeOverHeaderAsFieldName() {
        if (this.jButtonTakeOverHeaderAsFieldName == null) {
            this.jButtonTakeOverHeaderAsFieldName = new JButton();
            this.jButtonTakeOverHeaderAsFieldName.setText(Messages.getString("ImportConfiguratorFrame.takeOverFieldNames"));
            this.jButtonTakeOverHeaderAsFieldName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.takeOverHeaderAsFieldNames();
                }
            });
        }
        return this.jButtonTakeOverHeaderAsFieldName;
    }

    private JPanel createJPanelTableConfig() {
        JPanel jPanelTableConfig = new JPanel();
        jPanelTableConfig.setLayout(new GridBagLayout());
        jPanelTableConfig.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Messages.getString("ImportConfiguratorFrame.targetdatabasetable"), 0, 0, null, null));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        jPanelTableConfig.add((Component)this.getJTextFieldTableName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        jPanelTableConfig.add((Component)this.getJCheckBoxDeleteAllBefore(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        jPanelTableConfig.add((Component)this.getJCheckBoxInsertEnabled(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 13;
        JLabel label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.batchSize"));
        jPanelTableConfig.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        jPanelTableConfig.add((Component)this.getJTextFieldBatchSize(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        jPanelTableConfig.add((Component)this.getJCheckBoxUpdateEnabled(), gbc);
        return jPanelTableConfig;
    }

    private JPanel createJPanelFieldDescriptions() {
        JPanel jPanelFieldDescriptions = new JPanel();
        jPanelFieldDescriptions.setLayout(new GridBagLayout());
        jPanelFieldDescriptions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Messages.getString("ImportConfiguratorFrame.fielddescriptions"), 0, 0, new Font("Lucida Grande", 0, 13), Color.black));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jPanelFieldDescriptions.add((Component)this.createJPanelFieldConfigButtons(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jPanelFieldDescriptions.add((Component)this.createJPanelFieldDetails(), gbc);
        return jPanelFieldDescriptions;
    }

    private JCheckBox getJCheckBoxDeleteAllBefore() {
        if (this.jCheckBoxDeleteAllBefore == null) {
            this.jCheckBoxDeleteAllBefore = new JCheckBox();
            this.jCheckBoxDeleteAllBefore.setText(Messages.getString("ImportConfiguratorFrame.deleteallpreviousdatasets"));
        }
        return this.jCheckBoxDeleteAllBefore;
    }

    private JCheckBox getJCheckBoxInsertEnabled() {
        if (this.jCheckBoxInsertEnabled == null) {
            this.jCheckBoxInsertEnabled = new JCheckBox();
            this.jCheckBoxInsertEnabled.setText(Messages.getString("ImportConfiguratorFrame.insertenabled"));
            this.jCheckBoxInsertEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.getJTextFieldBatchSize().setEditable(ImportConfiguratorFrame.this.jCheckBoxInsertEnabled.isSelected() && !ImportConfiguratorFrame.this.jCheckBoxUpdateEnabled.isSelected());
                }
            });
        }
        return this.jCheckBoxInsertEnabled;
    }

    private JCheckBox getJCheckBoxUpdateEnabled() {
        if (this.jCheckBoxUpdateEnabled == null) {
            this.jCheckBoxUpdateEnabled = new JCheckBox();
            this.jCheckBoxUpdateEnabled.setText(Messages.getString("ImportConfiguratorFrame.updateenabled"));
            this.jCheckBoxUpdateEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.getJTextFieldBatchSize().setEditable(ImportConfiguratorFrame.this.jCheckBoxInsertEnabled.isSelected() && !ImportConfiguratorFrame.this.jCheckBoxUpdateEnabled.isSelected());
                }
            });
        }
        return this.jCheckBoxUpdateEnabled;
    }

    private JPanel createJPanelFieldDetails() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        JTextField field = new JTextField();
        field.setEditable(true);
        field.setText(Messages.getString("ImportConfiguratorFrame.dropConfigPropertiesHere"));
        field.setBorder(new LineBorder(Color.BLACK, 1, true));
        field.setTransferHandler(new ImportConfiguratorTransferHandler(this));
        panel.add((Component)field, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.createTestDataPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.createJScrollPaneFieldDescriptions(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getJButtonMoveFieldDescUp(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getJButtonMoveFieldDescDown(), gbc);
        return panel;
    }

    private JPanel createTestDataPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.weightx = 2.0;
        gbc.fill = 2;
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("ImportConfiguratorFrame.playtest"));
        jLabel.setHorizontalAlignment(4);
        panel.add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getJButtonTestBackwards(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        panel.add((Component)this.getJTextFieldCurrentRowNum(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 2, 2, 2);
        panel.add((Component)this.getJButtonTestForwards(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(2, 10, 2, 5);
        JLabel label = new JLabel();
        label.setText(Messages.getString("ImportConfiguratorFrame.countColumns"));
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 5, 2, 5);
        this.jLabelCurrentCountColumns = new JLabel();
        this.jLabelCurrentCountColumns.setText("0");
        this.jLabelCurrentCountColumns.setBorder(new LineBorder(Color.BLACK, 1, true));
        this.jLabelCurrentCountColumns.setHorizontalAlignment(0);
        this.jLabelCurrentCountColumns.setPreferredSize(new Dimension(100, 25));
        panel.add((Component)this.jLabelCurrentCountColumns, gbc);
        return panel;
    }

    private JTextField getJTextFieldCurrentRowNum() {
        if (this.jTextFieldCurrentRowNum == null) {
            this.jTextFieldCurrentRowNum = new JTextField();
            this.jTextFieldCurrentRowNum.setText("1");
            this.jTextFieldCurrentRowNum.setHorizontalAlignment(0);
            this.jTextFieldCurrentRowNum.setPreferredSize(new Dimension(100, 25));
            this.jTextFieldCurrentRowNum.setMinimumSize(this.jTextFieldCurrentRowNum.getPreferredSize());
            String actionKey = "readRowAt";
            this.jTextFieldCurrentRowNum.getActionMap().put("readRowAt", this.readDatasetAtRowAction);
            this.jTextFieldCurrentRowNum.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "readRowAt");
        }
        return this.jTextFieldCurrentRowNum;
    }

    private JButton getJButtonTestForwards() {
        if (this.jButtonTestForwards == null) {
            this.jButtonTestForwards = new JButton();
            this.jButtonTestForwards.setIcon(ApplicationIcons.NEXT_GIF);
            this.jButtonTestForwards.addActionListener(this.moveForwardAction);
        }
        return this.jButtonTestForwards;
    }

    private JButton getJButtonTestBackwards() {
        if (this.jButtonTestBackwards == null) {
            this.jButtonTestBackwards = new JButton();
            this.jButtonTestBackwards.setIcon(ApplicationIcons.PREV_GIF);
            this.jButtonTestBackwards.addActionListener(this.moveBackwardAction);
        }
        return this.jButtonTestBackwards;
    }

    private JButton getJButtonMoveFieldDescUp() {
        if (this.jButtonMoveFieldDescUp == null) {
            this.jButtonMoveFieldDescUp = new JButton();
            this.jButtonMoveFieldDescUp.setIcon(ApplicationIcons.UP_GIF);
            this.jButtonMoveFieldDescUp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonUp_actionPerformed();
                }
            });
        }
        return this.jButtonMoveFieldDescUp;
    }

    private JButton getJButtonMoveFieldDescDown() {
        if (this.jButtonMoveFieldDescDown == null) {
            this.jButtonMoveFieldDescDown = new JButton();
            this.jButtonMoveFieldDescDown.setIcon(ApplicationIcons.DOWN_GIF);
            this.jButtonMoveFieldDescDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.buttonDown_actionPerformed();
                }
            });
        }
        return this.jButtonMoveFieldDescDown;
    }

    private JScrollPane createJScrollPaneFieldDescriptions() {
        JScrollPane jScrollPaneFieldDescriptions = new JScrollPane();
        jScrollPaneFieldDescriptions.setViewportView(this.getJTableFieldDescriptions());
        jScrollPaneFieldDescriptions.setPreferredSize(new Dimension(400, 300));
        return jScrollPaneFieldDescriptions;
    }

    private JTable getJTableFieldDescriptions() {
        if (this.jTableFieldDescriptions == null) {
            this.jTableFieldDescriptions = new JTable();
            this.jTableFieldDescriptions.setBackground(Main.info);
            this.jTableFieldDescriptions.setModel(this.getDescriptionTableModel());
            this.jTableFieldDescriptions.setSelectionMode(0);
            this.jTableFieldDescriptions.setToolTipText(null);
            this.jTableFieldDescriptions.setAutoResizeMode(2);
            this.jTableFieldDescriptions.getTableHeader().setReorderingAllowed(false);
            TableInputListener til = new TableInputListener();
            this.jTableFieldDescriptions.addMouseListener(til);
            this.jTableFieldDescriptions.setDefaultRenderer(Object.class, new DescriptionRenderer());
            this.jTableFieldDescriptions.registerKeyboardAction(til, "open", KeyStroke.getKeyStroke(10, 0), 0);
            this.jTableFieldDescriptions.registerKeyboardAction(this.moveBackwardAction, "prev", KeyStroke.getKeyStroke(37, 0), 0);
            this.jTableFieldDescriptions.registerKeyboardAction(this.moveForwardAction, "next", KeyStroke.getKeyStroke(39, 0), 0);
            this.jTableFieldDescriptions.getTableHeader().setDefaultRenderer(new TitleRenderer());
            this.jTableFieldDescriptions.getColumnModel().getColumn(0).setPreferredWidth(8);
            this.jTableFieldDescriptions.getColumnModel().getColumn(1).setPreferredWidth(8);
            this.jTableFieldDescriptions.getColumnModel().getColumn(2).setPreferredWidth(8);
            this.jTableFieldDescriptions.getColumnModel().getColumn(3).setPreferredWidth(100);
            this.jTableFieldDescriptions.getColumnModel().getColumn(4).setPreferredWidth(200);
            this.jTableFieldDescriptions.getColumnModel().getColumn(5).setPreferredWidth(100);
            this.jTableFieldDescriptions.setDragEnabled(true);
            this.jTableFieldDescriptions.setTransferHandler(new ImportConfiguratorTransferHandler(this));
        }
        return this.jTableFieldDescriptions;
    }

    public String getConfigurationPropertiesAsString() throws UnsupportedEncodingException {
        Properties p = this.buildProperties();
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(p);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue() != null ? entry.getValue() : "");
            sb.append("\n");
        }
        return sb.toString();
    }

    private long getCountRowsToSkip() throws NumberFormatException {
        if (this.jTextFieldSkipRows.getText() != null && this.jTextFieldSkipRows.getText().length() > 0) {
            return Long.parseLong(this.jTextFieldSkipRows.getText().trim());
        }
        return 0L;
    }

    private Properties buildProperties() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"buildProperties");
        }
        Properties props = new Properties();
        ImportAttributes opts = this.buildImportAttributes();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"buildProperties: store attributes");
        }
        opts.storeInto(props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"buildProperties: store field descriptions");
        }
        for (int i = 0; i < this.descriptionTableModel.getRowCount(); ++i) {
            FieldDescription fd = this.descriptionTableModel.getFieldDescription(i);
            if (fd.isDummy()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("put into properties: field description " + fd + " with index=" + fd.getIndex()));
            }
            fd.completeProperties(props);
        }
        return props;
    }

    private ImportAttributes buildImportAttributes() {
        ImportAttributes opts = new ImportAttributes();
        opts.setTableName(this.jTextFieldTableName.getText());
        opts.setSheetName(this.jTextFieldSheetName.getText());
        opts.setInsertEnabled(this.jCheckBoxInsertEnabled.isSelected());
        opts.setUpdateEnabled(this.jCheckBoxUpdateEnabled.isSelected());
        if (this.jTextFieldBatchSize.isEditable() && !this.jTextFieldBatchSize.getText().trim().isEmpty()) {
            opts.setBatchSize(Integer.parseInt(this.jTextFieldBatchSize.getText()));
        }
        opts.setDeleteBeforeImport(this.jCheckBoxDeleteAllBefore.isSelected());
        opts.setSkipFirstRow(this.jCheckBoxIgnoreFirstLine.isSelected());
        opts.setHandleFileAlwaysAsCSV(this.jCheckBoxHandleAlwaysAsCSVFile.isSelected());
        opts.setCountSkipRows(this.getCountRowsToSkip());
        opts.setDelimiter(this.delimiterConfigPanel.getDelimiter());
        opts.setEnclosure(this.delimiterConfigPanel.getEnclosure());
        opts.setColumnCount(this.descriptionTableModel.getRowCount());
        opts.setPreProcessSQL(this.jTextAreaPreProcessingSQL.getText());
        opts.setPreProcessEnabled(this.jCheckBoxEnablePreProcessing.isSelected());
        opts.setPostProcessSQL(this.jTextAreaPostProcessingSQL.getText());
        opts.setPostProcessEnabled(this.jCheckBoxEnablePostProcessing.isSelected());
        opts.setCharsetName((String)this.jComboBoxCharSet.getSelectedItem());
        return opts;
    }

    private DescriptionTableModel getDescriptionTableModel() {
        if (this.descriptionTableModel == null) {
            this.descriptionTableModel = new DescriptionTableModel();
            this.descriptionTableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    ImportConfiguratorFrame.this.setupAddParameterComboBoxes();
                }
            });
        }
        return this.descriptionTableModel;
    }

    ArrayList<FieldDescription> getAllFieldDescriptions() {
        return this.descriptionTableModel.getDescriptions();
    }

    private ImportProgressPanel getImportProgressPanel() {
        if (this.importProgressPanel == null) {
            this.importProgressPanel = new ImportProgressPanel();
        }
        return this.importProgressPanel;
    }

    private boolean setupTestDatasetProvider() {
        if (this.currentDataFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setupTestDatasetProvider");
            }
            if (this.testDatasetProvider != null) {
                this.testDatasetProvider.closeDatasetProvider();
            }
            ImportAttributes attr = this.buildImportAttributes();
            try {
                this.testDatasetProvider = this.importer.createDatasetProvider(this.currentDataFile, true, "csv", attr);
                return true;
            }
            catch (Throwable e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), "Open data file", 0);
                return false;
            }
        }
        return true;
    }

    private void setupTestFieldTokenizer() {
        if (this.currentDataFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"setupTestFieldTokenizer");
            }
            this.testFieldParser = this.importer.createFieldTokenizer(this.currentDataFile.getName());
            if (this.testFieldParser instanceof CSVFieldTokenizer) {
                ((CSVFieldTokenizer)this.testFieldParser).setDelimiter(this.delimiterConfigPanel.getDelimiter());
                ((CSVFieldTokenizer)this.testFieldParser).setEnclosure(this.delimiterConfigPanel.getEnclosure());
            }
            this.testFieldParser.setTestMode(true);
            this.descriptionTableModel.setTokenizer(this.testFieldParser);
        }
    }

    private boolean checkParser() {
        if (this.testDatasetProvider == null && this.currentDataFile != null) {
            this.setupTestDatasetProvider();
        }
        if (this.testFieldParser == null) {
            this.setupTestFieldTokenizer();
        }
        if (this.testFieldParser != null && this.testFieldParser instanceof CSVFieldTokenizer) {
            ((CSVFieldTokenizer)this.testFieldParser).setDelimiter(this.delimiterConfigPanel.getDelimiter());
            ((CSVFieldTokenizer)this.testFieldParser).setEnclosure(this.delimiterConfigPanel.getEnclosure());
        }
        return this.testFieldParser != null && this.testDatasetProvider != null;
    }

    private void showTestData(int direction) {
        if (this.checkParser()) {
            Object dataset = this.readDataset(direction);
            this.testFieldParser.setRowData(dataset);
            this.createTestFieldDescriptions();
            this.refreshTestData();
        }
        this.validate();
    }

    private void showTestDataAtRow(final long rowNumber) {
        if (this.checkParser()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("showTestDataAtRow rowNumber=" + rowNumber));
            }
            if (SwingUtilities.isEventDispatchThread()) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                ImportConfiguratorFrame.this.jTextFieldCurrentRowNum.setEnabled(false);
                            }
                        });
                        final Object dataset = ImportConfiguratorFrame.this.readDatasetAtRowNumber(rowNumber);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImportConfiguratorFrame.this.testFieldParser.setRowData(dataset);
                                ImportConfiguratorFrame.this.createTestFieldDescriptions();
                                ImportConfiguratorFrame.this.refreshTestData();
                                ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                ImportConfiguratorFrame.this.jTextFieldCurrentRowNum.setEnabled(true);
                            }
                        });
                    }
                };
                Thread t = new Thread(runnable);
                t.start();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                        ImportConfiguratorFrame.this.jTextFieldCurrentRowNum.setEnabled(false);
                    }
                });
                final Object dataset = this.readDatasetAtRowNumber(rowNumber);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImportConfiguratorFrame.this.testFieldParser.setRowData(dataset);
                        ImportConfiguratorFrame.this.createTestFieldDescriptions();
                        ImportConfiguratorFrame.this.refreshTestData();
                        ImportConfiguratorFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                        ImportConfiguratorFrame.this.jTextFieldCurrentRowNum.setEnabled(true);
                    }
                });
            }
        }
    }

    private void createTestFieldDescriptions() {
        if (this.checkParser()) {
            try {
                int countColumns = this.testFieldParser.countDelimitedFields();
                int countExistingFDs = this.getDescriptionTableModel().getRowCount();
                if (countColumns != countExistingFDs) {
                    this.deleteDummyFieldDescriptions();
                    this.getDescriptionTableModel().createTestFieldDescriptions(countColumns);
                }
            }
            catch (ParserException e) {
                logger.error((Object)("createTestFieldDescriptions failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void deleteDummyFieldDescriptions() {
        this.getDescriptionTableModel().removeTestFieldDescriptions();
    }

    private Object readDataset(int direction) {
        Object dataset = null;
        if (this.testDatasetProvider != null) {
            try {
                long rowNumber = this.testDatasetProvider.getCurrentRowNum();
                if (direction > 0) {
                    ++rowNumber;
                } else if (direction < 0 && rowNumber > 0L) {
                    --rowNumber;
                }
                dataset = this.testDatasetProvider.getDatasetAtRowInTestMode(rowNumber);
                this.jTextFieldCurrentRowNum.setText(String.valueOf(this.testDatasetProvider.getCurrentRowNum() + 1L));
            }
            catch (Exception ioe) {
                logger.error((Object)("ImportKonfigurator.readDataset: " + ioe.toString()), (Throwable)ioe);
            }
        }
        return dataset;
    }

    private Object readDatasetAtRowNumber(long rowNumber) {
        Object dataset = null;
        if (this.testDatasetProvider != null) {
            try {
                dataset = this.testDatasetProvider.getDatasetAtRowInTestMode(rowNumber);
                this.jTextFieldCurrentRowNum.setText(String.valueOf(this.testDatasetProvider.getCurrentRowNum() + 1L));
            }
            catch (Exception ioe) {
                logger.error((Object)("ImportKonfigurator.readDatasetAtRowNumber: " + ioe.toString()), (Throwable)ioe);
            }
        }
        return dataset;
    }

    private void refreshTestData() {
        if (this.testFieldParser != null && this.testDatasetProvider != null) {
            this.checkParser();
            try {
                long rowsBeforeDataLine = this.getCountRowsToSkip();
                if (this.jCheckBoxIgnoreFirstLine.isSelected()) {
                    ++rowsBeforeDataLine;
                }
                boolean skipConverting = this.testDatasetProvider.getCurrentRowNum() < rowsBeforeDataLine;
                this.testFieldParser.parseRawData(this.descriptionTableModel.getDescriptions(), skipConverting);
                this.jLabelCurrentCountColumns.setText(String.valueOf(this.testFieldParser.countDelimitedFields()));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
            this.descriptionTableModel.fireTableRowsUpdated(0, this.descriptionTableModel.getRowCount() - 1);
            this.validate();
        }
    }

    private void buttonAdd_actionPerformed() {
        FieldDescription fd = new FieldDescription();
        fd.setIndex(this.descriptionTableModel.getRowCount());
        if (this.editFieldDescription(fd)) {
            this.descriptionTableModel.addFieldDescription(fd);
        }
    }

    private void buttonEdit_actionPerformed() {
        int row = this.jTableFieldDescriptions.getSelectedRow();
        int col = this.jTableFieldDescriptions.getSelectedColumn();
        if (row >= 0) {
            FieldDescription fd = this.descriptionTableModel.getFieldDescription(row);
            if (col < 5) {
                if (this.editFieldDescription(fd)) {
                    this.refreshTestData();
                }
            } else {
                new TextViewer(this, fd.getName(), this.descriptionTableModel.getValueAt(row, col).toString());
            }
        }
    }

    private boolean editFieldDescription(FieldDescription fd) {
        if (fd == null) {
            throw new IllegalArgumentException("fd cannot be null");
        }
        DescriptionEditor descriptionEditor = this.createDescriptionEditor(fd);
        descriptionEditor.setVisible(true);
        if (descriptionEditor.isOkPerformed()) {
            this.descriptionTableModel.fireTableRowsUpdated(this.jTableFieldDescriptions.getSelectedRow(), this.jTableFieldDescriptions.getSelectedRow());
            return true;
        }
        return false;
    }

    private DescriptionEditor createDescriptionEditor(FieldDescription fd) {
        DescriptionEditor descriptionEditor = new DescriptionEditor(this, fd);
        WindowHelper.locateWindowAtMiddle(this, descriptionEditor);
        return descriptionEditor;
    }

    private void reorgFieldDescriptionIndex() {
        for (int i = 0; i < this.descriptionTableModel.getRowCount(); ++i) {
            FieldDescription fd = this.descriptionTableModel.getFieldDescription(i);
            fd.setIndex(i);
        }
    }

    private File chooseImportCfgFilename(boolean save) {
        File f;
        File parentDir;
        File cfgFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new ImpPropFileFilter());
        if (this.configFileName != null) {
            cfgFile = new File(this.configFileName.trim());
            chooser.setSelectedFile(cfgFile);
            parentDir = cfgFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else if (this.jTextFieldSourceFileName.getText().trim().length() > 0) {
            cfgFile = new File(this.jTextFieldSourceFileName.getText().trim());
            parentDir = cfgFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else {
            File parentDir2 = new File(Main.getUserProperty("IMPORT_CFGFILE_DIR", System.getProperty("user.home")));
            if (parentDir2 != null) {
                chooser.setCurrentDirectory(parentDir2);
            }
        }
        int returnVal = -1;
        if (save) {
            chooser.setDialogType(1);
            chooser.setDialogTitle(Messages.getString("ImportConfiguratorFrame.chooseSaveImportConfig"));
            returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                f = chooser.getSelectedFile();
                if (chooser.getFileFilter() instanceof ImpPropFileFilter && !f.getName().toLowerCase().endsWith(IMPORT_CONFIG_EXTENSION)) {
                    return new File(f.getAbsolutePath() + IMPORT_CONFIG_EXTENSION);
                }
                return f;
            }
        } else {
            chooser.setDialogType(0);
            chooser.setDialogTitle(Messages.getString("ImportConfiguratorFrame.chooseOpenImportConfig"));
            returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                f = chooser.getSelectedFile();
                if (f.exists()) {
                    if (chooser.getFileFilter() instanceof ImpPropFileFilter && !f.getName().toLowerCase().endsWith(IMPORT_CONFIG_EXTENSION)) {
                        return new File(f.getAbsolutePath() + IMPORT_CONFIG_EXTENSION);
                    }
                    return f;
                }
                JOptionPane.showMessageDialog(this, f.getAbsolutePath() + Messages.getString("ImportConfiguratorFrame.filenotexists"), Messages.getString("ImportConfiguratorFrame.titleopenimportconfigfile"), 0);
            }
        }
        return null;
    }

    private File chooseTalendSchemaFilename(boolean save) {
        File parentDir;
        File cfgFile;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new TalendSchemaFileFilter());
        String fileName = this.jTextFieldTableName.getText() + ".xml";
        if (this.configFileName != null) {
            cfgFile = new File(this.configFileName.trim());
            chooser.setSelectedFile(new File(cfgFile.getParentFile(), fileName));
            parentDir = cfgFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else if (this.jTextFieldSourceFileName.getText().trim().length() > 0) {
            cfgFile = new File(this.jTextFieldSourceFileName.getText().trim());
            chooser.setSelectedFile(new File(cfgFile.getParentFile(), fileName));
            parentDir = cfgFile.getParentFile();
            if (parentDir != null) {
                chooser.setCurrentDirectory(parentDir);
            }
        } else {
            File parentDir2 = new File(Main.getUserProperty("IMPORT_CFGFILE_DIR", System.getProperty("user.home")));
            chooser.setSelectedFile(new File(parentDir2, fileName));
            if (parentDir2 != null) {
                chooser.setCurrentDirectory(parentDir2);
            }
        }
        int returnVal = -1;
        if (save) {
            chooser.setDialogType(1);
            chooser.setDialogTitle(Messages.getString("ImportConfiguratorFrame.saveasTalendSchema"));
            returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                if (chooser.getFileFilter() instanceof TalendSchemaFileFilter && !f.getName().toLowerCase().endsWith(".xml")) {
                    return new File(f.getAbsolutePath() + ".xml");
                }
                return f;
            }
        }
        return null;
    }

    private void setConfigFileName(String name) {
        this.configFileName = name;
        if (name == null) {
            this.setTitle(Messages.getString("ImportConfiguratorFrame.titleunknown"));
        } else {
            this.setTitle(Messages.getString("ImportConfiguratorFrame.titleconfigsaved") + this.configFileName);
            File parentDir = new File(name).getParentFile();
            Main.setUserProperty("IMPORT_CFGFILE_DIR", parentDir.getAbsolutePath());
        }
    }

    private String isDescriptionValid() {
        String errorMessage = null;
        if (this.jTextFieldTableName.getText().trim().length() == 0) {
            errorMessage = Messages.getString("ImportConfiguratorFrame.errortableunknown");
        } else if (this.descriptionTableModel.getRowCount() == 0) {
            errorMessage = Messages.getString("ImportConfiguratorFrame.errornofielddesc");
        } else if (this.delimiterConfigPanel.getDelimiterToken().length() == 0) {
            for (int i = 0; i < this.descriptionTableModel.getRowCount(); ++i) {
                FieldDescription fd = this.descriptionTableModel.getFieldDescription(i);
                if (fd.getPositionType() != 2 && fd.getPositionType() != 3) continue;
                errorMessage = Messages.getString("ImportConfiguratorFrame.errornodelimiter");
                break;
            }
        }
        if (!this.jCheckBoxInsertEnabled.isSelected() && !this.jCheckBoxUpdateEnabled.isSelected()) {
            errorMessage = Messages.getString("ImportConfiguratorFrame.errornoinsertorupdate");
        }
        return errorMessage;
    }

    private boolean saveConfigFile(boolean saveas) {
        File f;
        boolean doit = true;
        boolean ok = false;
        if (saveas) {
            f = this.chooseImportCfgFilename(true);
            if (f != null) {
                this.setConfigFileName(f.getAbsolutePath());
                doit = true;
            } else {
                doit = false;
            }
        } else if (this.configFileName == null) {
            f = this.chooseImportCfgFilename(true);
            if (f != null) {
                this.setConfigFileName(f.getAbsolutePath());
                doit = true;
            } else {
                doit = false;
            }
        }
        if (doit) {
            try {
                FileWriter fw = new FileWriter(new File(this.configFileName));
                fw.append(this.getConfigurationPropertiesAsString());
                fw.flush();
                fw.close();
                this.lastConfiguration = this.buildProperties();
                ok = true;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ioe.getMessage(), Messages.getString("ImportConfiguratorFrame.messagetitlesaveconfig"), 0);
            }
        }
        return ok;
    }

    private boolean saveTalendSchemaFile() {
        boolean doit = true;
        boolean ok = false;
        File f = this.chooseTalendSchemaFilename(true);
        doit = f != null;
        if (doit) {
            try {
                ArrayList<FieldDescription> listFd = new ArrayList<FieldDescription>();
                for (int i = 0; i < this.descriptionTableModel.getRowCount(); ++i) {
                    FieldDescription fd = this.descriptionTableModel.getFieldDescription(i);
                    if (fd.isDummy()) continue;
                    listFd.add(fd);
                }
                FileWriter fw = new FileWriter(f);
                SchemaUtil su = new SchemaUtil();
                fw.append(su.getSchemaXMLFromFieldDescriptions(listFd));
                fw.flush();
                fw.close();
                ok = true;
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ioe.getMessage(), Messages.getString("ImportConfiguratorFrame.messagetitlesaveconfig"), 0);
            }
        }
        return ok;
    }

    private JMenuBar getImportConfigMenuBar() {
        if (this.importConfigMenuBar == null) {
            this.importConfigMenuBar = new JMenuBar();
            this.importConfigMenuBar.add(this.getJMenuFile());
        }
        return this.importConfigMenuBar;
    }

    private JMenu getJMenuFile() {
        if (this.jMenuFile == null) {
            this.jMenuFile = new JMenu();
            this.jMenuFile.setText(Messages.getString("ImportConfiguratorFrame.file"));
            this.jMenuFile.add(this.getJMenuItemFileNew());
            this.jMenuFile.add(this.getJMenuItemFileOpen());
            this.jMenuFile.add(this.getJMenuItemFileSave());
            this.jMenuFile.add(this.getJMenuItemFileSaveAs());
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.getJMenuItemFileSaveAsTalendSchema());
            this.jMenuFile.addSeparator();
            this.jMenuFile.add(this.getJMenuItemClose());
        }
        return this.jMenuFile;
    }

    private JMenuItem getJMenuItemFileNew() {
        if (this.jMenuItemFileNew == null) {
            this.jMenuItemFileNew = new JMenuItem();
            this.jMenuItemFileNew.setText(Messages.getString("ImportConfiguratorFrame.new"));
            this.jMenuItemFileNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImportConfiguratorFrame.this.checkSaveConfig()) {
                        ImportConfiguratorFrame.this.clearConfiguration();
                    }
                }
            });
        }
        return this.jMenuItemFileNew;
    }

    private JMenuItem getJMenuItemFileOpen() {
        if (this.jMenuItemFileOpen == null) {
            this.jMenuItemFileOpen = new JMenuItem();
            this.jMenuItemFileOpen.setText(Messages.getString("ImportConfiguratorFrame.open"));
            this.jMenuItemFileOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.chooseAndOpenConfigfile();
                }
            });
        }
        return this.jMenuItemFileOpen;
    }

    private JMenuItem getJMenuItemFileSave() {
        if (this.jMenuItemFileSave == null) {
            this.jMenuItemFileSave = new JMenuItem();
            this.jMenuItemFileSave.setText(Messages.getString("ImportConfiguratorFrame.save"));
            this.jMenuItemFileSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.saveConfigFile(false);
                }
            });
        }
        return this.jMenuItemFileSave;
    }

    private JMenuItem getJMenuItemFileSaveAs() {
        if (this.jMenuItemFileSaveAs == null) {
            this.jMenuItemFileSaveAs = new JMenuItem();
            this.jMenuItemFileSaveAs.setText(Messages.getString("ImportConfiguratorFrame.saveas"));
            this.jMenuItemFileSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.saveConfigFile(true);
                }
            });
        }
        return this.jMenuItemFileSaveAs;
    }

    private JMenuItem getJMenuItemFileSaveAsTalendSchema() {
        if (this.jMenuItemFileSaveAsTalendSchema == null) {
            this.jMenuItemFileSaveAsTalendSchema = new JMenuItem();
            this.jMenuItemFileSaveAsTalendSchema.setText(Messages.getString("ImportConfiguratorFrame.saveasTalendSchema"));
            this.jMenuItemFileSaveAsTalendSchema.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportConfiguratorFrame.this.saveTalendSchemaFile();
                }
            });
        }
        return this.jMenuItemFileSaveAsTalendSchema;
    }

    private JMenuItem getJMenuItemClose() {
        if (this.jMenuItemClose == null) {
            this.jMenuItemClose = new JMenuItem();
            this.jMenuItemClose.setText(Messages.getString("ImportConfiguratorFrame.close"));
            this.jMenuItemClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ImportConfiguratorFrame.this.close()) {
                        ImportConfiguratorFrame.this.dispose();
                    }
                }
            });
        }
        return this.jMenuItemClose;
    }

    private JComboBox getJComboBoxSortFieldDescriptions() {
        if (this.jComboBoxSortFieldDescriptions == null) {
            this.jComboBoxSortFieldDescriptions = new JComboBox();
            this.jComboBoxSortFieldDescriptions.addItem(new FieldDescriptionComparatorByIndex());
            this.jComboBoxSortFieldDescriptions.addItem(new FieldDescriptionComparatorByPosition());
            this.jComboBoxSortFieldDescriptions.addItem(new FieldDescriptionComparatorByName());
            this.jComboBoxSortFieldDescriptions.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    int row;
                    Comparator c;
                    if (e.getID() == 701 && e.getStateChange() == 1 && (c = (Comparator)ImportConfiguratorFrame.this.jComboBoxSortFieldDescriptions.getSelectedItem()) != null && (row = ImportConfiguratorFrame.this.jTableFieldDescriptions.getSelectedRow()) != -1) {
                        FieldDescription fd = ImportConfiguratorFrame.this.descriptionTableModel.getFieldDescription(row);
                        ImportConfiguratorFrame.this.descriptionTableModel.sortBy(c);
                        ImportConfiguratorFrame.this.refreshTestData();
                        if (fd != null) {
                            int newSelectionRow = ImportConfiguratorFrame.this.descriptionTableModel.getRowIndex(fd);
                            ImportConfiguratorFrame.this.jTableFieldDescriptions.setRowSelectionInterval(newSelectionRow, newSelectionRow);
                            Rectangle r = ImportConfiguratorFrame.this.jTableFieldDescriptions.getCellRect(newSelectionRow, 0, false);
                            ImportConfiguratorFrame.this.jTableFieldDescriptions.scrollRectToVisible(r);
                        }
                    }
                }
            });
        }
        return this.jComboBoxSortFieldDescriptions;
    }

    private static class FieldDescriptionComparatorByIndex
    implements Comparator<FieldDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FieldDescriptionComparatorByIndex() {
        }

        @Override
        public int compare(FieldDescription o1, FieldDescription o2) {
            if (o1.isDummy() && !o2.isDummy()) {
                return 1;
            }
            if (!o1.isDummy() && o2.isDummy()) {
                return -1;
            }
            if (!o1.isDummy() && !o2.isDummy()) {
                return o1.getIndex() - o2.getIndex();
            }
            return 0;
        }

        public String toString() {
            return Messages.getString("ImportConfiguratorFrame.sortFdByIndex");
        }
    }

    private static class FieldDescriptionComparatorByName
    implements Comparator<FieldDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FieldDescriptionComparatorByName() {
        }

        @Override
        public int compare(FieldDescription o1, FieldDescription o2) {
            if (o1.isDummy() && !o2.isDummy()) {
                return 1;
            }
            if (!o1.isDummy() && o2.isDummy()) {
                return -1;
            }
            if (!o1.isDummy() && !o2.isDummy()) {
                if (o1.getName() != null && o2.getName() != null) {
                    return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
                return 0;
            }
            return 0;
        }

        public String toString() {
            return Messages.getString("ImportConfiguratorFrame.sortFdByName");
        }
    }

    private static class FieldDescriptionComparatorByPosition
    implements Comparator<FieldDescription>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FieldDescriptionComparatorByPosition() {
        }

        @Override
        public int compare(FieldDescription o1, FieldDescription o2) {
            if (o1.isDummy() && !o2.isDummy()) {
                return 1;
            }
            if (!o1.isDummy() && o2.isDummy()) {
                return -1;
            }
            if (!o1.isDummy() && !o2.isDummy()) {
                if (o1.getPositionType() != o2.getPositionType()) {
                    return o1.getPositionType() - o2.getPositionType();
                }
                if (o1.getPositionType() == 2 || o1.getPositionType() == 3) {
                    return o1.getDelimPos() - o2.getDelimPos();
                }
                return o1.getAbsPos() - o2.getAbsPos();
            }
            return 0;
        }

        public String toString() {
            return Messages.getString("ImportConfiguratorFrame.sortFdByPosition");
        }
    }

    private class ReadDatasetAtRowAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ReadDatasetAtRowAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                long rowNumber = Long.parseLong(ImportConfiguratorFrame.this.jTextFieldCurrentRowNum.getText());
                if (rowNumber == 0L) {
                    rowNumber = 1L;
                }
                ImportConfiguratorFrame.this.showTestDataAtRow(rowNumber - 1L);
            }
            catch (Exception ex) {
                logger.warn((Object)("readDatasetAtRowAction failed: " + ex.getClass() + ": " + ex.getMessage()));
            }
        }
    }

    private class TableInputListener
    extends MouseAdapter
    implements ActionListener {
        private TableInputListener() {
        }

        protected void fireDoubleClickPerformed() {
            if (ImportConfiguratorFrame.this.jTableFieldDescriptions.getSelectedRow() != -1) {
                ImportConfiguratorFrame.this.buttonEdit_actionPerformed();
            }
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.getClickCount() == 2) {
                this.fireDoubleClickPerformed();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("open")) {
                this.fireDoubleClickPerformed();
            }
        }
    }

    private static class TitleRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color colorData = new Color(190, 230, 190);
        private final Color colorDesc = new Color(200, 200, 100);

        public TitleRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table_loc, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(Color.black);
            if (column == 5) {
                this.setBackground(this.colorData);
            } else {
                this.setBackground(this.colorDesc);
            }
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setHorizontalAlignment(0);
            this.setText((String)value);
            this.setFont(new Font("Dialog", 0, 12));
            if (column == 0) {
                this.setToolTipText(Messages.getString("ImportConfiguratorFrame.willbeimported"));
            } else if (column == 1) {
                this.setToolTipText(Messages.getString("ImportConfiguratorFrame.ispartofprimarykey"));
            } else {
                this.setToolTipText((String)value);
            }
            return this;
        }
    }

    private static final class DescriptionRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public DescriptionRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table_loc, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.setFont(table_loc.getFont());
            if (isSelected) {
                if (hasFocus) {
                    this.setForeground(Color.black);
                    this.setBackground(Color.white);
                } else {
                    this.setForeground(table_loc.getSelectionForeground());
                    this.setBackground(table_loc.getSelectionBackground());
                }
            } else {
                this.setForeground(table_loc.getForeground());
                if (col == 5) {
                    this.setBackground(new Color(240, 255, 240));
                } else {
                    this.setBackground(new Color(255, 255, 225));
                }
            }
            if (hasFocus) {
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    private static class ParameterPlaceHolder {
        private String name;
        private String code;

        private ParameterPlaceHolder() {
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

