/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sqlrunner.flatfileimport.gui.Messages;

public class DelimiterConfigPanel
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 1L;
    private JRadioButton jRadioButtonPredefined = null;
    private JRadioButton jRadioButtonUserDefined = null;
    private JComboBox jComboBoxPredefinedDelimiter = null;
    private JTextField jTextFieldUserDefinedDelimiter = null;
    private ButtonGroup buttonGroupDelimiter;
    private static final String PIPE = "|";
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String SPACE = "{SPACE}";
    private static final String TAB = "{TAB}";
    private Vector<ItemListener> listenerList = new Vector();
    private JComboBox jComboBoxEnclosure = null;
    private JLabel jLabel = null;

    public DelimiterConfigPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 0;
        gridBagConstraints31.anchor = 13;
        gridBagConstraints31.fill = 2;
        gridBagConstraints31.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints31.gridy = 2;
        this.jLabel = new JLabel();
        this.jLabel.setText(Messages.getString("DelimiterConfigPanel.0"));
        this.jLabel.setHorizontalAlignment(4);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.gridy = 2;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints21.gridx = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints1.gridx = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJRadioButtonPredefined(), gridBagConstraints1);
        this.add((Component)this.getJRadioButtonUserDefined(), gridBagConstraints);
        this.add((Component)this.getJComboBoxPredefinedDelimiter(), gridBagConstraints2);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Messages.getString("DelimiterConfigPanel.fielddelimiter"), 0, 0, new Font("Lucida Grande", 0, 13), Color.black));
        this.setPreferredSize(new Dimension(240, 110));
        this.add((Component)this.getJTextFieldUserDefinedDelimiter(), gridBagConstraints3);
        this.add((Component)this.getJComboBoxEnclosure(), gridBagConstraints21);
        this.add((Component)this.jLabel, gridBagConstraints31);
        this.buttonGroupDelimiter = new ButtonGroup();
        this.buttonGroupDelimiter.add(this.jRadioButtonPredefined);
        this.buttonGroupDelimiter.add(this.jRadioButtonUserDefined);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jRadioButtonPredefined.setEnabled(enabled);
        this.jRadioButtonUserDefined.setEnabled(enabled);
        if (this.jRadioButtonPredefined.isSelected()) {
            this.jComboBoxPredefinedDelimiter.setEnabled(enabled);
        } else if (this.jRadioButtonUserDefined.isSelected()) {
            this.jTextFieldUserDefinedDelimiter.setEnabled(enabled);
        }
        this.jComboBoxEnclosure.setEnabled(enabled);
    }

    private JRadioButton getJRadioButtonPredefined() {
        if (this.jRadioButtonPredefined == null) {
            this.jRadioButtonPredefined = new JRadioButton();
            this.jRadioButtonPredefined.setText(Messages.getString("DelimiterConfigPanel.predefined"));
            this.jRadioButtonPredefined.setSelected(true);
            this.jRadioButtonPredefined.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getID() == 701) {
                        DelimiterConfigPanel.this.fireItemChangePerformed();
                        if (e.getStateChange() == 1) {
                            DelimiterConfigPanel.this.jTextFieldUserDefinedDelimiter.setEnabled(false);
                            DelimiterConfigPanel.this.jComboBoxPredefinedDelimiter.setEnabled(true);
                        } else {
                            DelimiterConfigPanel.this.jTextFieldUserDefinedDelimiter.setEnabled(true);
                            DelimiterConfigPanel.this.jComboBoxPredefinedDelimiter.setEnabled(false);
                        }
                    }
                }
            });
        }
        return this.jRadioButtonPredefined;
    }

    private JRadioButton getJRadioButtonUserDefined() {
        if (this.jRadioButtonUserDefined == null) {
            this.jRadioButtonUserDefined = new JRadioButton();
            this.jRadioButtonUserDefined.setText(Messages.getString("DelimiterConfigPanel.userdefined"));
        }
        return this.jRadioButtonUserDefined;
    }

    private JComboBox getJComboBoxPredefinedDelimiter() {
        if (this.jComboBoxPredefinedDelimiter == null) {
            this.jComboBoxPredefinedDelimiter = new JComboBox();
            ListCellRenderer comp = this.jComboBoxPredefinedDelimiter.getRenderer();
            if (comp instanceof JLabel) {
                ((JLabel)((Object)comp)).setHorizontalAlignment(0);
            }
            this.jComboBoxPredefinedDelimiter.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DelimiterConfigPanel.this.fireItemChangePerformed();
                }
            });
            this.jComboBoxPredefinedDelimiter.addItem(PIPE);
            this.jComboBoxPredefinedDelimiter.addItem(SEMICOLON);
            this.jComboBoxPredefinedDelimiter.addItem(COMMA);
            this.jComboBoxPredefinedDelimiter.addItem(SPACE);
            this.jComboBoxPredefinedDelimiter.addItem(TAB);
        }
        return this.jComboBoxPredefinedDelimiter;
    }

    private JTextField getJTextFieldUserDefinedDelimiter() {
        if (this.jTextFieldUserDefinedDelimiter == null) {
            this.jTextFieldUserDefinedDelimiter = new JTextField();
            this.jTextFieldUserDefinedDelimiter.setEnabled(false);
            this.jTextFieldUserDefinedDelimiter.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DelimiterConfigPanel.this.fireItemChangePerformed();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DelimiterConfigPanel.this.fireItemChangePerformed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DelimiterConfigPanel.this.fireItemChangePerformed();
                }
            });
        }
        return this.jTextFieldUserDefinedDelimiter;
    }

    public String getDelimiterToken() {
        try {
            if (this.jRadioButtonPredefined.isSelected()) {
                return (String)this.jComboBoxPredefinedDelimiter.getSelectedItem();
            }
            return this.jTextFieldUserDefinedDelimiter.getText();
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public String getDelimiter() {
        String delim = this.getDelimiterToken();
        if (SPACE.equals(delim)) {
            delim = " ";
        } else if (TAB.equals(delim)) {
            delim = "\t";
        }
        return delim;
    }

    public void setDelimiterToken(String delimiterToken) {
        try {
            if (PIPE.equals(delimiterToken)) {
                this.jRadioButtonPredefined.setSelected(true);
                this.jComboBoxPredefinedDelimiter.setSelectedIndex(0);
            } else if (SEMICOLON.equals(delimiterToken)) {
                this.jRadioButtonPredefined.setSelected(true);
                this.jComboBoxPredefinedDelimiter.setSelectedIndex(1);
            } else if (COMMA.equals(delimiterToken)) {
                this.jRadioButtonPredefined.setSelected(true);
                this.jComboBoxPredefinedDelimiter.setSelectedIndex(2);
            } else if (SPACE.equals(delimiterToken)) {
                this.jRadioButtonPredefined.setSelected(true);
                this.jComboBoxPredefinedDelimiter.setSelectedIndex(3);
            } else if (TAB.equals(delimiterToken)) {
                this.jRadioButtonPredefined.setSelected(true);
                this.jComboBoxPredefinedDelimiter.setSelectedIndex(4);
            } else {
                this.jRadioButtonUserDefined.setSelected(true);
                this.jTextFieldUserDefinedDelimiter.setText(delimiterToken);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        if (!this.listenerList.contains(l)) {
            this.listenerList.add(l);
        }
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(l);
    }

    private void fireItemChangePerformed() {
        ItemEvent e = new ItemEvent(this, 701, this.getDelimiter(), 1);
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).itemStateChanged(e);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] oa = new Object[]{this.getDelimiter()};
        return oa;
    }

    private JComboBox getJComboBoxEnclosure() {
        if (this.jComboBoxEnclosure == null) {
            this.jComboBoxEnclosure = new JComboBox();
            this.jComboBoxEnclosure.addItem("");
            this.jComboBoxEnclosure.addItem("\"");
            this.jComboBoxEnclosure.addItem("'");
            this.jComboBoxEnclosure.addItem("%");
            ListCellRenderer comp = this.jComboBoxEnclosure.getRenderer();
            if (comp instanceof JLabel) {
                ((JLabel)((Object)comp)).setHorizontalAlignment(0);
            }
            this.jComboBoxEnclosure.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DelimiterConfigPanel.this.fireItemChangePerformed();
                }
            });
        }
        return this.jComboBoxEnclosure;
    }

    public void setEnclosure(String enclosure) {
        if (enclosure == null) {
            enclosure = "";
        }
        this.jComboBoxEnclosure.setSelectedItem(enclosure);
    }

    public String getEnclosure() {
        String enclosure = (String)this.jComboBoxEnclosure.getSelectedItem();
        if (enclosure == "") {
            enclosure = null;
        }
        return enclosure;
    }
}

