/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.generator;

import org.apache.log4j.Logger;
import sqlrunner.flatfileimport.generator.AutoValueGenerator;

public class NumberValueGenerator
implements AutoValueGenerator {
    private static final Logger logger = Logger.getLogger(NumberValueGenerator.class);
    private long currentValue = 0L;
    private long startLongValue = 0L;
    private boolean descending = false;

    @Override
    public synchronized String getNext() {
        if (this.descending) {
            return String.valueOf(this.currentValue--);
        }
        return String.valueOf(this.currentValue++);
    }

    @Override
    public synchronized void reset() {
        this.currentValue = 0L;
    }

    @Override
    public void setDirectionToDescending(boolean descending) {
        this.descending = descending;
    }

    public boolean isDirectionDescending() {
        return this.descending;
    }

    @Override
    public synchronized void setStartValue(String startValue) {
        try {
            this.currentValue = this.startLongValue = Long.parseLong(startValue);
        }
        catch (Exception e) {
            logger.error((Object)("setStartValue invalid value:" + startValue));
        }
    }
}

