/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class StringInputStream
extends InputStream {
    private byte[] bytes = null;
    private int pointer = 0;

    public StringInputStream(String string) throws IOException {
        if (string == null) {
            throw new IOException("null string not supported");
        }
        this.bytes = string.getBytes();
    }

    public StringInputStream(String string, String charSet) throws UnsupportedEncodingException, IOException {
        if (string == null) {
            throw new IOException("null string not supported");
        }
        this.bytes = string.getBytes(charSet);
    }

    @Override
    public int available() throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        return this.bytes.length - this.pointer;
    }

    @Override
    public void close() throws IOException {
        this.bytes = null;
        this.pointer = 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        int readedBytes = 0;
        if (this.pointer >= this.bytes.length) {
            readedBytes = -1;
        } else {
            for (int i = 0; i < len && this.pointer < this.bytes.length; ++i) {
                b[i + off] = this.bytes[this.pointer++];
                ++readedBytes;
            }
        }
        return readedBytes;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        int readedBytes = 0;
        if (this.pointer >= this.bytes.length) {
            readedBytes = -1;
        } else {
            for (int i = 0; i < b.length && this.pointer < this.bytes.length; ++i) {
                b[i] = this.bytes[this.pointer++];
                ++readedBytes;
            }
        }
        return readedBytes;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        this.pointer = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        if (n > (long)(this.bytes.length - this.pointer - 1)) {
            n = this.bytes.length - this.pointer - 1;
        }
        this.pointer += (int)n;
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.bytes == null) {
            throw new IOException("stream is closed");
        }
        if (this.pointer >= this.bytes.length) {
            return -1;
        }
        return this.bytes[this.pointer++];
    }
}

