/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.log4j.Logger;
import sqlrunner.base64.Base64;

public class ImportAttributes {
    private static Logger logger = Logger.getLogger(ImportAttributes.class);
    private String tableName;
    private boolean insertEnabled;
    private boolean updateEnabled;
    private boolean deleteBeforeImport;
    private boolean skipFirstRow;
    private boolean handleFileAlwaysAsCSV;
    private long countSkipRows;
    private String delimiter;
    private String enclosure;
    private boolean ignoreLineBreakInEnclosedValues = false;
    private String preProcessSQL;
    private String postProcessSQL;
    private boolean preProcessEnabled;
    private boolean postProcessEnabled;
    private int columnCount;
    private String charsetName;
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");
    private String sheetName;
    private int batchSize;

    public void setLogger(Logger newLogger) {
        logger = newLogger;
    }

    public void storeInto(Properties properties) {
        if (this.tableName != null) {
            properties.put("TABLE_NAME", this.tableName);
        }
        properties.put("INSERT_ENABLED", this.insertEnabled ? "true" : "false");
        properties.put("UPDATE_ENABLED", this.updateEnabled ? "true" : "false");
        properties.put("DELETE_BEFORE_IMPORT", this.deleteBeforeImport ? "true" : "false");
        properties.put("SKIP_FIRST_ROW", this.skipFirstRow ? "true" : "false");
        properties.put("HANDLE_ALWAYS_AS_CSV", this.handleFileAlwaysAsCSV ? "true" : "false");
        properties.put("SKIP_ROWS", String.valueOf(this.countSkipRows));
        properties.put("DELIMITER", ImportAttributes.getTokenFromDelimiter(this.delimiter));
        if (this.enclosure != null) {
            properties.put("ENCLOSURE", this.enclosure);
            properties.put("IGNORE_ENCLOSED_LINE_BREAK", (Object)this.ignoreLineBreakInEnclosedValues);
        } else {
            properties.remove("ENCLOSURE");
        }
        properties.put("COLUMN_COUNT", String.valueOf(this.columnCount));
        if (this.preProcessSQL != null && this.preProcessSQL.trim().length() > 1) {
            try {
                properties.put("PRE_PROCESS_SQL", Base64.toString(Base64.encode(this.preProcessSQL.getBytes("UTF-16")), false));
                properties.put("PRE_PROCESS_SQL_ENABLED", String.valueOf(this.preProcessEnabled));
            }
            catch (UnsupportedEncodingException ex) {
                properties.put("PRE_PROCESS_SQL_ENABLED", String.valueOf(false));
                logger.error((Object)"PRE_PROCESS_SQL_ENABLED cannot be encoded", (Throwable)ex);
            }
        } else {
            properties.remove("PRE_PROCESS_SQL");
            properties.remove("PRE_PROCESS_SQL_ENABLED");
        }
        if (this.postProcessSQL != null && this.postProcessSQL.trim().length() > 1) {
            try {
                properties.put("POST_PROCESS_SQL", Base64.toString(Base64.encode(this.postProcessSQL.getBytes("UTF-16")), false));
                properties.put("POST_PROCESS_SQL_ENABLED", String.valueOf(this.postProcessEnabled));
            }
            catch (UnsupportedEncodingException ex) {
                properties.put("POST_PROCESS_SQL_ENABLED", String.valueOf(false));
                logger.error((Object)"POST_PROCESS_SQL_ENABLED cannot be encoded", (Throwable)ex);
            }
        }
        if (this.charsetName != null) {
            properties.put("CHARSET", this.charsetName);
        } else {
            properties.put("CHARSET", DEFAULT_CHARSET);
        }
        if (this.sheetName != null) {
            properties.put("SHEET_NAME", this.sheetName);
        } else {
            properties.remove("SHEET_NAME");
        }
        if (this.batchSize > 1) {
            properties.put("BATCH_SIZE", String.valueOf(this.batchSize));
        } else {
            properties.remove("BATCH_SIZE");
        }
    }

    private static String getDelimiterFromToken(String token) {
        if (token == null) {
            return null;
        }
        if (token.equals("{TAB}")) {
            return "\t";
        }
        if (token.equals("{SPACE}")) {
            return " ";
        }
        return token;
    }

    private static String getTokenFromDelimiter(String delimiter) {
        if (delimiter == null) {
            return null;
        }
        if ("\t".equals(delimiter)) {
            return "{TAB}";
        }
        if (" ".equals(delimiter)) {
            return "{SPACE}";
        }
        return delimiter;
    }

    public String getDelimiterToken() {
        return ImportAttributes.getTokenFromDelimiter(this.delimiter);
    }

    public void clear() {
        this.tableName = null;
        Properties p = new Properties();
        try {
            this.setupFrom(p);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setupFrom(Properties properties) throws Exception {
        this.setTableName(properties.getProperty("TABLE_NAME"));
        this.preProcessEnabled = "true".equalsIgnoreCase(properties.getProperty("PRE_PROCESS_SQL_ENABLED", "false"));
        String preProcessSQLBase64 = properties.getProperty("PRE_PROCESS_SQL");
        this.preProcessSQL = preProcessSQLBase64 != null && preProcessSQLBase64.length() > 2 ? Base64.getText(preProcessSQLBase64, "UTF-16") : null;
        this.postProcessEnabled = "true".equalsIgnoreCase(properties.getProperty("POST_PROCESS_SQL_ENABLED", "false"));
        String postProcessSQLBase64 = properties.getProperty("POST_PROCESS_SQL");
        this.postProcessSQL = postProcessSQLBase64 != null && postProcessSQLBase64.length() > 2 ? Base64.getText(postProcessSQLBase64, "UTF-16") : null;
        this.insertEnabled = properties.getProperty("INSERT_ENABLED", "true").trim().equals("true");
        this.handleFileAlwaysAsCSV = properties.getProperty("HANDLE_ALWAYS_AS_CSV", "false").trim().equals("true");
        this.updateEnabled = properties.getProperty("UPDATE_ENABLED", "true").trim().equals("true");
        this.deleteBeforeImport = properties.getProperty("DELETE_BEFORE_IMPORT", "false").trim().equals("true");
        this.delimiter = ImportAttributes.getDelimiterFromToken(properties.getProperty("DELIMITER"));
        this.enclosure = properties.getProperty("ENCLOSURE");
        this.ignoreLineBreakInEnclosedValues = "true".equals(properties.getProperty("IGNORE_ENCLOSED_LINE_BREAK", "false"));
        this.skipFirstRow = properties.getProperty("SKIP_FIRST_ROW", "true").trim().equals("true");
        this.countSkipRows = Long.parseLong(properties.getProperty("SKIP_ROWS", "0"));
        this.setCharsetName(properties.getProperty("CHARSET", DEFAULT_CHARSET));
        this.setSheetName(properties.getProperty("SHEET_NAME"));
        this.setBatchSize(Integer.parseInt(properties.getProperty("BATCH_SIZE", "0")));
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName != null && sheetName.trim().length() > 0 ? sheetName.trim() : null;
    }

    public String getCharsetName() {
        return this.charsetName != null ? this.charsetName : DEFAULT_CHARSET;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName != null && charsetName.trim().length() > 0 ? charsetName.trim() : null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName != null && tableName.trim().length() > 0 ? tableName.trim() : null;
    }

    public boolean isInsertEnabled() {
        return this.insertEnabled;
    }

    public void setInsertEnabled(boolean insertEnabled) {
        this.insertEnabled = insertEnabled;
    }

    public boolean isUpdateEnabled() {
        return this.updateEnabled;
    }

    public void setUpdateEnabled(boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
    }

    public boolean isDeleteBeforeImport() {
        return this.deleteBeforeImport;
    }

    public void setDeleteBeforeImport(boolean deleteBeforeImport) {
        this.deleteBeforeImport = deleteBeforeImport;
    }

    public boolean isSkipFirstRow() {
        return this.skipFirstRow;
    }

    public void setSkipFirstRow(boolean skipFirstRow) {
        this.skipFirstRow = skipFirstRow;
    }

    public boolean isHandleFileAlwaysAsCSV() {
        return this.handleFileAlwaysAsCSV;
    }

    public void setHandleFileAlwaysAsCSV(boolean handleFileAlwaysAsCSV) {
        this.handleFileAlwaysAsCSV = handleFileAlwaysAsCSV;
    }

    public long getCountSkipRows() {
        return this.countSkipRows;
    }

    public void setCountSkipRows(long countSkipRows) {
        this.countSkipRows = countSkipRows;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getPreProcessSQL() {
        return this.preProcessSQL;
    }

    public void setPreProcessSQL(String preProcessSQL) {
        this.preProcessSQL = preProcessSQL;
    }

    public String getPostProcessSQL() {
        return this.postProcessSQL;
    }

    public void setPostProcessSQL(String postProcessSQL) {
        this.postProcessSQL = postProcessSQL;
    }

    public boolean isPreProcessEnabled() {
        return this.preProcessEnabled && this.preProcessSQL != null && this.preProcessSQL.length() > 1;
    }

    public void setPreProcessEnabled(boolean preProcessEnabled) {
        this.preProcessEnabled = preProcessEnabled;
    }

    public boolean isPostProcessEnabled() {
        return this.postProcessEnabled && this.postProcessSQL != null && this.postProcessSQL.length() > 1;
    }

    public void setPostProcessEnabled(boolean postProcessEnabled) {
        this.postProcessEnabled = postProcessEnabled;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isIgnoreLineBreakInEnclosedValues() {
        return this.ignoreLineBreakInEnclosedValues;
    }

    public void setIgnoreLineBreakInEnclosedValues(boolean ignoreLineBreakInEnclosedValues) {
        this.ignoreLineBreakInEnclosedValues = ignoreLineBreakInEnclosedValues;
    }
}

