/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import sqlrunner.flatfileimport.CSVFieldTokenizer;
import sqlrunner.flatfileimport.DatasetProvider;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.ImportAttributes;
import sqlrunner.flatfileimport.RandomAccessReader;

public class CSVFileDatasetProvider
implements DatasetProvider {
    private transient RandomAccessReader randomReader = null;
    private transient BufferedReader bufferedReader = null;
    private boolean testMode = false;
    private File currentFile;
    private boolean useEnclosure = false;
    private char enclosure = (char)32;
    private long currentRowNum = 0L;
    private String currentLine = null;

    private void setEncloser(String enclosure) {
        if (enclosure != null && !enclosure.isEmpty()) {
            if (enclosure.length() > 1) {
                throw new IllegalArgumentException("Enclosure can only be one char!");
            }
            this.enclosure = enclosure.charAt(0);
            this.useEnclosure = true;
        } else {
            this.useEnclosure = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long retrieveDatasetCount() throws IOException {
        if (this.currentFile == null) {
            throw new IllegalStateException("setupDatasetProvider not performed");
        }
        long count = 0L;
        BufferedInputStream in = null;
        try {
            byte[] buffer = new byte[1024];
            int len = 0;
            in = new BufferedInputStream(new FileInputStream(this.currentFile));
            int c = 32;
            while ((len = in.read(buffer, 0, buffer.length)) != -1 && !Thread.currentThread().isInterrupted()) {
                for (int i = 0; i < len; ++i) {
                    c = (char)buffer[i];
                    if (c != 10) continue;
                    ++count;
                }
            }
            if (c != 10) {
                ++count;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return count;
    }

    @Override
    public FieldTokenizer createParser() {
        CSVFieldTokenizer parser = new CSVFieldTokenizer();
        return parser;
    }

    @Override
    public void setupDatasetProvider(File file, boolean testMode, ImportAttributes properties) throws Exception {
        if (properties.isIgnoreLineBreakInEnclosedValues()) {
            this.setEncloser(properties.getEnclosure());
        }
        this.testMode = testMode;
        if (testMode) {
            this.randomReader = new RandomAccessReader(new RandomAccessFile(file, "r"), properties.getCharsetName());
            if (this.useEnclosure) {
                this.randomReader.setEnclosure(this.enclosure);
            } else {
                this.randomReader.disableEnclosure();
            }
        } else {
            this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), properties.getCharsetName()));
        }
        this.currentFile = file;
        this.currentRowNum = 0L;
        this.currentLine = null;
    }

    @Override
    public void closeDatasetProvider() {
        if (this.randomReader != null) {
            try {
                this.randomReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.bufferedReader != null) {
            try {
                this.bufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Object getNextDataset() throws Exception {
        if (this.testMode) {
            throw new Exception("getNextDataset not supported in test mode");
        }
        this.currentLine = this.readLine();
        ++this.currentRowNum;
        return this.currentLine;
    }

    private String readLine() throws IOException {
        if (this.useEnclosure) {
            return this.readLineWithEnclosure();
        }
        return this.bufferedReader.readLine();
    }

    private String readLineWithEnclosure() throws IOException {
        StringBuilder line = new StringBuilder();
        boolean inEclosuredField = false;
        char last_c = '\u0000';
        while (true) {
            int r;
            if ((r = this.bufferedReader.read()) == -1) {
                if (line.length() > 0) {
                    return line.toString();
                }
                return null;
            }
            char c = (char)r;
            if (c == this.enclosure) {
                inEclosuredField = !inEclosuredField && last_c != this.enclosure;
                line.append(c);
            } else if (c == '\n') {
                if (!inEclosuredField) break;
                line.append(c);
            } else {
                if (c == '\r') continue;
                line.append(c);
                if (last_c == this.enclosure) {
                    inEclosuredField = true;
                }
            }
            last_c = c;
        }
        return line.toString();
    }

    private String getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public long getCurrentRowNum() {
        return this.currentRowNum;
    }

    @Override
    public Object getDatasetAtRowInTestMode(long rowNumber) throws Exception {
        if (!this.testMode) {
            throw new IllegalStateException("method getDatasetAtRowInTestMode can only be used in test mode");
        }
        this.readDatasetInTestModeAt(rowNumber);
        return this.getCurrentLine();
    }

    private void readDatasetInTestModeAt(long rowNumber) throws Exception {
        if (rowNumber < 0L) {
            this.randomReader.seek(0L);
            this.currentLine = null;
            this.randomReader.seek(0L);
            this.currentRowNum = 0L;
        } else if (rowNumber == 0L) {
            this.randomReader.seek(0L);
            this.currentLine = this.randomReader.readLineWithCharSet();
            this.randomReader.seek(0L);
            this.currentRowNum = 0L;
        } else if (rowNumber == this.currentRowNum - 1L) {
            if (this.randomReader.seekToPrevLineStart()) {
                --this.currentRowNum;
                long pos = this.randomReader.getFilePointer();
                this.currentLine = this.randomReader.readLineWithCharSet();
                this.randomReader.seek(pos);
            }
        } else {
            if (rowNumber < this.currentRowNum) {
                this.currentRowNum = 0L;
                this.randomReader.seek(0L);
            }
            if (rowNumber > this.currentRowNum) {
                boolean jumped = false;
                long pos = this.randomReader.getFilePointer();
                while (rowNumber > this.currentRowNum && this.randomReader.seekToNextLineStart()) {
                    pos = this.randomReader.getFilePointer();
                    ++this.currentRowNum;
                    jumped = true;
                }
                if (jumped) {
                    this.currentLine = this.randomReader.readLineWithCharSet();
                    this.randomReader.seek(pos);
                }
            }
        }
    }
}

