/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.util.List;
import org.apache.log4j.Logger;
import sqlrunner.flatfileimport.AbstractFieldTokenizer;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.ParserException;

public class CSVFieldTokenizer
extends AbstractFieldTokenizer {
    private static final Logger logger = Logger.getLogger(CSVFieldTokenizer.class);
    private String rowData;
    private char[] data;
    private int lastPos;
    private String fieldDelimiter;
    private char[] delimiterChars;
    private String enclosure;
    private char[] enclosureChars;
    String combinedDelimiter = null;

    public CSVFieldTokenizer() {
        this.setRowData(null);
        this.setDelimiter(null);
        this.setEnclosure(null);
    }

    @Override
    public void setRowData(Object rowData) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setRowData(<" + rowData + ">)"));
        }
        if (rowData instanceof String) {
            this.rowData = (String)rowData;
            this.data = this.getChars(this.rowData);
        } else {
            if (rowData != null) {
                throw new IllegalArgumentException("rowData must be a String");
            }
            this.rowData = null;
            this.data = this.getChars(null);
        }
    }

    public String extractDataBetweenDelimiters(int fieldNum) throws ParserException {
        return this.extractDataAtDelimiter(fieldNum, 0);
    }

    private char[] getChars(String s) {
        if (s == null) {
            return new char[0];
        }
        return s.toCharArray();
    }

    private String extractDataAtDelimiter(int fieldNum, int length) throws ParserException {
        String value = null;
        int countDelimiters = 0;
        boolean inField = false;
        boolean atEnclosureStart = false;
        boolean atEnclosureStop = false;
        boolean atDelimiter = false;
        boolean useEnclosure = this.enclosureChars.length > 0;
        boolean fieldStartsWithEnclosure = false;
        int currPos = 0;
        while (currPos < this.data.length && countDelimiters <= fieldNum) {
            if (atEnclosureStart) {
                atEnclosureStart = false;
                fieldStartsWithEnclosure = true;
                atEnclosureStop = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos += this.enclosureChars.length);
                if (atEnclosureStop) continue;
                inField = true;
                continue;
            }
            if (atEnclosureStop) {
                atEnclosureStop = false;
                atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos += this.enclosureChars.length);
                if (atDelimiter || currPos >= this.data.length) continue;
                throw new ParserException("delimiter after enclosure stop missing");
            }
            if (atDelimiter) {
                ++countDelimiters;
                fieldStartsWithEnclosure = false;
                atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos += this.delimiterChars.length);
                if (atDelimiter) continue;
                if (useEnclosure && currPos < this.data.length) {
                    atEnclosureStart = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
                    if (atEnclosureStart) continue;
                    inField = true;
                    continue;
                }
                inField = true;
                continue;
            }
            if (inField) {
                StringBuilder sb = null;
                if (countDelimiters == fieldNum) {
                    sb = new StringBuilder();
                }
                while (currPos < this.data.length) {
                    if (sb != null) {
                        sb.append(this.data[currPos]);
                    }
                    ++currPos;
                    if (fieldStartsWithEnclosure) {
                        atEnclosureStop = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
                        if (!atEnclosureStop) continue;
                        break;
                    }
                    atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos);
                    if (!atEnclosureStart && !atDelimiter) continue;
                }
                inField = false;
                if (sb == null) continue;
                value = sb.toString();
                continue;
            }
            if (useEnclosure) {
                atEnclosureStart = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
            }
            atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos);
            if (atEnclosureStart || atDelimiter) continue;
            inField = true;
        }
        if (length > 0 && value != null && value.length() > length) {
            value = value.substring(0, length);
        }
        return value;
    }

    public static boolean startsWith(char[] data, char[] search, int startPos) {
        if (search.length == 0 || data.length == 0) {
            return false;
        }
        if (startPos < 0 || startPos > data.length - search.length) {
            return false;
        }
        int searchPos = 0;
        int count = search.length;
        int dataPos = startPos;
        while (--count >= 0) {
            if (data[dataPos++] == search[searchPos++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int countDelimitedFields() throws ParserException {
        int countFields = this.data.length > 0 ? 1 : 0;
        boolean inField = false;
        boolean atEnclosureStart = false;
        boolean atEnclosureStop = false;
        boolean atDelimiter = false;
        boolean useEnclosure = this.enclosureChars.length > 0;
        boolean fieldStartsWithEnclosure = false;
        int currPos = 0;
        while (currPos < this.data.length) {
            if (atEnclosureStart) {
                atEnclosureStart = false;
                fieldStartsWithEnclosure = true;
                atEnclosureStop = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos += this.enclosureChars.length);
                if (atEnclosureStop) continue;
                inField = true;
                continue;
            }
            if (atEnclosureStop) {
                atEnclosureStop = false;
                atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos += this.enclosureChars.length);
                if (atDelimiter || currPos >= this.data.length) continue;
                throw new ParserException("delimiter after enclosure stop missing");
            }
            if (atDelimiter) {
                ++countFields;
                fieldStartsWithEnclosure = false;
                atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos += this.delimiterChars.length);
                if (atDelimiter) continue;
                if (useEnclosure && currPos < this.data.length) {
                    atEnclosureStart = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
                    if (atEnclosureStart) continue;
                    inField = true;
                    continue;
                }
                inField = true;
                continue;
            }
            if (inField) {
                while (currPos < this.data.length) {
                    ++currPos;
                    if (fieldStartsWithEnclosure) {
                        atEnclosureStop = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
                        if (!atEnclosureStop) continue;
                        break;
                    }
                    atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos);
                    if (!atEnclosureStart && !atDelimiter) continue;
                }
                inField = false;
                continue;
            }
            if (useEnclosure) {
                atEnclosureStart = CSVFieldTokenizer.startsWith(this.data, this.enclosureChars, currPos);
            }
            atDelimiter = CSVFieldTokenizer.startsWith(this.data, this.delimiterChars, currPos);
            if (atEnclosureStart || atDelimiter) continue;
            inField = true;
        }
        return countFields;
    }

    private String extractDataAtAbsPos(int position, int length) {
        this.lastPos = position + length;
        if (this.lastPos > this.rowData.length()) {
            this.lastPos = this.rowData.length();
        }
        return this.rowData.substring(position, this.lastPos);
    }

    private String extractDataAtLastPos(int length) {
        if (length == 0) {
            return null;
        }
        if (length < 0) {
            int beginIndex = this.lastPos + length;
            if (beginIndex < 0) {
                beginIndex = 0;
            }
            return this.rowData.substring(beginIndex, this.lastPos);
        }
        int beginIndex = this.lastPos;
        this.lastPos = beginIndex + length;
        if (this.lastPos > this.rowData.length()) {
            this.lastPos = this.rowData.length();
        }
        return this.rowData.substring(beginIndex, this.lastPos);
    }

    private String extractData(FieldDescription field) throws ParserException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("extractData(field=" + field.getName() + ") rawdata=<" + this.rowData + ">"));
        }
        String value = null;
        if (field.getPositionType() == 0) {
            value = this.extractDataAtAbsPos(field.getAbsPos(), field.getLength());
        } else if (field.getPositionType() == 1) {
            value = this.extractDataAtLastPos(field.getLength());
        } else if (field.getPositionType() == 2) {
            value = this.extractDataBetweenDelimiters(field.getDelimPos());
        } else if (field.getPositionType() == 3) {
            value = this.extractDataAtDelimiter(field.getDelimPos(), field.getLength());
        } else if (field.getPositionType() == 4) {
            value = field.getNextAutoGeneratedValue();
        } else if (field.getPositionType() == 5) {
            value = field.getDefaultValue();
        }
        if (value != null && field.isTrimRequired()) {
            value = value.trim();
        }
        if (value == null || value.trim().length() == 0) {
            if (field.getAlternativeFieldDescription() != null) {
                value = this.extractData(field.getAlternativeFieldDescription());
            }
            if (value == null || value.trim().length() == 0) {
                value = field.getDefaultValue();
            }
        } else {
            value = CSVFieldTokenizer.filter(field.getFilterPattern(), value);
        }
        if (BasicDataType.isNumberType(field.getBasicTypeId()) && value != null && value.trim().endsWith("-")) {
            value = "-" + value.replace('-', ' ').trim();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getData returns <" + value + ">"));
        }
        return value;
    }

    @Override
    public boolean parseRawData(List<FieldDescription> fieldDescriptionList) throws ParserException {
        return this.parseRawData(fieldDescriptionList, false);
    }

    @Override
    public boolean parseRawData(List<FieldDescription> fieldDescriptionList, boolean skipConverting) throws ParserException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseRawData fieldList.size=" + fieldDescriptionList.size() + " skipConverting=" + skipConverting));
        }
        this.setFieldDescriptions(fieldDescriptionList);
        this.clearListData();
        if (this.rowData != null) {
            FieldDescription fd = null;
            for (int i = 0; i < this.getCountFieldDescriptions(); ++i) {
                fd = this.getFieldDescriptionAt(i);
                try {
                    if (skipConverting) {
                        this.addDataValue(this.extractData(fd));
                        continue;
                    }
                    this.addDataValue(this.convertStringValue(fd, this.extractData(fd)));
                    continue;
                }
                catch (ParserException e) {
                    if (fd.isIgnoreDatasetIfInvalid()) {
                        return false;
                    }
                    throw e;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean parseRawData(Object rawdata) throws ParserException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("parseRowData rawdata=<" + rawdata + ">"));
        }
        if (!this.hasFieldDescriptions()) {
            throw new IllegalStateException("descriptions cannot be empty or null");
        }
        this.setRowData(rawdata);
        this.clearListData();
        if (this.rowData != null) {
            FieldDescription fd = null;
            for (int i = 0; i < this.getCountFieldDescriptions(); ++i) {
                fd = this.getFieldDescriptionAt(i);
                try {
                    this.addDataValue(this.convertStringValue(fd, this.extractData(fd)));
                    continue;
                }
                catch (ParserException e) {
                    if (fd.isIgnoreDatasetIfInvalid()) {
                        return false;
                    }
                    throw e;
                }
            }
            return true;
        }
        return false;
    }

    public void setDelimiter(String delimiter) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setDelimiter(<" + delimiter + ">)"));
        }
        this.fieldDelimiter = delimiter;
        this.delimiterChars = this.getChars(this.fieldDelimiter);
    }

    public String getDelimiter() {
        return this.fieldDelimiter;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
        this.enclosureChars = this.getChars(enclosure);
    }

    public String getEnclosure() {
        return this.enclosure;
    }
}

