/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.ParserException;
import sqlrunner.text.GenericDateUtil;

public abstract class AbstractFieldTokenizer
implements FieldTokenizer {
    private final ArrayList<Object> fieldDataList = new ArrayList();
    private boolean testMode = false;
    private List<FieldDescription> descriptions;
    private static String nullValue = "\\N";

    protected int getListDataSize() {
        return this.fieldDataList.size();
    }

    protected void clearListData() {
        this.fieldDataList.clear();
    }

    protected boolean addDataValue(Object value) {
        this.fieldDataList.add(value);
        return value != null;
    }

    @Override
    public Object getData(int fieldDescriptionIndex) {
        if (this.fieldDataList != null && fieldDescriptionIndex < this.fieldDataList.size()) {
            return this.fieldDataList.get(fieldDescriptionIndex);
        }
        return null;
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @Override
    public boolean isTestMode() {
        return this.testMode;
    }

    protected boolean hasFieldDescriptions() {
        return this.descriptions != null && !this.descriptions.isEmpty();
    }

    protected int getCountFieldDescriptions() {
        if (!this.hasFieldDescriptions()) {
            return 0;
        }
        return this.descriptions.size();
    }

    protected FieldDescription getFieldDescriptionAt(int index) {
        return this.descriptions.get(index);
    }

    @Override
    public void setFieldDescriptions(List<FieldDescription> listOfDescriptions) {
        if (listOfDescriptions == null || listOfDescriptions.isEmpty()) {
            throw new IllegalArgumentException("listOfDescriptions cannot be empty or null");
        }
        this.descriptions = listOfDescriptions;
    }

    protected static String filter(Pattern pattern, String content) {
        if (pattern != null && content != null) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                if (matcher.start() >= matcher.end()) continue;
                sb.append(matcher.group());
            }
            content = sb.toString();
        }
        if (nullValue.equals(content)) {
            content = null;
        }
        return content;
    }

    protected Object convertStringValue(FieldDescription fd, String strValue) throws ParserException {
        Object value = null;
        if (strValue != null && strValue.length() > 0) {
            if (BasicDataType.isNumberType(fd.getBasicTypeId())) {
                try {
                    NumberFormat nf = fd.getNumberFormat();
                    Number n = nf.parse(strValue);
                    value = n;
                }
                catch (Exception e) {
                    String message = "value=" + strValue + " parse as number failed: " + e.getMessage();
                    if (this.isTestMode()) {
                        value = "ERROR:" + message;
                    }
                    throw new ParserException(message);
                }
            } else if (fd.getBasicTypeId() == BasicDataType.DATE.getId()) {
                if (fd.getFieldFormat() == null || fd.getFieldFormat().length() == 0) {
                    throw new ParserException("date format not defined");
                }
                SimpleDateFormat sdf = new SimpleDateFormat(fd.getFieldFormat(), fd.getLocale());
                try {
                    Date date = null;
                    try {
                        date = sdf.parse(strValue);
                    }
                    catch (ParseException e0) {
                        date = GenericDateUtil.parseDate(strValue);
                    }
                    Timestamp timestamp = new Timestamp(date.getTime());
                    value = timestamp;
                }
                catch (ParseException e) {
                    String message = "value=" + strValue + " parse as date failed: " + e.getMessage();
                    if (this.isTestMode()) {
                        value = "ERROR:" + message;
                    }
                    throw new ParserException(message);
                }
            } else {
                value = fd.getBasicTypeId() == BasicDataType.BOOLEAN.getId() ? Boolean.valueOf(Boolean.parseBoolean(strValue)) : strValue;
            }
        } else if (!fd.isNullEnabled()) {
            String message = "value for primary key field " + fd + " cannot be null";
            if (this.isTestMode()) {
                value = "ERROR:" + message;
            } else {
                throw new ParserException(message);
            }
        }
        return value;
    }
}

