/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.fileconverter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class TextFileConverter {
    private long currentInputLineNumber = 0L;
    private long maxLinesPerFile = 0L;
    private long currentOutputLineNumber = 0L;

    public void reset() {
        this.currentInputLineNumber = 0L;
        this.maxLinesPerFile = 0L;
        this.currentOutputLineNumber = 0L;
    }

    public void setMaxLinesPerFile(long maxLinesPerFile) {
        this.maxLinesPerFile = maxLinesPerFile;
    }

    public long getMaxLinesPerFile() {
        return this.maxLinesPerFile;
    }

    public void convert(File source, String sourceEncoding, File target, String targetEncoding, String targetLineSeparator) throws IOException {
        if (source.equals(target)) {
            throw new IllegalArgumentException("source cannot equal to target file");
        }
        File currentTargetFile = target;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), sourceEncoding));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(currentTargetFile), targetEncoding));
        String line = null;
        int fileIndex = 0;
        while ((line = in.readLine()) != null && !Thread.currentThread().isInterrupted()) {
            ++this.currentInputLineNumber;
            if (this.maxLinesPerFile > 0L && this.currentOutputLineNumber == this.maxLinesPerFile) {
                this.currentOutputLineNumber = 0L;
                out.close();
                currentTargetFile = this.createNextFile(target, ++fileIndex);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(currentTargetFile), targetEncoding));
            }
            out.write(line);
            out.write(targetLineSeparator);
            ++this.currentOutputLineNumber;
        }
        out.close();
        in.close();
    }

    public long getCurrentLineNumber() {
        return this.currentInputLineNumber;
    }

    private File createNextFile(File originalTargetFile, int index) {
        String path = originalTargetFile.getParent();
        String originalName = originalTargetFile.getName();
        int p0 = originalName.lastIndexOf(".");
        String newName = p0 != -1 ? originalName.substring(0, p0) + "_" + String.valueOf(index) + originalName.substring(p0, originalName.length()) : originalName + "_" + String.valueOf(index);
        if (path != null) {
            return new File(path, newName);
        }
        return new File(newName);
    }

    public static enum LineSeparator {
        UNIX("UNIX", "\n"),
        WINDOWS("Windows", "\r\n");

        private String name;
        private String sep;

        private LineSeparator(String name, String sep) {
            this.name = name;
            this.sep = sep;
        }

        public String getName() {
            return this.name;
        }

        public String getSeparator() {
            return this.sep;
        }

        public String toString() {
            return this.getName();
        }
    }
}

