/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import dbtools.ConnectionDescription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sqlrunner.DBMessageDialog;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.export.ExportFormatPanel;
import sqlrunner.export.Exporter;
import sqlrunner.export.ExporterToTextFile;
import sqlrunner.export.Messages;
import sqlrunner.export.TargetPanel;
import sqlrunner.swinghelper.WindowHelper;

public class QueryExportFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel jPanelQuery = null;
    private JScrollPane jScrollPaneQuery = null;
    private JTextArea jTextAreaQuery = null;
    private JTextField jTextFieldFetchSize = null;
    private JButton jButtonTakeover = null;
    private ExportFormatPanel exportFormatPanel = null;
    private TargetPanel targetPanel = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonStart = null;
    private JButton jButtonCancel = null;
    private JButton jButtonClose = null;
    private JCheckBox jCheckBoxLineWrap = null;
    private StatusBar status = null;
    private MainFrame mainFrame = null;
    private boolean enabled = true;
    private transient Thread exportThread = null;

    public QueryExportFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initialize();
        this.pack();
        WindowHelper.checkAndCorrectWindowBounds(this);
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("QueryExportFrame.0"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 10.0;
            this.jContentPane.add((Component)this.getJPanelQuery(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.jContentPane.add((Component)this.getExportFormatPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.jContentPane.add((Component)this.getTargetPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            this.jContentPane.add((Component)this.getJPanelButtons(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.anchor = 15;
            this.jContentPane.add((Component)this.getStatusBar(), gbc);
        }
        return this.jContentPane;
    }

    private JPanel getJPanelQuery() {
        if (this.jPanelQuery == null) {
            this.jPanelQuery = new JPanel();
            this.jPanelQuery.setLayout(new GridBagLayout());
            this.jPanelQuery.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), "Query", 0, 0, null, null));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 20, 2, 2);
            gbc.anchor = 13;
            this.jPanelQuery.add((Component)this.getJButtonTakeover(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanelQuery.add((Component)this.getJCheckBoxLineWrap(), gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            this.jPanelQuery.add((Component)this.getJScrollPaneQuery(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel label = new JLabel();
            label.setText(Messages.getString("QueryExportFrame.fetchSize"));
            this.jPanelQuery.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weightx = 2.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanelQuery.add((Component)this.getJTextFieldFetchSize(), gbc);
        }
        return this.jPanelQuery;
    }

    private JTextField getJTextFieldFetchSize() {
        if (this.jTextFieldFetchSize == null) {
            this.jTextFieldFetchSize = new JTextField();
            this.jTextFieldFetchSize.setText("1000");
        }
        return this.jTextFieldFetchSize;
    }

    private JScrollPane getJScrollPaneQuery() {
        if (this.jScrollPaneQuery == null) {
            this.jScrollPaneQuery = new JScrollPane();
            this.jScrollPaneQuery.setPreferredSize(new Dimension(400, 100));
            this.jScrollPaneQuery.setViewportView(this.getJTextAreaQuery());
        }
        return this.jScrollPaneQuery;
    }

    private JTextArea getJTextAreaQuery() {
        if (this.jTextAreaQuery == null) {
            this.jTextAreaQuery = new JTextArea();
        }
        return this.jTextAreaQuery;
    }

    private JButton getJButtonTakeover() {
        if (this.jButtonTakeover == null) {
            this.jButtonTakeover = new JButton();
            this.jButtonTakeover.setText(Messages.getString("QueryExportFrame.1"));
            this.jButtonTakeover.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryExportFrame.this.setQueryText(QueryExportFrame.this.mainFrame.getText());
                }
            });
        }
        return this.jButtonTakeover;
    }

    private ExportFormatPanel getExportFormatPanel() {
        if (this.exportFormatPanel == null) {
            this.exportFormatPanel = new ExportFormatPanel();
            this.exportFormatPanel.setDateSQLExpression(Main.getUserProperty("SQL_STRING_DATE_CONVERSION", "to_date('<STRING>','dd.MM.yy HH24:MI')"));
            this.exportFormatPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("flat")) {
                        QueryExportFrame.this.getTargetPanel().enableFileTypeCSV(true);
                        QueryExportFrame.this.getTargetPanel().enableFileTypeXLS(true);
                        QueryExportFrame.this.getTargetPanel().enableFileTypeSQL(false);
                    } else {
                        QueryExportFrame.this.getTargetPanel().enableFileTypeCSV(false);
                        QueryExportFrame.this.getTargetPanel().enableFileTypeXLS(false);
                        QueryExportFrame.this.getTargetPanel().enableFileTypeSQL(true);
                    }
                }
            });
        }
        return this.exportFormatPanel;
    }

    private TargetPanel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = new TargetPanel(false);
        }
        return this.targetPanel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 17;
            this.jPanelButtons.add((Component)this.getJButtonStart(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanelButtons.add((Component)this.getJButtonCancel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 13;
            this.jPanelButtons.add((Component)this.getJButtonClose(), gbc);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonStart() {
        if (this.jButtonStart == null) {
            this.jButtonStart = new JButton();
            this.jButtonStart.setText(Messages.getString("QueryExportFrame.4"));
            this.jButtonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryExportFrame.this.startExport();
                }
            });
        }
        return this.jButtonStart;
    }

    private JFrame getFrame() {
        return this;
    }

    private void startExport() {
        Main.setUserProperty("SQL_STRING_DATE_CONVERSION", this.exportFormatPanel.getDateSQLExpression());
        if (this.jTextAreaQuery.getText().trim().length() > 1) {
            if (this.mainFrame.getDatabase().getDatabaseSession().isConnected()) {
                int exportType = this.exportFormatPanel.isExportInCSVFileSelected() ? 1 : 2;
                boolean ok = false;
                if (!this.targetPanel.hasFileName()) {
                    JOptionPane.showMessageDialog(this, Messages.getString("ResultTableExportDialog.3"), Messages.getString("ResultTableExportDialog.4"), 1);
                    ok = false;
                    this.targetPanel.setFocusToFileName();
                } else {
                    ok = true;
                }
                if (ok) {
                    int answer;
                    ok = this.targetPanel.getFile().exists() ? (answer = JOptionPane.showConfirmDialog(this, Messages.getString("ResultTableExportDialog.5"), Messages.getString("ResultTableExportDialog.6"), 0, 1)) == 0 : true;
                }
                if (ok) {
                    File targetFile;
                    int fetchSize = 0;
                    try {
                        String value = this.jTextFieldFetchSize.getText();
                        if (value != null) {
                            fetchSize = Integer.parseInt(value.trim());
                        }
                    }
                    catch (NumberFormatException e) {
                        fetchSize = 0;
                    }
                    final ConnectionDescription cdExport = this.mainFrame.getDatabase().getDatabaseSession().getConnectionDescription().clone();
                    cdExport.setAutoCommit(false);
                    cdExport.setDefaultFetchSize(fetchSize);
                    long maxRowsPerFile = 0L;
                    if (this.targetPanel.shouldFileSplitted()) {
                        maxRowsPerFile = this.targetPanel.getMaxLimitDatasetInSplittedFiles();
                    }
                    if ((targetFile = this.targetPanel.getFile()).getName().toLowerCase().endsWith(".xls") || targetFile.getName().toLowerCase().endsWith(".xlsx")) {
                        // empty if block
                    }
                    final ExporterToTextFile exporter = new ExporterToTextFile(cdExport, this.jTextAreaQuery.getText().trim(), targetFile);
                    exporter.setExportType(exportType);
                    exporter.setDelimiter(this.exportFormatPanel.getDelimiter());
                    exporter.setCharSet(Main.getFileEnoding());
                    exporter.setCreateHeader(this.exportFormatPanel.isWithHeaderSelected());
                    exporter.useCommaAsDecimalDelimiter(this.exportFormatPanel.isReplacePointWithCommaSelected());
                    exporter.setMaxDatasetsPerFile(maxRowsPerFile);
                    exporter.setEnclosure(this.exportFormatPanel.getEnclosure());
                    exporter.setDateFormat(MainFrame.getDateFormatMask());
                    exporter.setLineSeparator(Main.getCurrentLineSeparator());
                    final LongRunningAction lra = new LongRunningAction(){

                        @Override
                        public String getName() {
                            return "Export Query";
                        }

                        @Override
                        public void cancel() {
                            exporter.abort();
                        }

                        @Override
                        public boolean canBeCanceled() {
                            return true;
                        }
                    };
                    this.exportThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    QueryExportFrame.this.setEnabled(false);
                                    MainFrame.addLongRunningAction(lra);
                                    ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setText("CONN");
                                    ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setToolTipText(cdExport.toString());
                                    ((QueryExportFrame)QueryExportFrame.this).status.message.setText(Messages.getString("QueryExportFrame.18"));
                                    ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setBackground(Color.red);
                                }
                            });
                            Timer timer = new Timer(1000, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    QueryExportFrame.this.handleStatusInfo(exporter);
                                }
                            });
                            timer.start();
                            try {
                                if (exporter.connect()) {
                                    exporter.exportData();
                                }
                                timer.stop();
                            }
                            catch (IOException ioe) {
                                JOptionPane.showMessageDialog(QueryExportFrame.this.getFrame(), ioe.getMessage(), Messages.getString("QueryExportFrame.27"), 0);
                                timer.stop();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        QueryExportFrame.this.handleStatusInfo(exporter);
                                        ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setText("DISC");
                                        ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setToolTipText(Messages.getString("QueryExportFrame.31"));
                                        ((QueryExportFrame)QueryExportFrame.this).status.infoAction.setBackground(new Color(204, 204, 204));
                                        QueryExportFrame.this.setEnabled(true);
                                        MainFrame.removeLongRunningAction(lra);
                                    }
                                });
                            }
                            catch (SQLException sqle) {
                                new DBMessageDialog(QueryExportFrame.this.getFrame(), sqle.getMessage(), Messages.getString("QueryExportFrame.26"));
                                timer.stop();
                                {
                                    catch (Throwable throwable) {
                                        timer.stop();
                                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                        throw throwable;
                                    }
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    };
                    this.exportThread.start();
                }
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("QueryExportFrame.8"), Messages.getString("QueryExportFrame.9"), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this, Messages.getString("QueryExportFrame.10"), Messages.getString("QueryExportFrame.11"), 0);
        }
    }

    private void handleStatusInfo(Exporter exporter) {
        switch (exporter.getStatus()) {
            case 1: {
                this.status.message.setText(Messages.getString("QueryExportFrame.connecting"));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.status.message.setText(Messages.getString("QueryExportFrame.18"));
                break;
            }
            case 4: {
                this.status.message.setText(String.valueOf(exporter.getCurrentRowNum()) + " " + Messages.getString("QueryExportFrame.21"));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.status.message.setText(Messages.getString("QueryExportFrame.24") + " " + String.valueOf(exporter.getCurrentRowNum()) + Messages.getString("QueryExportFrame.25"));
                break;
            }
            case 7: {
                this.status.message.setText(Messages.getString("QueryExportFrame.22") + " " + String.valueOf(exporter.getCurrentRowNum()) + Messages.getString("QueryExportFrame.25"));
            }
        }
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText(Messages.getString("QueryExportFrame.12"));
            this.jButtonCancel.setEnabled(false);
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (QueryExportFrame.this.exportThread != null && QueryExportFrame.this.exportThread.isAlive()) {
                        QueryExportFrame.this.exportThread.interrupt();
                    }
                }
            });
        }
        return this.jButtonCancel;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText(Messages.getString("QueryExportFrame.13"));
            this.jButtonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryExportFrame.this.dispose();
                }
            });
        }
        return this.jButtonClose;
    }

    private JCheckBox getJCheckBoxLineWrap() {
        if (this.jCheckBoxLineWrap == null) {
            this.jCheckBoxLineWrap = new JCheckBox();
            this.jCheckBoxLineWrap.setText(Messages.getString("QueryExportFrame.14"));
            this.jCheckBoxLineWrap.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getID() == 701) {
                        QueryExportFrame.this.jTextAreaQuery.setLineWrap(QueryExportFrame.this.jCheckBoxLineWrap.isSelected());
                    }
                }
            });
        }
        return this.jCheckBoxLineWrap;
    }

    private StatusBar getStatusBar() {
        if (this.status == null) {
            this.status = new StatusBar();
        }
        return this.status;
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                if (!this.enabled) break;
                this.dispose();
                break;
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.targetPanel.setEnabled(enabled);
        this.exportFormatPanel.setEnabled(enabled);
        this.jTextAreaQuery.setEditable(enabled);
        this.jTextFieldFetchSize.setEditable(enabled);
        this.jButtonTakeover.setEnabled(enabled);
        this.jButtonStart.setEnabled(enabled);
        this.jButtonCancel.setEnabled(!enabled);
        this.jButtonClose.setEnabled(enabled);
        if (enabled) {
            this.enableEvents(64L);
        } else {
            this.disableEvents(64L);
        }
    }

    public void setQueryText(String query) {
        this.jTextAreaQuery.setText(query);
    }

    static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JLabel message = new FixedLabel();
        public JLabel infoAction = new FixedLabel();
        static final int INFO_ACTION_BREITE = 60;
        static final int HOEHE = 25;

        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.message.setBorder(BorderFactory.createLoweredBevelBorder());
            this.message.setForeground(Color.black);
            this.infoAction.setPreferredSize(new Dimension(60, 25));
            this.infoAction.setOpaque(true);
            this.infoAction.setText("DISC");
            this.infoAction.setToolTipText(Messages.getString("QueryExportFrame.16"));
            this.infoAction.setBorder(BorderFactory.createLoweredBevelBorder());
            this.infoAction.setForeground(Color.black);
            this.add(this.message);
            this.add(this.infoAction);
            this.message.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth() - 60;
            this.message.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.message);
            this.add(this.message, null, 0);
            this.doLayout();
        }

        class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.message.setToolTipText(StatusBar.this.message.getText());
            }
        }

        private static class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

