/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;

public class XORCaret
extends DefaultCaret {
    private static final long serialVersionUID = 1L;
    protected int lastPaintedWidth = 8;
    protected Font currentFont = null;
    protected int currentAscent = 0;
    protected FontMetrics currentFontMetrics = null;
    protected char currentChar;

    public XORCaret() {
        this.setBlinkRate(500);
    }

    private int currentWidth(Graphics2D g2d) {
        String current = null;
        try {
            current = this.getComponent().getText(this.getDot(), 1);
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        this.currentChar = current != null && current.length() > 0 ? current.charAt(0) : (char)32;
        Font font = this.getComponent().getFont();
        if (font != this.currentFont) {
            this.currentFontMetrics = g2d.getFontMetrics();
            this.currentAscent = this.currentFontMetrics.getAscent();
        }
        if (Character.isWhitespace(this.currentChar)) {
            return this.currentFontMetrics.charWidth(' ');
        }
        return this.currentFontMetrics.charWidth(current.charAt(0));
    }

    @Override
    public final void paint(Graphics g) {
        if (this.isVisible()) {
            TextUI ui = this.getComponent().getUI();
            Rectangle r = null;
            int dot = this.getDot();
            try {
                r = ui.modelToView(this.getComponent(), dot);
            }
            catch (BadLocationException ex) {
                System.err.println("paint failed: " + ex.getMessage());
                return;
            }
            g.setColor(this.getComponent().getCaretColor());
            this.lastPaintedWidth = this.currentWidth((Graphics2D)g);
            g.fillRect(r.x, r.y, this.lastPaintedWidth, r.height);
            g.setColor(this.getComponent().getBackground());
            try {
                String s;
                if (dot < this.getComponent().getDocument().getLength() && !Character.isISOControl((s = this.getComponent().getText(dot, 1)).charAt(0))) {
                    g.drawString(s, r.x, r.y + this.currentAscent);
                }
            }
            catch (BadLocationException ex) {
                System.err.println(ex.toString());
            }
        }
    }

    @Override
    public final void damage(Rectangle r) {
        if (r != null) {
            this.x = r.x;
            this.y = r.y;
            this.width = this.lastPaintedWidth;
            this.height = r.height;
            this.repaint();
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

