/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sqlrunner.editor.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class SearchReplaceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField jTextFieldSearch = null;
    private JTextField jTextFieldReplace = null;
    private JButton jButtonSuche = null;
    private JButton jButtonCancel = null;
    private JCheckBox jCheckBoxCaseSensitiv = null;
    private int aktCaret;
    private JCheckBox jCheckBoxWithoutAsk = null;
    private JCheckBox jCheckBoxAbAnfang = null;
    private JLabel jLabelInfo = null;
    private JButton jButtonReplace = null;
    private boolean replaceIsSelected;
    private JTextComponent editor;
    private JCheckBox jCheckBoxWholeWords = null;
    private transient SearchReplaceThread searchReplaceThread = null;
    private JPanel jContentPane = null;

    public SearchReplaceDialog(JFrame frame, boolean modal, JTextComponent editor) {
        super(frame, Messages.getString("SearchReplaceDialog.title"), modal);
        this.editor = editor;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.cancel();
            }
        }
        super.processWindowEvent(e);
    }

    public void setSearchText(String text) {
        this.jTextFieldSearch.setText(this.editor.getSelectedText());
        this.jTextFieldSearch.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("suche")) {
            this.replaceIsSelected = false;
            this.startSearch();
        }
        if (e.getActionCommand().equals("ersetze")) {
            if (this.editor.getSelectionStart() != this.editor.getSelectionEnd()) {
                this.editor.replaceSelection(this.jTextFieldReplace.getText());
            }
            this.replaceIsSelected = true;
            this.startSearch();
        }
        if (e.getActionCommand().equals("abbrechen")) {
            this.cancel();
        }
    }

    private void cancel() {
        if (this.searchReplaceThread != null && this.searchReplaceThread.isAlive()) {
            this.searchReplaceThread.interrupt();
            this.searchReplaceThread = null;
        }
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.jButtonSuche);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SearchReplaceDialog.this.this_keyPressed(e);
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 3;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(10, 2, 2, 10);
            this.jTextFieldSearch = new JTextField();
            this.jTextFieldSearch.setText("");
            this.jTextFieldSearch.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    SearchReplaceDialog.this.this_keyPressed(e);
                }
            });
            this.jContentPane.add((Component)this.jTextFieldSearch, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridwidth = 3;
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.gridy = 1;
            this.jCheckBoxCaseSensitiv = new JCheckBox();
            this.jCheckBoxCaseSensitiv.setText(Messages.getString("SearchReplaceDialog.casesensitive"));
            this.jContentPane.add((Component)this.jCheckBoxCaseSensitiv, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 10);
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            this.jCheckBoxWholeWords = new JCheckBox();
            this.jCheckBoxWholeWords.setText(Messages.getString("SearchReplaceDialog.wholewords"));
            this.jContentPane.add((Component)this.jCheckBoxWholeWords, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 3;
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 2, 2, 10);
            this.jTextFieldReplace = new JTextField();
            this.jTextFieldReplace.setText("");
            this.jTextFieldReplace.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    SearchReplaceDialog.this.this_keyPressed(e);
                }
            });
            this.jContentPane.add((Component)this.jTextFieldReplace, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.gridwidth = 4;
            this.jCheckBoxWithoutAsk = new JCheckBox();
            this.jCheckBoxWithoutAsk.setText(Messages.getString("SearchReplaceDialog.replacewithoutasking"));
            this.jCheckBoxWithoutAsk.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SearchReplaceDialog.this.jCheckBoxWithoutAsk_stateChanged(e);
                }
            });
            this.jContentPane.add((Component)this.jCheckBoxWithoutAsk, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.gridwidth = 4;
            this.jCheckBoxAbAnfang = new JCheckBox();
            this.jCheckBoxAbAnfang.setText(Messages.getString("SearchReplaceDialog.startattextbegin"));
            this.jContentPane.add((Component)this.jCheckBoxAbAnfang, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(10, 5, 2, 2);
            gbc.gridx = 0;
            gbc.anchor = 13;
            gbc.gridy = 0;
            JLabel label = new JLabel();
            label.setText(Messages.getString("SearchReplaceDialog.searchtext"));
            this.jContentPane.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 5, 2);
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 17;
            gbc.gridwidth = 2;
            this.jButtonSuche = new JButton();
            this.jButtonSuche.setText(Messages.getString("SearchReplaceDialog.Search"));
            this.jButtonSuche.setToolTipText(Messages.getString("SearchReplaceDialog.tooltipsearchbutton"));
            this.jButtonSuche.setActionCommand("suche");
            this.jButtonSuche.addActionListener(this);
            this.jContentPane.add((Component)this.jButtonSuche, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 5, 2);
            gbc.gridx = 2;
            gbc.gridy = 5;
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            this.jButtonReplace = new JButton();
            this.jButtonReplace.setText(Messages.getString("SearchReplaceDialog.replace"));
            this.jButtonReplace.setToolTipText(Messages.getString("SearchReplaceDialog.replacetext"));
            this.jButtonReplace.setActionCommand("ersetze");
            this.jButtonReplace.addActionListener(this);
            this.jContentPane.add((Component)this.jButtonReplace, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 5, 10);
            gbc.gridy = 5;
            gbc.anchor = 13;
            gbc.gridx = 3;
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText(Messages.getString("SearchReplaceDialog.cancel"));
            this.jButtonCancel.setActionCommand("abbrechen");
            this.jButtonCancel.addActionListener(this);
            this.jContentPane.add((Component)this.jButtonCancel, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 5, 2, 2);
            gbc.gridx = 0;
            gbc.anchor = 13;
            gbc.gridy = 2;
            label = new JLabel();
            label.setText(Messages.getString("SearchReplaceDialog.replacetextfield"));
            this.jContentPane.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.fill = 2;
            gbc.anchor = 15;
            gbc.gridwidth = 4;
            this.jLabelInfo = new JLabel();
            this.jLabelInfo.setBorder(BorderFactory.createLoweredBevelBorder());
            this.jLabelInfo.setText(Messages.getString("SearchReplaceDialog.status"));
            this.jLabelInfo.setToolTipText(Messages.getString("SearchReplaceDialog.5"));
            this.jContentPane.add((Component)this.jLabelInfo, gbc);
        }
        return this.jContentPane;
    }

    private void startSearch() {
        this.aktCaret = this.editor.getCaretPosition();
        int startPos = this.jCheckBoxAbAnfang.isSelected() ? 0 : this.aktCaret;
        if (this.jTextFieldSearch.getText().equals("")) {
            this.jLabelInfo.setForeground(Color.red);
            this.jLabelInfo.setText(Messages.getString("SearchReplaceDialog.plaesentertext"));
        } else {
            if (this.searchReplaceThread != null) {
                this.searchReplaceThread.interrupt();
                this.searchReplaceThread = null;
            }
            this.searchReplaceThread = new SearchReplaceThread(this.editor, this.jTextFieldSearch.getText(), this.jCheckBoxCaseSensitiv.isSelected(), this.jCheckBoxWholeWords.isSelected(), this.jTextFieldReplace.getText(), this.replaceIsSelected && this.jCheckBoxWithoutAsk.isSelected(), startPos);
            this.searchReplaceThread.start();
        }
    }

    private void jCheckBoxWithoutAsk_stateChanged(ChangeEvent e) {
        if (this.jCheckBoxWithoutAsk.isSelected()) {
            this.jButtonReplace.setText(Messages.getString("SearchReplaceDialog.replaceall"));
        } else {
            this.jButtonReplace.setText(Messages.getString("SearchReplaceDialog.replace"));
        }
        this.pack();
    }

    private void this_keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.cancel();
            }
        }
    }

    private class SearchReplaceThread
    extends Thread {
        Document doc;
        JTextComponent editor;
        String searchString;
        boolean caseSensitiv;
        boolean wholeWord;
        String replaceString;
        boolean replaceAll;
        int startPos;

        SearchReplaceThread(JTextComponent editor, String searchString, boolean caseSensitiv, boolean wholeWord, String replaceString, boolean replaceAll, int startPos) {
            this.doc = editor.getDocument();
            this.editor = editor;
            this.searchString = searchString;
            this.caseSensitiv = caseSensitiv;
            this.wholeWord = wholeWord;
            this.replaceString = replaceString;
            this.replaceAll = replaceAll;
            this.startPos = startPos;
        }

        private boolean checkIsLetter(char c) {
            boolean isLetter = false;
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '\u00e4' || c == '\u00f6' || c == '\u00fc' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc' || c >= '0' && c <= '9') {
                isLetter = true;
            }
            return isLetter;
        }

        private int indexOfWholeWord(String text, String searchText, int start) {
            int i = -1;
            int pos = start;
            boolean ready = false;
            if (text.length() > 0 && text.length() >= searchText.length()) {
                while (!ready) {
                    i = text.indexOf(searchText, pos);
                    if (i != -1) {
                        pos = i;
                        if (i > 0 && this.checkIsLetter(text.charAt(i - 1))) {
                            i = -1;
                        }
                        if (i + searchText.length() < text.length() && this.checkIsLetter(text.charAt(i + searchText.length()))) {
                            i = -1;
                        }
                        if (i != -1) {
                            ready = true;
                            continue;
                        }
                        if (++pos < text.length()) continue;
                        ready = true;
                        i = -1;
                        continue;
                    }
                    ready = true;
                }
            }
            return i;
        }

        private int indexOfWholeWord(StringBuilder text, String searchText, int start) {
            int i = -1;
            int pos = start;
            boolean ready = false;
            if (text.length() > 0 && text.length() >= searchText.length()) {
                while (!ready) {
                    i = text.indexOf(searchText, pos);
                    if (i != -1) {
                        pos = i;
                        if (i > 0 && this.checkIsLetter(text.charAt(i - 1))) {
                            i = -1;
                        }
                        if (i + searchText.length() < text.length() && this.checkIsLetter(text.charAt(i + searchText.length()))) {
                            i = -1;
                        }
                        if (i != -1) {
                            ready = true;
                            continue;
                        }
                        if (++pos < text.length()) continue;
                        ready = true;
                        i = -1;
                        continue;
                    }
                    ready = true;
                }
            }
            return i;
        }

        private int findNextOccurence(int start, String completeText) {
            int i = -1;
            if (this.caseSensitiv) {
                i = this.wholeWord ? this.indexOfWholeWord(completeText, this.searchString, start) : completeText.indexOf(this.searchString, start);
            } else {
                String lowerText = completeText;
                String lowerSuchtext = this.searchString;
                lowerText = lowerText.toLowerCase();
                lowerSuchtext = lowerSuchtext.toLowerCase();
                i = this.wholeWord ? this.indexOfWholeWord(lowerText, lowerSuchtext, start) : lowerText.indexOf(lowerSuchtext, start);
            }
            return i;
        }

        private int findNextOccurence(int start, StringBuilder completeText) {
            int i = -1;
            if (this.caseSensitiv) {
                i = this.wholeWord ? this.indexOfWholeWord(completeText, this.searchString, start) : completeText.indexOf(this.searchString, start);
            } else {
                String lowerText = completeText.toString().toLowerCase();
                String lowerSuchtext = this.searchString;
                lowerSuchtext = lowerSuchtext.toLowerCase();
                i = this.wholeWord ? this.indexOfWholeWord(lowerText, lowerSuchtext, start) : lowerText.indexOf(lowerSuchtext, start);
            }
            return i;
        }

        @Override
        public void run() {
            SearchReplaceDialog.this.jLabelInfo.setForeground(Color.black);
            SearchReplaceDialog.this.jLabelInfo.setText(Messages.getString("SearchReplaceDialog.searchatpos") + " " + this.startPos + " ... ");
            SearchReplaceDialog.this.jButtonSuche.setEnabled(false);
            SearchReplaceDialog.this.jButtonReplace.setEnabled(false);
            try {
                if (this.replaceAll) {
                    StringBuilder sb = new StringBuilder(this.editor.getText(0, this.doc.getLength()));
                    int i = this.findNextOccurence(this.startPos, sb);
                    int countReplacements = 0;
                    int lastPos = 0;
                    while (i != -1) {
                        if (this.isInterrupted()) {
                            SearchReplaceDialog.this.jButtonSuche.setEnabled(true);
                            SearchReplaceDialog.this.jButtonReplace.setEnabled(true);
                            return;
                        }
                        SearchReplaceDialog.this.jLabelInfo.setText(Messages.getString("SearchReplaceDialog.foundedatpos") + " " + (i + 1));
                        lastPos = i;
                        sb.replace(i, i + this.searchString.length(), this.replaceString);
                        ++countReplacements;
                        this.startPos = i + this.replaceString.length();
                        i = this.findNextOccurence(this.startPos, sb);
                    }
                    this.editor.setText(sb.toString());
                    this.editor.repaint();
                    this.editor.setCaretPosition(lastPos);
                    SearchReplaceDialog.this.jLabelInfo.setForeground(Color.black);
                    SearchReplaceDialog.this.jLabelInfo.setText(SearchReplaceDialog.this.jLabelInfo.getText() + countReplacements + " " + Messages.getString("SearchReplaceDialog.replacesexecuted"));
                } else {
                    int i = this.findNextOccurence(this.startPos, this.editor.getText(0, this.doc.getLength()));
                    if (i == -1) {
                        SearchReplaceDialog.this.jLabelInfo.setForeground(Color.blue);
                        SearchReplaceDialog.this.jLabelInfo.setText(SearchReplaceDialog.this.jLabelInfo.getText() + " " + Messages.getString("SearchReplaceDialog.searchtextfounded"));
                    } else {
                        SearchReplaceDialog.this.jCheckBoxAbAnfang.setSelected(false);
                        SearchReplaceDialog.this.jLabelInfo.setForeground(Color.black);
                        SearchReplaceDialog.this.jLabelInfo.setText(SearchReplaceDialog.this.jLabelInfo.getText() + Messages.getString("SearchReplaceDialog.foundedatpos") + " " + (i + 1));
                        this.editor.select(i, i + this.searchString.length());
                        this.editor.repaint();
                    }
                }
                SearchReplaceDialog.this.jButtonSuche.setEnabled(true);
                SearchReplaceDialog.this.jButtonReplace.setEnabled(true);
                SearchReplaceDialog.this.jButtonSuche.requestFocus();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

