/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import sqlrunner.editor.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class GotoLineDialog
extends JDialog
implements ActionListener,
KeyListener {
    private final Logger logger = Logger.getLogger(GotoLineDialog.class);
    private static final long serialVersionUID = 1L;
    private JTextField textFieldIndex;
    private JButton buttonJumpToLine;
    private JButton buttonJumpToPos;
    private JLabel jLabelResult;
    private JButton buttonClose;
    private int destLine;
    private JTextComponent editor;

    public GotoLineDialog(Frame frame, String title, JTextComponent editor) {
        super(frame, title, false);
        this.editor = editor;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.anchor = 13;
        gbc.insets = new Insets(10, 5, 2, 2);
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("GotoLineDialog.label"));
        this.getContentPane().add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 2, 2, 10);
        this.textFieldIndex = new JTextField();
        this.textFieldIndex.addKeyListener(this);
        this.textFieldIndex.requestFocus();
        this.getContentPane().add((Component)this.textFieldIndex, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.insets = new Insets(10, 2, 2, 10);
        gbc.anchor = 17;
        this.buttonJumpToLine = new JButton();
        this.buttonJumpToLine.setText(Messages.getString("GotoLineDialog.gotoline"));
        this.buttonJumpToLine.setActionCommand("gotoline");
        this.buttonJumpToLine.addActionListener(this);
        this.getContentPane().add((Component)this.buttonJumpToLine, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.insets = new Insets(10, 2, 2, 10);
        gbc.anchor = 13;
        this.buttonJumpToPos = new JButton();
        this.buttonJumpToPos.setText(Messages.getString("GotoLineDialog.gotoposition"));
        this.buttonJumpToPos.setActionCommand("gotoposition");
        this.buttonJumpToPos.addActionListener(this);
        this.getContentPane().add((Component)this.buttonJumpToPos, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.insets = new Insets(2, 2, 10, 2);
        gbc.fill = 2;
        gbc.gridwidth = 2;
        this.jLabelResult = new JLabel();
        this.jLabelResult.setText(" ");
        this.getContentPane().add((Component)this.jLabelResult, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridx = 1;
        gbc.insets = new Insets(2, 2, 10, 10);
        gbc.anchor = 13;
        this.buttonClose = new JButton();
        this.buttonClose.setText(Messages.getString("GotoLineDialog.cancel"));
        this.buttonClose.setActionCommand("close");
        this.buttonClose.addActionListener(this);
        this.getContentPane().add((Component)this.buttonClose, gbc);
        this.getRootPane().setDefaultButton(this.buttonJumpToLine);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("gotoline") && this.jumpToLine()) {
            this.close();
        }
        if (e.getActionCommand().equals("gotoposition") && this.jumpToPosition()) {
            this.close();
        }
        if (e.getActionCommand().equals("close")) {
            this.close();
        }
    }

    private void editLineNumber_keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 10: {
                if (!this.jumpToLine()) break;
            }
            case 27: {
                this.close();
            }
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.close();
                break;
            }
            case 205: {
                this.textFieldIndex.requestFocus();
                this.textFieldIndex.selectAll();
                this.jLabelResult.setText(" ");
            }
        }
        super.processWindowEvent(e);
    }

    private void close() {
        this.setVisible(false);
    }

    private boolean jumpToPosition() {
        try {
            int pos = Integer.parseInt(this.textFieldIndex.getText());
            int selectionStart = this.editor.getSelectionStart();
            int selectionEnd = this.editor.getSelectionEnd();
            if (selectionStart < selectionEnd) {
                pos += selectionStart;
            }
            this.editor.setCaretPosition(pos);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jumpToLine() {
        boolean ok = false;
        Document doc = this.editor.getDocument();
        if (doc.getLength() == 0) {
            this.jLabelResult.setForeground(Color.red);
            this.jLabelResult.setText(Messages.getString("GotoLineDialog.emptydoc"));
        } else {
            this.buttonJumpToLine.setEnabled(false);
            try {
                this.destLine = Integer.parseInt(this.textFieldIndex.getText()) - 1;
                if (this.destLine < 0) {
                    throw new NumberFormatException("0");
                }
                Element root = doc.getDefaultRootElement();
                Element elem = root.getElement(this.destLine);
                if (elem == null) {
                    this.jLabelResult.setForeground(Color.red);
                    this.jLabelResult.setText(Messages.getString("GotoLineDialog.linenotexist"));
                    this.textFieldIndex.selectAll();
                    this.textFieldIndex.requestFocus();
                } else {
                    int p0 = elem.getStartOffset();
                    this.editor.setCaretPosition(p0);
                    this.jLabelResult.setForeground(Color.black);
                    this.jLabelResult.setText(Messages.getString("GotoLineDialog.atpos") + " " + p0 + Messages.getString("GotoLineDialog.founded"));
                    ok = true;
                }
            }
            catch (NumberFormatException nfe) {
                this.jLabelResult.setForeground(Color.red);
                this.jLabelResult.setText(Messages.getString("GotoLineDialog.invalidvalue") + " " + nfe.getMessage());
                this.textFieldIndex.selectAll();
                this.textFieldIndex.requestFocus();
            }
            finally {
                this.buttonJumpToLine.setEnabled(true);
            }
        }
        return ok;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.textFieldIndex) {
            this.editLineNumber_keyPressed(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

