/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.apache.log4j.Logger;
import sqlrunner.MainFrame;
import sqlrunner.editor.ExtEditorPane;

public class ExtEditorTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(ExtEditorTransferHandler.class);
    private static final long serialVersionUID = 1L;
    private transient Position p0 = null;
    private transient Position p1 = null;
    private ExtEditorPane source;
    private boolean shouldRemove;

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (logger.isDebugEnabled()) {
            for (DataFlavor f : flavors) {
                logger.debug((Object)("canImport: checks flavor: " + f));
            }
        }
        if (flavors.length == 0) {
            logger.warn((Object)"canImport: No favors given");
        }
        if (c instanceof ExtEditorPane) {
            if (this.hasFileFlavor(flavors)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"import flavors as file flavor");
                }
                return true;
            }
            if (this.hasStringFlavor(flavors)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"import flavors as string flavor");
                }
                return true;
            }
        } else {
            logger.warn((Object)("target component is not ExtEditorPane! current target: " + c));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"canImport: cannot import flavors");
        }
        return false;
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hasFileFlavor: check flavor: " + flavors[i]));
            }
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStringFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("hasStringFlavor: check flavor: " + flavors[i]));
            }
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        if (!(c instanceof ExtEditorPane) || !this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        ExtEditorPane target = (ExtEditorPane)c;
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                List files;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"handle transferable as files");
                }
                if ((files = (List)t.getTransferData(DataFlavor.javaFileListFlavor)).size() > 0) {
                    File f = (File)files.get(0);
                    MainFrame mainFrame = target.getMainFrame();
                    mainFrame.handleFile(f);
                    return true;
                }
            } else if (this.hasStringFlavor(t.getTransferDataFlavors())) {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                if (str.startsWith("file:/")) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"handle transferable as file uri");
                    }
                    URI uri = null;
                    try {
                        uri = URI.create(str.trim());
                        File f = new File(uri);
                        MainFrame mainFrame = target.getMainFrame();
                        mainFrame.handleFile(f);
                    }
                    catch (Exception e) {
                        logger.error((Object)("handle transferable as file uri failed: str=" + str + " uri=" + uri), (Throwable)e);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"handle transferable as text content");
                    }
                    if (target == this.source && target.getCaretPosition() >= this.p0.getOffset() && target.getCaretPosition() <= this.p1.getOffset()) {
                        this.shouldRemove = false;
                        return true;
                    }
                    if (str != null) {
                        str = str.replace("\u0000", "");
                    }
                    target.replaceSelection(str);
                }
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)("unsuppported dragged data flavor: " + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        int end;
        if (!(c instanceof ExtEditorPane)) {
            return null;
        }
        this.source = (ExtEditorPane)c;
        int start = this.source.getSelectionStart();
        if (start == (end = this.source.getSelectionEnd())) {
            return null;
        }
        try {
            Document doc = this.source.getDocument();
            this.p0 = doc.createPosition(start);
            this.p1 = doc.createPosition(end);
        }
        catch (BadLocationException e) {
            logger.error((Object)("text cannot moved: " + e.getMessage()));
        }
        this.shouldRemove = true;
        String data = this.source.getSelectedText();
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        if (this.shouldRemove && action == 2 && this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
            try {
                ExtEditorPane sourceLoc = (ExtEditorPane)c;
                sourceLoc.getDocument().remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
            }
            catch (BadLocationException e) {
                logger.error((Object)("text cannot be deleted: " + e.getMessage()));
            }
        }
        this.source = null;
    }
}

