/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.base64;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.base64.Base64;

public class Base64Viewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Base64Viewer.class);
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JPanel jPanel = null;
    private JButton jButtonEncode = null;
    private JButton jButtonDecode = null;
    private JCheckBox jCheckBoxBinaryData = null;
    private JComboBox jComboBoxCharSet = null;

    public Base64Viewer() {
        this.initialize();
    }

    private void initialize() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Base64 transcoder");
        this.setContentPane(this.getJContentPane());
        this.pack();
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "South");
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTextArea());
            this.jScrollPane.setPreferredSize(new Dimension(400, 100));
        }
        return this.jScrollPane;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
            this.jTextArea.setLineWrap(true);
        }
        return this.jTextArea;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.insets = new Insets(2, 2, 2, 2);
            gb.gridy = 0;
            gb.gridx = 0;
            this.jPanel.add((Component)this.getJButtonEncode(), gb);
            gb.gridy = 0;
            gb.gridx = 1;
            this.jPanel.add((Component)this.getJComboBoxCharSet(), gb);
            gb.gridy = 0;
            gb.gridx = 2;
            this.jPanel.add((Component)this.getJButtonDecode(), gb);
            gb.gridy = 0;
            gb.gridx = 3;
            this.jPanel.add((Component)this.getJCheckBoxBinaryData(), gb);
        }
        return this.jPanel;
    }

    private JComboBox getJComboBoxCharSet() {
        if (this.jComboBoxCharSet == null) {
            this.jComboBoxCharSet = new JComboBox();
            this.jComboBoxCharSet.setEditable(true);
            this.jComboBoxCharSet.addItem("UTF-8");
            this.jComboBoxCharSet.addItem("UTF-16");
            this.jComboBoxCharSet.addItem("ISO-8859-1");
            this.jComboBoxCharSet.addItem("ISO-8859-15");
            this.jComboBoxCharSet.addItem("Cp1251");
            this.jComboBoxCharSet.addItem("MacRoman");
        }
        return this.jComboBoxCharSet;
    }

    private JButton getJButtonEncode() {
        if (this.jButtonEncode == null) {
            this.jButtonEncode = new JButton();
            this.jButtonEncode.setText("encode");
            this.jButtonEncode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Base64Viewer.this.jCheckBoxBinaryData.isSelected()) {
                        Base64Viewer.this.readBinaryData();
                    } else {
                        String text = Base64Viewer.cleanBase64String(Base64Viewer.this.jTextArea.getText());
                        if (text != null && text.length() > 0) {
                            try {
                                Base64Viewer.this.jTextArea.setText(Base64.toString(Base64.encode(text.getBytes((String)Base64Viewer.this.jComboBoxCharSet.getSelectedItem())), true));
                            }
                            catch (UnsupportedEncodingException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        return this.jButtonEncode;
    }

    private JButton getJButtonDecode() {
        if (this.jButtonDecode == null) {
            this.jButtonDecode = new JButton();
            this.jButtonDecode.setText("decode");
            this.jButtonDecode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Base64Viewer.this.jCheckBoxBinaryData.isSelected()) {
                        Base64Viewer.this.writeBinaryData();
                    } else {
                        String text = Base64Viewer.this.jTextArea.getText();
                        if (text != null && text.length() > 0) {
                            try {
                                Base64Viewer.this.jTextArea.setText(Base64.getText(text, (String)Base64Viewer.this.jComboBoxCharSet.getSelectedItem()));
                            }
                            catch (UnsupportedEncodingException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        return this.jButtonDecode;
    }

    private void writeBinaryData() {
        String base64EncodedData = Base64Viewer.cleanBase64String(this.jTextArea.getText());
        if (base64EncodedData != null && base64EncodedData.length() > 0) {
            JFileChooser chooser = new JFileChooser();
            String fileName = Main.getUserProperty("BASE64_FILE", System.getProperty("user.home"));
            chooser.setCurrentDirectory(new File(fileName).getParentFile());
            chooser.setSelectedFile(new File(fileName));
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle("decoded base64 data");
            int returnVal = chooser.showSaveDialog(this);
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                Main.setUserProperty("BASE64_FILE", f.getAbsolutePath());
                byte[] binaryData = Base64.decode(base64EncodedData.getBytes());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("decode and write file " + f.getAbsolutePath() + " length=" + binaryData.length));
                }
                try {
                    FileOutputStream fout = new FileOutputStream(f);
                    fout.write(binaryData);
                    fout.close();
                }
                catch (IOException e) {
                    logger.error((Object)("writeBinaryData failed: " + e.getMessage()), (Throwable)e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error while writing file", 0);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "no base64 data in text field", "decode", 1);
        }
    }

    private void readBinaryData() {
        JFileChooser chooser = new JFileChooser();
        String fileName = Main.getUserProperty("BASE64_FILE", System.getProperty("user.home"));
        chooser.setCurrentDirectory(new File(fileName).getParentFile());
        chooser.setSelectedFile(new File(fileName));
        chooser.setDialogType(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("encode base64 data");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            Main.setUserProperty("BASE64_FILE", f.getAbsolutePath());
            long filesize = f.length();
            if (filesize < Integer.MAX_VALUE) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("read und encode file " + f.getAbsolutePath() + " length=" + filesize));
                }
                byte[] binaryData = new byte[(int)filesize];
                try {
                    FileInputStream fin = new FileInputStream(f);
                    int nbytes = fin.read(binaryData);
                    fin.close();
                    byte[] base64EncodedData = Base64.encode(binaryData, nbytes);
                    this.jTextArea.setText(Base64.toString(base64EncodedData, true));
                }
                catch (IOException e) {
                    logger.error((Object)("readBinaryData failed: " + e.getMessage()), (Throwable)e);
                    JOptionPane.showMessageDialog(this, e.getMessage(), "Error while reading", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "File size to large.\nThis fnction can handle only files with a size until 2147483647 bytes.", "Read file and encode", 1);
            }
        }
    }

    private static String cleanBase64String(String base64EncodedText) {
        StringBuffer sb = new StringBuffer(base64EncodedText.length());
        for (int i = 0; i < base64EncodedText.length(); ++i) {
            char c = base64EncodedText.charAt(i);
            if (c == '\n' || c == ' ' || c == '\t' || c == '\r') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private JCheckBox getJCheckBoxBinaryData() {
        if (this.jCheckBoxBinaryData == null) {
            this.jCheckBoxBinaryData = new JCheckBox();
            this.jCheckBoxBinaryData.setText("binary data");
        }
        return this.jCheckBoxBinaryData;
    }
}

