/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import dbtools.SQLStatement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AdminStatement
extends SQLStatement {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(AdminStatement.class);
    private String comment;
    private int dbType = -1;
    private char command;
    static Vector<AdminStatement> adminSQLs = null;

    public AdminStatement(int dbType, char command, String sql, String comment) {
        super(sql);
        this.dbType = dbType;
        this.hidden = true;
        this.comment = comment;
        this.command = command;
    }

    public int getDbType() {
        return this.dbType;
    }

    public String getComment() {
        return this.comment;
    }

    public char getCommand() {
        return this.command;
    }

    public static synchronized void readAdminSQLs(File f) {
        adminSQLs = new Vector();
        adminSQLs.removeAllElements();
        String line = null;
        String comment_loc = null;
        StringBuffer sql_loc = new StringBuffer();
        int type = -1;
        char command_loc = ' ';
        boolean inSQL = false;
        AdminStatement adminStat = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() <= 4) continue;
                if (line.startsWith("[")) {
                    if (inSQL) {
                        adminStat = new AdminStatement(type, command_loc, sql_loc.toString(), comment_loc);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)adminStat);
                        }
                        adminSQLs.addElement(adminStat);
                        inSQL = false;
                    }
                    int pos0 = line.indexOf(124);
                    type = Integer.parseInt(line.substring(1, pos0).trim());
                    command_loc = line.charAt(pos0 + 1);
                    int pos1 = line.indexOf(93);
                    comment_loc = line.substring(pos0 += 3, pos1).trim();
                    inSQL = true;
                    sql_loc.setLength(0);
                    continue;
                }
                sql_loc.append(line);
                sql_loc.append('\n');
            }
            br.close();
            if (sql_loc.length() > 2) {
                adminStat = new AdminStatement(type, command_loc, sql_loc.toString(), comment_loc);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)adminStat);
                }
                adminSQLs.addElement(adminStat);
            }
        }
        catch (IOException ioe) {
            System.err.println("SQLAdminStatement.readAdminSQLs:" + ioe.toString());
        }
    }

    static AdminStatement getSQLAdminStatement(String name) {
        AdminStatement as = null;
        for (int i = 0; i < adminSQLs.size() && !name.equals((as = adminSQLs.elementAt(i)).getComment()); ++i) {
            as = null;
        }
        return as;
    }

    @Override
    public String toString() {
        return this.comment;
    }

    @Override
    public int hashCode() {
        return adminSQLs.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

