/*
 * Decompiled with CFR 0.152.
 */
package dbtools;

import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sqlrunner.text.StringReplacer;

public final class SQLParser {
    private static final Logger logger = Logger.getLogger(SQLParser.class);
    private List<SQLStatement> parsedStatements;
    protected int blockCount;
    private boolean parserDisabled = false;
    public static final int PL_SQL = 0;
    private boolean isPLSQL = false;
    private boolean autoDetectPLSQL = true;
    static int maxTextStringLength = 0;
    static String[] plsqlKeyWords;

    public SQLParser() {
    }

    public SQLParser(String text) {
        this.parseScript(text);
    }

    public SQLParser(File file, String charset) throws IOException {
        String sql = SQLParser.readSQLFile(file, charset);
        this.parseScript(sql);
    }

    public SQLParser(String text, boolean disableParser) {
        this.parserDisabled = disableParser;
        this.parseScript(text);
    }

    public SQLParser(String text, boolean disableParser, boolean enableAutoDetectPLSQL) {
        this.parserDisabled = disableParser;
        this.autoDetectPLSQL = enableAutoDetectPLSQL;
        this.parseScript(text);
    }

    private void initParser() {
        this.parsedStatements = new ArrayList<SQLStatement>();
        this.isPLSQL = false;
        this.blockCount = 0;
    }

    public void disableParser(boolean disable) {
        this.parserDisabled = disable;
    }

    public boolean isParserDisabled() {
        return this.parserDisabled;
    }

    public String parseScript(String text) {
        return this.parseScript(text, 0);
    }

    public String parseScript(String text, int textOffset) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Start parsing script...");
        }
        this.initParser();
        if (text == null) {
            throw new IllegalArgumentException("sql code cannot be null");
        }
        StringBuilder temp = new StringBuilder();
        if (this.parserDisabled) {
            SQLStatement.resetIndex();
            SQLStatement sql = new SQLStatement(text);
            sql.setTextRange(0, text.length());
            this.parsedStatements.add(sql);
        } else if (text.length() > 1) {
            SQLStatement sql;
            int i;
            SQLStatement.resetIndex();
            boolean inStringConstant = false;
            boolean inLineComment = false;
            boolean inBlockComment = false;
            boolean endOfStatement = true;
            int c0 = 10;
            char c1 = '\n';
            int as = 0;
            boolean isPreparedStatement = false;
            boolean hasNamedParams = false;
            boolean plsql = false;
            boolean plsqlTested = false;
            for (i = 0; i < text.length(); ++i) {
                if (i > 0) {
                    c0 = text.charAt(i - 1);
                }
                char c = text.charAt(i);
                c1 = i < text.length() - 1 ? (char)text.charAt(i + 1) : (char)' ';
                if (!(inStringConstant || inLineComment || inBlockComment)) {
                    if (c == '\'' && c0 != 92) {
                        inStringConstant = true;
                        temp.append(c);
                        continue;
                    }
                    if (c == '/' && c1 == '*') {
                        inBlockComment = true;
                        ++i;
                        temp.append(c);
                        temp.append(c1);
                        continue;
                    }
                    if (c == '-' && c1 == '-') {
                        inLineComment = true;
                        ++i;
                        temp.append(' ');
                        temp.append(' ');
                        continue;
                    }
                    if (c == ';' || c0 == 10 && c == '/' && Character.isWhitespace(c1)) {
                        String sqlStr;
                        if (c == ';') {
                            if (plsql) {
                                temp.append(c);
                            } else {
                                endOfStatement = true;
                            }
                        } else if (plsql && c0 == 10 && c == '/' && Character.isWhitespace(c1)) {
                            endOfStatement = true;
                        }
                        if (i == text.length() - 1) {
                            endOfStatement = true;
                        }
                        if (!endOfStatement) continue;
                        if (isPreparedStatement && !plsql) {
                            sqlStr = temp.toString().trim();
                            if (!sqlStr.isEmpty()) {
                                sql = new SQLStatement(sqlStr);
                                sql.setPrepared(true);
                                sql.setHasNamedParams(hasNamedParams);
                                SQLParser.setupPreparedStatementParams(sql);
                                sql.setTextRange(textOffset + as, textOffset + i);
                                this.parsedStatements.add(sql);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("add statement (" + this.parsedStatements.size() + ") " + " code=" + sql.getSQL()));
                                }
                            } else if (logger.isDebugEnabled()) {
                                logger.debug((Object)"skip empty statement");
                            }
                        } else {
                            sqlStr = temp.toString().trim();
                            if (!sqlStr.isEmpty()) {
                                sql = new SQLStatement(temp.toString().trim());
                                sql.setTextRange(textOffset + as, textOffset + i);
                                this.parsedStatements.add(sql);
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("add statement (" + this.parsedStatements.size() + ") " + " code=" + sql.getSQL()));
                                }
                            } else if (logger.isDebugEnabled()) {
                                logger.debug((Object)"skip empty statement");
                            }
                        }
                        temp.setLength(0);
                        plsql = false;
                        continue;
                    }
                    if (endOfStatement) {
                        if (!Character.isWhitespace(c) && !(c0 == 10 && c == '/' && Character.isWhitespace(c1)) && c != ';') {
                            endOfStatement = false;
                            temp.append(c);
                            as = i;
                            plsqlTested = false;
                        }
                        if (plsqlTested) continue;
                        if (this.testForPLSQL(text, i)) {
                            plsql = true;
                        }
                        plsqlTested = true;
                        continue;
                    }
                    if (c == '?') {
                        isPreparedStatement = true;
                    } else if (c0 != 58 && c == ':' && Character.isLetter(c1)) {
                        isPreparedStatement = true;
                        hasNamedParams = true;
                    }
                    temp.append(c);
                    continue;
                }
                if (inLineComment) {
                    if (c == '\n') {
                        inLineComment = false;
                        temp.append(c);
                        continue;
                    }
                    temp.append(' ');
                    continue;
                }
                if (inBlockComment) {
                    if (c == '*' && c1 == '/') {
                        inBlockComment = false;
                        ++i;
                        temp.append(c);
                        temp.append(c1);
                        continue;
                    }
                    temp.append(c);
                    continue;
                }
                if (!inStringConstant) continue;
                if (c == '\'' && c0 != 92) {
                    inStringConstant = false;
                }
                temp.append(c);
            }
            if (!endOfStatement && i == text.length()) {
                String remainingText = temp.toString().trim();
                if (this.autoDetectPLSQL && this.testForPLSQL(remainingText.toUpperCase(), 0)) {
                    plsql = true;
                } else if (remainingText.length() > 2) {
                    if (isPreparedStatement) {
                        SQLStatement statement = new SQLStatement(remainingText);
                        statement.setPrepared(true);
                        SQLParser.setupPreparedStatementParams(statement);
                        statement.setTextRange(textOffset + as, textOffset + i - 1);
                        this.parsedStatements.add(statement);
                    } else {
                        sql = new SQLStatement(remainingText);
                        sql.setTextRange(textOffset + as, textOffset + i - 1);
                        this.parsedStatements.add(sql);
                    }
                }
            }
            this.isPLSQL = plsql;
        }
        return temp.toString();
    }

    public static int[] findOppositeParenthese(int currPos, String text) {
        int[] bracketPositions = new int[]{-1, -1};
        if (text.length() == 0) {
            return bracketPositions;
        }
        int bracketCounter = 0;
        int c = 32;
        if (currPos < text.length()) {
            c = text.charAt(currPos);
        }
        int c0 = 32;
        if (currPos > 0) {
            c0 = text.charAt(currPos - 1);
        }
        boolean searchForwards = false;
        if (c0 == 41) {
            searchForwards = false;
            bracketPositions[1] = --currPos;
        } else if (c0 == 40) {
            searchForwards = true;
            bracketPositions[0] = --currPos;
        } else if (c == 40) {
            searchForwards = true;
            bracketPositions[0] = currPos;
        } else if (c == 41) {
            searchForwards = false;
            bracketPositions[1] = currPos;
        } else {
            return bracketPositions;
        }
        boolean inLineComment = false;
        boolean inBlockComment = false;
        boolean inString = false;
        if (searchForwards) {
            for (int i = currPos + 1; i < text.length(); ++i) {
                c = text.charAt(i);
                int c1 = i < text.length() - 1 ? (int)text.charAt(i + 1) : 32;
                if (!inString && c == 39) {
                    inString = true;
                    continue;
                }
                if (!inBlockComment && c == 47 && c1 == 42) {
                    inBlockComment = true;
                    continue;
                }
                if (!inLineComment && c == 45 && c1 == 45) {
                    inLineComment = true;
                    continue;
                }
                if (!(inLineComment || inBlockComment || inString)) {
                    if (c == 41) {
                        if (bracketCounter == 0) {
                            bracketPositions[1] = i;
                            break;
                        }
                        if (bracketCounter <= 0) continue;
                        --bracketCounter;
                        continue;
                    }
                    if (c != 40) continue;
                    ++bracketCounter;
                    continue;
                }
                if (c == 10) {
                    inLineComment = false;
                    inString = false;
                    continue;
                }
                if (inBlockComment && c == 42 && c1 == 47) {
                    inBlockComment = false;
                    continue;
                }
                if (!inString || c != 39) continue;
                inString = false;
            }
        } else {
            for (int i = currPos - 1; i >= 0; --i) {
                c = text.charAt(i);
                int c1 = i < text.length() - 1 ? (int)text.charAt(i + 1) : 32;
                if (!inString && c == 39) {
                    inString = true;
                    continue;
                }
                if (c == 10) {
                    inString = false;
                    int lineCommentStart = SQLParser.findLineCommentStartBackwards(i - 1, text);
                    if (lineCommentStart == -1) continue;
                    inLineComment = true;
                    continue;
                }
                if (!inBlockComment && c == 42 && c1 == 47) {
                    inBlockComment = true;
                    continue;
                }
                if (!(inLineComment || inBlockComment || inString)) {
                    if (c == 40) {
                        if (bracketCounter == 0) {
                            bracketPositions[0] = i;
                            break;
                        }
                        if (bracketCounter <= 0) continue;
                        --bracketCounter;
                        continue;
                    }
                    if (c != 41) continue;
                    ++bracketCounter;
                    continue;
                }
                if (inLineComment && c == 45 && c1 == 45) {
                    inLineComment = false;
                    continue;
                }
                if (inBlockComment && c == 47 && c1 == 42) {
                    inBlockComment = false;
                    continue;
                }
                if (!inString || c != 39) continue;
                inString = false;
            }
        }
        return bracketPositions;
    }

    public static int findOppositeToken(int currPos, String text, String startToken, String endToken) {
        int oppositePos;
        block18: {
            boolean inString;
            boolean inBlockComment;
            boolean inLineComment;
            char c;
            int bracketCounter;
            block19: {
                oppositePos = -1;
                bracketCounter = 0;
                if (--currPos <= 0) break block18;
                c = text.charAt(currPos);
                inLineComment = false;
                inBlockComment = false;
                inString = false;
                if (c != '(') break block19;
                for (int i = currPos + 1; i < text.length(); ++i) {
                    c = text.charAt(i);
                    int c1 = i < text.length() - 1 ? (int)text.charAt(i + 1) : 32;
                    if (!inString && c == '\'') {
                        inString = true;
                        continue;
                    }
                    if (!inBlockComment && c == '/' && c1 == 42) {
                        inBlockComment = true;
                        continue;
                    }
                    if (!inLineComment && c == '-' && c1 == 45) {
                        inLineComment = true;
                        continue;
                    }
                    if (!(inLineComment || inBlockComment || inString)) {
                        if (c == ')') {
                            if (bracketCounter == 0) {
                                oppositePos = i;
                                break block18;
                            }
                            if (bracketCounter <= 0) continue;
                            --bracketCounter;
                            continue;
                        }
                        if (c != '(') continue;
                        ++bracketCounter;
                        continue;
                    }
                    if (c == '\n') {
                        inLineComment = false;
                        inString = false;
                        continue;
                    }
                    if (inBlockComment && c == '*' && c1 == 47) {
                        inBlockComment = false;
                        continue;
                    }
                    if (!inString || c != '\'') continue;
                    inString = false;
                }
                break block18;
            }
            if (c != ')') break block18;
            for (int i = currPos - 1; i >= 0; --i) {
                c = text.charAt(i);
                int c1 = i < text.length() - 1 ? (int)text.charAt(i + 1) : 32;
                if (!inString && c == '\'') {
                    inString = true;
                    continue;
                }
                if (c == '\n') {
                    inString = false;
                    int lineCommentStart = SQLParser.findLineCommentStartBackwards(i - 1, text);
                    if (lineCommentStart == -1) continue;
                    inLineComment = true;
                    continue;
                }
                if (!inBlockComment && c == '*' && c1 == 47) {
                    inBlockComment = true;
                    continue;
                }
                if (!(inLineComment || inBlockComment || inString)) {
                    if (c == '(') {
                        if (bracketCounter == 0) {
                            oppositePos = i;
                            break;
                        }
                        if (bracketCounter <= 0) continue;
                        --bracketCounter;
                        continue;
                    }
                    if (c != ')') continue;
                    ++bracketCounter;
                    continue;
                }
                if (inLineComment && c == '-' && c1 == 45) {
                    inLineComment = false;
                    continue;
                }
                if (inBlockComment && c == '/' && c1 == 42) {
                    inBlockComment = false;
                    continue;
                }
                if (!inString || c != '\'') continue;
                inString = false;
            }
        }
        return oppositePos;
    }

    public static int findLineCommentStartBackwards(int currPos, String text) {
        int commentStart = -1;
        boolean inString = false;
        for (int i = currPos; i >= 0; --i) {
            char c = text.charAt(i);
            int c1 = i < text.length() - 1 ? (int)text.charAt(i + 1) : 32;
            if (c == '\n') break;
            if (!inString && c == '\'') {
                inString = true;
                continue;
            }
            if (inString && c == '\'') {
                inString = false;
                continue;
            }
            if (inString || c != '-' || c1 != 45) continue;
            commentStart = i + 1;
            break;
        }
        return commentStart;
    }

    private boolean testForPLSQL(String text, int startPos) {
        String test = null;
        test = startPos + maxTextStringLength <= text.length() ? text.substring(startPos, startPos + maxTextStringLength).trim().toUpperCase() : text.substring(startPos).trim().toUpperCase();
        boolean testResult = false;
        for (int i = 0; i < plsqlKeyWords.length; ++i) {
            if (!test.startsWith(plsqlKeyWords[i])) continue;
            testResult = true;
            break;
        }
        return testResult;
    }

    public boolean isPLSQL() {
        return this.isPLSQL;
    }

    public int getStatementCount() {
        return this.parsedStatements.size();
    }

    public List<SQLStatement> getStatements() {
        return this.parsedStatements;
    }

    public SQLStatement getStatementAt(int index) {
        return this.parsedStatements.get(index);
    }

    public void printDebugData() {
        for (int i = 0; i < this.parsedStatements.size(); ++i) {
            System.out.println(this.parsedStatements.get(i));
        }
    }

    public static String getTableForQuery(SQLStatement stat) {
        int p0;
        String sql = stat.getSQL();
        sql = sql.replace('\n', ' ');
        sql = sql.replace('\r', ' ');
        sql = sql.replace('\t', ' ');
        sql = SQLParser.removeAllComments(sql);
        int bracketCounter = 0;
        boolean inString = false;
        boolean prevCharIsSpace = false;
        boolean inWord = false;
        StringBuffer sb = new StringBuffer();
        for (p0 = sql.indexOf(32); p0 < sql.length(); ++p0) {
            char c = sql.charAt(p0);
            if (c == '(') {
                ++bracketCounter;
                inWord = false;
                prevCharIsSpace = false;
                continue;
            }
            if (c == ')') {
                --bracketCounter;
                inWord = false;
                prevCharIsSpace = false;
                continue;
            }
            if (Character.isSpaceChar(c)) {
                if (bracketCounter == 0) {
                    prevCharIsSpace = true;
                }
                if (inWord && sb.toString().toLowerCase().equals("from")) break;
                inWord = false;
                continue;
            }
            if (c == '\'') {
                inString = !inString;
                inWord = false;
                prevCharIsSpace = false;
                continue;
            }
            if (!Character.isLetter(c)) continue;
            if (!inString && bracketCounter == 0) {
                if (prevCharIsSpace) {
                    sb.setLength(0);
                }
                if (prevCharIsSpace || inWord) {
                    inWord = true;
                    sb.append(c);
                }
            }
            prevCharIsSpace = false;
        }
        if (p0 != -1) {
            if ((sql = sql.substring(p0, sql.length()).trim()).length() > 0) {
                if (sql.charAt(0) == '(') {
                    p0 = sql.indexOf(41) + 1;
                } else {
                    p0 = sql.indexOf(32);
                    if (p0 == -1 && (p0 = sql.indexOf(59)) == -1) {
                        p0 = sql.length();
                    }
                }
                sql = p0 != -1 ? sql.substring(0, p0) : null;
            }
            return sql;
        }
        return null;
    }

    public static String formatSQL(String sql) {
        StringReplacer sr = new StringReplacer(sql.trim());
        sr.replace("\n", " ");
        sr.replace("\r", "");
        sr.replace("\t", " ");
        sql = sr.getResultText();
        if (sql.toLowerCase().startsWith("select")) {
            return SQLParser.formatSelectStatement(sql);
        }
        if (sql.toLowerCase().startsWith("update")) {
            return SQLParser.formatUpdateStatement(sql);
        }
        if (sql.toLowerCase().startsWith("delete")) {
            return SQLParser.formatDeleteStatement(sql);
        }
        return sql;
    }

    public static String formatSelectStatement(String sql) {
        StringBuffer formattedSelect = new StringBuffer();
        formattedSelect.append("select ");
        int pos = sql.indexOf(32);
        if (pos != -1) {
            int p0;
            int bracketCounter = 0;
            boolean inString = false;
            boolean prevCharIsSpace = false;
            boolean inWord = false;
            StringBuffer sb = new StringBuffer();
            for (p0 = sql.indexOf(32); p0 < sql.length(); ++p0) {
                char c = sql.charAt(p0);
                if (c == '(') {
                    ++bracketCounter;
                    inWord = false;
                    prevCharIsSpace = false;
                    continue;
                }
                if (c == ')') {
                    --bracketCounter;
                    inWord = false;
                    prevCharIsSpace = false;
                    continue;
                }
                if (Character.isSpaceChar(c)) {
                    if (bracketCounter == 0) {
                        prevCharIsSpace = true;
                    }
                    if (inWord && sb.toString().equals("from")) break;
                    inWord = false;
                    continue;
                }
                if (c == '\'') {
                    inString = !inString;
                    inWord = false;
                    prevCharIsSpace = false;
                    continue;
                }
                if (!Character.isLetter(c)) continue;
                if (!inString && bracketCounter == 0) {
                    if (prevCharIsSpace) {
                        sb.setLength(0);
                    }
                    if (prevCharIsSpace || inWord) {
                        inWord = true;
                        sb.append(c);
                    }
                }
                prevCharIsSpace = false;
            }
            if (p0 != -1) {
                if ((sql = sql.substring(p0, sql.length()).trim()).length() > 0) {
                    if (sql.charAt(0) == '(') {
                        p0 = sql.indexOf(41) + 1;
                    } else {
                        p0 = sql.indexOf(32);
                        if (p0 == -1 && (p0 = sql.indexOf(59)) == -1) {
                            p0 = sql.length();
                        }
                    }
                    sql = p0 != -1 ? sql.substring(0, p0) : null;
                }
                return sql;
            }
            return null;
        }
        return formattedSelect.toString();
    }

    public static String formatUpdateStatement(String updateSQL) {
        StringBuffer formattedUpdate = new StringBuffer(updateSQL);
        return formattedUpdate.toString();
    }

    public static String formatDeleteStatement(String deleteSQL) {
        StringBuffer formattedDelete = new StringBuffer(deleteSQL);
        return formattedDelete.toString();
    }

    public static String removeAllComments(String sqlcode) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        boolean inStringConstant = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        for (i = 0; i < sqlcode.length(); ++i) {
            char c = sqlcode.charAt(i);
            int c1 = i < sqlcode.length() - 1 ? (int)sqlcode.charAt(i + 1) : 32;
            if (!(inStringConstant || inLineComment || inBlockComment)) {
                if (c == '\'') {
                    inStringConstant = true;
                    sb.append(c);
                    continue;
                }
                if (c == '/' && c1 == 42) {
                    inBlockComment = true;
                    ++i;
                    continue;
                }
                if (c == '-' && c1 == 45) {
                    inLineComment = true;
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (inLineComment) {
                if (c != '\n') continue;
                inLineComment = false;
                sb.append(c);
                continue;
            }
            if (inBlockComment) {
                if (c != '*' || c1 != 47) continue;
                inBlockComment = false;
                ++i;
                continue;
            }
            if (!inStringConstant) continue;
            if (c == '\'') {
                inStringConstant = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String commentPSParameter(String sqlcode) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int paramIndex = 0;
        boolean inStringConstant = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        boolean inParamIndexNumber = false;
        for (i = 0; i < sqlcode.length(); ++i) {
            char c = sqlcode.charAt(i);
            char c1 = i < sqlcode.length() - 1 ? (char)sqlcode.charAt(i + 1) : (char)' ';
            char c2 = i < sqlcode.length() - 2 ? (char)sqlcode.charAt(i + 2) : (char)' ';
            char c3 = i < sqlcode.length() - 3 ? (char)sqlcode.charAt(i + 3) : (char)' ';
            if (!(inStringConstant || inLineComment || inBlockComment)) {
                if (c == '\'') {
                    inStringConstant = true;
                    sb.append(c);
                    continue;
                }
                if (c == '/' && c1 == '*') {
                    inBlockComment = true;
                    ++i;
                    sb.append(c);
                    sb.append(c1);
                    continue;
                }
                if (c == '-' && c1 == '-') {
                    inLineComment = true;
                    ++i;
                    continue;
                }
                sb.append(c);
                if (c != '?') continue;
                if (c1 == '/' && c2 == '*') {
                    inBlockComment = true;
                    sb.append(c1);
                    sb.append(c2);
                    i += 2;
                    if (c3 == '#') {
                        inParamIndexNumber = true;
                        sb.append(c3);
                        sb.append(++paramIndex);
                        ++i;
                        continue;
                    }
                    sb.append('#');
                    sb.append(++paramIndex);
                    sb.append(' ');
                    continue;
                }
                sb.append("/*#");
                sb.append(++paramIndex);
                sb.append("*/");
                continue;
            }
            if (inLineComment) {
                if (c != '\n') continue;
                inLineComment = false;
                sb.append(c);
                continue;
            }
            if (inBlockComment) {
                if (c == '*' && c1 == '/') {
                    inBlockComment = false;
                    inParamIndexNumber = false;
                    ++i;
                    sb.append(c);
                    sb.append(c1);
                    continue;
                }
                if (inParamIndexNumber) {
                    if (c >= '0' && c <= '9') continue;
                    sb.append(c);
                    inParamIndexNumber = false;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (!inStringConstant) continue;
            if (c == '\'') {
                inStringConstant = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void setupPreparedStatementParams(SQLStatement ps) {
        SQLPSParam param = null;
        int c0 = 32;
        int lastParamPos = 0;
        int i = 0;
        int paramIndex = 0;
        boolean inStringConstant = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        boolean inParamComment = false;
        boolean inParamName = false;
        boolean hasNamedParameter = false;
        StringBuffer paramName = new StringBuffer();
        String sqlcode = ps.getSQL();
        for (i = 0; i < sqlcode.length(); ++i) {
            char c = sqlcode.charAt(i);
            char c1 = i < sqlcode.length() - 1 ? (char)sqlcode.charAt(i + 1) : (char)' ';
            if (!(inStringConstant || inLineComment || inBlockComment)) {
                if (c == '\'') {
                    inStringConstant = true;
                    inParamName = false;
                } else if (c == '/' && c1 == '*') {
                    inBlockComment = true;
                    if (lastParamPos == i - 1 && !inParamName) {
                        inParamComment = true;
                    }
                    ++i;
                    paramName = new StringBuffer();
                    inParamName = false;
                } else if (c == '-' && c1 == '-') {
                    inLineComment = true;
                    ++i;
                    inParamName = false;
                } else if (inParamName) {
                    if (Character.isWhitespace(c) || c == ' ' || c == ',') {
                        param.setName(paramName.toString());
                        inParamName = false;
                    } else {
                        paramName.append(c);
                    }
                } else if (c == '?') {
                    param = new SQLPSParam();
                    param.setIndex(++paramIndex);
                    ps.addParam(param);
                    lastParamPos = i;
                    inParamName = false;
                } else if (c0 != 58 && c == ':' && Character.isLetter(c1)) {
                    param = new SQLPSParam();
                    param.setIndex(++paramIndex);
                    param.setNamedParam(true);
                    ps.addParam(param);
                    lastParamPos = i;
                    inParamName = true;
                    paramName = new StringBuffer();
                    hasNamedParameter = true;
                }
            } else if (inLineComment) {
                if (c == '\n') {
                    inLineComment = false;
                }
            } else if (inBlockComment) {
                if (c == '*' && c1 == '/') {
                    inBlockComment = false;
                    ++i;
                    if (inParamComment && param != null) {
                        param.setName(paramName.toString());
                    }
                    inParamComment = false;
                } else if (inParamComment) {
                    paramName.append(c);
                }
            } else if (inStringConstant && c == '\'') {
                inStringConstant = false;
            }
            c0 = c;
        }
        if (inParamName) {
            param.setName(paramName.toString());
        }
        if (hasNamedParameter) {
            String sql = ps.getSQL();
            StringReplacer sr = new StringReplacer(sql);
            for (SQLPSParam p : ps.getParams()) {
                if (!p.isNamedParam()) continue;
                sr.replace(":" + p.getName(), "?");
            }
            ps.setSQL(sr.getResultText());
        }
    }

    public static String removePSComments(String sql) {
        StringBuffer sb = new StringBuffer();
        int currPos = 0;
        boolean inBlockComment = false;
        for (currPos = 0; currPos < sql.length(); ++currPos) {
            char c1;
            char c = sql.charAt(currPos);
            if (inBlockComment) {
                if (c != '*' || currPos >= sql.length() - 1 || (c1 = sql.charAt(currPos + 1)) != '/') continue;
                inBlockComment = false;
                ++currPos;
                continue;
            }
            sb.append(c);
            if (c != '?' || currPos >= sql.length() - 5 || (c1 = sql.charAt(currPos + 1)) != '/' || (c1 = sql.charAt(currPos + 2)) != '*') continue;
            inBlockComment = true;
        }
        return sb.toString();
    }

    public static String extractFileName(String sqlStartCommand, String baseDir) {
        String fileName = null;
        if (sqlStartCommand.startsWith("start")) {
            fileName = sqlStartCommand.substring("start".length() + 1);
        } else if (sqlStartCommand.startsWith("@")) {
            fileName = sqlStartCommand.substring("@".length() + 1);
        } else {
            throw new IllegalArgumentException(sqlStartCommand + " is not a start command");
        }
        if (fileName != null) {
            fileName = fileName.trim();
        }
        boolean absoluteFileName = false;
        if (fileName.startsWith("/") || fileName.startsWith("\\")) {
            absoluteFileName = true;
        }
        if (fileName.indexOf(":\\") != -1 || fileName.indexOf(":/") != -1) {
            absoluteFileName = true;
        }
        String fileSeparator = System.getProperty("file.separator");
        if (!absoluteFileName) {
            fileName = baseDir.endsWith("/") || baseDir.endsWith("\\") ? baseDir + fileName : baseDir + fileSeparator + fileName;
        }
        if (!fileName.toLowerCase().endsWith(".sql")) {
            fileName = fileName + ".sql";
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSQLFile(File f, String charset) throws IOException {
        int CR = 13;
        int LF = 10;
        int LSEP = 8232;
        int PSEP = 8233;
        int NL = 133;
        BufferedReader in = null;
        char[] buffer = new char[8096];
        StringBuffer sb = new StringBuffer(buffer.length);
        try {
            int nch;
            in = charset != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), charset)) : new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            int c0 = 32;
            while ((nch = in.read(buffer, 0, buffer.length)) != -1) {
                for (int i = 0; i < nch; ++i) {
                    int c = buffer[i];
                    if (c == 8232 || c == 8233 || c == 133) {
                        buffer[i] = 10;
                    } else if (c == 10) {
                        buffer[i] = c0 == 13 ? 0 : 10;
                    } else if (c == 13) {
                        buffer[i] = 10;
                    }
                    c0 = c;
                }
                SQLParser.copy(sb, buffer, 0, nch);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return sb.toString();
    }

    private static void copy(StringBuffer sb, char[] buffer, int startPos, int length) {
        for (int i = startPos; i < startPos + length; ++i) {
            char c = buffer[i];
            if (c <= '\u0000') continue;
            sb.append(c);
        }
    }

    static {
        for (String s : plsqlKeyWords = new String[]{"DECLARE", "CREATE OR REPLACE PROCEDURE", "CREATE OR REPLACE FUNCTION", "CREATE OR REPLACE PACKAGE", "CREATE FUNCTION", "CREATE PROCEDURE", "CREATE PACKAGE", "CREATE OR REPLACE TRIGGER", "CREATE TRIGGER", "BEGIN"}) {
            int l = s.length();
            if (l <= maxTextStringLength) continue;
            maxTextStringLength = l;
        }
    }
}

