/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.tabletransfer;

import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import de.jlo.talendcomp.tabletransfer.ColumnValue;
import de.jlo.talendcomp.tabletransfer.DBHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.text.StringReplacer;

public final class TableTransfer {
    private Logger logger = null;
    private Properties properties = new Properties();
    private Connection sourceConnection;
    private Connection targetConnection;
    private SQLStatement targetInsertStatement;
    private Statement sourceSelectStatement;
    private PreparedStatement targetPSInsert;
    private SQLDataModel sourceModel;
    private static final Map<String, SQLDataModel> sqlModelCache = new HashMap<String, SQLDataModel>();
    private SQLDataModel targetModel;
    private SQLTable sourceTable;
    private String sourceQuery;
    private SQLTable targetTable;
    private static final int RETURN_CODE_OK = 0;
    private static final int RETURN_CODE_ERROR_INPUT = 1;
    private static final int RETURN_CODE_ERROR_OUPUT = 1;
    private static final int RETURN_CODE_WARN = 5;
    private int returnCode = 0;
    private String errorMessage;
    private Exception errorException;
    private BlockingQueue<Object> tableQueue;
    private BlockingQueue<Object> fileQueue;
    private final Object closeFlag = new String("The End");
    private List<String> listResultSetFieldNames;
    private List<String> listResultSetFieldTypeNames;
    private Thread readerThread;
    private Thread writerThread;
    private Thread writerBackupThread;
    private volatile int countInserts = 0;
    private volatile int countFileRows = 0;
    private volatile int countRead = 0;
    private volatile boolean runningDb = false;
    private volatile boolean runningFile = false;
    private long startTime;
    public static final String SOURCE_URL = "source.url";
    public static final String SOURCE_USER = "source.user";
    public static final String SOURCE_PASSWORD = "source.password";
    public static final String SOURCE_DRIVER = "source.driverClass";
    public static final String SOURCE_FETCHSIZE = "source.fetchSize";
    public static final String SOURCE_PROPERTIES = "source.properties";
    public static final String SOURCE_TABLE = "source.table";
    public static final String SOURCE_WHERE = "source.whereClause";
    public static final String SOURCE_QUERY = "source.query";
    public static final String TARGET_URL = "target.url";
    public static final String TARGET_USER = "target.user";
    public static final String TARGET_PASSWORD = "target.password";
    public static final String TARGET_DRIVER = "target.driverClass";
    public static final String TARGET_BATCHSIZE = "target.batchSize";
    public static final String TARGET_TABLE = "target.table";
    public static final String TARGET_PROPERTIES = "target.properties";
    public static final String DIE_ON_ERROR = "abortIfErrors";
    private boolean dieOnError = true;
    private boolean initialized = false;
    private List<String> excludeFieldList = new ArrayList<String>();
    private List<ColumnValue> fixedColumnValueList = new ArrayList<ColumnValue>();
    private boolean outputToTable = true;
    private boolean outputToFile = false;
    private File backupFile = null;
    private File backupFileTmp = null;
    private String fieldSeparator = ";";
    private String fieldEclosure = "\"";
    private String nullReplacement = "\\N";
    private BufferedWriter backupOutputWriter = null;
    private SimpleDateFormat sdfOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean ignoreReadFieldErrors = true;
    private Pattern patternForBackslash = null;
    private Pattern patternForQuota = null;
    private String replacementForBackslash = null;
    private String replacementForQuota = null;
    private SQLCodeGenerator codeGenerator = new SQLCodeGenerator();
    private boolean exportBooleanAsNumber = true;
    private Map<String, String> dbJavaTypeMap = new HashMap<String, String>();
    private boolean debug = false;
    private boolean keepDataModels = false;
    private String modelKey = null;
    private Map<Integer, String> outputClassMap = new HashMap<Integer, String>();

    public void enableLog4J(boolean enable) {
        this.logger = enable ? Logger.getLogger(TableTransfer.class) : null;
    }

    public void addDbJavaTypeMapping(String dbType, String javaType) {
        if (dbType != null && !dbType.trim().isEmpty() && javaType != null && !javaType.trim().isEmpty()) {
            this.dbJavaTypeMap.put(dbType, javaType);
        }
    }

    public void addExcludeField(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.excludeFieldList.add(name.trim());
        }
    }

    public void setColumnValue(String name, Object value) {
        if (name != null && !name.trim().isEmpty()) {
            ColumnValue cv = new ColumnValue(name.trim());
            cv.setValue(value);
            this.fixedColumnValueList.add(cv);
        }
    }

    public final int getCurrentCountInserts() {
        return Math.max(this.countInserts, this.countFileRows);
    }

    public final int getCurrentCountReads() {
        return this.countRead;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final boolean isRunning() {
        return this.runningDb || this.runningFile;
    }

    public final void execute() throws Exception {
        if (!this.initialized) {
            throw new Exception("Not initialized!");
        }
        this.countRead = 0;
        this.countInserts = 0;
        this.startWriting();
        this.startReading();
    }

    private final void startReading() {
        this.readerThread = new Thread(){

            @Override
            public void run() {
                TableTransfer.this.read();
            }
        };
        this.readerThread.setDaemon(false);
        this.readerThread.start();
    }

    private final void startWriting() throws Exception {
        if (this.outputToTable) {
            this.runningDb = true;
            this.writerThread = new Thread(){

                @Override
                public void run() {
                    TableTransfer.this.writeTable();
                }
            };
            this.writerThread.setDaemon(false);
            this.writerThread.start();
        }
        if (this.outputToFile) {
            this.runningFile = true;
            this.info("Create backup file: " + this.backupFile.getAbsolutePath());
            this.backupFileTmp = new File(this.backupFile.getAbsolutePath() + ".tmp");
            this.backupOutputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.backupFileTmp), "UTF-8"));
            this.info("Backup file established.");
            this.writerBackupThread = new Thread(){

                @Override
                public void run() {
                    TableTransfer.this.writeFile();
                }
            };
            this.writerBackupThread.setDaemon(false);
            this.writerBackupThread.start();
        }
    }

    public final void stop() {
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.writerThread != null) {
            this.writerThread.interrupt();
        }
        if (this.writerBackupThread != null) {
            this.writerBackupThread.interrupt();
        }
    }

    public final void disconnect() {
        this.info("Close source connection...");
        if (this.sourceConnection != null) {
            try {
                if (!this.sourceConnection.isClosed()) {
                    this.sourceConnection.close();
                }
            }
            catch (SQLException e) {
                this.error("disconnect from source failed: " + e.getMessage(), e);
            }
        }
        if (this.outputToTable) {
            this.info("Close target connection...");
            if (this.targetConnection != null) {
                try {
                    if (!this.targetConnection.isClosed()) {
                        this.targetConnection.close();
                    }
                }
                catch (SQLException e) {
                    this.error("disconnect from target failed: " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void read() {
        if (this.sourceTable != null) {
            this.info("Start fetch data from source table " + this.sourceTable.getAbsoluteName());
        } else {
            this.info("Start fetch data from source query " + this.sourceQuery);
        }
        try {
            ResultSet rs = this.sourceSelectStatement.executeQuery(this.sourceQuery);
            this.info("Analyse result set...");
            ResultSetMetaData rsMeta = rs.getMetaData();
            int countColumns = rsMeta.getColumnCount();
            this.listResultSetFieldNames = new ArrayList<String>(countColumns);
            this.listResultSetFieldTypeNames = new ArrayList<String>(countColumns);
            for (int i = 1; i <= countColumns; ++i) {
                String name = rsMeta.getColumnName(i).toLowerCase();
                String type = rsMeta.getColumnTypeName(i).toUpperCase();
                this.listResultSetFieldNames.add(name);
                this.listResultSetFieldTypeNames.add(type);
                this.debug("Name: " + name + ",  Type: " + type);
            }
            for (ColumnValue cv : this.fixedColumnValueList) {
                this.listResultSetFieldNames.add(cv.getColumnName());
                this.debug("Name: " + cv.getColumnName());
            }
            this.info("Start fetching data...");
            this.startTime = System.currentTimeMillis();
            while (rs.next()) {
                Object[] row = this.fillRow(rs, countColumns);
                if (this.outputToTable) {
                    this.tableQueue.put(row);
                }
                if (this.outputToFile) {
                    if (this.writerBackupThread == null || !this.writerBackupThread.isAlive()) {
                        if (!this.outputToTable) throw new Exception("No output will work. The component is in backup only mode and the backup thread is not started or dead. Stop processing.");
                        this.warn("Backup process died. Switch off backup", null);
                        this.outputToFile = false;
                    } else {
                        this.fileQueue.put(row);
                    }
                }
                ++this.countRead;
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
            rs.close();
            if (this.sourceTable != null) {
                this.info("Finished fetch data from source table " + this.sourceTable.getAbsoluteName() + " count read:" + this.countRead);
            } else {
                this.info("Finished fetch data from source query, count read:" + this.countRead);
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            SQLException en = e.getNextException();
            if (en != null) {
                message = "\nNext Exception:" + en.getMessage();
            }
            this.error("Read failed in line number " + this.countRead + " message:" + message, e);
            this.returnCode = 1;
        }
        catch (InterruptedException ie) {
            this.error("Read interrupted (send data sets)", ie);
            this.returnCode = 1;
        }
        catch (Exception ie) {
            this.error("Read failed: " + ie.getMessage(), ie);
            this.returnCode = 1;
        }
        finally {
            try {
                if (this.outputToTable) {
                    this.info("Stopping write table thread...");
                    this.tableQueue.put(this.closeFlag);
                }
                if (this.outputToFile) {
                    this.info("Stopping write file thread...");
                    this.fileQueue.put(this.closeFlag);
                }
            }
            catch (InterruptedException e) {
                this.error("read interrupted (send close flag)", e);
                this.returnCode = 1;
            }
            try {
                if (!this.sourceConnection.getAutoCommit()) {
                    this.sourceConnection.commit();
                }
                this.sourceSelectStatement.close();
            }
            catch (SQLException e) {}
        }
        this.info("End read.");
    }

    private final Object[] fillRow(ResultSet rs, int countDBColumns) throws SQLException {
        String dbType = null;
        String javaType = null;
        Object[] row = new Object[countDBColumns + this.fixedColumnValueList.size()];
        for (int columnIndex = 0; columnIndex < countDBColumns; ++columnIndex) {
            dbType = this.listResultSetFieldTypeNames.get(columnIndex);
            javaType = dbType != null ? this.dbJavaTypeMap.get(dbType) : null;
            try {
                if (javaType == null) {
                    row[columnIndex] = rs.getObject(columnIndex + 1);
                    continue;
                }
                if ("date".equals(javaType)) {
                    row[columnIndex] = rs.getDate(columnIndex + 1);
                    continue;
                }
                if ("time".equals(javaType)) {
                    row[columnIndex] = rs.getTime(columnIndex + 1);
                    continue;
                }
                if ("timestamp".equals(javaType)) {
                    row[columnIndex] = rs.getTimestamp(columnIndex + 1);
                    continue;
                }
                if ("string".equals(javaType)) {
                    row[columnIndex] = rs.getString(columnIndex + 1);
                    continue;
                }
                if ("boolean".equals(javaType)) {
                    row[columnIndex] = rs.getBoolean(columnIndex + 1);
                    continue;
                }
                if ("short".equals(javaType)) {
                    row[columnIndex] = rs.getShort(columnIndex + 1);
                    continue;
                }
                if ("byte".equals(javaType)) {
                    row[columnIndex] = rs.getByte(columnIndex + 1);
                    continue;
                }
                if ("integer".equals(javaType)) {
                    row[columnIndex] = rs.getInt(columnIndex + 1);
                    continue;
                }
                if ("long".equals(javaType)) {
                    row[columnIndex] = rs.getLong(columnIndex + 1);
                    continue;
                }
                if ("bigdecimal".equals(javaType)) {
                    row[columnIndex] = rs.getBigDecimal(columnIndex + 1);
                    continue;
                }
                if ("double".equals(javaType)) {
                    row[columnIndex] = rs.getDouble(columnIndex + 1);
                    continue;
                }
                if ("float".equals(javaType)) {
                    row[columnIndex] = Float.valueOf(rs.getFloat(columnIndex + 1));
                    continue;
                }
                row[columnIndex] = rs.getObject(columnIndex + 1);
                continue;
            }
            catch (SQLException e) {
                if (!this.ignoreReadFieldErrors) {
                    throw e;
                }
                this.warn("Ignore database error while reading field with index: " + columnIndex + " in row: " + this.countRead + " message: " + e.getMessage(), e);
                row[columnIndex] = null;
            }
        }
        for (ColumnValue cv : this.fixedColumnValueList) {
            row[columnIndex++] = cv.getValue();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTable() {
        this.info("Start writing data into target table " + this.targetTable.getAbsoluteName());
        int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
        int currentBatchCount = 0;
        try {
            boolean autocommitTemp = false;
            try {
                autocommitTemp = this.targetConnection.getAutoCommit();
            }
            catch (SQLException e2) {
                this.warn("Failed to detect autocommit state: " + e2.getMessage(), e2);
            }
            boolean autocommit = autocommitTemp;
            boolean endFlagReceived = false;
            block21: while (!endFlagReceived) {
                try {
                    ArrayList queueObjects = new ArrayList(batchSize);
                    this.tableQueue.drainTo(queueObjects, batchSize);
                    for (Object item : queueObjects) {
                        if (item == this.closeFlag) {
                            this.info("Write table thread: Stop flag received.");
                            endFlagReceived = true;
                            continue block21;
                        }
                        this.prepareInsertStatement((Object[])item);
                        this.targetPSInsert.addBatch();
                        ++this.countInserts;
                        if (++currentBatchCount == batchSize) {
                            this.debug("Write execute insert batch");
                            this.targetPSInsert.executeBatch();
                            if (!autocommit) {
                                this.targetConnection.commit();
                            }
                            currentBatchCount = 0;
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        continue block21;
                    }
                }
                catch (InterruptedException e) {
                    this.error("Write interrupted in line " + this.countInserts, e);
                    this.returnCode = 1;
                    break;
                }
                catch (SQLException sqle) {
                    this.error("Write failed in line number " + this.countInserts + " message:" + sqle.getMessage(), sqle);
                    if (sqle.getNextException() != null) {
                        this.error("Next exception:" + sqle.getNextException().getMessage(), sqle.getNextException());
                    }
                    if (this.dieOnError) {
                        this.returnCode = 1;
                        try {
                            if (autocommit) break;
                            this.targetConnection.rollback();
                        }
                        catch (SQLException e) {
                            this.error("write rollback failed: " + e.getMessage(), e);
                        }
                        break;
                    }
                    try {
                        if (autocommit) continue;
                        this.targetConnection.commit();
                    }
                    catch (SQLException e) {
                        this.error("write commit failed: " + e.getMessage(), e);
                    }
                }
                catch (Exception e1) {
                    this.returnCode = 1;
                    this.error("write failed:" + e1.getMessage(), e1);
                    break;
                }
            }
            if (currentBatchCount > 0 && this.returnCode == 0) {
                try {
                    this.debug("write execute final insert batch");
                    this.targetPSInsert.executeBatch();
                    if (!autocommit) {
                        this.targetConnection.commit();
                    }
                    currentBatchCount = 0;
                }
                catch (SQLException sqle) {
                    this.returnCode = 1;
                    this.error("write failed executing last batch message:" + sqle.getMessage(), sqle);
                    if (sqle.getNextException() != null) {
                        this.error("write failed embedded error:" + sqle.getNextException().getMessage(), sqle.getNextException());
                    }
                    try {
                        this.targetConnection.rollback();
                    }
                    catch (SQLException e) {
                        this.error("write rollback failed:" + e.getMessage(), e);
                    }
                }
            }
            if (this.returnCode == 1) {
                this.error("Read has been failed. Stop write in table.", null);
            }
        }
        finally {
            try {
                this.targetPSInsert.close();
            }
            catch (SQLException sQLException) {}
            this.runningDb = false;
            this.info("Finished write data into target table " + this.targetTable.getAbsoluteName() + ", count inserts:" + this.countInserts);
        }
        this.info("Write table finished.");
    }

    private final Object getRowValue(String columnName, Object[] row) {
        int index = this.listResultSetFieldNames.indexOf(columnName.toLowerCase());
        if (index != -1) {
            return row[index];
        }
        return null;
    }

    private final void prepareInsertStatement(Object[] row) throws Exception {
        for (SQLPSParam p : this.targetInsertStatement.getParams()) {
            Object value = this.getRowValue(p.getName(), row);
            if (value != null) {
                String className = this.outputClassMap.get(p.getIndex());
                if (className == null) {
                    className = value.getClass().getSimpleName();
                    this.outputClassMap.put(p.getIndex(), className);
                    this.debug("Output class mapping: #" + p.getIndex() + " (" + p.getName() + ") use: " + className);
                }
                if ("BigDecimal".equals(className)) {
                    this.targetPSInsert.setBigDecimal(p.getIndex(), (BigDecimal)value);
                    continue;
                }
                if ("BigInteger".equals(className)) {
                    this.targetPSInsert.setLong(p.getIndex(), ((BigInteger)value).longValue());
                    continue;
                }
                if ("Double".equals(className)) {
                    this.targetPSInsert.setDouble(p.getIndex(), (Double)value);
                    continue;
                }
                if ("Float".equals(className)) {
                    this.targetPSInsert.setFloat(p.getIndex(), ((Float)value).floatValue());
                    continue;
                }
                if ("Long".equals(className)) {
                    this.targetPSInsert.setLong(p.getIndex(), (Long)value);
                    continue;
                }
                if ("Integer".equals(className)) {
                    this.targetPSInsert.setInt(p.getIndex(), (Integer)value);
                    continue;
                }
                if ("Short".equals(className)) {
                    this.targetPSInsert.setShort(p.getIndex(), (Short)value);
                    continue;
                }
                if ("String".equals(className)) {
                    this.targetPSInsert.setString(p.getIndex(), (String)value);
                    continue;
                }
                if ("Date".equals(className)) {
                    this.targetPSInsert.setDate(p.getIndex(), (Date)value);
                    continue;
                }
                if ("Timestamp".equals(className)) {
                    this.targetPSInsert.setTimestamp(p.getIndex(), (Timestamp)value);
                    continue;
                }
                if ("Time".equals(className)) {
                    this.targetPSInsert.setTime(p.getIndex(), (Time)value);
                    continue;
                }
                if ("Boolean".equals(className)) {
                    this.targetPSInsert.setBoolean(p.getIndex(), (Boolean)value);
                    continue;
                }
                if ("String".equals(className)) {
                    this.targetPSInsert.setString(p.getIndex(), (String)value);
                    continue;
                }
                this.targetPSInsert.setObject(p.getIndex(), value);
                continue;
            }
            this.targetPSInsert.setNull(p.getIndex(), this.targetTable.getField(p.getName()).getType());
        }
    }

    public final void executeSQLOnTarget(String sqlStatement) throws Exception {
        if (this.targetConnection == null || this.targetConnection.isClosed()) {
            throw new Exception("executeSQLOnTarget failed because target connection is null or closed");
        }
        try {
            Statement stat = this.targetConnection.createStatement();
            stat.execute(sqlStatement);
            stat.close();
        }
        catch (SQLException sqle) {
            this.error("executeSQLOnTarget sql=" + sqlStatement + " failed: " + sqle.getMessage(), sqle);
            throw sqle;
        }
    }

    public void commitSource() throws SQLException {
        this.sourceConnection.commit();
    }

    public void commitTarget() throws SQLException {
        this.targetConnection.commit();
    }

    public final void setup() throws Exception {
        this.createSourceSelectStatement();
        if (this.outputToTable) {
            this.createTargetInsertStatement();
        }
        int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "100"));
        int fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "100"));
        int queueSize = Math.max(batchSize, fetchSize) + 100;
        if (this.outputToTable) {
            this.tableQueue = new LinkedBlockingQueue<Object>(queueSize);
        }
        if (this.outputToFile) {
            this.fileQueue = new LinkedBlockingQueue<Object>(queueSize);
        }
        this.dieOnError = Boolean.parseBoolean(this.properties.getProperty(DIE_ON_ERROR, "true"));
        this.patternForBackslash = Pattern.compile("\\", 16);
        this.patternForQuota = Pattern.compile("\"", 16);
        this.replacementForBackslash = Matcher.quoteReplacement("\\\\");
        this.replacementForQuota = Matcher.quoteReplacement("\\\"");
        this.initialized = true;
    }

    private final SQLTable getSourceSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(SOURCE_TABLE);
        if (this.sourceTable == null || !this.sourceTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.getSourceDatabase();
            }
            if ((schema = this.sourceModel.getSchema(schemaName)) == null) {
                throw new Exception("getSourceTable failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            this.sourceTable = schema.getTable(tableName);
            if (this.sourceTable == null) {
                throw new Exception("getSourceTable failed: table " + schemaName + "." + tableName + " not available");
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field = this.sourceTable.getField(exclFieldName);
                if (field == null) continue;
                this.sourceTable.removeSQLField(field);
            }
        }
        return this.sourceTable;
    }

    private String getSourceDatabase() throws SQLException {
        String cat = this.sourceConnection.getCatalog();
        if (cat == null || cat.trim().isEmpty()) {
            cat = this.sourceModel.getLoginSchemaName();
        }
        return cat;
    }

    private String getTargetDatabase() throws SQLException {
        String cat = this.targetConnection.getCatalog();
        if (cat == null || cat.trim().isEmpty()) {
            cat = this.targetModel.getLoginSchemaName();
        }
        return cat;
    }

    private final SQLTable getTargetSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(TARGET_TABLE);
        if (this.targetTable == null || !this.targetTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.getTargetDatabase();
            }
            if ((schema = this.targetModel.getSchema(schemaName)) == null) {
                throw new Exception("getTargetSQLTable failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            this.targetTable = schema.getTable(tableName);
            if (this.targetTable == null) {
                throw new Exception("getTargetSQLTable failed: table " + schemaName + "." + tableName + " not available");
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field;
                boolean exclude = true;
                for (ColumnValue cv : this.fixedColumnValueList) {
                    if (!cv.getColumnName().equalsIgnoreCase(exclFieldName)) continue;
                    exclude = false;
                    break;
                }
                if (!exclude || (field = this.targetTable.getField(exclFieldName)) == null) continue;
                this.targetTable.removeSQLField(field);
            }
        }
        return this.targetTable;
    }

    private boolean isMysql() {
        boolean mysqlDriverPresent = false;
        try {
            Class.forName("com.mysql.jdbc.Statement");
            mysqlDriverPresent = true;
        }
        catch (ClassNotFoundException e) {
            this.debug("No MySQL class loaded.");
        }
        return mysqlDriverPresent;
    }

    private Statement createSourceSelectStatement() throws Exception {
        this.sourceQuery = this.properties.getProperty(SOURCE_QUERY);
        if (this.sourceQuery == null) {
            this.sourceQuery = this.codeGenerator.buildSelectStatement(this.getSourceSQLTable(), true) + this.buildSourceWhereSQL();
            this.properties.put(SOURCE_QUERY, this.sourceQuery);
        }
        this.debug("createSourceSelectStatement SQL:" + this.sourceQuery);
        this.sourceSelectStatement = this.sourceConnection.createStatement(1003, 1007);
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            this.sourceSelectStatement.setFetchSize(fetchSize);
        }
        if (this.isMysql()) {
            DBHelper util = (DBHelper)Class.forName("de.jlo.talendcomp.tabletransfer.MySQLHelper").newInstance();
            util.setupStatement(this.sourceSelectStatement);
        }
        return this.sourceSelectStatement;
    }

    private int getFetchSize() {
        int fetchSize = 0;
        try {
            fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "0"));
        }
        catch (Exception e) {
            this.warn("getFetchSize failed: " + e.getMessage(), e);
        }
        return fetchSize;
    }

    private PreparedStatement createTargetInsertStatement() throws Exception {
        this.targetInsertStatement = this.codeGenerator.buildPSInsertSQLStatement(this.getTargetSQLTable(), true);
        this.debug("createTargetInsertStatement SQL:" + this.targetInsertStatement.getSQL());
        this.targetPSInsert = this.targetConnection.prepareStatement(this.targetInsertStatement.getSQL());
        return this.targetPSInsert;
    }

    private final String buildSourceWhereSQL() {
        String where = this.properties.getProperty(SOURCE_WHERE);
        if (where != null && !where.trim().isEmpty()) {
            if ((where = this.replacePlaceholders(where)).startsWith("where")) {
                return " " + where;
            }
            return " where " + where;
        }
        return "";
    }

    private final String replacePlaceholders(String stringWithPlaceholders) {
        boolean ready = false;
        ArrayList<String> listPlaceHolders = new ArrayList<String>();
        int p0 = -1;
        int p1 = -1;
        while (!ready) {
            p0 = stringWithPlaceholders.indexOf(123, p1 + 1);
            p1 = stringWithPlaceholders.indexOf(125, p0 + 1);
            if (p0 != -1 && p1 != -1) {
                String key = stringWithPlaceholders.substring(p0 + 1, p1);
                listPlaceHolders.add(key);
                continue;
            }
            ready = true;
        }
        StringReplacer sr = new StringReplacer(stringWithPlaceholders);
        for (String key : listPlaceHolders) {
            String value = this.properties.getProperty(key);
            if (value == null) {
                this.warn("replacePlaceholders for string " + stringWithPlaceholders + " failed in key:" + key + " reason: missing value", null);
                this.returnCode = 5;
                value = "";
            }
            sr.replace("{" + key + "}", value.trim());
        }
        return sr.getResultText();
    }

    private final String getSchemaName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(0, pos);
        }
        return null;
    }

    private final String getTableName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(pos + 1, schemaAndTable.length());
        }
        return schemaAndTable;
    }

    public final void setupDataModels() throws SQLException {
        if (this.keepDataModels) {
            this.sourceModel = sqlModelCache.get("source_" + this.modelKey);
            if (this.sourceModel == null) {
                this.sourceModel = new SQLDataModel(this.sourceConnection);
                this.sourceModel.loadSchemas();
                sqlModelCache.put("source_" + this.modelKey, this.sourceModel);
            } else {
                this.sourceModel.setConnection(this.sourceConnection);
            }
        } else {
            this.sourceModel = new SQLDataModel(this.sourceConnection);
            this.sourceModel.loadSchemas();
        }
        if (this.sourceConnection != null && !this.sourceConnection.getAutoCommit()) {
            this.sourceConnection.commit();
        }
        if (this.outputToTable) {
            if (this.keepDataModels) {
                this.targetModel = sqlModelCache.get("target_" + this.modelKey);
                if (this.targetModel == null) {
                    this.targetModel = new SQLDataModel(this.targetConnection);
                    this.targetModel.loadSchemas();
                    sqlModelCache.put("target_" + this.modelKey, this.targetModel);
                } else {
                    this.targetModel.setConnection(this.targetConnection);
                }
            } else {
                this.targetModel = new SQLDataModel(this.targetConnection);
                this.targetModel.loadSchemas();
            }
            if (!this.targetConnection.getAutoCommit()) {
                this.targetConnection.commit();
            }
        }
    }

    public void loadProperties(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.error("LoadProperties from " + filePath + " failed: " + e.getMessage(), e);
            this.returnCode = 1;
        }
    }

    public void setSourceURL(String url) {
        this.properties.setProperty(SOURCE_URL, url);
    }

    public String getSourceURL() {
        return this.properties.getProperty(SOURCE_URL);
    }

    public void setSourceUser(String sourceUser) {
        this.properties.setProperty(SOURCE_USER, sourceUser);
    }

    public String getSourceUser() {
        return this.properties.getProperty(SOURCE_USER);
    }

    public String getSourcePassword() {
        return this.properties.getProperty(SOURCE_PASSWORD);
    }

    public void setSourcePassword(String passwd) {
        this.properties.setProperty(SOURCE_PASSWORD, passwd);
    }

    public String getSourceDriverClass() {
        return this.properties.getProperty(SOURCE_DRIVER);
    }

    public void setSourceDriverClass(String driverClassName) {
        this.properties.setProperty(SOURCE_DRIVER, driverClassName);
    }

    public String getSourceFetchSize() {
        return this.properties.getProperty(SOURCE_FETCHSIZE);
    }

    public void setSourceFetchSize(String fetchSize) {
        this.properties.setProperty(SOURCE_FETCHSIZE, fetchSize);
    }

    public String getTargetInsertStatement() {
        return this.targetInsertStatement.getSQL();
    }

    public String getSourceQuery() {
        return this.properties.getProperty(SOURCE_QUERY);
    }

    public void setSourceQuery(String sourceQuery) {
        this.properties.setProperty(SOURCE_QUERY, sourceQuery);
    }

    public String getSourceTable() {
        return this.codeGenerator.getEncapsulatedName(this.properties.getProperty(SOURCE_TABLE));
    }

    public void setSourceTable(String tableAndSchema) {
        this.properties.setProperty(SOURCE_TABLE, tableAndSchema);
        this.properties.remove(SOURCE_QUERY);
    }

    public String getSourceWhereClause() {
        return this.properties.getProperty(SOURCE_WHERE);
    }

    public void setSourceWhereClause(String whereClause) {
        this.properties.setProperty(SOURCE_WHERE, whereClause);
    }

    public void setSourceProperties(String propertiesString) {
        this.properties.setProperty(SOURCE_PROPERTIES, propertiesString);
    }

    public String getSourceProperties() {
        return this.properties.getProperty(SOURCE_PROPERTIES);
    }

    public void setTargetURL(String url) {
        this.properties.setProperty(TARGET_URL, url);
    }

    public String getTargetURL() {
        return this.properties.getProperty(TARGET_URL);
    }

    public void setTargetUser(String targetUser) {
        this.properties.setProperty(TARGET_USER, targetUser);
    }

    public String getTargetUser() {
        return this.properties.getProperty(TARGET_USER);
    }

    public String getTargetPassword() {
        return this.properties.getProperty(TARGET_PASSWORD);
    }

    public void setTargetPassword(String passwd) {
        this.properties.setProperty(TARGET_PASSWORD, passwd);
    }

    public String getTargetDriverClass() {
        return this.properties.getProperty(TARGET_DRIVER);
    }

    public void setTargetDriverClass(String driverClassName) {
        this.properties.setProperty(TARGET_DRIVER, driverClassName);
    }

    public String getTargetBatchSize() {
        return this.properties.getProperty(TARGET_BATCHSIZE);
    }

    public void setTargetBatchSize(String batchSize) {
        this.properties.setProperty(TARGET_BATCHSIZE, batchSize);
    }

    public String getTargetTable() {
        return this.codeGenerator.getEncapsulatedName(this.properties.getProperty(TARGET_TABLE));
    }

    public void setTargetTable(String tableAndSchema) {
        this.properties.setProperty(TARGET_TABLE, tableAndSchema);
    }

    public void setTargetProperties(String propertiesString) {
        this.properties.setProperty(TARGET_PROPERTIES, propertiesString);
    }

    public String getTargetProperties() {
        return this.properties.getProperty(TARGET_PROPERTIES);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean isSuccessful() {
        return this.returnCode == 0;
    }

    private final void warn(String message, Exception t) {
        if (this.logger != null) {
            if (t != null) {
                this.logger.warn(message, t);
            } else {
                this.logger.warn(message);
            }
        } else {
            System.err.println("WARN: " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
        if (message != null) {
            this.errorMessage = message;
        }
        if (t != null) {
            this.errorException = t;
        }
    }

    private final void info(String message) {
        if (this.logger != null) {
            this.logger.info(message);
        } else {
            System.out.println(message);
        }
    }

    private final void debug(String message) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        } else if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    private final void error(String message, Exception t) {
        if (this.logger != null) {
            if (t != null) {
                this.logger.error(message, t);
            } else {
                this.logger.error(message);
            }
        } else {
            System.err.println("ERROR: " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
        if (message != null) {
            this.errorMessage = message;
        }
        if (t != null) {
            this.errorException = t;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public Connection getSourceConnection() {
        return this.sourceConnection;
    }

    public Statement getSourceStatement() {
        return this.sourceSelectStatement;
    }

    private boolean isClosed(Connection connection) {
        try {
            return connection.isClosed();
        }
        catch (SQLException e) {
            this.logger.error("Check if connection is closed failed:" + e.getMessage(), e);
            return true;
        }
    }

    public void setSourceConnection(Connection sourceConnection) {
        if (sourceConnection == null) {
            throw new IllegalArgumentException("Source connection cannot be null!");
        }
        if (sourceConnection == this.targetConnection) {
            throw new IllegalArgumentException("Source connection cannot be the same as used for the target! Establish for source and target different connection instances!");
        }
        if (this.isClosed(sourceConnection)) {
            throw new IllegalArgumentException("Source connection is already closed!");
        }
        this.sourceConnection = sourceConnection;
    }

    public Connection getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(Connection targetConnection) throws Exception {
        if (targetConnection == null) {
            throw new IllegalArgumentException("Target connection cannot be null!");
        }
        if (this.sourceConnection == targetConnection) {
            throw new IllegalArgumentException("Target connection cannot be the same as used for the source! Establish for source and target different connection instances!");
        }
        if (targetConnection.isReadOnly()) {
            throw new Exception("Target connection cannot be in read only mode!");
        }
        if (this.isClosed(targetConnection)) {
            throw new IllegalArgumentException("Target connection is already closed!");
        }
        this.targetConnection = targetConnection;
    }

    public static final double roundScale2(Double number) {
        if (number != null) {
            return (double)Math.round(number * 100.0) / 100.0;
        }
        return 0.0;
    }

    public String getBackupFilePath() {
        if (this.backupFile != null) {
            return this.backupFile.getAbsolutePath();
        }
        return null;
    }

    public String setBackupFilePath(String backupFilePath) throws Exception {
        if (backupFilePath != null && !backupFilePath.trim().isEmpty()) {
            File test = new File(backupFilePath);
            if (test.isDirectory()) {
                if (!test.exists()) {
                    test.mkdirs();
                    if (!test.exists()) {
                        throw new Exception("Backup dir: " + test.getAbsolutePath() + " could not be created!");
                    }
                }
                this.backupFile = test = new File(test, this.getTargetTable() + ".csv");
                this.outputToFile = true;
                return this.backupFile.getAbsolutePath();
            }
            File dir = test.getParentFile();
            if (dir == null) {
                throw new Exception("Backup file has to be an absolute path (directory or file)!");
            }
            if (!dir.exists()) {
                dir.mkdirs();
                if (!dir.exists()) {
                    throw new Exception("Backup dir: " + dir.getAbsolutePath() + " could not be created!");
                }
            }
            this.backupFile = test;
            this.outputToFile = true;
            return this.backupFile.getAbsolutePath();
        }
        return null;
    }

    private String convertToString(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            if (sValue.isEmpty()) {
                return "";
            }
            Matcher m1 = this.patternForBackslash.matcher(sValue);
            sValue = m1.replaceAll(this.replacementForBackslash);
            Matcher m2 = this.patternForQuota.matcher(sValue);
            sValue = m2.replaceAll(this.replacementForQuota);
            return sValue;
        }
        if (value instanceof java.util.Date) {
            return this.sdfOut.format((java.util.Date)value);
        }
        if (value instanceof Boolean) {
            if (this.exportBooleanAsNumber) {
                return (Boolean)value != false ? "1" : "0";
            }
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Short) {
            return Short.toString((Short)value);
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value != null) {
            return value.toString();
        }
        return this.nullReplacement;
    }

    private void writeRowToBackup(Object[] row) throws Exception {
        if (row != null) {
            boolean firstLoop = true;
            for (Object value : row) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    this.backupOutputWriter.write(this.fieldSeparator);
                }
                this.backupOutputWriter.write(this.fieldEclosure);
                this.backupOutputWriter.write(this.convertToString(value));
                this.backupOutputWriter.write(this.fieldEclosure);
            }
            this.backupOutputWriter.write("\n");
            ++this.countFileRows;
        }
    }

    private void writeFile() {
        try {
            File errorFile;
            this.countFileRows = 0;
            this.info("Start writing data in file: " + this.backupFile.getAbsolutePath());
            int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
            boolean endFlagReceived = false;
            block8: while (!endFlagReceived) {
                try {
                    ArrayList queueObjects = new ArrayList(batchSize);
                    this.fileQueue.drainTo(queueObjects, batchSize);
                    for (Object item : queueObjects) {
                        if (item == this.closeFlag) {
                            this.info("Write file thread: Stop flag received.");
                            endFlagReceived = true;
                            continue block8;
                        }
                        this.writeRowToBackup((Object[])item);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        continue block8;
                    }
                }
                catch (Exception e) {
                    this.error("write file failed in line number " + this.countFileRows + " message:" + e.getMessage(), e);
                    if (!this.dieOnError) continue;
                    this.returnCode = 1;
                    break;
                }
            }
            try {
                this.backupOutputWriter.flush();
                this.backupOutputWriter.close();
            }
            catch (Exception e) {
                this.error("Close file failed: " + e.getMessage(), e);
            }
            this.runningFile = false;
            if (this.returnCode == 0) {
                this.info("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.info("Rename tmp file: " + this.backupFileTmp.getAbsolutePath() + " to target file: " + this.backupFile.getAbsolutePath());
                this.backupFileTmp.renameTo(this.backupFile);
            } else if (this.returnCode == 1) {
                this.info("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.warn("Read has been failed. Rename file as error file.", null);
                errorFile = new File(this.backupFile.getAbsolutePath() + ".error");
                this.backupFileTmp.renameTo(errorFile);
            } else if (this.returnCode == 1) {
                this.info("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.warn("Write to file has been failed. Rename file as error file.", null);
                errorFile = new File(this.backupFile.getAbsolutePath() + ".error");
                this.backupFileTmp.renameTo(errorFile);
            }
        }
        catch (Exception e) {
            try {
                this.backupOutputWriter.flush();
                this.backupOutputWriter.close();
            }
            catch (Exception e1) {
                this.error("Close file failed: " + e.getMessage(), e);
            }
            this.runningFile = false;
            this.error("Write data into file " + this.backupFile.getAbsolutePath() + " count rows:" + this.countFileRows + " failed: " + e.getMessage(), e);
        }
        this.info("Write file finished");
    }

    public boolean isOutputToTable() {
        return this.outputToTable;
    }

    public void setOutputToTable(boolean outputToTable) {
        this.outputToTable = outputToTable;
    }

    public void setDebug(boolean debug) {
        if (this.logger != null) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
        }
        this.debug = debug;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isExportBooleanAsNumber() {
        return this.exportBooleanAsNumber;
    }

    public void setExportBooleanAsNumber(Boolean exportBooleanAsNumber) {
        if (exportBooleanAsNumber != null) {
            this.exportBooleanAsNumber = exportBooleanAsNumber;
        }
    }

    public boolean isKeepDataModels() {
        return this.keepDataModels;
    }

    public void setKeepDataModels(boolean keepDataModels, String key) {
        this.keepDataModels = keepDataModels;
        if (keepDataModels && (key == null || key.trim().isEmpty())) {
            throw new IllegalArgumentException("If the model should kept statically the key cannot be null or empty!");
        }
        this.modelKey = key;
    }
}

