/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Properties;
import org.apache.log4j.Logger;
import sqlrunner.base64.Base64;
import sqlrunner.export.Exporter;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.xml.XMLWriter;

public class XMLExporter
implements Exporter {
    private static final Logger defaultLogger = Logger.getLogger(XMLExporter.class);
    private Logger exportLogger = defaultLogger;
    public static final String PROP_ENCODING = "encoding";
    public static final String PROP_XML_INDENTION = "indention";
    public static final String PROP_BASE64_CODED_STRINGS = "base64CodedStrings";
    public static final String PROP_DATE_FORMAT = "dateFormat";
    public static final String PROP_NUMBERFORMAT_LOCALE = "numberFormatLocale";
    private boolean base64CodedStrings = true;
    private static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    private String dateFormat = "yyyyMMdd";
    private boolean xmlIndention = false;
    private final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";
    private final Locale DEFAULT_NUMBERFORMAT_LOCALE;
    private Locale numberFormatLocale = this.DEFAULT_NUMBERFORMAT_LOCALE = Locale.US;
    private String currentAction = "";
    private long currentCount = 0L;
    private String query = null;
    private DatabaseSession exportSession;
    private ConnectionDescription cd;
    private boolean codeStringInBase64 = false;
    private File outputFile;
    private String tableName;
    private String sql;
    private boolean interrupted;

    @Override
    public void setQuery(String sql) {
        this.query = sql;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getCurrentAction() {
        return this.currentAction;
    }

    public long getCurrentCount() {
        return this.currentCount;
    }

    @Override
    public boolean connect() throws Exception {
        if (this.cd == null) {
            throw new Exception("No connection description set");
        }
        this.exportSession = new DatabaseSession();
        this.exportSession.setConnectionDescription(this.cd);
        return this.exportSession.connect();
    }

    public ConnectionDescription getConnectionDescription() {
        return this.cd;
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connDesc) {
        if (connDesc == null) {
            throw new IllegalArgumentException("connDesc cannot be null");
        }
        this.cd = connDesc.clone();
        this.cd.setAutoCommit(false);
    }

    public void setProperties(Properties properties) throws Exception {
        this.base64CodedStrings = Boolean.getBoolean(properties.getProperty(PROP_BASE64_CODED_STRINGS, "true"));
        this.xmlIndention = Boolean.getBoolean(properties.getProperty(PROP_XML_INDENTION, "false"));
        this.dateFormat = properties.getProperty(PROP_DATE_FORMAT, "dd.MM.yyyy");
        this.encoding = properties.getProperty(PROP_ENCODING, "UTF-8");
        this.numberFormatLocale = new Locale(properties.getProperty(PROP_NUMBERFORMAT_LOCALE, this.DEFAULT_NUMBERFORMAT_LOCALE.toString()));
    }

    public boolean usesBase64CodingForStrings() {
        return this.base64CodedStrings;
    }

    public boolean isUseXmlIndention() {
        return this.xmlIndention;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Locale getNumberFormatLocale() {
        return this.numberFormatLocale;
    }

    public void setMaxDatasetsPerFile(long maxDatasetsPerFile) {
    }

    @Override
    public void setLogger(Logger logger) {
        this.exportLogger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.exportLogger;
    }

    @Override
    public void resetToStaticLogger() {
        this.exportLogger = defaultLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportData() throws IOException, SQLException {
        this.currentAction = "select " + this.tableName;
        if (this.sql == null) {
            this.sql = "select * from " + this.tableName;
        }
        ResultSet rs = this.exportSession.executeQuery(this.sql);
        if (!this.exportSession.isSuccessful()) {
            throw new SQLException(this.exportSession.getLastErrorMessage());
        }
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter(new FileOutputStream(this.outputFile));
            xmlWriter.setFormatOutput(false);
            xmlWriter.writeXMLBegin();
            xmlWriter.writeTagBegin(this.tableName.toLowerCase(), null);
        }
        catch (IOException ioe) {
            this.exportLogger.error((Object)("Create XMLWriter failed: " + ioe.toString()));
            throw ioe;
        }
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            Object[] resultRow = new Object[cols];
            int[] types = new int[cols];
            String[] columnNames = new String[cols];
            for (i = 0; i < cols; ++i) {
                columnNames[i] = rsmd.getColumnName(i + 1).toLowerCase();
                types[i] = BasicDataType.getBasicTypeByTypes(rsmd.getColumnType(i + 1));
            }
            while (rs.next()) {
                if (this.interrupted) {
                    this.exportLogger.warn((Object)"Export interrupted");
                    break;
                }
                for (i = 0; i < cols; ++i) {
                    if (BasicDataType.isDateType(types[i])) {
                        resultRow[i] = rs.getTimestamp(i + 1);
                        continue;
                    }
                    if (BasicDataType.isNumberType(types[i])) {
                        resultRow[i] = rs.getString(i + 1);
                        continue;
                    }
                    if (types[i] == BasicDataType.CLOB.getId()) {
                        if (rs.getObject(i + 1) != null) {
                            Clob clob = rs.getClob(i + 1);
                            resultRow[i] = clob.getSubString(1L, (int)clob.length());
                            continue;
                        }
                        resultRow[i] = null;
                        continue;
                    }
                    if (BasicDataType.isStringType(types[i])) {
                        resultRow[i] = rs.getString(i + 1);
                        continue;
                    }
                    if (BasicDataType.isBooleanType(types[i])) {
                        resultRow[i] = rs.getBoolean(i + 1);
                        continue;
                    }
                    if (BasicDataType.BINARY.getId() == types[i]) {
                        if (rs.getObject(i + 1) != null) {
                            resultRow[i] = rs.getBinaryStream(i + 1);
                            continue;
                        }
                        resultRow[i] = null;
                        continue;
                    }
                    resultRow[i] = null;
                }
                this.processDataSet(xmlWriter, resultRow, columnNames, types);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {}
            if (xmlWriter != null) {
                try {
                    xmlWriter.writeTagEnd();
                    xmlWriter.close();
                }
                catch (IOException e) {
                    this.exportLogger.error((Object)("write document end tag failed: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private void processDataSet(XMLWriter xmlWriter, Object[] resultRow, String[] columnNames, int[] types) throws IOException {
        xmlWriter.writeTagBegin("row", null);
        String[][] attributes = new String[1][2];
        for (int i = 0; i < columnNames.length; ++i) {
            Object content = resultRow[i];
            if (content == null) continue;
            if (BasicDataType.isDateType(types[i])) {
                xmlWriter.writeTagBegin(columnNames[i], null);
                if (content instanceof Timestamp) {
                    xmlWriter.writeTextContent(String.valueOf(((Timestamp)content).getTime()));
                } else if (content instanceof Time) {
                    xmlWriter.writeTextContent(String.valueOf(((Time)content).getTime()));
                }
            } else if (BasicDataType.isNumberType(types[i])) {
                xmlWriter.writeTagBegin(columnNames[i], null);
                if (content != null) {
                    xmlWriter.writeTextContent(content.toString());
                }
            } else if (types[i] == BasicDataType.CLOB.getId()) {
                attributes[0][0] = "code";
                attributes[0][1] = "base64";
                xmlWriter.writeTagBegin(columnNames[i], attributes);
                if (content != null) {
                    xmlWriter.writeCDATAContent(Base64.toString(Base64.encode(((String)content).getBytes("UTF-16")), true));
                }
            } else if (BasicDataType.isStringType(types[i])) {
                if (this.codeStringInBase64) {
                    attributes[0][0] = "code";
                    attributes[0][1] = "base64";
                    xmlWriter.writeTagBegin(columnNames[i], attributes);
                    if (content != null) {
                        xmlWriter.writeCDATAContent(Base64.toString(Base64.encode(((String)content).getBytes("UTF-16")), true));
                    }
                } else {
                    xmlWriter.writeTagBegin(columnNames[i], null);
                    if (content != null) {
                        xmlWriter.writeTextContent((String)content);
                    }
                }
            } else if (BasicDataType.isBooleanType(types[i])) {
                xmlWriter.writeTagBegin(columnNames[i], null);
                if (content != null) {
                    xmlWriter.writeTextContent(content.toString());
                }
            } else if (BasicDataType.BINARY.getId() == types[i]) {
                attributes[0][0] = "code";
                attributes[0][1] = "base64";
                xmlWriter.writeTagBegin(columnNames[i], attributes);
                if (content != null) {
                    byte[] buffer = new byte[24];
                    int length = -1;
                    StringBuffer sb = new StringBuffer();
                    InputStream is = (InputStream)content;
                    while ((length = is.read(buffer)) != -1) {
                        sb.append(Base64.toString(Base64.encode(buffer, length)));
                    }
                    is.close();
                    xmlWriter.writeCDATAContent(sb.toString());
                }
            } else {
                xmlWriter.writeTagBegin(columnNames[i], null);
                if (content != null) {
                    xmlWriter.writeTextContent(content.toString());
                }
            }
            xmlWriter.writeTagEnd();
        }
        xmlWriter.writeTagEnd();
    }

    @Override
    public void abort() {
        this.interrupted = true;
        if (this.exportSession != null) {
            this.exportSession.cancelStatement();
        }
    }

    @Override
    public int getCurrentRowNum() {
        return 0;
    }

    @Override
    public int getStatus() {
        return 0;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void setDateFormat(String pattern) {
        this.dateFormat = pattern;
    }
}

