/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.text;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericDateUtil {
    public static boolean matches(String pattern, String date) {
        Pattern p = DateUtil.getCompiledPattern(pattern);
        Matcher m = p.matcher(date);
        return m.matches();
    }

    public static boolean isDate(String date) {
        DateUtil instance = DateUtil.getInstance();
        return instance.isDate(date);
    }

    public static Date parseDate(String text) throws ParseException {
        DateUtil instance = DateUtil.getInstance();
        return instance.parseDate(text);
    }

    public static List<String> getSupportedFormats() {
        DateUtil instance = DateUtil.getInstance();
        return instance.getSupportedFormats();
    }

    protected static class DateUtil {
        protected static DateUtil instance = new DateUtil();
        protected static final String US_DAYS_E = "Mon|Tue|Wed|Thu|Fri|Sat|Sun";
        protected static final String US_DAYS_EEEE = "Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday";
        protected static final String DE_DAYS_E = "Mo|Di|Mi|Do|Fr|Sa|So";
        protected static final String DE_DAYS_EEEE = "Montag|Dienstag|Mittwoch|Donnerstag|Freitag|Samstag|Sonntag";
        protected static final String US_MONTHS_MMM = "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec";
        protected static final String US_MONTHS_MMMM = "January|February|March|April|May|June|July|August|September|October|November|December";
        protected static final String DE_MONTHS_MMM = "Jan|Feb|Mrz|Apr|Mai|Jun|Jul|Aug|Sep|Okt|Nov|Dez";
        protected static final String DE_MONTHS_MMMM = "Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember";
        protected static final String US_ZONE_Z = "CET|CEST";
        protected static final String US_ZONE_ZZZZ = "Central European Time|Central European Summer Time";
        protected static final String DE_ZONE_Z = "MEZ|MESZ";
        protected static final String DE_ZONE_ZZZZ = "Mitteleurop\u00e4ische Zeit|Mitteleurop\u00e4ische Sommerzeit";
        protected static final String US_ERA_G = "BC|AD";
        protected static final String DE_ERA_G = "v. Chr.|n. Chr.";
        protected static final String AM_PM = "AM|PM";
        protected static final String N_FORMAT = "F_";
        protected static final String N_PATTERN = "P_";
        protected static final String N_PATTERNFULL = "PF_";
        protected static final String N_DATE = "D_";
        protected static final String N_TIME = "T_";
        protected static final String N_DATETIME = "DT_";
        protected static final String N_TIMESTAMP = "TS_";
        protected static final String N_SHORT = "SHORT";
        protected static final String N_LONG = "LONG";
        protected static final String P_LINE_BEGIN = "^";
        protected static final String P_LINE_END = "$";
        protected static final String F_DE_D_SHORT = "d.M.y";
        protected static final String P_DE_D_SHORT = "((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2})";
        protected static final String PF_DE_D_SHORT = "^((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2})$";
        protected static final String F_DE_D_LONG = "dd.MM.yyyy";
        protected static final String P_DE_D_LONG = "(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3})";
        protected static final String PF_DE_D_LONG = "^(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3})$";
        protected static final String F_ISO_D_LONG = "yyyy-MM-dd";
        protected static final String P_ISO_D_LONG = "(19[\\d]{2}|[2-9][\\d]{3})-((0[13578]|10|12)-((0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)-(0[1-9]|[12][\\d]|[3][0]))|(02-(0[1-9]|[12][\\d])))";
        protected static final String PF_ISO_D_LONG = "^(19[\\d]{2}|[2-9][\\d]{3})-((0[13578]|10|12)-((0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)-(0[1-9]|[12][\\d]|[3][0]))|(02-(0[1-9]|[12][\\d])))$";
        protected static final String F_US_D_SHORT = "M/d/yy";
        protected static final String P_US_D_SHORT = "((([13578]|10|12)\\/([1-9]|[12][\\d]|[3][01]))|(([469]|11)\\/([1-9]|[12][\\d]|[3][0]))|(2\\/([1-9]|[12][\\d])))\\/([\\d]{2})";
        protected static final String PF_US_D_SHORT = "^((([13578]|10|12)\\/([1-9]|[12][\\d]|[3][01]))|(([469]|11)\\/([1-9]|[12][\\d]|[3][0]))|(2\\/([1-9]|[12][\\d])))\\/([\\d]{2})$";
        protected static final String F_US_D_LONG = "MM/dd/yyyy";
        protected static final String P_US_D_LONG = "(((0[13578]|10|12)\\/(0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)\\/(0[1-9]|[12][\\d]|[3][0]))|(02\\/(0[1-9]|[12][\\d])))\\/(19[\\d]{2}|[2-9][\\d]{3})";
        protected static final String PF_US_D_LONG = "^(((0[13578]|10|12)\\/(0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)\\/(0[1-9]|[12][\\d]|[3][0]))|(02\\/(0[1-9]|[12][\\d])))\\/(19[\\d]{2}|[2-9][\\d]{3})$";
        protected static final String F_DE_T_LONG = "HH:mm:ss";
        protected static final String P_DE_T_LONG = "([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])";
        protected static final String PF_DE_T_LONG = "^([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])$";
        protected static final String F_ISO_T_LONG = "THH:mm:ss";
        protected static final String P_ISO_T_LONG = "[T]([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])";
        protected static final String PF_ISO_T_LONG = "^[T]([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])$";
        protected static final String F_DE_DT_SHORT = "d.M.y HH:mm:ss";
        protected static final String P_DE_DT_SHORT = "((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])";
        protected static final String PF_DE_DT_SHORT = "^((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])$";
        protected static final String F_DE_DT_LONG = "dd.MM.yyyy HH:mm:ss";
        protected static final String P_DE_DT_LONG = "(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])";
        protected static final String PF_DE_DT_LONG = "^(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])$";
        protected static final String F_ISO_DT_LONG = "yyyy-MM-ddTHH:mm:ss";
        protected static final String P_ISO_DT_LONG = "(19[\\d]{2}|[2-9][\\d]{3})-((0[13578]|10|12)-((0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)-(0[1-9]|[12][\\d]|[3][0]))|(02-(0[1-9]|[12][\\d])))[T]([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])";
        protected static final String PF_ISO_DT_LONG = "^(19[\\d]{2}|[2-9][\\d]{3})-((0[13578]|10|12)-((0[1-9]|[12][\\d]|[3][01]))|((0[469]|11)-(0[1-9]|[12][\\d]|[3][0]))|(02-(0[1-9]|[12][\\d])))[T]([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])$";
        protected static final String F_DE_TS_SHORT = "d.M.y HH:mm:ss.SSS";
        protected static final String P_DE_TS_SHORT = "((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])\\.[0-9]{3}";
        protected static final String PF_DE_TS_SHORT = "^((([1-9]|[12][\\d]|[3][01])\\.([13578]|10|12))|(([1-9]|[12][\\d]|[3][0])\\.([469]|11))|(([1-9]|[12][\\d])\\.2))\\.([\\d]{2}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])\\.[0-9]{3}$";
        protected static final String F_DE_TS_LONG = "dd.MM.yyyy HH:mm:ss.SSSSSS";
        protected static final String P_DE_TS_LONG = "(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])\\.[0-9]{6}";
        protected static final String PF_DE_TS_LONG = "^(((0[1-9]|[12][\\d]|[3][01])\\.(0[13578]|10|12))|((0[1-9]|[12][\\d]|[3][0])\\.(0[469]|11))|((0[1-9]|[12][\\d])\\.02))\\.(19[\\d]{2}|[2-9][\\d]{3}) ([01][\\d]|[2][0-4]):([0-5][0-9]|[6][0]):([0-5][0-9]|[6][0])\\.[0-9]{6}$";
        private static final Map<String, Pattern> compiledPatternMap = new HashMap<String, Pattern>();

        private DateUtil() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Pattern getCompiledPattern(String patternStr) {
            Pattern p = compiledPatternMap.get(patternStr);
            if (p == null) {
                Map<String, Pattern> map = compiledPatternMap;
                synchronized (map) {
                    Pattern temp = Pattern.compile(patternStr);
                    compiledPatternMap.put(patternStr, temp);
                    p = temp;
                }
            }
            return p;
        }

        private String getDateKey(String date) {
            String dateKey = null;
            Field[] member = this.getClass().getDeclaredFields();
            boolean stop = false;
            List<Field> list = Arrays.asList(member);
            Iterator<Field> iterator = list.iterator();
            while (iterator.hasNext() && !stop) {
                Field field = iterator.next();
                String fieldName = field.getName();
                if (!fieldName.startsWith(N_PATTERNFULL)) continue;
                try {
                    String pattern = (String)field.get(null);
                    Pattern p = DateUtil.getCompiledPattern(pattern);
                    Matcher m = p.matcher(date);
                    if (!m.matches()) continue;
                    stop = true;
                    int position = fieldName.indexOf("_") + 1;
                    dateKey = fieldName.substring(position);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
            }
            return dateKey;
        }

        public boolean isDate(String date) {
            return this.getDateKey(date) != null;
        }

        private String getFieldValue(String date, String norm) {
            String dateKey = this.getDateKey(date);
            String fieldKey = null;
            String fieldValue = null;
            if (dateKey != null) {
                fieldKey = norm + dateKey;
                try {
                    Field field = this.getClass().getDeclaredField(fieldKey);
                    fieldValue = field.get(null).toString();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return fieldValue;
        }

        private String getPattern(String date) {
            return this.getFieldValue(date, N_PATTERNFULL);
        }

        private String getFormat(String date) {
            return this.getFieldValue(date, N_FORMAT);
        }

        public Date parseDate(String text) throws ParseException {
            Date date = null;
            String format = this.getFormat(text);
            if (format == null) {
                StringBuffer supported = new StringBuffer();
                List<String> supportedFormats = this.getSupportedFormats();
                supported.append("Supported formats are:\n");
                for (String temp : supportedFormats) {
                    supported.append(temp);
                    supported.append("\n");
                }
                throw new ParseException(text + " is an unsupported date format!\n" + supported.toString(), 0);
            }
            SimpleDateFormat formater = new SimpleDateFormat(format, Locale.GERMAN);
            date = formater.parse(text);
            return date;
        }

        protected List<String> getSupportedFormats() {
            ArrayList<String> supported = new ArrayList<String>();
            String regex = "^F_[A-Z]{2,3}_(D|DT|TS)_.*";
            Pattern pattern = DateUtil.getCompiledPattern(regex);
            Field[] member = this.getClass().getDeclaredFields();
            List<Field> list = Arrays.asList(member);
            for (Field field : list) {
                String fieldName = field.getName();
                Matcher matcher = pattern.matcher(fieldName);
                if (!matcher.matches()) continue;
                try {
                    String value = (String)field.get(null);
                    supported.add(value);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return supported;
        }

        public static DateUtil getInstance() {
            return instance;
        }
    }
}

