/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.log4jpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import sqlrunner.log4jpanel.Messages;

public final class LogPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(LogPanel.class);
    private static final long serialVersionUID = 1L;
    private int maxLines = 0;
    private JScrollPane scrollPane = null;
    private JTextArea jTextArea = null;
    private transient LogWriter writer = new LogWriter(this);
    private transient PatternLayout layout = new PatternLayout("%d{HH:mm} [%-5p] %-25c - %m%n");
    private transient WriterAppender appender = new WriterAppender((Layout)this.layout, (Writer)this.writer);
    private boolean stopped = false;
    private boolean loggingEnabled = true;
    private JPanel jPanelTools = null;
    private JButton jButtonSaveAs = null;
    private JButton jButtonClear = null;
    private File file;
    private JCheckBox jCheckBoxAutoScrolling = null;
    private JCheckBox jCheckBoxLoggingEnabled = null;
    private JLabel jLabel = null;
    private String suggestedFileName;
    private boolean changed = false;
    private static LogPanel logPanel;

    public LogPanel() {
        this.initialize();
    }

    public static LogPanel getInstance() {
        if (logPanel == null) {
            logPanel = new LogPanel();
        }
        return logPanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(321, 109));
        this.scrollPane = new JScrollPane();
        this.jTextArea = new JTextArea();
        this.jTextArea.setEditable(false);
        this.add((Component)this.getJPanelTools(), "North");
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.setViewportView(this.jTextArea);
        this.changed = false;
    }

    public Appender getAppender() {
        return this.appender;
    }

    public void setAppenderLayout(Layout layout) {
        this.appender.setLayout(layout);
    }

    public Layout getAppenderLayout() {
        return this.appender.getLayout();
    }

    public void setConversionPattern(String format) {
        this.layout.setConversionPattern(format);
    }

    public String getConversionPattern() {
        return this.layout.getConversionPattern();
    }

    public void setMaxLogLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getMaxLogLines() {
        return this.maxLines;
    }

    public void setLineWrap(boolean lineWrap) {
        this.jTextArea.setLineWrap(lineWrap);
    }

    public boolean getLineWrap() {
        return this.jTextArea.getLineWrap();
    }

    public void clear() {
        this.stopped = true;
        this.jTextArea.setText(null);
        this.stopped = false;
        this.changed = false;
    }

    public void setAutoScrolling(boolean auto) {
        this.jCheckBoxAutoScrolling.setSelected(auto);
    }

    public boolean isAutoScrolling() {
        return this.jCheckBoxAutoScrolling.isSelected();
    }

    public void setLoggingEnabled(boolean enabled) {
        this.loggingEnabled = enabled;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void append(String s) {
        if (!this.stopped && this.loggingEnabled) {
            this.changed = true;
            this.jTextArea.append(s);
            if (this.maxLines > 0) {
                int lines4Delete;
                int len = this.jTextArea.getLineCount();
                int n = lines4Delete = this.maxLines > 5 ? 5 : this.maxLines;
                if (len > this.maxLines) {
                    try {
                        this.jTextArea.getDocument().remove(0, lines4Delete);
                    }
                    catch (BadLocationException exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (this.jCheckBoxAutoScrolling.isSelected()) {
                Dimension size = this.jTextArea.getSize();
                JViewport port = this.scrollPane.getViewport();
                Point point = new Point(0, size.height);
                port.setViewPosition(point);
            }
        }
    }

    public void newLine() {
        this.append("\n");
    }

    private JPanel getJPanelTools() {
        if (this.jPanelTools == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("Logging");
            this.jPanelTools = new JPanel();
            this.jPanelTools.add((Component)this.jLabel, null);
            this.jPanelTools.add((Component)this.getJButtonSaveAs(), null);
            this.jPanelTools.add((Component)this.getJButtonClear(), null);
            this.jPanelTools.add((Component)this.getJCheckBoxAutoScrolling(), null);
            this.jPanelTools.add((Component)this.getJCheckBoxLoggingEnabled(), null);
        }
        return this.jPanelTools;
    }

    private JButton getJButtonSaveAs() {
        if (this.jButtonSaveAs == null) {
            this.jButtonSaveAs = new JButton();
            this.jButtonSaveAs.setText(Messages.getString("LogPanel.save"));
            this.jButtonSaveAs.setToolTipText("save log entries in file");
            this.jButtonSaveAs.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.showSaveFileDialog();
                }
            });
        }
        return this.jButtonSaveAs;
    }

    private JButton getJButtonClear() {
        if (this.jButtonClear == null) {
            this.jButtonClear = new JButton();
            this.jButtonClear.setText(Messages.getString("LogPanel.clear"));
            this.jButtonClear.setToolTipText("clear log entries");
            this.jButtonClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogPanel.this.clear();
                }
            });
        }
        return this.jButtonClear;
    }

    public void showSaveFileDialog() {
        JFileChooser chooser = new JFileChooser();
        if (this.file != null) {
            chooser.setCurrentDirectory(this.file.getParentFile());
        } else {
            if (this.suggestedFileName != null) {
                chooser.setSelectedFile(new File(this.suggestedFileName));
            }
            chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        if (this.file != null) {
            chooser.setSelectedFile(this.file);
        }
        chooser.setDialogType(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("save file");
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            File f = chooser.getSelectedFile();
            if (!f.getAbsolutePath().endsWith(".log")) {
                f = new File(f.getAbsolutePath() + ".log");
            }
            this.saveDocument(f);
        }
    }

    public void saveDocument(File file) {
        if (file != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("saveDocument(file=" + file + ")"));
                }
                BufferedWriter bwFile = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                String text = this.jTextArea.getText();
                bwFile.write(text);
                bwFile.close();
                this.file = file;
                this.changed = false;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("loadDocument file=" + file + " failed:" + e.getMessage()), (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("loadDocument file=" + file + " failed:" + e.getMessage()), (Throwable)e);
            }
        } else {
            this.file = null;
        }
    }

    private JCheckBox getJCheckBoxAutoScrolling() {
        if (this.jCheckBoxAutoScrolling == null) {
            this.jCheckBoxAutoScrolling = new JCheckBox();
            this.jCheckBoxAutoScrolling.setText("auto scrolling");
            this.jCheckBoxAutoScrolling.setSelected(true);
            this.jCheckBoxAutoScrolling.setToolTipText("shows always the end of text");
        }
        return this.jCheckBoxAutoScrolling;
    }

    private JCheckBox getJCheckBoxLoggingEnabled() {
        if (this.jCheckBoxLoggingEnabled == null) {
            this.jCheckBoxLoggingEnabled = new JCheckBox();
            this.jCheckBoxLoggingEnabled.setText("logging on");
            this.jCheckBoxLoggingEnabled.setSelected(this.loggingEnabled);
            this.jCheckBoxLoggingEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LogPanel.this.loggingEnabled = LogPanel.this.jCheckBoxLoggingEnabled.isSelected();
                }
            });
        }
        return this.jCheckBoxLoggingEnabled;
    }

    public final String getSuggestedFileName() {
        return this.suggestedFileName;
    }

    public final void setSuggestedFileName(String suggestedFileName) {
        this.suggestedFileName = suggestedFileName;
        this.file = null;
    }

    public final boolean isChanged() {
        return this.changed;
    }

    private static class LogWriter
    extends Writer {
        private LogPanel logpanel;

        public LogWriter(LogPanel logframe) {
            this.logpanel = logframe;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(String text) {
            this.logpanel.append(text);
        }

        @Override
        public void write(char[] parm1, int parm2, int parm3) throws IOException {
            this.write(String.valueOf(parm1, parm2, parm3));
        }
    }
}

