/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import sqlrunner.flatfileimport.FileImporter;
import sqlrunner.swinghelper.WindowHelper;

public class MessageView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTextArea textArea = new JTextArea();
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JPanel jPanel1 = new JPanel();
    private final JButton buttonClose = new JButton();
    private final JButton buttonAbort = new JButton();
    private transient FileImporter importer;
    private boolean enabled = true;

    public MessageView() {
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.jbInit();
            this.pack();
            Dimension screen = this.getToolkit().getScreenSize();
            int x = (screen.width >> 1) - (this.getSize().width >> 1);
            int y = (screen.height >> 1) - (this.getSize().height >> 1);
            this.setLocation(x, y);
            this.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFlatFileImportObject(FileImporter importer_loc) {
        this.importer = importer_loc;
    }

    public JTextComponent getTextComponent() {
        return this.textArea;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void jbInit() throws Exception {
        this.setTitle("Import-Message-View");
        this.getContentPane().setLayout(this.borderLayout1);
        this.buttonClose.setText("Schliessen");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageView.this.buttonClose_actionPerformed(e);
            }
        });
        this.buttonAbort.setText("Import abbrechen");
        this.buttonAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageView.this.buttonAbort_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.buttonAbort, null);
        this.jPanel1.add((Component)this.buttonClose, null);
        this.jScrollPane1.setPreferredSize(new Dimension(400, 400));
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.jScrollPane1.getViewport().add((Component)this.textArea, null);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                if (!this.enabled) break;
                this.cancel();
                super.processWindowEvent(e);
                break;
            }
            default: {
                super.processWindowEvent(e);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled_loc) {
        this.enabled = enabled_loc;
        this.buttonAbort.setEnabled(!enabled_loc);
        this.buttonClose.setEnabled(enabled_loc);
    }

    private void cancel() {
        this.dispose();
    }

    private void buttonAbort_actionPerformed(ActionEvent e) {
        this.importer.interrupt();
        this.setEnabled(true);
    }

    private void buttonClose_actionPerformed(ActionEvent e) {
        this.cancel();
    }
}

