/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import sqlrunner.flatfileimport.gui.ImportConfiguratorFrame;

public class ImportConfiguratorTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(ImportConfiguratorTransferHandler.class);
    private static final long serialVersionUID = 1L;
    private ImportConfiguratorFrame configurator;
    private boolean dragActionIsActive = false;

    public ImportConfiguratorTransferHandler(ImportConfiguratorFrame configurator) {
        this.configurator = configurator;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        if (this.dragActionIsActive) {
            return false;
        }
        if (this.hasFileFlavor(flavors)) {
            return true;
        }
        return this.hasStringFlavor(flavors);
    }

    private boolean hasFileFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStringFlavor(DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        try {
            if (this.hasFileFlavor(t.getTransferDataFlavors())) {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() > 0) {
                    File f = (File)files.get(0);
                    this.configurator.handleFile(f);
                    return true;
                }
            } else if (this.hasStringFlavor(t.getTransferDataFlavors())) {
                String propertiesAsString = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.configurator.handleConfigProperties(propertiesAsString);
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error((Object)("unsuppported dragged data flavor: " + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (!(c instanceof JTable)) {
            return null;
        }
        String data = null;
        try {
            data = this.configurator.getConfigurationPropertiesAsString();
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        this.dragActionIsActive = true;
        return new StringSelection(data);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected void exportDone(JComponent c, Transferable data, int action) {
        this.dragActionIsActive = false;
    }
}

