/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sqlrunner.Main;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.gui.ImportConfiguratorFrame;
import sqlrunner.flatfileimport.gui.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class DescriptionEditor
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane;
    private JComboBox cbPositionType;
    private JTextField textFieldColumnName;
    private JLabel labelIndex;
    private JLabel jLabelDefaultValue;
    private JCheckBox checkboxEnabled;
    private JCheckBox checkboxIsPrimaryKey;
    private JComboBox cbBasicType;
    private JComboBox comboboxDateFormat;
    private JComboBox comboBoxLocale;
    private JTextField textFieldDelimPos;
    private JTextField textFieldAbsPos;
    private JTextField textFieldLength;
    private JButton buttonOk;
    private JButton buttonCancel;
    private transient FieldDescription fd = null;
    private JLabel labelRegelText;
    private boolean okPerformed;
    static String tooltipTextDate = "<HTML><BODY>" + Messages.getString("DescriptionEditor.1") + Messages.getString("DescriptionEditor.2") + Messages.getString("DescriptionEditor.3") + Messages.getString("DescriptionEditor.4") + Messages.getString("DescriptionEditor.5") + Messages.getString("DescriptionEditor.6") + Messages.getString("DescriptionEditor.7") + "</BODY></HTML>";
    private JTextField textFieldDefaultValue;
    private JComboBox cbAlternativeFieldDescription;
    private JCheckBox jCheckBoxAggregateValues = null;
    private JCheckBox jCheckBoxNotNull = null;
    private JCheckBox jCheckBoxIgnoreDatasetIfInvalid = null;
    private JTextField jTextFieldGeneratorStartValue = null;
    private JTextField jTextFieldRegex = null;
    private JCheckBox jCheckBoxTrim;
    private ImportConfiguratorFrame configuratorFrame;

    public DescriptionEditor(ImportConfiguratorFrame configuratorFrame, FieldDescription desc) {
        super((Frame)configuratorFrame, true);
        this.fd = desc;
        this.configuratorFrame = configuratorFrame;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.loadDescription(this.fd);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DescriptionEditor(ImportConfiguratorFrame configuratorFrame) {
        super((Frame)configuratorFrame, true);
        this.configuratorFrame = configuratorFrame;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initComponents();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() throws Exception {
        this.setTitle(Messages.getString("DescriptionEditor.newfielddesc"));
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.buttonOk);
        this.initComboBoxes();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.gridwidth = 5;
            this.labelIndex = new JLabel();
            this.labelIndex.setBackground(new Color(255, 255, 240));
            this.labelIndex.setText(Messages.getString("DescriptionEditor.chronlogicalorder"));
            this.labelIndex.setFont(new Font("Dialog", 0, 12));
            this.labelIndex.setForeground(Color.black);
            this.labelIndex.setBorder(BorderFactory.createEtchedBorder());
            this.labelIndex.setOpaque(true);
            this.labelIndex.setHorizontalAlignment(0);
            this.jContentPane.add((Component)this.labelIndex, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.gridwidth = 3;
            this.checkboxEnabled = new JCheckBox();
            this.checkboxEnabled.setOpaque(false);
            this.checkboxEnabled.setText(Messages.getString("DescriptionEditor.enablefield"));
            this.jContentPane.add((Component)this.checkboxEnabled, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.anchor = 13;
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.tablefield"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.textFieldColumnName = new JTextField();
            this.textFieldColumnName.setToolTipText(Messages.getString("DescriptionEditor.fieldintargettable"));
            this.jContentPane.add((Component)this.textFieldColumnName, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.gridwidth = 5;
            this.checkboxIsPrimaryKey = new JCheckBox();
            this.checkboxIsPrimaryKey.setOpaque(false);
            this.checkboxIsPrimaryKey.setText(Messages.getString("DescriptionEditor.unique"));
            this.jContentPane.add((Component)this.checkboxIsPrimaryKey, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 10, 2, 0);
            gbc.gridwidth = 2;
            this.jContentPane.add((Component)this.getJCheckBoxNotNull(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 10, 2, 0);
            gbc.gridwidth = 2;
            this.jContentPane.add((Component)this.getJCheckBoxIgnoreDatasetIfInvalid(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 13;
            gbc.gridwidth = 1;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.datatype1"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.cbBasicType = new JComboBox();
            this.cbBasicType.setToolTipText(Messages.getString("DescriptionEditor.datatype"));
            this.cbBasicType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DescriptionEditor.this.cbBasicType_itemStateChanged(e);
                }
            });
            this.jContentPane.add((Component)this.cbBasicType, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.anchor = 17;
            gbc.gridwidth = 3;
            this.jContentPane.add((Component)this.getJCheckBoxAggregateValues(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.anchor = 13;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.format"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.comboboxDateFormat = new JComboBox();
            this.comboboxDateFormat.setEditable(true);
            this.jContentPane.add((Component)this.comboboxDateFormat, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.anchor = 13;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.locale"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.gridx = 1;
            gbc.gridy = 8;
            gbc.weightx = 1.0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.comboBoxLocale = new JComboBox();
            this.comboBoxLocale.setEditable(true);
            this.jContentPane.add((Component)this.comboBoxLocale, gbc);
            gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridx = 0;
            gbc.gridy = 9;
            gbc.insets = new Insets(2, 10, 2, 2);
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.alternativefield"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 9;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.cbAlternativeFieldDescription = new JComboBox();
            this.jContentPane.add((Component)this.cbAlternativeFieldDescription, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 10;
            gbc.anchor = 13;
            this.jLabelDefaultValue = new JLabel();
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.defaultvalue"));
            this.jContentPane.add((Component)this.jLabelDefaultValue, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 10;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.textFieldDefaultValue = new JTextField();
            this.jContentPane.add((Component)this.textFieldDefaultValue, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 11;
            gbc.anchor = 13;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.positioning"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.gridx = 1;
            gbc.gridy = 11;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.cbPositionType = new JComboBox();
            this.cbPositionType.setToolTipText(Messages.getString("DescriptionEditor.kindofselection"));
            this.cbPositionType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    DescriptionEditor.this.cbPositionType_itemStateChanged(e);
                }
            });
            this.jContentPane.add((Component)this.cbPositionType, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 12;
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.fromcountdelimiter"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 2;
            gbc.gridy = 12;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.textFieldDelimPos = new JTextField();
            this.textFieldDelimPos.setEnabled(false);
            this.jContentPane.add((Component)this.textFieldDelimPos, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 13;
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.absolutecharpos"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 2;
            gbc.gridy = 13;
            gbc.insets = new Insets(2, 2, 2, 10);
            gbc.weightx = 1.0;
            this.textFieldAbsPos = new JTextField();
            this.textFieldAbsPos.setEnabled(false);
            this.jContentPane.add((Component)this.textFieldAbsPos, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 10, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 14;
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.readnumberofchars"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 2;
            gbc.gridy = 14;
            gbc.weightx = 1.0;
            gbc.gridwidth = 1;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.textFieldLength = new JTextField();
            this.textFieldLength.setEnabled(false);
            this.jContentPane.add((Component)this.textFieldLength, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 15;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridwidth = 2;
            jLabel = new JLabel();
            jLabel.setText(Messages.getString("DescriptionEditor.0"));
            this.jContentPane.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 2;
            gbc.gridy = 15;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.jContentPane.add((Component)this.getJTextFieldGeneratorStartValue(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 16;
            gbc.anchor = 17;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.jContentPane.add((Component)this.getJCheckBoxTrim(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 17;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 0);
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Regex");
            this.jContentPane.add((Component)jLabel3, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 17;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(2, 2, 2, 10);
            this.jContentPane.add((Component)this.getJTextFieldRegex(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 18;
            gbc.fill = 2;
            gbc.gridwidth = 3;
            this.labelRegelText = new JLabel();
            this.labelRegelText.setBackground(new Color(255, 255, 240));
            this.labelRegelText.setFont(new Font("Dialog", 0, 12));
            this.labelRegelText.setForeground(Color.black);
            this.labelRegelText.setBorder(BorderFactory.createEtchedBorder());
            this.labelRegelText.setOpaque(true);
            this.labelRegelText.setToolTipText(Messages.getString("DescriptionEditor.summary"));
            this.labelRegelText.setText("    ");
            this.labelRegelText.setHorizontalAlignment(0);
            this.jContentPane.add((Component)this.labelRegelText, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 20, 5, 2);
            gbc.gridx = 0;
            gbc.gridy = 19;
            gbc.anchor = 13;
            gbc.gridwidth = 1;
            this.buttonCancel = new JButton();
            this.buttonCancel.setText(Messages.getString("DescriptionEditor.cancel"));
            this.buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DescriptionEditor.this.buttonCancel_actionPerformed(e);
                }
            });
            this.jContentPane.add((Component)this.buttonCancel, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 5, 20);
            gbc.gridx = 1;
            gbc.gridy = 19;
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            this.buttonOk = new JButton();
            this.buttonOk.setText(Messages.getString("DescriptionEditor.accept"));
            this.buttonOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DescriptionEditor.this.buttonOk_actionPerformed(e);
                }
            });
            this.jContentPane.add((Component)this.buttonOk, gbc);
        }
        return this.jContentPane;
    }

    private void setupComboBoxAlternativeField() {
        this.cbAlternativeFieldDescription.removeAllItems();
        this.cbAlternativeFieldDescription.addItem(Messages.getString("DescriptionEditor.noalternativefield"));
        int max = this.configuratorFrame.getAllFieldDescriptions().size();
        for (int i = 0; i < max; ++i) {
            FieldDescription temp = this.configuratorFrame.getAllFieldDescriptions().get(i);
            if (temp.equals(this.fd)) continue;
            this.cbAlternativeFieldDescription.addItem(temp);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    private void cancel() {
        this.dispose();
    }

    private void initComboBoxes() {
        this.cbBasicType.addItem(BasicDataType.CHARACTER);
        this.cbBasicType.addItem(BasicDataType.DATE);
        this.cbBasicType.addItem(BasicDataType.DOUBLE);
        this.cbBasicType.addItem(BasicDataType.INTEGER);
        this.cbBasicType.addItem(BasicDataType.LONG);
        this.cbBasicType.addItem(BasicDataType.BOOLEAN);
        this.cbBasicType.addItem("--");
        this.cbBasicType.addItem(BasicDataType.CLOB);
        this.cbBasicType.addItem(BasicDataType.ROWID);
        this.cbBasicType.addItem("--");
        this.cbBasicType.addItem(BasicDataType.SQLEXP);
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(0));
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(1));
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(2));
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(3));
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(4));
        this.cbPositionType.addItem(FieldDescription.getPositioningTypeName(5));
        this.setupComboBoxAlternativeField();
        this.prepareComboBoxFormatForDate();
        this.prepareComboBoxLocale();
    }

    private void prepareComboBoxFormatForDate() {
        String formatStr;
        int i = 0;
        this.comboboxDateFormat.removeAllItems();
        while ((formatStr = Main.getDefaultProperty("DATE_FORMAT_" + String.valueOf(i))) != null) {
            this.comboboxDateFormat.addItem(formatStr);
            ++i;
        }
        this.comboboxDateFormat.setToolTipText(tooltipTextDate);
    }

    private void prepareComboBoxLocale() {
        this.comboBoxLocale.removeAllItems();
        Locale[] locales = NumberFormat.getAvailableLocales();
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (int i = 0; i < locales.length; ++i) {
            this.comboBoxLocale.addItem(locales[i]);
        }
        this.comboBoxLocale.setSelectedItem(new Locale("en_US"));
        this.comboBoxLocale.setToolTipText("select location for your numbers");
    }

    public void setFieldDescription(FieldDescription fd_loc) {
        this.fd = fd_loc;
        this.loadDescription(fd_loc);
    }

    private void loadDescription(FieldDescription fd_loc) {
        if (fd_loc == null) {
            throw new IllegalArgumentException("fd_loc cannot be null");
        }
        this.textFieldColumnName.setText(fd_loc.getName());
        if (fd_loc.isDummy()) {
            this.labelIndex.setText(" ");
        } else {
            this.labelIndex.setText(Messages.getString("DescriptionEditor.willbereadas") + String.valueOf(fd_loc.getIndex() + 1) + Messages.getString("DescriptionEditor.readed"));
        }
        this.checkboxEnabled.setSelected(fd_loc.isEnabled());
        this.checkboxIsPrimaryKey.setSelected(fd_loc.isPartOfPrimaryKey());
        this.cbBasicType.setSelectedItem(BasicDataType.getBasicDataType(fd_loc.getBasicTypeId()));
        this.setComboboxDateFormatItem(fd_loc.getFieldFormat());
        this.setComboboxLocaleItem(fd_loc.getLocale());
        if (fd_loc.getDefaultValue() != null) {
            this.textFieldDefaultValue.setText(fd_loc.getDefaultValue());
        } else {
            this.textFieldDefaultValue.setText("");
        }
        this.cbPositionType.setSelectedIndex(fd_loc.getPositionType());
        if (fd_loc.getDelimPos() != -1) {
            this.textFieldDelimPos.setText(String.valueOf(fd_loc.getDelimPos()));
        }
        if (fd_loc.getAbsPos() != -1) {
            this.textFieldAbsPos.setText(String.valueOf(fd_loc.getAbsPos()));
        }
        this.textFieldLength.setText(String.valueOf(fd_loc.getLength()));
        this.labelRegelText.setText(fd_loc.getExtractionDescription());
        this.jCheckBoxAggregateValues.setSelected(fd_loc.isAggregateNumberValues());
        if (this.fd.getName() != null) {
            this.setTitle(Messages.getString("DescriptionEditor.importfielddesc") + this.fd.getName());
        } else {
            this.setTitle(Messages.getString("DescriptionEditor.importfielddesc"));
        }
        this.jCheckBoxNotNull.setSelected(!fd_loc.isNullEnabled());
        this.jCheckBoxIgnoreDatasetIfInvalid.setSelected(fd_loc.isIgnoreDatasetIfInvalid());
        this.jTextFieldGeneratorStartValue.setText(fd_loc.getGeneratorStartValue());
        this.jCheckBoxTrim.setSelected(fd_loc.isTrimRequired());
        this.jTextFieldRegex.setText(this.fd.getRegex());
        if (fd_loc.getAlternativeFieldDescription() != null) {
            this.cbAlternativeFieldDescription.setSelectedItem(fd_loc.getAlternativeFieldDescription());
        } else {
            this.cbAlternativeFieldDescription.setSelectedIndex(0);
        }
    }

    private void setComboboxDateFormatItem(String format) {
        if (format != null) {
            int i;
            for (i = 0; i < this.comboboxDateFormat.getItemCount(); ++i) {
                if (!format.equals(this.comboboxDateFormat.getItemAt(i).toString())) continue;
                this.comboboxDateFormat.setSelectedIndex(i);
                break;
            }
            if (i == this.comboboxDateFormat.getItemCount()) {
                this.comboboxDateFormat.addItem(format);
                this.comboboxDateFormat.setSelectedItem(format);
            }
        }
    }

    private void setComboboxLocaleItem(Locale locale) {
        this.comboBoxLocale.setSelectedItem(locale);
    }

    private void buttonCancel_actionPerformed(ActionEvent e) {
        this.okPerformed = false;
        this.cancel();
    }

    private Locale getSelectedLocale() {
        Object o = this.comboBoxLocale.getSelectedItem();
        if (o instanceof Locale) {
            return (Locale)o;
        }
        if (o instanceof String) {
            return new Locale((String)o);
        }
        return null;
    }

    private void buttonOk_actionPerformed(ActionEvent e) {
        this.fd.setName(this.textFieldColumnName.getText().trim());
        this.fd.setDefaultValue(this.textFieldDefaultValue.getText());
        this.fd.setEnabled(this.checkboxEnabled.isSelected());
        this.fd.setIsPartOfPrimaryKey(this.checkboxIsPrimaryKey.isSelected());
        BasicDataType type = (BasicDataType)this.cbBasicType.getSelectedItem();
        if (type != null) {
            this.fd.setBasicTypeId(type.getId());
        }
        this.fd.setAggregateNumberValues(this.jCheckBoxAggregateValues.isSelected());
        Object item = this.comboboxDateFormat.getSelectedItem();
        if (item != null) {
            this.fd.setFormat(item.toString().trim());
        }
        this.fd.setLocale(this.getSelectedLocale());
        this.fd.setPositionType(this.cbPositionType.getSelectedIndex());
        switch (this.fd.getPositionType()) {
            case 0: {
                if (this.textFieldAbsPos.getText().length() > 0) {
                    this.fd.setAbsPos(Integer.parseInt(this.textFieldAbsPos.getText()));
                }
                if (this.textFieldLength.getText().length() <= 0) break;
                this.fd.setLength(Integer.parseInt(this.textFieldLength.getText()));
                break;
            }
            case 1: {
                if (this.textFieldLength.getText().length() <= 0) break;
                this.fd.setLength(Integer.parseInt(this.textFieldLength.getText()));
                break;
            }
            case 3: {
                if (this.textFieldLength.getText().length() > 0) {
                    this.fd.setLength(Integer.parseInt(this.textFieldLength.getText()));
                }
                if (this.textFieldDelimPos.getText().length() <= 0) break;
                this.fd.setDelimPos(Integer.parseInt(this.textFieldDelimPos.getText()));
                break;
            }
            case 2: {
                if (this.textFieldDelimPos.getText().length() <= 0) break;
                this.fd.setDelimPos(Integer.parseInt(this.textFieldDelimPos.getText()));
            }
        }
        this.fd.setNullEnabled(!this.jCheckBoxNotNull.isSelected());
        this.fd.setIgnoreDatasetIfInvalid(this.jCheckBoxIgnoreDatasetIfInvalid.isSelected());
        this.fd.setGeneratorStartValue(this.jTextFieldGeneratorStartValue.getText());
        this.fd.setFilterRegex(this.jTextFieldRegex.getText());
        this.fd.setTrimRequired(this.jCheckBoxTrim.isSelected());
        Object test = this.cbAlternativeFieldDescription.getSelectedItem();
        if (test instanceof FieldDescription) {
            this.fd.setAlternativeFieldDescriptionName(((FieldDescription)test).getName());
            this.fd.setAlternativeFieldDescription((FieldDescription)test);
        } else {
            this.fd.setAlternativeFieldDescriptionName(null);
            this.fd.setAlternativeFieldDescription(null);
        }
        if (this.fd.validate()) {
            this.okPerformed = true;
            this.cancel();
        } else {
            JOptionPane.showMessageDialog(this, this.fd.getErrorMessage(), Messages.getString("DescriptionEditor.checkdesc"), 0);
        }
    }

    public boolean isOkPerformed() {
        return this.okPerformed;
    }

    private void cbPositionType_itemStateChanged(ItemEvent e) {
        if (this.cbPositionType.getSelectedItem() != null) {
            this.cbPositionType.setToolTipText(this.cbPositionType.getSelectedItem().toString());
        }
        switch (this.cbPositionType.getSelectedIndex()) {
            case 0: {
                this.textFieldAbsPos.setEnabled(true);
                this.textFieldLength.setEnabled(true);
                this.textFieldDelimPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(true);
                this.jCheckBoxTrim.setEnabled(true);
                this.jTextFieldGeneratorStartValue.setEnabled(false);
                break;
            }
            case 1: {
                this.textFieldLength.setEnabled(true);
                this.textFieldAbsPos.setEnabled(false);
                this.textFieldDelimPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(true);
                this.jCheckBoxTrim.setEnabled(true);
                this.jTextFieldGeneratorStartValue.setEnabled(false);
                break;
            }
            case 3: {
                this.textFieldLength.setEnabled(true);
                this.textFieldDelimPos.setEnabled(true);
                this.textFieldAbsPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(true);
                this.jCheckBoxTrim.setEnabled(true);
                this.jTextFieldGeneratorStartValue.setEnabled(false);
                break;
            }
            case 2: {
                this.textFieldDelimPos.setEnabled(true);
                this.textFieldLength.setEnabled(false);
                this.textFieldAbsPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(true);
                this.jCheckBoxTrim.setEnabled(true);
                this.jTextFieldGeneratorStartValue.setEnabled(false);
                break;
            }
            case 4: {
                this.textFieldDelimPos.setEnabled(false);
                this.textFieldLength.setEnabled(false);
                this.textFieldAbsPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(false);
                this.jCheckBoxTrim.setEnabled(false);
                this.jTextFieldGeneratorStartValue.setEnabled(true);
                break;
            }
            case 5: {
                this.textFieldDelimPos.setEnabled(false);
                this.textFieldLength.setEnabled(false);
                this.textFieldAbsPos.setEnabled(false);
                this.jTextFieldRegex.setEnabled(false);
                this.jCheckBoxTrim.setEnabled(false);
                this.jTextFieldGeneratorStartValue.setEnabled(false);
            }
        }
    }

    private void cbBasicType_itemStateChanged(ItemEvent e) {
        BasicDataType type = (BasicDataType)this.cbBasicType.getSelectedItem();
        if (type == BasicDataType.DATE) {
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.defaultvalue"));
            this.comboboxDateFormat.setEnabled(true);
            this.comboboxDateFormat.setToolTipText(tooltipTextDate);
            this.comboBoxLocale.setEnabled(true);
            this.jCheckBoxTrim.setEnabled(true);
            this.jTextFieldRegex.setEnabled(true);
            this.jCheckBoxAggregateValues.setEnabled(false);
            this.cbAlternativeFieldDescription.setEnabled(true);
            this.cbPositionType.setEnabled(true);
        } else if (BasicDataType.isNumberType(type)) {
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.defaultvalue"));
            this.comboboxDateFormat.setEnabled(false);
            this.comboBoxLocale.setEnabled(true);
            this.jCheckBoxTrim.setEnabled(true);
            this.jTextFieldRegex.setEnabled(true);
            this.jCheckBoxAggregateValues.setEnabled(true);
            this.cbAlternativeFieldDescription.setEnabled(true);
            this.cbPositionType.setEnabled(true);
        } else if (type == BasicDataType.BOOLEAN) {
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.defaultvalue"));
            this.comboboxDateFormat.setEnabled(false);
            this.comboBoxLocale.setEnabled(false);
            this.jCheckBoxTrim.setEnabled(true);
            this.jTextFieldRegex.setEnabled(true);
            this.jCheckBoxAggregateValues.setEnabled(false);
            this.cbAlternativeFieldDescription.setEnabled(true);
            this.cbPositionType.setEnabled(true);
        } else if (type == BasicDataType.SQLEXP) {
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.sqlterm"));
            this.comboboxDateFormat.setEnabled(false);
            this.comboboxDateFormat.setToolTipText(null);
            this.comboBoxLocale.setEnabled(false);
            this.jCheckBoxTrim.setEnabled(false);
            this.jTextFieldRegex.setEnabled(false);
            this.jCheckBoxAggregateValues.setEnabled(false);
            this.cbAlternativeFieldDescription.setEnabled(false);
            this.cbPositionType.setEnabled(false);
        } else {
            this.jLabelDefaultValue.setText(Messages.getString("DescriptionEditor.defaultvalue"));
            this.comboboxDateFormat.setEnabled(false);
            this.comboboxDateFormat.setToolTipText(null);
            this.comboBoxLocale.setEnabled(false);
            this.jCheckBoxTrim.setEnabled(true);
            this.jTextFieldRegex.setEnabled(true);
            this.jCheckBoxAggregateValues.setEnabled(false);
            this.cbAlternativeFieldDescription.setEnabled(true);
            this.cbPositionType.setEnabled(true);
        }
    }

    private JCheckBox getJCheckBoxAggregateValues() {
        if (this.jCheckBoxAggregateValues == null) {
            this.jCheckBoxAggregateValues = new JCheckBox();
            this.jCheckBoxAggregateValues.setText(Messages.getString("DescriptionEditor.aggregatevalues"));
        }
        return this.jCheckBoxAggregateValues;
    }

    private JCheckBox getJCheckBoxNotNull() {
        if (this.jCheckBoxNotNull == null) {
            this.jCheckBoxNotNull = new JCheckBox();
            this.jCheckBoxNotNull.setText(Messages.getString("DescriptionEditor.notnull"));
        }
        return this.jCheckBoxNotNull;
    }

    private JCheckBox getJCheckBoxIgnoreDatasetIfInvalid() {
        if (this.jCheckBoxIgnoreDatasetIfInvalid == null) {
            this.jCheckBoxIgnoreDatasetIfInvalid = new JCheckBox();
            this.jCheckBoxIgnoreDatasetIfInvalid.setText(Messages.getString("DescriptionEditor.ignoreDatasetIfInvalid"));
        }
        return this.jCheckBoxIgnoreDatasetIfInvalid;
    }

    private JTextField getJTextFieldGeneratorStartValue() {
        if (this.jTextFieldGeneratorStartValue == null) {
            this.jTextFieldGeneratorStartValue = new JTextField();
        }
        return this.jTextFieldGeneratorStartValue;
    }

    private JTextField getJTextFieldRegex() {
        if (this.jTextFieldRegex == null) {
            this.jTextFieldRegex = new JTextField();
        }
        return this.jTextFieldRegex;
    }

    private JCheckBox getJCheckBoxTrim() {
        if (this.jCheckBoxTrim == null) {
            this.jCheckBoxTrim = new JCheckBox();
            this.jCheckBoxTrim.setText(Messages.getString("DescriptionEditor.trim"));
        }
        return this.jCheckBoxTrim;
    }
}

