/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import sqlrunner.flatfileimport.DatasetProvider;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.ImportAttributes;
import sqlrunner.flatfileimport.XLSFieldParser;

public class XLSFileDatasetProvider
implements DatasetProvider {
    protected Sheet workSheet = null;
    private Workbook book;
    private FileInputStream fileInputStream;
    protected int currentRowNum = -1;

    @Override
    public long retrieveDatasetCount() throws Exception {
        if (this.workSheet == null) {
            throw new IllegalStateException("setupDatasetProvider not performed");
        }
        return this.workSheet.getLastRowNum() + 1;
    }

    protected Workbook createWorkbook(File file) throws Exception {
        this.fileInputStream = new FileInputStream(file);
        this.book = new HSSFWorkbook((InputStream)this.fileInputStream);
        return this.book;
    }

    @Override
    public void closeDatasetProvider() {
        this.book = null;
        try {
            this.fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.workSheet = null;
    }

    @Override
    public FieldTokenizer createParser() {
        XLSFieldParser parser = new XLSFieldParser();
        return parser;
    }

    @Override
    public Object getNextDataset() throws Exception {
        ++this.currentRowNum;
        Row row = this.workSheet.getRow(this.currentRowNum);
        return row;
    }

    @Override
    public void setupDatasetProvider(File file, boolean testMode, ImportAttributes properties) throws Exception {
        this.book = this.createWorkbook(file);
        if (properties.getSheetName() != null) {
            this.workSheet = this.book.getSheet(properties.getSheetName());
            if (this.workSheet == null) {
                throw new Exception("No sheet with name=" + properties.getSheetName() + " available");
            }
        } else {
            this.workSheet = this.book.getSheetAt(0);
            if (this.workSheet == null) {
                throw new Exception("No sheet at index 0 available");
            }
        }
        this.currentRowNum = -1;
    }

    @Override
    public long getCurrentRowNum() {
        return this.currentRowNum;
    }

    @Override
    public Object getDatasetAtRowInTestMode(long rowNumber) throws Exception {
        if (rowNumber < 0L) {
            throw new IllegalArgumentException("rowNumber cannot be less zero");
        }
        this.currentRowNum = (int)rowNumber;
        if (this.workSheet != null) {
            return this.workSheet.getRow(this.currentRowNum);
        }
        return null;
    }
}

