/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class RandomAccessReader
extends Reader {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private RandomAccessFile raf;
    private char[] buffer;
    private byte[] bytes;
    private int bufferPos = 0;
    private int bufferEnd = 0;
    private long raPtrPos = 0L;
    private String charSet = null;
    private boolean useEnclosure = false;
    private char enclosure = (char)32;

    public RandomAccessReader(RandomAccessFile raf, String charSet) throws IOException {
        this(raf, 8192);
        this.charSet = charSet;
    }

    public RandomAccessReader(RandomAccessFile raf, int sz) throws IOException {
        this.raf = raf;
        this.buffer = new char[sz];
        this.bytes = new byte[sz];
        this.resetBuffer();
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
        this.raf = null;
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public final int read() throws IOException {
        if (this.bufferPos >= this.bufferEnd && this.fill() < 0) {
            return -1;
        }
        if (this.bufferEnd == 0) {
            return -1;
        }
        return this.buffer[this.bufferPos++];
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int remainder = this.bufferEnd - this.bufferPos;
        if (len <= remainder) {
            System.arraycopy(this.buffer, this.bufferPos, cbuf, off, len);
            this.bufferPos += len;
            return len;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                return i;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    public long getFilePointer() throws IOException {
        return this.raPtrPos - (long)this.bufferEnd + (long)this.bufferPos;
    }

    public void seek(long pos) throws IOException {
        int p = (int)(this.raPtrPos - pos);
        if (p >= 0 && p <= this.bufferEnd) {
            this.bufferPos = this.bufferEnd - p;
        } else {
            this.raf.seek(pos);
            this.resetBuffer();
        }
    }

    private int fill() throws IOException {
        int b;
        if (this.raf == null) {
            throw new IOException("Random access file closed");
        }
        int i = b = this.raf.read(this.bytes, 0, 8192);
        while (--i >= 0) {
            this.buffer[i] = (char)this.bytes[i];
        }
        if (b >= 0) {
            this.raPtrPos += (long)b;
            this.bufferPos = 0;
            this.bufferEnd = b;
        }
        return b;
    }

    private void resetBuffer() throws IOException {
        this.bufferPos = 0;
        this.bufferEnd = 0;
        this.raPtrPos = this.raf.getFilePointer();
    }

    public final String readLineWithCharSet() throws IOException {
        int n;
        if (this.charSet == null || this.charSet.length() == 0) {
            throw new IOException("charset not set");
        }
        ByteBuffer input = new ByteBuffer();
        int n2 = -1;
        boolean eol = false;
        boolean inEnclosure = false;
        block6: while (!eol) {
            n = this.read();
            if (this.useEnclosure && n == this.enclosure) {
                inEnclosure = !inEnclosure;
            }
            switch (n) {
                case -1: 
                case 10: {
                    if (inEnclosure) continue block6;
                    eol = true;
                    continue block6;
                }
                case 13: {
                    if (!inEnclosure) {
                        eol = true;
                    }
                    long cur = this.getFilePointer();
                    if (this.read() == 10) continue block6;
                    this.seek(cur);
                    continue block6;
                }
            }
            input.add((byte)n);
        }
        if (n == -1 && input.length() == 0) {
            return null;
        }
        String line = "";
        try {
            line = new String(input.getBytes(), this.charSet);
        }
        catch (UnsupportedEncodingException usee) {
            throw new IOException(usee);
        }
        return line;
    }

    public final boolean seekToNextLineStart() throws IOException {
        boolean inEnclosure = false;
        while (true) {
            int c = this.read();
            if (this.useEnclosure && c == this.enclosure) {
                inEnclosure = !inEnclosure;
            }
            switch (c) {
                case -1: {
                    return false;
                }
                case 10: {
                    if (!inEnclosure) {
                        return true;
                    }
                }
                case 13: {
                    long cur = this.getFilePointer();
                    c = this.read();
                    if (c != 10 && c != -1) {
                        this.seek(cur);
                    }
                    if (c == -1) {
                        return false;
                    }
                    if (inEnclosure) break;
                    return true;
                }
            }
        }
    }

    public boolean seekToPrevLineStart() throws IOException {
        boolean inEnclosure = false;
        boolean lastEol = true;
        block4: while (true) {
            int c = this.readBackwards();
            if (this.useEnclosure && c == this.enclosure) {
                inEnclosure = !inEnclosure;
            }
            switch (c) {
                case -1: {
                    return !lastEol;
                }
                case 10: 
                case 13: {
                    if (inEnclosure) break;
                    if (lastEol) {
                        lastEol = false;
                        long cur = this.getFilePointer();
                        if (this.readBackwards() == 13) continue block4;
                        this.seek(cur);
                        break;
                    }
                    this.read();
                    return true;
                }
            }
        }
    }

    public int readBackwards() throws IOException {
        long cur = this.getFilePointer();
        if (cur == 0L) {
            return -1;
        }
        this.raf.seek(--cur);
        int c = this.raf.read();
        this.raf.seek(cur);
        this.resetBuffer();
        return c;
    }

    public char getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(char enclosure) {
        this.useEnclosure = true;
        this.enclosure = enclosure;
    }

    public void disableEnclosure() {
        this.useEnclosure = false;
    }

    private static final class ByteBuffer {
        private byte[] value = new byte[256];
        private int count = 0;

        private ByteBuffer() {
        }

        public void add(byte b) {
            int newCount = this.count + 1;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = b;
        }

        public byte[] getBytes() {
            byte[] byteArray = new byte[this.count];
            for (int i = 0; i < this.count; ++i) {
                byteArray[i] = this.value[i];
            }
            return byteArray;
        }

        public int length() {
            return this.count;
        }

        private void expandCapacity(int minimumCapacity) {
            int newCapacity = (this.value.length + 1) * 2;
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            } else if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            byte[] newValue = new byte[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
        }
    }
}

