/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.export.ExportFormatPanel;
import sqlrunner.export.Messages;
import sqlrunner.export.TargetPanel;
import sqlrunner.swinghelper.WindowHelper;

public class ResultTableExportDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(ResultTableExportDialog.class);
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private ExportFormatPanel exportFormatPanel = null;
    private TargetPanel targetPanel = null;
    private JPanel jPanelButtons = null;
    private JButton jButtonStart = null;
    private JButton jButtonClose = null;
    private MainFrame mainFrame = null;

    public ResultTableExportDialog(MainFrame mainFrame) {
        super(mainFrame);
        this.mainFrame = mainFrame;
        this.initialize();
        this.pack();
        WindowHelper.checkAndCorrectWindowBounds(this);
    }

    private void initialize() {
        this.setTitle(Messages.getString("ResultTableExportDialog.0"));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridy = 0;
            this.jContentPane.add((Component)this.getExportFormatPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridy = 1;
            this.jContentPane.add((Component)this.getTargetPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.fill = 2;
            gbc.gridy = 2;
            this.jContentPane.add((Component)this.getJPanelButtons(), gbc);
        }
        return this.jContentPane;
    }

    private ExportFormatPanel getExportFormatPanel() {
        if (this.exportFormatPanel == null) {
            this.exportFormatPanel = new ExportFormatPanel();
            this.exportFormatPanel.setDateSQLExpression(Main.getUserProperty("SQL_STRING_DATE_CONVERSION", "to_date('<STRING>','dd.MM.yy HH24:MI')"));
            this.exportFormatPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("flat")) {
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeCSV(true);
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeXLS(true);
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeSQL(false);
                    } else {
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeCSV(false);
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeXLS(false);
                        ResultTableExportDialog.this.getTargetPanel().enableFileTypeSQL(true);
                    }
                }
            });
        }
        return this.exportFormatPanel;
    }

    private TargetPanel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = new TargetPanel(true);
        }
        return this.targetPanel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridy = 0;
            this.jPanelButtons.add((Component)this.getJButtonStart(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridy = 0;
            this.jPanelButtons.add((Component)this.getJButtonClose(), gbc);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonStart() {
        if (this.jButtonStart == null) {
            this.jButtonStart = new JButton();
            this.jButtonStart.setText(Messages.getString("ResultTableExportDialog.1"));
            this.jButtonStart.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResultTableExportDialog.this.startExport();
                }
            });
        }
        return this.jButtonStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExport() {
        Main.setUserProperty("SQL_STRING_DATE_CONVERSION", this.exportFormatPanel.getDateSQLExpression());
        LongRunningAction lra = new LongRunningAction(){

            @Override
            public String getName() {
                return "Export result table";
            }

            @Override
            public void cancel() {
            }

            @Override
            public boolean canBeCanceled() {
                return false;
            }
        };
        MainFrame.addLongRunningAction(lra);
        try {
            this.jButtonStart.setEnabled(false);
            this.jButtonClose.setEnabled(false);
            this.disableEvents(64L);
            int exportType = this.exportFormatPanel.isExportInCSVFileSelected() ? 0 : 1;
            if (this.targetPanel.isExportInFileSelected()) {
                boolean ok = false;
                if (!this.targetPanel.hasFileName()) {
                    JOptionPane.showMessageDialog(this, Messages.getString("ResultTableExportDialog.3"), Messages.getString("ResultTableExportDialog.4"), 1);
                    ok = false;
                    this.targetPanel.setFocusToFileName();
                } else {
                    ok = true;
                }
                if (ok) {
                    int answer;
                    ok = this.targetPanel.getFile().exists() ? (answer = JOptionPane.showConfirmDialog(this, Messages.getString("ResultTableExportDialog.5"), Messages.getString("ResultTableExportDialog.6"), 0, 1)) == 0 : true;
                }
                if (ok) {
                    if (this.targetPanel.shouldFileSplitted()) {
                        try {
                            if (this.mainFrame.getDatabase().exportTableInMultipleFiles(this.targetPanel.getFile(), this.exportFormatPanel.getDelimiter(), this.exportFormatPanel.getEnclosure(), exportType, this.exportFormatPanel.getDateSQLExpression(), this.targetPanel.getMaxLimitDatasetInSplittedFiles(), this.exportFormatPanel.isWithHeaderSelected(), this.exportFormatPanel.isReplacePointWithCommaSelected())) {
                                this.setVisible(false);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            logger.error((Object)("startExport failed:" + nfe.getMessage()), (Throwable)nfe);
                            JOptionPane.showMessageDialog(this, Messages.getString("ResultTableExportDialog.7"), Messages.getString("ResultTableExportDialog.8"), 0);
                        }
                    } else {
                        File targetFile = this.targetPanel.getFile();
                        if (targetFile.getName().toLowerCase().endsWith(".xls") || targetFile.getName().toLowerCase().endsWith(".xlsx")) {
                            this.exportToSpreadsheetFile(targetFile, this.exportFormatPanel.isWithHeaderSelected());
                        } else if (this.mainFrame.getDatabase().exportTableInCSVFile(targetFile, this.exportFormatPanel.getDelimiter(), this.exportFormatPanel.getEnclosure(), exportType, this.exportFormatPanel.getDateSQLExpression(), this.exportFormatPanel.isWithHeaderSelected(), this.exportFormatPanel.isReplacePointWithCommaSelected())) {
                            this.setVisible(false);
                        }
                    }
                }
            } else {
                try {
                    this.mainFrame.insertOrReplaceText(this.mainFrame.getDatabase().exportTableToString(this.exportFormatPanel.getDelimiter(), this.exportFormatPanel.getEnclosure(), exportType, this.exportFormatPanel.getDateSQLExpression(), this.exportFormatPanel.isWithHeaderSelected(), this.exportFormatPanel.isReplacePointWithCommaSelected()));
                    this.setVisible(false);
                }
                catch (NumberFormatException nfe) {
                    logger.error((Object)("startExport failed:" + nfe.getMessage()), (Throwable)nfe);
                    JOptionPane.showMessageDialog(this, Messages.getString("ResultTableExportDialog.9"), Messages.getString("ResultTableExportDialog.10"), 0);
                }
            }
            this.jButtonStart.setEnabled(true);
            this.jButtonClose.setEnabled(true);
            this.enableEvents(64L);
        }
        finally {
            MainFrame.removeLongRunningAction(lra);
        }
    }

    private void exportToSpreadsheetFile(File f, boolean withHeader) {
        try {
            this.mainFrame.getDatabase().exportTableToSpreadSheetFile(f, withHeader);
        }
        catch (Exception e) {
            logger.error((Object)("exportToSpreadsheetFile file=" + f.getAbsolutePath() + " failed:" + e.getMessage()), (Throwable)e);
            JOptionPane.showMessageDialog(this, "Export failed", e.getMessage(), 0);
        }
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText(Messages.getString("ResultTableExportDialog.11"));
            this.jButtonClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResultTableExportDialog.this.setVisible(false);
                }
            });
        }
        return this.jButtonClose;
    }
}

