/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.SQLParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import sqlrunner.BinaryDataFile;
import sqlrunner.export.Exporter;
import sqlrunner.flatfileimport.BasicDataType;

public class ExporterToTextFile
implements Exporter {
    private static Logger staticClassLogger = Logger.getLogger(ExporterToTextFile.class);
    private Logger logger = staticClassLogger;
    private String sqlCode;
    private String delim = "|";
    private String enclosure;
    private String insertStatementBegin;
    private String dateFormatTemplate;
    private BufferedWriter bw;
    private DatabaseSession session;
    private ConnectionDescription cd;
    private File outputFile;
    private long maxDatasetsPerFile = 0L;
    public static final int FILE = 1;
    public static final int INSERT_FORMAT = 2;
    private int exportType = 1;
    private SimpleDateFormat sdf = new SimpleDateFormat();
    private String[] columnNames;
    private File currentFile;
    private int fileIndex = 0;
    private int rowCountOverAll = 0;
    private int rowCountPerFile = 0;
    private boolean createHeaderLine = false;
    private boolean changePointToComma = false;
    private String fileCharSet = null;
    private String lineSeparator = System.getProperty("line.separator");
    private boolean abort = false;
    private String currentAction = null;
    private boolean connected = false;
    private String lastErrorMessage;
    private int status = 0;

    public ExporterToTextFile(ConnectionDescription cd, String sqlCode, File outputFile) {
        this.cd = cd;
        this.sqlCode = sqlCode;
        this.outputFile = new File(outputFile.getAbsolutePath());
    }

    @Override
    public void setConnectionDescription(ConnectionDescription connDesc) {
        this.cd = connDesc;
    }

    @Override
    public void setQuery(String sql) {
        this.sqlCode = sql;
    }

    public void setCharSet(String charSet) {
        this.fileCharSet = charSet;
    }

    public void setExportType(int type) {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("type=" + type + " unknown");
        }
        this.exportType = type;
    }

    public void setCreateHeader(boolean createHeader) {
        this.createHeaderLine = createHeader;
    }

    public void useCommaAsDecimalDelimiter(boolean useCommaAsDecimalDelimiter) {
        this.changePointToComma = useCommaAsDecimalDelimiter;
    }

    public void setMaxDatasetsPerFile(long maxDatasetsPerFile) {
        this.maxDatasetsPerFile = maxDatasetsPerFile;
    }

    public void setDelimiter(String delimiter) {
        this.delim = delimiter;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public void setLineSeparator(String sep) {
        this.lineSeparator = sep;
    }

    @Override
    public void setDateFormat(String pattern) {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new IllegalArgumentException("pattern cannot be null or empty");
        }
        this.sdf = new SimpleDateFormat(pattern);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void resetToStaticLogger() {
        this.logger = staticClassLogger;
    }

    @Override
    public void exportData() throws IOException, SQLException {
        this.abort = false;
        if (this.connected) {
            this.currentAction = "parsing sql";
            this.status = 2;
            SQLParser sqlParser = new SQLParser(this.sqlCode);
            String singleStatement = sqlParser.getStatementAt(0).getSQL();
            this.currentAction = "selecting data";
            this.status = 3;
            ResultSet rs = this.session.executeQuery(singleStatement);
            if (!this.session.isSuccessful()) {
                this.lastErrorMessage = this.session.getLastErrorMessage();
                this.logger.error((Object)("running statement:\n" + singleStatement + "\nfailed: " + this.session.getLastErrorMessage()));
                throw new SQLException(this.lastErrorMessage);
            }
            if (rs == null) {
                this.lastErrorMessage = "no resultset available";
                this.logger.error((Object)("running statement:\n" + singleStatement + "\nfailed: " + this.lastErrorMessage));
                throw new SQLException(this.lastErrorMessage);
            }
            try {
                this.currentAction = "getting metadata for result";
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                Object[] resultRow = new Object[cols];
                this.columnNames = new String[cols];
                for (int i = 0; i < cols; ++i) {
                    this.columnNames[i] = rsmd.getColumnName(i + 1);
                }
                this.currentAction = "fetching data";
                this.status = 4;
                int[] types = new int[cols];
                for (int c = 0; c < cols; ++c) {
                    types[c] = BasicDataType.getBasicTypeByTypes(rsmd.getColumnType(c + 1));
                }
                while (rs.next()) {
                    if (this.abort || Thread.currentThread().isInterrupted()) {
                        this.status = 7;
                        break;
                    }
                    for (int i = 0; i < cols; ++i) {
                        if (types[i] == BasicDataType.DATE.getId()) {
                            resultRow[i] = rs.getTimestamp(i + 1);
                            continue;
                        }
                        if (BasicDataType.isNumberType(types[i])) {
                            resultRow[i] = rs.getObject(i + 1);
                            continue;
                        }
                        if (types[i] == BasicDataType.BOOLEAN.getId()) {
                            if (rs.getObject(i + 1) != null) {
                                resultRow[i] = rs.getBoolean(i + 1);
                                continue;
                            }
                            resultRow[i] = null;
                            continue;
                        }
                        if (types[i] == BasicDataType.CHARACTER.getId()) {
                            resultRow[i] = rs.getString(i + 1);
                            continue;
                        }
                        if (types[i] == BasicDataType.CLOB.getId()) {
                            if (rs.getObject(i + 1) != null) {
                                Clob clob = rs.getClob(i + 1);
                                resultRow[i] = clob.getSubString(1L, (int)clob.length());
                                continue;
                            }
                            resultRow[i] = null;
                            continue;
                        }
                        if (types[i] == BasicDataType.BINARY.getId()) {
                            if (rs.getObject(i + 1) != null) {
                                resultRow[i] = new BinaryDataFile();
                                continue;
                            }
                            resultRow[i] = null;
                            continue;
                        }
                        if (types[i] != -100) continue;
                        resultRow[i] = rs.getString(i + 1);
                        break;
                    }
                    this.processDataSet(resultRow, types);
                }
            }
            catch (SQLException sqle) {
                this.lastErrorMessage = "fetching data failed: " + sqle.getMessage();
                this.logger.error((Object)this.lastErrorMessage, (Throwable)sqle);
                throw sqle;
            }
            catch (IOException ioe) {
                this.lastErrorMessage = "writing data failed: " + ioe.getMessage();
                this.logger.error((Object)this.lastErrorMessage, (Throwable)ioe);
                throw ioe;
            }
            finally {
                this.currentAction = "closing streams";
                this.status = 5;
                try {
                    if (this.bw != null) {
                        this.bw.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    this.logger.error((Object)("closing resultset failed: " + sqle.getMessage()), (Throwable)sqle);
                }
                catch (IOException ioe) {
                    this.logger.error((Object)("closing file failed: " + ioe.getMessage()), (Throwable)ioe);
                }
                this.session.close();
            }
            this.status = 6;
        } else {
            this.logger.error((Object)"not connected");
        }
    }

    private void processDataSet(Object[] resultRow, int[] types) throws IOException {
        if (this.rowCountOverAll == 0) {
            this.currentFile = this.outputFile;
            this.bw = this.fileCharSet != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile), this.fileCharSet)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.currentFile)));
        } else if (this.maxDatasetsPerFile > 0L && (long)this.rowCountPerFile == this.maxDatasetsPerFile) {
            this.rowCountPerFile = 0;
            ++this.fileIndex;
            this.currentFile = this.createNextFile(this.outputFile, this.fileIndex);
            this.bw.flush();
            this.bw.close();
            this.bw = this.fileCharSet != null ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile), this.fileCharSet)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.currentFile)));
        }
        if (this.exportType == 2) {
            if (this.rowCountOverAll == 0) {
                this.insertStatementBegin = this.createInsertStatementText(this.sqlCode);
            }
            this.bw.write(this.createInsertLine(resultRow, types, this.insertStatementBegin, this.dateFormatTemplate));
            this.bw.write(this.lineSeparator);
        } else if (this.rowCountPerFile == 0) {
            if (this.createHeaderLine) {
                this.bw.write(this.createDelimitedHeaderLine());
                this.bw.write(this.lineSeparator);
            }
            this.bw.write(this.createDelimitedLine(resultRow, types));
            this.bw.write(this.lineSeparator);
        } else {
            this.bw.write(this.createDelimitedLine(resultRow, types));
            this.bw.write(this.lineSeparator);
        }
        ++this.rowCountOverAll;
        ++this.rowCountPerFile;
    }

    private String createDelimitedHeaderLine() {
        StringBuffer sb = new StringBuffer();
        boolean firstLoop = true;
        for (int c = 0; c < this.columnNames.length; ++c) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(this.delim);
            }
            if (this.enclosure != null) {
                sb.append(this.enclosure);
            }
            sb.append(this.columnNames[c]);
            if (this.enclosure == null) continue;
            sb.append(this.enclosure);
        }
        return sb.toString();
    }

    private String createDelimitedLine(Object[] resultRow, int[] types) {
        StringBuffer sb = new StringBuffer();
        for (int c = 0; c < resultRow.length; ++c) {
            if (this.enclosure != null) {
                sb.append(this.enclosure);
            }
            if (types[c] == BasicDataType.DATE.getId()) {
                if (this.sdf == null) {
                    throw new IllegalStateException("date format not defined");
                }
                if (resultRow[c] != null) {
                    sb.append(this.sdf.format((Date)resultRow[c]));
                }
            } else if (BasicDataType.isNumberType(types[c])) {
                if (resultRow[c] != null) {
                    if (this.changePointToComma) {
                        sb.append(resultRow[c].toString().replace('.', ','));
                    } else {
                        sb.append(resultRow[c].toString());
                    }
                }
            } else if (resultRow[c] != null) {
                sb.append(resultRow[c].toString());
            }
            if (this.enclosure != null) {
                sb.append(this.enclosure);
            }
            if (c >= resultRow.length - 1) continue;
            sb.append(this.delim);
        }
        return sb.toString().replace('\n', ' ').replace('\r', ' ');
    }

    private String createInsertStatementText(String sql) {
        sql = sql.toLowerCase();
        int p0 = sql.indexOf("from");
        if ((sql = sql.substring(p0 += 4, sql.length()).trim()).charAt(0) == '(') {
            p0 = sql.indexOf(41) + 1;
        } else {
            p0 = sql.indexOf(32);
            if (p0 == -1 && (p0 = sql.indexOf(59)) == -1) {
                p0 = sql.length();
            }
        }
        sql = p0 != -1 ? sql.substring(0, p0) : null;
        if (sql != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("insert into ");
            sb.append(sql);
            sb.append(" (");
            for (int i = 0; i < this.columnNames.length; ++i) {
                sb.append(this.columnNames[i]);
                if (i >= this.columnNames.length - 1) continue;
                sb.append(',');
            }
            sb.append(") values (");
            return sb.toString();
        }
        return null;
    }

    private String createInsertLine(Object[] resultRow, int[] types, String insertStart, String dateFormatTemplate_loc) {
        StringBuffer sb = new StringBuffer();
        sb.append(insertStart);
        for (int c = 0; c < resultRow.length; ++c) {
            if (types[c] == BasicDataType.DATE.getId()) {
                if (resultRow[c] != null) {
                    String s = this.sdf.format((Date)resultRow[c]);
                    int p0 = dateFormatTemplate_loc.indexOf("<");
                    if (p0 != -1) {
                        int p1 = dateFormatTemplate_loc.indexOf(">", p0 + 1);
                        dateFormatTemplate_loc = dateFormatTemplate_loc.substring(0, p0) + s + dateFormatTemplate_loc.substring(p1 + 1, dateFormatTemplate_loc.length());
                    }
                    sb.append(dateFormatTemplate_loc);
                } else {
                    sb.append("null");
                }
            } else if (BasicDataType.isStringType(types[c])) {
                sb.append("'");
                if (resultRow[c] != null) {
                    sb.append(this.dublicateSingleQuotas(resultRow[c].toString().replace('\n', ' ').replace('\r', ' ')));
                }
                sb.append("'");
            } else if (resultRow[c] != null) {
                sb.append(resultRow[c].toString().replace('\n', ' ').replace('\r', ' '));
            } else {
                sb.append("null");
            }
            if (c < resultRow.length - 1) {
                sb.append(',');
                continue;
            }
            sb.append(");");
        }
        return sb.toString();
    }

    private String dublicateSingleQuotas(String text) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\'') {
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public boolean connect() {
        if (this.cd == null) {
            throw new IllegalStateException("no ConnectionDescription set");
        }
        this.status = 1;
        this.session = new DatabaseSession(this.cd);
        this.connected = this.session.isConnected();
        if (!this.connected) {
            this.lastErrorMessage = this.session.getLastErrorMessage();
        }
        return this.connected;
    }

    private File createNextFile(File originalTargetFile, int index) {
        String path = originalTargetFile.getParent();
        String fullname = originalTargetFile.getName();
        int p0 = fullname.lastIndexOf(".");
        String name = p0 != -1 ? fullname.substring(0, p0) + "_" + String.valueOf(index) + fullname.substring(p0, fullname.length()) : fullname + "_" + String.valueOf(index);
        if (path != null) {
            return new File(path, name);
        }
        return new File(name);
    }

    @Override
    public void abort() {
        this.abort = true;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public int getCurrentRowNum() {
        return this.rowCountOverAll;
    }

    public int getRowCountPerFile() {
        return this.rowCountPerFile;
    }

    @Override
    public String getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    @Override
    public void setOutputFile(File outputFile) {
        this.outputFile = new File(outputFile.getAbsolutePath());
    }
}

