/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExporterToSpreadsheetFile {
    private static final Logger logger = Logger.getLogger(ExporterToSpreadsheetFile.class);
    private SpreadsheetTyp currentInputType;
    private SpreadsheetTyp currentOutputType;
    private FileInputStream fin;
    private FileOutputStream fout;
    private File inputFile;
    private File outputFile;
    private Workbook workbook;
    private Sheet sheet;
    private String targetSheetName;
    private Row row;
    private int currentRowIndex = 0;
    private boolean exportDateTypeAsString = false;
    private String dateFormatPattern = "dd.MM.yyyy HH.mm.ss";
    private SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormatPattern);
    private CreationHelper createHelper;
    private CellStyle cellDateStyle;

    public void setDateFormat(String pattern) {
        if (pattern != null) {
            this.sdf = new SimpleDateFormat(pattern);
            this.dateFormatPattern = pattern;
            this.setupDateFormatStyle();
        } else {
            this.exportDateTypeAsString = false;
        }
    }

    public void setExportDateAsString() {
        this.exportDateTypeAsString = true;
    }

    public void setExportDateAsDate() {
        this.exportDateTypeAsString = false;
    }

    public void setTargetSheetName(String name) throws IOException {
        this.targetSheetName = name;
        this.setSheet();
    }

    public void setOutputFile(File outputFile) throws Exception {
        this.outputFile = outputFile;
        this.currentOutputType = this.getSpreadsheetType(outputFile);
        if (this.currentInputType != null && this.currentInputType != this.currentOutputType) {
            throw new Exception("Workbook cannot be saved into a different type for input");
        }
    }

    public void setInputFile(File inputFile) throws Exception {
        this.inputFile = inputFile;
        this.fin = new FileInputStream(inputFile);
        this.currentInputType = this.getSpreadsheetType(inputFile);
        if (this.currentOutputType != null) {
            if (this.currentInputType != this.currentOutputType) {
                logger.error((Object)"Input and Output must have the same file type!");
                throw new Exception("Input and Output must have the same file type!");
            }
        } else {
            this.currentOutputType = this.currentInputType;
        }
    }

    private SpreadsheetTyp getSpreadsheetType(File f) {
        SpreadsheetTyp type = null;
        if (f.getName().toLowerCase().endsWith(".xls")) {
            type = SpreadsheetTyp.XLS;
        } else if (f.getName().toLowerCase().endsWith(".xlsx")) {
            type = SpreadsheetTyp.XLSX;
        }
        return type;
    }

    public void setWorkbook() throws IOException {
        if (this.fin != null) {
            if (this.currentOutputType == SpreadsheetTyp.XLS) {
                logger.debug((Object)("Create XLS workbook from file " + this.inputFile.getAbsolutePath()));
                this.workbook = new HSSFWorkbook((InputStream)this.fin);
            } else if (this.currentOutputType == SpreadsheetTyp.XLSX) {
                logger.debug((Object)("Create XLSX workbook from file " + this.inputFile.getAbsolutePath()));
                this.workbook = new XSSFWorkbook((InputStream)this.fin);
            }
        } else if (this.currentOutputType == SpreadsheetTyp.XLS) {
            logger.debug((Object)"Create XLS workbook");
            this.workbook = new HSSFWorkbook();
        } else if (this.currentOutputType == SpreadsheetTyp.XLSX) {
            logger.debug((Object)"Create XLSX workbook");
            this.workbook = new XSSFWorkbook();
        }
        this.setupDateFormatStyle();
    }

    private void setupDateFormatStyle() {
        if (this.workbook != null) {
            this.createHelper = this.workbook.getCreationHelper();
            this.cellDateStyle = this.workbook.createCellStyle();
            this.cellDateStyle.setDataFormat(this.createHelper.createDataFormat().getFormat(this.dateFormatPattern));
        }
    }

    public void setSheet() throws IOException {
        if (this.workbook == null) {
            this.setWorkbook();
        }
        if (this.targetSheetName != null) {
            this.sheet = this.workbook.getSheet(this.targetSheetName);
            if (this.sheet == null) {
                logger.debug((Object)("Create sheet with name: " + this.targetSheetName));
                this.workbook.createSheet(this.targetSheetName);
            }
        } else {
            logger.debug((Object)"Create sheet with default name");
            this.sheet = this.workbook.createSheet();
        }
    }

    public void writeRow(List<Object> listValues) throws IOException {
        Object[] oneRow = listValues.toArray();
        this.writeRow(oneRow);
    }

    public void writeRow(Object[] listValues) throws IOException {
        if (this.sheet == null) {
            this.setSheet();
        }
        logger.debug((Object)("Create new row with index=" + this.currentRowIndex));
        this.row = this.sheet.createRow(this.currentRowIndex++);
        int cellIndex = 0;
        for (Object value : listValues) {
            Cell cell = this.row.createCell(cellIndex++);
            if (value instanceof String) {
                cell.setCellValue((String)value);
                cell.setCellType(1);
                continue;
            }
            if (value instanceof Integer) {
                cell.setCellValue((double)((Integer)value).intValue());
                cell.setCellType(0);
                continue;
            }
            if (value instanceof Boolean) {
                cell.setCellValue((double)((Integer)value).intValue());
                cell.setCellType(4);
                continue;
            }
            if (value instanceof Double) {
                cell.setCellValue(((Double)value).doubleValue());
                cell.setCellType(0);
                continue;
            }
            if (value instanceof Number) {
                cell.setCellValue(Double.valueOf(((Number)value).doubleValue()).doubleValue());
                cell.setCellType(0);
                continue;
            }
            if (value instanceof Date) {
                if (this.exportDateTypeAsString) {
                    String s = this.sdf.format((Date)value);
                    cell.setCellValue(s);
                    cell.setCellType(1);
                    continue;
                }
                cell.setCellStyle(this.cellDateStyle);
                cell.setCellValue((Date)value);
                continue;
            }
            if (value == null) continue;
            cell.setCellValue(value.toString());
            cell.setCellType(1);
        }
    }

    public void writeWorkbook() throws Exception {
        logger.debug((Object)"Write workbook");
        this.fout = new FileOutputStream(this.outputFile);
        this.workbook.write((OutputStream)this.fout);
        this.fout.flush();
    }

    public void close() {
        logger.debug((Object)"Close workbook and files");
        if (this.fin != null) {
            try {
                this.fin.close();
            }
            catch (Exception e) {
                logger.warn((Object)("closing input file failed: " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.fout != null) {
            try {
                this.fout.close();
            }
            catch (Exception e) {
                logger.warn((Object)("closing output file failed: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static enum SpreadsheetTyp {
        XLS,
        XLSX;

    }
}

