/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.editor.SyntaxContext;

public final class SyntaxScanner {
    private static final Logger logger = Logger.getLogger((String)SyntaxScanner.class.getName());
    private Document doc;
    private int startPos;
    private int endPos;
    private int startOffset = 0;
    private int endOffset = 0;
    static String blockCommentBegin = "/*";
    static String blockCommentEnd = "*/";
    static String lineComment = "--";
    static char stringLimiter = (char)39;
    private boolean inStringConstants;
    private boolean inLineComment;
    private boolean inBlockComment;
    private boolean inVariable;
    private Hashtable<String, DisplayAttribute> defs;
    private Hashtable<String, DisplayAttribute> defsForAdds;
    private Properties sections;
    private String word;
    private DisplayAttribute da;
    private DisplayAttribute commentDA;
    private DisplayAttribute stringConstantsDA;
    private DisplayAttribute findWordDA = new DisplayAttribute(Color.BLACK, Color.YELLOW, Main.textFont);
    private String fontType = null;
    private int fontSize = 0;
    private Element root;
    private final Object commentAttribute = new AttributeFlag();
    private JTextComponent editor;
    private boolean valid = true;
    public boolean docLoaded = false;
    private String languageName;
    private String highlightedWord = null;

    public SyntaxScanner() {
        this.defs = new Hashtable();
        this.sections = new Properties();
        this.defineFontMetrics();
        this.languageName = Main.getDefaultProperty("WORDFILE_LANGUAGE_NAME", "SQL");
        if (this.loadSectionCfg()) {
            this.loadWordFile();
        }
    }

    public void setupChangedTextFont() {
        this.defineFontMetrics();
        for (DisplayAttribute da : this.defs.values()) {
            da.font = this.changeFontSize(da.font, this.fontSize);
        }
        this.commentDA.font = this.changeFontSize(this.commentDA.font, this.fontSize);
        this.findWordDA.font = Main.textFont;
    }

    private Font changeFontSize(Font font, int newSize) {
        return new Font(font.getName(), font.getStyle(), newSize);
    }

    private void defineFontMetrics() {
        this.fontType = Main.textFont.getName();
        this.fontSize = Main.textFont.getSize();
    }

    private String getLanguageProperty(String line, String propName) {
        int p0 = line.indexOf(propName);
        StringBuffer value = new StringBuffer();
        if (p0 > 0 && (p0 = line.indexOf(61, p0)) > 0) {
            value.append("");
            boolean reading = false;
            for (int i = p0 + 1; i < line.length(); ++i) {
                if (line.charAt(i) != ' ') {
                    reading = true;
                    value.append(line.charAt(i));
                    continue;
                }
                if (reading) break;
            }
        }
        if (value.length() > 0) {
            return value.toString();
        }
        return null;
    }

    private boolean loadSectionCfg() {
        boolean ok;
        try {
            try {
                FileInputStream fis = new FileInputStream(Main.getHighlighterFontCfgFileName());
                this.sections.load(fis);
                fis.close();
                ok = true;
            }
            catch (AccessControlException ae) {
                InputStream is = this.getClass().getResourceAsStream("/highlighter.cfg");
                this.sections.load(is);
                is.close();
                ok = true;
            }
        }
        catch (IOException ioe) {
            logger.warn((Object)("Scanner.loadSectionCfg: error reading description for highlighter - : exception: " + ioe));
            this.disableScanner();
            ok = false;
        }
        return ok;
    }

    private void loadWordFile() {
        BufferedReader br;
        boolean inLanguage = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Scanner: load configuration from wordfile.txt ...");
        }
        if ((br = Main.getTextResource("wordfile.txt")) == null) {
            this.disableScanner();
        } else {
            try {
                String line;
                this.da = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    if (inLanguage) {
                        if (line.startsWith("/L")) {
                            inLanguage = false;
                            break;
                        }
                        if (line.startsWith("/C")) {
                            this.da = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_" + line.substring(1, 3)));
                            continue;
                        }
                        if (line.startsWith("/") || this.da == null) continue;
                        StringTokenizer st = new StringTokenizer(line, " ");
                        while (st.hasMoreTokens()) {
                            this.defs.put(st.nextToken(), this.da);
                        }
                        continue;
                    }
                    if (!line.startsWith("/L") || line.toUpperCase().indexOf(this.languageName.toUpperCase()) == -1) continue;
                    lineComment = this.getLanguageProperty(line, "Line Comment");
                    blockCommentBegin = this.getLanguageProperty(line, "Block Comment On");
                    blockCommentEnd = this.getLanguageProperty(line, "Block Comment Off");
                    stringLimiter = this.getLanguageProperty(line, "String Chars").charAt(0);
                    inLanguage = true;
                    this.commentDA = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_Comments"));
                    this.stringConstantsDA = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_String_Constants"));
                }
                br.close();
            }
            catch (NullPointerException npe) {
                this.disableScanner();
                this.da = null;
                logger.warn((Object)("Scanner not initialized " + npe.toString() + "exception: " + npe));
            }
            catch (IOException ioe) {
                this.disableScanner();
                this.da = null;
                logger.warn((Object)("Scanner not initialized " + ioe.toString() + "exception: " + ioe));
            }
            if (logger.isDebugEnabled()) {
                Enumeration<String> defsEnum = this.defs.keys();
                logger.debug((Object)"Scanner.loadWordFile:");
                while (defsEnum.hasMoreElements()) {
                    String alias = defsEnum.nextElement();
                    DisplayAttribute test = this.defs.get(alias);
                    logger.debug((Object)("    " + alias + ":    TextAttr=" + test.font.getStyle() + "    Color=" + test.foregroundColor));
                }
            }
        }
    }

    public void addAdditionalKeywords(String keywords) {
        this.da = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_ADDED_KEYWORDS"));
        if (this.da != null) {
            if (this.defsForAdds == null) {
                this.defsForAdds = new Hashtable();
            }
            if (keywords != null) {
                StringTokenizer tk = new StringTokenizer(keywords.toLowerCase(), ",");
                while (tk.hasMoreTokens()) {
                    this.defsForAdds.put(tk.nextToken().trim(), this.da);
                }
            } else {
                this.defsForAdds = null;
            }
        }
    }

    public void deregisterAdditionalKeywords() {
        this.defsForAdds = null;
    }

    public void addAdditionalKeywords(List<String> keywords) {
        this.da = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_ADDED_KEYWORDS"));
        if (this.da != null) {
            if (this.defsForAdds == null) {
                this.defsForAdds = new Hashtable();
            }
            for (String word : keywords) {
                this.defsForAdds.put(word, this.da);
            }
        }
    }

    public void addAdditionalSQLDataTypes(List<String> dataTypes) {
        this.da = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_C2"));
        if (this.da != null) {
            if (this.defsForAdds == null) {
                this.defsForAdds = new Hashtable();
            }
            for (String word : dataTypes) {
                this.defsForAdds.put(word, this.da);
            }
        }
    }

    public void addAdditionalPLSQLKeywords(List<String> dataTypes) {
        this.da = this.parseAttributeLine(this.sections.getProperty(this.languageName + "_C3"));
        if (this.da != null) {
            if (this.defsForAdds == null) {
                this.defsForAdds = new Hashtable();
            }
            for (String word : dataTypes) {
                this.defsForAdds.put(word, this.da);
            }
        }
    }

    public List<String> getLongKeywords() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.defs != null) {
            for (String keyword : this.defs.keySet()) {
                if (list.contains(keyword) || keyword.length() <= 2) continue;
                list.add(keyword.toLowerCase());
            }
        }
        if (this.defsForAdds != null) {
            for (String keyword : this.defsForAdds.keySet()) {
                if (list.contains(keyword) || keyword.length() <= 2) continue;
                list.add(keyword.toLowerCase());
            }
        }
        Collections.sort(list);
        return list;
    }

    public void setEnabled(boolean enabled) {
        SyntaxContext.setSyntaxHighlighting(enabled);
        this.valid = enabled;
    }

    public boolean isEnabled() {
        return SyntaxContext.isSyntaxHighlightingEnabled() && this.valid;
    }

    private void disableScanner() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SyntaxHighlighting disabled !");
        }
        Main.setDefaultProperty("SYNTAX_HIGHLIGHT_ENABLED", "false");
        Main.setUserProperty("SYNTAX_HIGHLIGHT", "false");
        this.setEnabled(false);
    }

    public void setDocument(Document doc_loc) {
        this.doc = doc_loc;
        this.root = this.doc.getDefaultRootElement();
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setEditor(JTextComponent editor_loc) {
        this.editor = editor_loc;
    }

    private DisplayAttribute parseAttributeLine(String aLine) {
        DisplayAttribute da_loc = null;
        if (aLine != null) {
            da_loc = new DisplayAttribute();
            try {
                int i1 = aLine.indexOf(44);
                da_loc.font = new Font(this.fontType, Integer.parseInt(aLine.substring(0, i1)), this.fontSize);
                int i2 = aLine.indexOf(44, i1 + 1);
                int rot = Integer.parseInt(aLine.substring(i1 + 1, i2));
                int i3 = aLine.indexOf(44, i2 + 1);
                int gruen = Integer.parseInt(aLine.substring(i2 + 1, i3));
                int blau = Integer.parseInt(aLine.substring(i3 + 1, aLine.length()));
                da_loc.foregroundColor = new Color(rot, gruen, blau);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)("Scanner.parseAttributes: invalid value in config file line:" + aLine + " scanner deactivated " + e));
                Main.setDefaultProperty("SYNTAX_HIGHLIGHT_ENABLED", "false");
                da_loc = null;
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.warn((Object)("Scanner.parseAttributes: not enough values in config file line:" + aLine + " scanner deactivated " + e));
                Main.setDefaultProperty("SYNTAX_HIGHLIGHT_ENABLED", "false");
                da_loc = null;
            }
        }
        return da_loc;
    }

    public void setRange(int start, int ende) {
        this.startPos = start;
        this.endPos = ende;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset <= this.endPos ? this.endOffset : this.endPos;
    }

    public Font getFont() {
        return this.da.font;
    }

    public Color getColor() {
        return this.da.foregroundColor;
    }

    public Color getBackgroundColor() {
        if (this.da != null) {
            return this.da.backgroundColor;
        }
        return null;
    }

    public boolean testIfCommentBegin(String s, int pos) {
        int iline = s.indexOf(lineComment);
        if (iline != -1 && iline == pos - 1) {
            this.inLineComment = true;
            this.inBlockComment = false;
            return true;
        }
        if (s.indexOf(blockCommentBegin) != -1 && s.indexOf(blockCommentBegin) == pos - 1) {
            this.inLineComment = false;
            this.inBlockComment = true;
            return true;
        }
        this.inLineComment = false;
        this.inBlockComment = false;
        return false;
    }

    public boolean testIfBlockCommentEnd(String s, int pos) {
        if (s.indexOf(blockCommentEnd) != -1 && s.indexOf(blockCommentEnd) == pos - 1) {
            this.inLineComment = false;
            this.inBlockComment = true;
            return true;
        }
        this.inLineComment = false;
        this.inBlockComment = false;
        return false;
    }

    public boolean scanLine() {
        try {
            Element elem = this.root.getElement(this.root.getElementIndex(this.startPos));
            MutableAttributeSet mas = (MutableAttributeSet)elem.getAttributes();
            if (elem.getStartOffset() == this.startPos && mas != null && mas.isDefined(this.commentAttribute)) {
                this.startOffset = this.startPos;
                int e = this.doc.getText(this.startPos, this.endPos - this.startPos).indexOf("*/");
                if (e != -1) {
                    this.da = this.commentDA;
                    this.startOffset = this.startPos;
                    this.endOffset = this.startPos + e + 2;
                } else {
                    this.da = this.commentDA;
                    this.startOffset = this.startPos;
                    this.endOffset = this.endPos;
                }
            } else {
                char c;
                int a;
                String s = this.doc.getText(this.startPos, this.endPos - this.startPos).toLowerCase();
                int c0 = 32;
                this.inStringConstants = false;
                this.inLineComment = false;
                this.inBlockComment = false;
                this.inVariable = false;
                for (a = 0; a < s.length(); ++a) {
                    c = s.charAt(a);
                    if (a > 0) {
                        c0 = s.charAt(a - 1);
                    }
                    if (c == stringLimiter && c0 != 92) {
                        this.inStringConstants = true;
                        break;
                    }
                    if (this.testIfCommentBegin(s, a)) break;
                    if (c == '\"' || c == '`') {
                        this.inVariable = true;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c == '\n') break;
                }
                if (this.inVariable) {
                    int e;
                    for (e = a + 1; e < s.length() && (c = s.charAt(e)) != '\"' && c != '`' && c != '\n'; ++e) {
                    }
                    this.startOffset = a + this.startPos;
                    this.endOffset = e + 1 + this.startPos;
                    this.da = null;
                    this.word = s.substring(a + 1, e);
                    if (this.highlightedWord != null && this.word.equalsIgnoreCase(this.highlightedWord)) {
                        this.da = this.findWordDA;
                    }
                } else if (this.inLineComment) {
                    int e;
                    for (e = a + 1; e < s.length() && (c = s.charAt(e)) != '\n'; ++e) {
                    }
                    this.da = this.commentDA;
                    this.startOffset = a + this.startPos - 1;
                    this.endOffset = e + 1 + this.startPos;
                } else if (this.inBlockComment) {
                    int e;
                    for (e = a + 1; e < s.length() && !this.testIfBlockCommentEnd(s, e); ++e) {
                    }
                    this.da = this.commentDA;
                    this.startOffset = a + this.startPos - 1;
                    this.endOffset = e + 1 + this.startPos;
                } else if (this.inStringConstants) {
                    int e;
                    for (e = a + 1; e < s.length(); ++e) {
                        c = s.charAt(e);
                        if (e > 0) {
                            c0 = s.charAt(e - 1);
                        }
                        if (c == stringLimiter && c0 != 92 || c == '\n') break;
                    }
                    this.da = this.stringConstantsDA;
                    this.startOffset = a + this.startPos;
                    this.endOffset = e + 1 + this.startPos;
                } else {
                    int e;
                    for (e = a; e < s.length() && ((c = s.charAt(e)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || c >= '0' && c <= '9') && c != '\n'; ++e) {
                    }
                    if (e > a) {
                        this.word = s.substring(a, e);
                        this.da = this.defs.get(this.word);
                        if (this.da == null && this.defsForAdds != null) {
                            this.da = this.defsForAdds.get(this.word);
                        }
                        if (this.da == null && this.highlightedWord != null && this.word.equalsIgnoreCase(this.highlightedWord)) {
                            this.da = this.findWordDA;
                        }
                    } else {
                        this.da = null;
                        ++e;
                    }
                    this.startOffset = a + this.startPos;
                    this.endOffset = e + this.startPos;
                }
            }
        }
        catch (BadLocationException ble) {
            logger.warn((Object)("Scanner.scan(): error in startPos: " + this.startPos + " endPos: " + this.endPos + " Scanner: deaktivated: " + ble));
            Main.setUserProperty("SYNTAX_HIGHLIGHT", "false");
            SyntaxContext.setSyntaxHighlighting(false);
            this.da = null;
        }
        return this.da != null;
    }

    private final int indexOfMultiLineCommentBegin(String s) {
        this.inStringConstants = false;
        this.inVariable = false;
        int pos = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == stringLimiter) {
                this.inStringConstants = !this.inStringConstants;
            }
            if (s.charAt(i) == '\"') {
                this.inVariable = !this.inVariable;
            }
            if (this.inStringConstants || this.inVariable) continue;
            if (s.charAt(i) == blockCommentBegin.charAt(0) && s.charAt(++i) == blockCommentBegin.charAt(1)) {
                pos = i;
                continue;
            }
            if (s.charAt(i) != blockCommentEnd.charAt(0) || s.charAt(++i) != blockCommentEnd.charAt(1)) continue;
            pos = -1;
        }
        return pos;
    }

    private final int setCommentAttributes(int textStartPos) {
        int endPos_loc = 0;
        try {
            endPos_loc = this.doc.getText(textStartPos, this.doc.getLength() - textStartPos).indexOf(blockCommentEnd);
            endPos_loc = endPos_loc != -1 ? (endPos_loc += textStartPos) : this.doc.getLength();
        }
        catch (BadLocationException ble) {
            logger.warn((Object)("error in handling comments " + ble));
        }
        Element root_loc = this.doc.getDefaultRootElement();
        int elemStartIndex = root_loc.getElementIndex(textStartPos);
        int elemEndIndex = root_loc.getElementIndex(endPos_loc);
        for (int i = elemStartIndex + 1; i <= elemEndIndex; ++i) {
            Element elem = root_loc.getElement(i);
            MutableAttributeSet mattr = (MutableAttributeSet)elem.getAttributes();
            mattr.addAttribute(this.commentAttribute, this.commentAttribute);
        }
        return endPos_loc;
    }

    private final String readWholeLine(int pos) {
        Element root_loc = this.doc.getDefaultRootElement();
        Element elem = root_loc.getElement(root_loc.getElementIndex(pos));
        int p0 = elem.getStartOffset();
        int p1 = elem.getEndOffset();
        String s = "";
        try {
            s = this.doc.getText(p0, p1 - p0);
        }
        catch (BadLocationException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return s;
    }

    private final int removeAttributes(int startPos_loc) {
        Element root_loc = this.doc.getDefaultRootElement();
        int elemStartIndex = root_loc.getElementIndex(startPos_loc);
        int endPos_loc = 0;
        try {
            endPos_loc = this.doc.getText(startPos_loc, this.doc.getLength() - startPos_loc).indexOf(blockCommentBegin);
            endPos_loc = endPos_loc == -1 ? this.doc.getLength() : (endPos_loc += startPos_loc);
        }
        catch (BadLocationException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        int elemEndIndex = root_loc.getElementIndex(endPos_loc);
        Element elem = root_loc;
        for (int i = elemStartIndex; i <= elemEndIndex; ++i) {
            elem = root_loc.getElement(i);
            MutableAttributeSet set = (MutableAttributeSet)elem.getAttributes();
            set.removeAttribute(this.commentAttribute);
        }
        return Math.min(elem.getEndOffset(), this.doc.getLength());
    }

    private final int findLastCommentBegin(int startPos_loc) {
        int lastPos = 0;
        int suchPos = startPos_loc;
        boolean gefunden = false;
        String s = "";
        try {
            s = this.doc.getText(0, startPos_loc);
        }
        catch (BadLocationException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        while (!gefunden) {
            lastPos = s.lastIndexOf(blockCommentBegin, suchPos);
            if (lastPos != -1) {
                if (this.indexOfMultiLineCommentBegin(this.readWholeLine(lastPos)) != -1) {
                    gefunden = true;
                    continue;
                }
                suchPos = lastPos - 1;
                continue;
            }
            lastPos = startPos_loc;
            gefunden = true;
        }
        if (lastPos > 0) {
            --lastPos;
        }
        return lastPos;
    }

    public void updateCommentAttributes(int startPos_loc, int length) {
        if (this.valid) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("start at:" + startPos_loc + " until:" + (startPos_loc + length - 1) + "..."));
            }
            int ende = Math.max(this.removeAttributes(startPos_loc), startPos_loc + length);
            boolean fertig = false;
            int commentBegin = -1;
            int commentEnd = this.findLastCommentBegin(startPos_loc);
            while (!fertig) {
                try {
                    commentBegin = this.doc.getText(commentEnd, this.doc.getLength() - commentEnd).indexOf(blockCommentBegin);
                }
                catch (BadLocationException e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                if (commentBegin != -1) {
                    if (this.indexOfMultiLineCommentBegin(this.readWholeLine(commentBegin += commentEnd)) != -1) {
                        commentEnd = this.setCommentAttributes(commentBegin);
                        if (commentEnd < ende) continue;
                        fertig = true;
                        continue;
                    }
                    if ((commentEnd += commentBegin) == 0) {
                        commentEnd += blockCommentBegin.length();
                    }
                    if (commentEnd < ende) continue;
                    fertig = true;
                    continue;
                }
                fertig = true;
            }
            this.editor.repaint();
        }
    }

    public final String getHighlightedWord() {
        return this.highlightedWord;
    }

    public final void setHighlightedWord(String highlightedWord) {
        this.highlightedWord = highlightedWord;
    }

    static class AttributeFlag {
        AttributeFlag() {
        }

        public String toString() {
            return "comment";
        }
    }

    static class DisplayAttribute {
        public Font font;
        public Color foregroundColor = Color.black;
        public Color backgroundColor = null;

        public DisplayAttribute() {
        }

        public DisplayAttribute(Color foreground, Color background, Font font) {
            this.foregroundColor = foreground;
            this.backgroundColor = background;
            this.font = font;
        }

        public String toString() {
            return "DisplayAttribut: " + this.font.toString() + " " + this.foregroundColor.toString();
        }
    }
}

