/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import sqlrunner.MainFrame;
import sqlrunner.editor.XORCaret;

public class ExtEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    public long prevCaretPosition;
    private MainFrame mainFrame;
    private boolean overWrite = false;

    public ExtEditorPane(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public boolean isOverWrite() {
        return this.overWrite;
    }

    public void setOverWrite(boolean overWrite_loc) {
        this.overWrite = overWrite_loc;
        this.checkCaret();
    }

    @Override
    public void setEditable(boolean ok) {
        super.setEditable(ok);
        if (ok) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        this.checkCaret();
    }

    public void checkCaret() {
        int prevCaretPosition_loc = 0;
        if (this.getCaret() != null) {
            prevCaretPosition_loc = this.getCaretPosition();
        }
        if (this.overWrite) {
            XORCaret defaultCaret = new XORCaret();
            defaultCaret.setBlinkRate(500);
            this.setCaret(defaultCaret);
        } else {
            DefaultCaret defaultCaret = new DefaultCaret();
            defaultCaret.setBlinkRate(500);
            this.setCaret(defaultCaret);
        }
        this.setCaretPosition(prevCaretPosition_loc);
    }

    @Override
    public void processMouseEvent(MouseEvent me) {
        switch (me.getID()) {
            case 501: {
                if (me.isShiftDown()) {
                    int prevCaretPosition_loc = this.getCaretPosition();
                    super.processMouseEvent(me);
                    if (prevCaretPosition_loc < this.getCaretPosition()) {
                        this.select(prevCaretPosition_loc, this.getCaretPosition());
                        break;
                    }
                    this.select(this.getCaretPosition(), prevCaretPosition_loc);
                    break;
                }
                super.processMouseEvent(me);
                break;
            }
            case 504: {
                if (this.isEditable()) {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                    break;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                break;
            }
            default: {
                super.processMouseEvent(me);
            }
        }
    }

    public void copyTextIntoLinesSmart(String text) throws Exception {
        block9: {
            int maxLineNum;
            int lineNum;
            Element rootElem;
            Document doc;
            boolean atLineEnd;
            StringTokenizer st;
            block11: {
                boolean atLinePos;
                int pos;
                block10: {
                    text = text.replaceAll("\r", "");
                    st = new StringTokenizer(text, "\n");
                    String selectedText = this.getSelectedText();
                    pos = this.getCaretPosition();
                    boolean atPattern = false;
                    atLineEnd = false;
                    atLinePos = false;
                    if (selectedText != null && !selectedText.isEmpty()) {
                        this.select(pos, pos);
                        atPattern = true;
                    } else {
                        String s = this.getText(pos, 1);
                        if ("\n".equals(s)) {
                            atLineEnd = true;
                        } else {
                            atLinePos = true;
                        }
                    }
                    doc = this.getDocument();
                    rootElem = doc.getDefaultRootElement();
                    lineNum = rootElem.getElementIndex(this.getCaretPosition());
                    maxLineNum = rootElem.getElementCount();
                    if (!atPattern) break block10;
                    while (st.hasMoreTokens()) {
                        block8: {
                            String content = st.nextToken();
                            int nextLineNum = lineNum;
                            do {
                                int end;
                                Element line;
                                int start;
                                String lineText;
                                int patternPos;
                                if ((patternPos = (lineText = this.getText(start = (line = rootElem.getElement(nextLineNum)).getStartOffset(), (end = line.getEndOffset()) - start)).indexOf(selectedText)) <= 0) continue;
                                doc.insertString(start + (patternPos += selectedText.length()), content, null);
                                lineNum = nextLineNum;
                                break block8;
                            } while (++nextLineNum < maxLineNum);
                            lineNum = nextLineNum;
                        }
                        if (++lineNum < maxLineNum) continue;
                        break block9;
                    }
                    break block9;
                }
                if (!atLinePos) break block11;
                Element line = rootElem.getElement(lineNum);
                int start = line.getStartOffset();
                int columnPos = pos - start;
                while (st.hasMoreTokens()) {
                    String content = st.nextToken();
                    line = rootElem.getElement(lineNum);
                    doc.insertString(line.getStartOffset() + columnPos, content, null);
                    if (++lineNum < maxLineNum) continue;
                    break block9;
                }
                break block9;
            }
            if (!atLineEnd) break block9;
            Element line = rootElem.getElement(lineNum);
            while (st.hasMoreTokens()) {
                String content = st.nextToken();
                line = rootElem.getElement(lineNum);
                doc.insertString(line.getEndOffset() - 1, content, null);
                if (++lineNum < maxLineNum) continue;
                break;
            }
        }
    }
}

