/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import sqlrunner.MainFrame;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.editor.Messages;
import sqlrunner.resources.ApplicationIcons;

public class CodeCompletionAssistent
extends JPanel {
    private final Logger logger = Logger.getLogger(CodeCompletionAssistent.class);
    private static final long serialVersionUID = 1L;
    private JList jList;
    private JCheckBox cbKeywords;
    private JCheckBox cbSchemas;
    private JCheckBox cbTables;
    private FilterModel model;
    private MainFrame mainFrame;
    private Object selectedItem;
    private String currentSearchStr;

    public CodeCompletionAssistent(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane();
        this.model = new FilterModel();
        this.jList = new JList(this.model);
        this.jList.setCellRenderer(new ObjectRenderer());
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0, false);
        this.jList.getActionMap().put("esc", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionAssistent.this.mainFrame.closeSyntaxChooser();
            }
        });
        this.jList.getInputMap().put(esc, "esc");
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        this.jList.getActionMap().put("enter", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionAssistent.this.mainFrame.insertSyntaxChooserText();
                CodeCompletionAssistent.this.mainFrame.closeSyntaxChooser();
            }
        });
        this.jList.getInputMap().put(enter, "enter");
        this.jList.setSelectionMode(0);
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeCompletionAssistent.this.selectedItem = CodeCompletionAssistent.this.jList.getSelectedValue();
            }
        });
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CodeCompletionAssistent.this.mainFrame.insertSyntaxChooserText();
                    CodeCompletionAssistent.this.mainFrame.closeSyntaxChooser();
                }
            }
        });
        sp.setViewportView(this.jList);
        this.add((Component)sp, "Center");
        this.add((Component)this.createCheckBoxPanel(), "South");
    }

    private JPanel createCheckBoxPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.cbKeywords = new JCheckBox();
        this.cbKeywords.setText(Messages.getString("SyntaxChooser.keywords"));
        this.cbKeywords.setSelected(true);
        this.cbKeywords.setOpaque(true);
        this.cbKeywords.setFocusable(false);
        this.cbKeywords.setBackground(ObjectRenderer.keywordBgColor);
        this.cbKeywords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionAssistent.this.model.refilter(CodeCompletionAssistent.this.currentSearchStr);
            }
        });
        this.cbSchemas = new JCheckBox();
        this.cbSchemas.setText(Messages.getString("SyntaxChooser.schemas"));
        this.cbSchemas.setSelected(true);
        this.cbSchemas.setOpaque(true);
        this.cbSchemas.setFocusable(false);
        this.cbSchemas.setBackground(ObjectRenderer.schemaBgColor);
        this.cbSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionAssistent.this.model.refilter(CodeCompletionAssistent.this.currentSearchStr);
            }
        });
        this.cbTables = new JCheckBox();
        this.cbTables.setText(Messages.getString("SyntaxChooser.tables"));
        this.cbTables.setSelected(true);
        this.cbTables.setOpaque(true);
        this.cbTables.setFocusable(false);
        this.cbTables.setBackground(ObjectRenderer.tableBgColor);
        this.cbTables.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CodeCompletionAssistent.this.model.refilter(CodeCompletionAssistent.this.currentSearchStr);
            }
        });
        panel.add(this.cbKeywords);
        panel.add(this.cbSchemas);
        panel.add(this.cbTables);
        return panel;
    }

    public void addItems(List<? extends Object> listItems) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("addItems: add " + listItems.size() + " keywords"));
        }
        this.model.addElements(listItems);
    }

    public void setSearchTerm(String term) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("setSearchTerm " + term));
        }
        this.currentSearchStr = term;
        this.model.refilter(this.currentSearchStr);
    }

    public void selectDown() {
        int pos = this.jList.getSelectedIndex();
        pos = pos == -1 ? 0 : ++pos;
        if (pos < this.jList.getModel().getSize()) {
            this.jList.setSelectedIndex(pos);
            this.jList.ensureIndexIsVisible(pos);
        }
    }

    public void selectUp() {
        int pos = this.jList.getSelectedIndex();
        if (pos == -1) {
            pos = this.jList.getModel().getSize() - 1;
        } else if (pos > 0) {
            --pos;
        }
        this.jList.setSelectedIndex(pos);
        this.jList.ensureIndexIsVisible(pos);
    }

    public Object getSeletedItem() {
        return this.selectedItem;
    }

    public void reset() {
        this.model.clear();
        this.selectedItem = null;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.jList.requestFocusInWindow();
    }

    private class FilterModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private List<Object> allItems = new ArrayList<Object>();
        private List<Object> filteredItems = new ArrayList<Object>();
        private boolean searchMethodStartsWith = false;

        @Override
        public Object getElementAt(int index) {
            if (index < this.filteredItems.size()) {
                return this.filteredItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filteredItems.size();
        }

        public void addElements(List<? extends Object> listElements) {
            this.allItems.addAll(listElements);
            this.refilter(null);
        }

        public void clear() {
            this.allItems.clear();
            int prevSize = this.filteredItems.size();
            this.filteredItems.clear();
            CodeCompletionAssistent.this.selectedItem = null;
            if (prevSize > 0) {
                this.fireContentsChanged(this, 0, prevSize);
            }
        }

        public void refilter(String term) {
            this.filteredItems.clear();
            if (term != null) {
                term = term.toLowerCase();
            }
            for (Object item : this.allItems) {
                if (CodeCompletionAssistent.this.cbKeywords.isSelected() && item instanceof String) {
                    if (!this.match((String)item, term)) continue;
                    this.filteredItems.add(item);
                    continue;
                }
                if (CodeCompletionAssistent.this.cbSchemas.isSelected() && item instanceof SQLSchema) {
                    if (!this.match(((SQLObject)item).getName(), term)) continue;
                    this.filteredItems.add(item);
                    continue;
                }
                if (!CodeCompletionAssistent.this.cbTables.isSelected() || !(item instanceof SQLTable) || !this.match(((SQLObject)item).getName(), term)) continue;
                this.filteredItems.add(item);
            }
            this.fireContentsChanged(this, 0, this.getSize());
            if (this.filteredItems.size() > 0) {
                CodeCompletionAssistent.this.jList.setSelectedIndex(0);
                CodeCompletionAssistent.this.selectedItem = this.filteredItems.get(0);
            }
        }

        private boolean match(String itemStr, String searchStr) {
            if (searchStr == null || searchStr.isEmpty()) {
                return true;
            }
            if (this.searchMethodStartsWith) {
                return itemStr.toLowerCase().startsWith(searchStr);
            }
            return itemStr.toLowerCase().indexOf(searchStr) != -1;
        }
    }

    private static final class ObjectRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        public static final Color keywordBgColor = new Color(250, 250, 220);
        public static final Color tableBgColor = new Color(220, 250, 250);
        public static final Color schemaBgColor = new Color(250, 220, 250);
        public static final Color fieldBgColor = new Color(220, 255, 220);
        private static Color selectedBgColor;
        private static Color selectedFgColor;
        private static Color textColor;

        private ObjectRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            if (selectedBgColor == null) {
                selectedBgColor = list.getSelectionBackground();
            }
            if (selectedFgColor == null) {
                selectedFgColor = list.getSelectionForeground();
            }
            if (textColor == null) {
                textColor = list.getForeground();
            }
            if (value instanceof String) {
                this.setText((String)value);
                this.setIcon(null);
                if (isSelected) {
                    this.setForeground(selectedFgColor);
                    this.setBackground(selectedBgColor);
                } else {
                    this.setForeground(textColor);
                    this.setBackground(keywordBgColor);
                }
            } else if (value instanceof SQLTable) {
                this.setText(((SQLTable)value).getName());
                this.setIcon(ApplicationIcons.TABLE_PNG);
                if (isSelected) {
                    this.setForeground(selectedFgColor);
                    this.setBackground(selectedBgColor);
                } else {
                    this.setForeground(textColor);
                    this.setBackground(tableBgColor);
                }
            } else if (value instanceof SQLProcedure) {
                this.setText(((SQLProcedure)value).getName());
                this.setIcon(ApplicationIcons.PROCEDURE_PNG);
                if (isSelected) {
                    this.setForeground(selectedFgColor);
                    this.setBackground(selectedBgColor);
                } else {
                    this.setForeground(textColor);
                    this.setBackground(keywordBgColor);
                }
            } else if (value instanceof SQLSchema) {
                this.setText(((SQLSchema)value).getName());
                this.setIcon(ApplicationIcons.SCHEMA_PNG);
                if (isSelected) {
                    this.setForeground(selectedFgColor);
                    this.setBackground(selectedBgColor);
                } else {
                    this.setForeground(textColor);
                    this.setBackground(schemaBgColor);
                }
            } else if (value instanceof SQLField) {
                this.setText(((SQLField)value).getName());
                this.setIcon(ApplicationIcons.FIELD_PNG);
                if (isSelected) {
                    this.setForeground(selectedFgColor);
                    this.setBackground(selectedBgColor);
                } else {
                    this.setForeground(textColor);
                    this.setBackground(fieldBgColor);
                }
            }
            return this;
        }
    }
}

