/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.dbext.extensions;

import dbtools.DatabaseSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.GenericDatabaseExtension;

public class DerbyExtension
extends GenericDatabaseExtension {
    private static final String name = "Derby Extension";
    private static final Logger logger = Logger.getLogger(DerbyExtension.class);

    public DerbyExtension() {
        this.addDriverClassName("org.apache.derby.jdbc.EmbeddedDriver");
        this.addDriverClassName("org.apache.derby.jdbc.ClientDriver");
    }

    @Override
    public boolean hasExplainFeature() {
        return true;
    }

    @Override
    public String getExplainSQL(String currentStatement) {
        if (currentStatement != null) {
            currentStatement = currentStatement.trim();
            StringBuilder sb = new StringBuilder();
            sb.append("call syscs_util.syscs_set_runtimestatistics(1);\n");
            sb.append(currentStatement);
            if (!currentStatement.endsWith(";")) {
                sb.append(";\n");
            }
            sb.append("VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS();\n");
            sb.append("call syscs_util.syscs_set_runtimestatistics(0);");
            return sb.toString();
        }
        return "";
    }

    @Override
    public String setupViewSQLCode(DatabaseSession session, SQLTable table) {
        if (table.isView()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setupViewSQLCode view=" + table.getAbsoluteName()));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("select v.VIEWDEFINITION ");
            sb.append(" from SYS.SYSVIEWS v, SYS.SYSTABLES t, SYS.SYSSCHEMAS s");
            sb.append(" where t.TABLEID = v.TABLEID");
            sb.append(" and t.SCHEMAID = s.SCHEMAID");
            sb.append(" and t.TABLENAME = '");
            sb.append(table.getName());
            sb.append("' and s.SCHEMANAME = '");
            sb.append(table.getSchema().getName());
            sb.append("'");
            String source = null;
            try {
                ResultSet rs = session.executeQuery(sb.toString());
                if (session.isSuccessful() && rs.next() && (source = rs.getString(1)) != null && !source.isEmpty()) {
                    table.setSourceCode(source);
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("setupViewSQLCode for table " + table.getAbsoluteName() + " failed: " + sqle.getMessage()), (Throwable)sqle);
            }
            return source;
        }
        return null;
    }

    @Override
    public String getName() {
        return name;
    }
}

