/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel;

import java.util.ArrayList;
import java.util.List;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLSchema;

public class SQLCatalog
extends SQLObject {
    private List<SQLSchema> schemas = new ArrayList<SQLSchema>();

    public SQLCatalog(SQLDataModel model, String name) {
        super(model, name);
    }

    public List<SQLSchema> getSchemas() {
        return this.schemas;
    }

    public int getCountSchemas() {
        return this.schemas.size();
    }

    public SQLSchema getSchemaAt(int index) {
        return this.schemas.get(index);
    }

    public void addSQLSchema(SQLSchema schema) {
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
            schema.setCatalog(this);
        }
    }

    public SQLSchema getSQLSchema(String name) {
        if (name == null) {
            return null;
        }
        for (SQLSchema s : this.schemas) {
            if (!name.equalsIgnoreCase(s.getName())) continue;
            return s;
        }
        return null;
    }
}

