/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sqlrunner.Main;
import sqlrunner.config.ConfigurationPanel;
import sqlrunner.config.Messages;
import sqlrunner.config.fontchooser.JFontChooser;
import sqlrunner.editor.SyntaxContext;

public class PanelConfigEditorSettings
extends JPanel
implements ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCheckBoxUseAntialising = new JCheckBox();
    private JCheckBox jCheckBoxLineHighlighting = new JCheckBox();
    private JCheckBox jCheckBoxBracketContentHighlighting = new JCheckBox();
    private JButton jButtonChooseFont;
    private boolean changed = false;
    private Font selectedFont;

    public PanelConfigEditorSettings() {
        try {
            this.initComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.selectedFont = Main.textFont;
    }

    private void initComponents() throws Exception {
        this.setMinimumSize(new Dimension(250, 85));
        this.setPreferredSize(new Dimension(250, 85));
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), Messages.getString("PanelConfigEditorSettings.bordertitle")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        this.jCheckBoxUseAntialising.setText(Messages.getString("PanelConfigEditorSettings.antialiasing"));
        this.jCheckBoxUseAntialising.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelConfigEditorSettings.this.changed = true;
            }
        });
        this.jCheckBoxUseAntialising.setSelected(SyntaxContext.isUseAntiAliasing());
        this.add((Component)this.jCheckBoxUseAntialising, gbc);
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PanelConfigEditorSettings.font"));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.insets = new Insets(2, 2, 2, 2);
        this.add((Component)jLabel, gbc2);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.add((Component)this.getButtonChooseFont(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.jCheckBoxLineHighlighting.setText(Messages.getString("PanelConfigEditorSettings.linehighlighting"));
        this.jCheckBoxLineHighlighting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelConfigEditorSettings.this.changed = true;
            }
        });
        this.jCheckBoxLineHighlighting.setSelected(Main.isLineHighlightingEnabled());
        this.add((Component)this.jCheckBoxLineHighlighting, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.anchor = 17;
        this.jCheckBoxBracketContentHighlighting.setText(Messages.getString("PanelConfigEditorSettings.bracketcontenthighlighting"));
        this.jCheckBoxBracketContentHighlighting.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelConfigEditorSettings.this.changed = true;
            }
        });
        this.jCheckBoxBracketContentHighlighting.setSelected(Main.isBracketContentHighlightingEnabled());
        this.add((Component)this.jCheckBoxBracketContentHighlighting, gbc);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public boolean performChanges() {
        SyntaxContext.setUseAntiAliasing(this.jCheckBoxUseAntialising.isSelected());
        Main.setUserProperty("USE_FONT_ANTIALIASING", String.valueOf(this.jCheckBoxUseAntialising.isSelected()));
        Main.setUserProperty("EDITOR_FONT_SIZE", String.valueOf(this.selectedFont.getSize()));
        Main.setUserProperty("EDITOR_FONT_FAMILY", this.selectedFont.getFamily());
        Main.redefineEditorFont();
        Main.enableLineHighlighting(this.jCheckBoxLineHighlighting.isSelected());
        Main.enableBracketContentHighlighting(this.jCheckBoxBracketContentHighlighting.isSelected());
        return true;
    }

    @Override
    public void cancel() {
    }

    private JButton getButtonChooseFont() {
        if (this.jButtonChooseFont == null) {
            this.jButtonChooseFont = new JButton();
            this.jButtonChooseFont.setText(Messages.getString("PanelConfigEditorSettings.chooseFont"));
            this.jButtonChooseFont.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelConfigEditorSettings.this.chooseFont();
                }
            });
        }
        return this.jButtonChooseFont;
    }

    private void chooseFont() {
        JFontChooser fc = new JFontChooser();
        fc.setSelectedFontFamily(this.selectedFont.getFamily());
        fc.setSelectedFontSize(this.selectedFont.getSize());
        int rc = fc.showDialog(this);
        if (rc == 0) {
            this.selectedFont = new Font(fc.getSelectedFontFamily(), 0, fc.getSelectedFontSize());
        }
    }
}

