/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import sqlrunner.BinaryDataFile;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.Messages;
import sqlrunner.editor.SearchReplaceDialog;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.text.GenericDateUtil;

public final class ValueEditor
extends JFrame {
    private static final Logger logger = Logger.getLogger(ValueEditor.class);
    private static final long serialVersionUID = 1L;
    private int contentType;
    private int row;
    private int col;
    private MainFrame mainFrame;
    private SearchReplaceDialog dlgSeRe;
    private boolean insertModus = false;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTextArea textArea = null;
    private JPanel jPanel = null;
    private JLabel labelCounter = null;
    private JCheckBox checkBoxLineWrap = null;
    private JCheckBox checkBoxViewAsDate = null;
    private JCheckBox checkBoxTrim = null;
    private JButton buttonSaveInDB = null;
    private JButton buttonLoadFile = null;
    private JButton buttonSaveInFile = null;
    private JButton buttonSearchReplace = null;
    private JComboBox cbDateFormat = null;

    public ValueEditor() {
        this.getRootPane().putClientProperty("Window.style", "small");
        this.initialize();
    }

    public ValueEditor(boolean readOnly, boolean insertModus, MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.insertModus = insertModus;
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initialize();
            WindowHelper.locateWindowAtMiddle(mainFrame, this);
            this.setVisible(true);
            if (readOnly) {
                this.buttonSaveInDB.setEnabled(false);
                this.buttonSaveInFile.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        int x = Integer.parseInt(Main.getUserProperty("CELL_EDITOR_WIDTH", "300"));
        int y = Integer.parseInt(Main.getUserProperty("CELL_EDITOR_HEIGHT", "150"));
        if (x < 300) {
            x = 300;
        }
        if (y < 150) {
            y = 150;
        }
        this.setSize(x, y);
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("ValueEditor.title"));
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.jContentPane.add((Component)this.getJPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 2.0;
            gbc.gridx = 0;
            this.jContentPane.add((Component)this.getJScrollPane(), gbc);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(390, 50));
            this.jScrollPane.setViewportView(this.getTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(this.checkBoxLineWrap.isSelected());
            this.textArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        ValueEditor.this.dispose();
                    }
                }
            });
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    ValueEditor.this.labelCounter.setText(String.valueOf(ValueEditor.this.textArea.getText().length()));
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    ValueEditor.this.labelCounter.setText(String.valueOf(ValueEditor.this.textArea.getText().length()));
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    ValueEditor.this.labelCounter.setText(String.valueOf(ValueEditor.this.textArea.getText().length()));
                }
            });
        }
        return this.textArea;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("ValueEditor.countchars"));
            this.jPanel.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 17;
            this.labelCounter = new JLabel();
            this.labelCounter.setText("0");
            this.jPanel.add((Component)this.labelCounter, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 2;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getCheckBoxLineWrap(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 4;
            gbc.gridwidth = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getCheckBoxTrim(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getComboBoxDateFormat(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.gridx = 2;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getCheckBoxViewAsDate(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.gridx = 0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.fill = 2;
            this.jPanel.add((Component)this.getButtonSaveInDB(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.gridx = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getButtonLoadFile(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.gridx = 3;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getButtonSaveInFile(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.gridx = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getButtonSearchReplace(), gbc);
        }
        return this.jPanel;
    }

    private JCheckBox getCheckBoxLineWrap() {
        if (this.checkBoxLineWrap == null) {
            this.checkBoxLineWrap = new JCheckBox();
            this.checkBoxLineWrap.setText(Messages.getString("ValueEditor.linewrap"));
            this.checkBoxLineWrap.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueEditor.this.textArea.setLineWrap(((JCheckBox)e.getSource()).isSelected());
                    ValueEditor.this.textArea.setWrapStyleWord(true);
                    Main.setUserProperty("CELL_EDITOR_LINEWRAP", String.valueOf(ValueEditor.this.checkBoxLineWrap.isSelected()));
                }
            });
            this.checkBoxLineWrap.setSelected(Main.getUserProperty("CELL_EDITOR_LINEWRAP", "false").equals("true"));
        }
        return this.checkBoxLineWrap;
    }

    private JCheckBox getCheckBoxViewAsDate() {
        if (this.checkBoxViewAsDate == null) {
            this.checkBoxViewAsDate = new JCheckBox();
            this.checkBoxViewAsDate.setText(Messages.getString("ValueEditor.interpretasdate"));
            this.checkBoxViewAsDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ValueEditor.this.checkBoxViewAsDate.isSelected()) {
                        try {
                            Date date = GenericDateUtil.parseDate(ValueEditor.this.textArea.getText().trim());
                            ValueEditor.this.textArea.setText(String.valueOf(date.getTime()));
                        }
                        catch (ParseException pe) {
                            logger.warn((Object)("converting long->Date failed:" + pe.getMessage()));
                        }
                    } else {
                        try {
                            long time = Long.parseLong(ValueEditor.this.textArea.getText().trim());
                            Date date = new Date(time);
                            SimpleDateFormat sdf = new SimpleDateFormat((String)ValueEditor.this.cbDateFormat.getSelectedItem());
                            ValueEditor.this.textArea.setText(sdf.format(date));
                        }
                        catch (NumberFormatException nfe) {
                            logger.warn((Object)("converting Date->long failed:" + nfe.getMessage()));
                        }
                    }
                    ValueEditor.this.labelCounter.setText(String.valueOf(ValueEditor.this.textArea.getText().length()));
                }
            });
            this.checkBoxViewAsDate.setToolTipText(Messages.getString("ValueEditor.showeditlongasdate"));
        }
        return this.checkBoxViewAsDate;
    }

    private JCheckBox getCheckBoxTrim() {
        if (this.checkBoxTrim == null) {
            this.checkBoxTrim = new JCheckBox();
            this.checkBoxTrim.setText(Messages.getString("ValueEditor.trimonsave"));
            this.checkBoxTrim.setToolTipText(Messages.getString("ValueEditor.removesallspaces"));
            this.checkBoxTrim.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.setUserProperty("CELL_EDITOR_TRIM", String.valueOf(ValueEditor.this.checkBoxTrim.isSelected()));
                }
            });
            this.checkBoxTrim.setSelected(Main.getUserProperty("CELL_EDITOR_TRIM", "false").equals("true"));
        }
        return this.checkBoxTrim;
    }

    private JButton getButtonSaveInDB() {
        if (this.buttonSaveInDB == null) {
            this.buttonSaveInDB = new JButton();
            this.buttonSaveInDB.setMnemonic(83);
            this.buttonSaveInDB.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueEditor.this.buttonSaveInDBActionPerformed();
                }
            });
            if (this.insertModus) {
                this.buttonSaveInDB.setText(Messages.getString("ValueEditor.writeintable"));
            } else {
                this.buttonSaveInDB.setText(Messages.getString("ValueEditor.updateindb"));
            }
        }
        return this.buttonSaveInDB;
    }

    private void buttonSaveInDBActionPerformed() {
        this.mainFrame.getDatabase().setCurrentCellEditor(this);
        if (this.contentType == BasicDataType.BINARY.getId()) {
            final File f = new File(this.textArea.getText());
            if (f.exists()) {
                if (this.insertModus) {
                    this.mainFrame.getDatabase().setValueAt(new BinaryDataFile(f.getAbsolutePath()), this.row, this.col);
                    this.dispose();
                } else {
                    this.buttonSaveInDB.setEnabled(false);
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            ValueEditor.this.mainFrame.getDatabase().updateValue(f.getAbsolutePath(), ValueEditor.this.row, ValueEditor.this.col, ValueEditor.this, null);
                            ValueEditor.this.buttonSaveInDB.setEnabled(true);
                        }
                    };
                    t.start();
                }
            } else {
                this.mainFrame.showErrorMessage(Messages.getString("ValueEditor.filenotexists"), Messages.getString("ValueEditor.uploadfile"));
                this.toFront();
            }
        } else if (BasicDataType.isStringType(this.contentType) || this.contentType == BasicDataType.BINARY.getId()) {
            final String text = this.checkBoxTrim.isSelected() ? this.textArea.getText().trim() : this.textArea.getText();
            if (this.insertModus) {
                this.mainFrame.getDatabase().setValueAtLogicalIndexes(this.row, this.col, text, this.cbDateFormat.getSelectedItem());
                this.dispose();
            } else {
                this.buttonSaveInDB.setEnabled(false);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        ValueEditor.this.mainFrame.getDatabase().updateValue(text, ValueEditor.this.row, ValueEditor.this.col, ValueEditor.this, ValueEditor.this.cbDateFormat.getSelectedItem());
                        ValueEditor.this.buttonSaveInDB.setEnabled(true);
                    }
                };
                t.start();
            }
        } else {
            final String text = this.textArea.getText().trim();
            if (this.insertModus) {
                this.mainFrame.getDatabase().setValueAt(text, this.row, this.col);
                this.dispose();
            } else {
                this.buttonSaveInDB.setEnabled(false);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        ValueEditor.this.mainFrame.getDatabase().updateValue(text, ValueEditor.this.row, ValueEditor.this.col, ValueEditor.this, ValueEditor.this.cbDateFormat.getSelectedItem());
                        ValueEditor.this.buttonSaveInDB.setEnabled(true);
                    }
                };
                t.start();
            }
        }
    }

    private JButton getButtonLoadFile() {
        if (this.buttonLoadFile == null) {
            this.buttonLoadFile = new JButton();
            this.buttonLoadFile.setIcon(ApplicationIcons.OPEN_GIF);
            this.buttonLoadFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueEditor.this.buttonLoadInFileActionPerformed();
                }
            });
        }
        return this.buttonLoadFile;
    }

    private void buttonLoadInFileActionPerformed() {
        this.mainFrame.getDatabase().setCurrentCellEditor(this);
        try {
            FileDialog openDialog = new FileDialog((Frame)this, Messages.getString("ValueEditor.load"), 0);
            String directory = Main.getUserProperty("TABLE_FIELD_LOAD_DIR", System.getProperty("user.home"));
            openDialog.setDirectory(directory);
            openDialog.setVisible(true);
            String dir = openDialog.getDirectory();
            String file = openDialog.getFile();
            if (dir != null && file != null) {
                Main.setUserProperty("TABLE_FIELD_LOAD_DIR", dir);
                File f = new File(dir + file);
                if (this.contentType == BasicDataType.BINARY.getId()) {
                    this.textArea.setText(dir + file);
                } else {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    int pos = 0;
                    this.textArea.setText("");
                    while ((line = br.readLine()) != null) {
                        this.textArea.insert(line + "\n", pos);
                        pos = pos + line.length() + 1;
                    }
                    br.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private JButton getButtonSaveInFile() {
        if (this.buttonSaveInFile == null) {
            this.buttonSaveInFile = new JButton();
            this.buttonSaveInFile.setIcon(ApplicationIcons.SAVE_GIF);
            if (this.insertModus) {
                this.buttonSaveInFile.setEnabled(false);
            }
            this.buttonSaveInFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueEditor.this.buttonSaveInFileActionPerformed();
                }
            });
            this.buttonSaveInFile.setToolTipText(Messages.getString("ValueEditor.savedatainfile"));
        }
        return this.buttonSaveInFile;
    }

    private void buttonSaveInFileActionPerformed() {
        this.mainFrame.getDatabase().setCurrentCellEditor(this);
        try {
            FileDialog saveDialog = new FileDialog((Frame)this, Messages.getString("ValueEditor.saveas"), 1);
            if (this.contentType == BasicDataType.BINARY.getId()) {
                saveDialog.setFile(this.mainFrame.getDatabase().getTableName() + "_" + this.mainFrame.getDatabase().getColumnName(this.col) + "_" + String.valueOf(this.row + 1) + ".bin");
            } else {
                saveDialog.setFile(this.mainFrame.getDatabase().getTableName() + "_" + this.mainFrame.getDatabase().getColumnName(this.col) + "_" + String.valueOf(this.row + 1) + ".txt");
            }
            String directory = Main.getUserProperty("TABLE_FIELD_LOAD_DIR", System.getProperty("user.home"));
            saveDialog.setDirectory(directory);
            saveDialog.setVisible(true);
            String dir = saveDialog.getDirectory();
            String file = saveDialog.getFile();
            if (dir != null && file != null) {
                Main.setUserProperty("TABLE_FIELD_LOAD_DIR", dir);
                File f = new File(dir + file);
                if (this.contentType == BasicDataType.BINARY.getId()) {
                    this.mainFrame.getDatabase().writeLOBValueInFile(f, this.row, this.col, this);
                } else {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                    String text = this.textArea.getText();
                    if (this.checkBoxTrim.isSelected() && text != null) {
                        text = text.trim();
                    }
                    if (text != null) {
                        bw.write(text);
                        bw.flush();
                    }
                    bw.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.toString());
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
        }
    }

    private JButton getButtonSearchReplace() {
        if (this.buttonSearchReplace == null) {
            this.buttonSearchReplace = new JButton();
            this.buttonSearchReplace.setIcon(ApplicationIcons.SEARCH_GIF);
            this.buttonSearchReplace.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ValueEditor.this.buttonSearchReplaceActionPerformed();
                }
            });
        }
        return this.buttonSearchReplace;
    }

    private void buttonSearchReplaceActionPerformed() {
        this.textArea.grabFocus();
        if (this.dlgSeRe == null) {
            this.dlgSeRe = new SearchReplaceDialog(this, false, this.textArea);
        }
        if (this.textArea.getSelectionStart() < this.textArea.getSelectionEnd()) {
            this.dlgSeRe.setSearchText(this.textArea.getSelectedText());
        }
        this.dlgSeRe.setVisible(true);
    }

    private JComboBox getComboBoxDateFormat() {
        if (this.cbDateFormat == null) {
            this.cbDateFormat = new JComboBox();
            this.prepareCbDateFormat();
        }
        return this.cbDateFormat;
    }

    private void prepareCbDateFormat() {
        String formatStr;
        int i = 0;
        while ((formatStr = Main.getDefaultProperty("DATE_FORMAT_" + String.valueOf(i))) != null) {
            this.cbDateFormat.addItem(formatStr);
            ++i;
        }
    }

    public void setObject(Object value, int row, int col) {
        this.row = row;
        this.col = col;
        this.contentType = this.mainFrame.getDatabase().isVerticalView() ? this.mainFrame.getDatabase().getColumnBasicType(this.mainFrame.getDatabase().convertFromVerticalToLogicalColIndex(row)) : this.mainFrame.getDatabase().getColumnBasicType(col);
        if (value != null) {
            if (this.contentType == BasicDataType.DATE.getId()) {
                this.getComboBoxDateFormat().setSelectedItem(MainFrame.getDateFormatMask());
                SimpleDateFormat sdf = new SimpleDateFormat(MainFrame.getDateFormatMask());
                this.textArea.setText(sdf.format(value));
            } else if (this.contentType == BasicDataType.BINARY.getId()) {
                this.textArea.setToolTipText(Messages.getString("ValueEditor.binarysavetooltip"));
                String name = ((BinaryDataFile)value).getFilename();
                if (name != null) {
                    this.textArea.setText(name);
                } else {
                    this.textArea.setText("");
                }
            } else if (BasicDataType.isStringType(this.contentType) || BasicDataType.isNumberType(this.contentType)) {
                this.checkBoxViewAsDate.setEnabled(true);
                this.checkBoxTrim.setEnabled(true);
                String text = value.toString();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\u00a0') {
                        sb.append(' ');
                        continue;
                    }
                    sb.append(c);
                }
                this.textArea.setText(sb.toString());
                this.labelCounter.setText(String.valueOf(this.textArea.getText().length()));
            } else {
                this.textArea.setText(value.toString());
                this.labelCounter.setText(String.valueOf(this.textArea.getText().length()));
            }
            this.textArea.setCaretPosition(0);
        }
    }

    public int getColumnIndex() {
        return this.col;
    }

    public int getRowIndex() {
        return this.row;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    public void setUpdateEnabled(boolean enable) {
        this.buttonSaveInDB.setEnabled(enable);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (!visible) {
            Main.setUserProperty("CELL_EDITOR_WIDTH", String.valueOf(this.getWidth()));
            Main.setUserProperty("CELL_EDITOR_HEIGHT", String.valueOf(this.getHeight()));
        }
        super.setVisible(visible);
    }

    @Override
    public void dispose() {
        if (this.dlgSeRe != null) {
            this.dlgSeRe.dispose();
        }
        Main.setUserProperty("CELL_EDITOR_WIDTH", String.valueOf(this.getWidth()));
        Main.setUserProperty("CELL_EDITOR_HEIGHT", String.valueOf(this.getHeight()));
        super.dispose();
    }
}

